# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LookmlModel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, project_name=None, allowed_db_connection_names=None, unlimited_db_connections=None, has_content=None, label=None, explores=None, can=None):
        """
        LookmlModel - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'project_name': 'str',
            'allowed_db_connection_names': 'list[str]',
            'unlimited_db_connections': 'bool',
            'has_content': 'bool',
            'label': 'str',
            'explores': 'list[LookmlModelNavExplore]',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'name': 'name',
            'project_name': 'project_name',
            'allowed_db_connection_names': 'allowed_db_connection_names',
            'unlimited_db_connections': 'unlimited_db_connections',
            'has_content': 'has_content',
            'label': 'label',
            'explores': 'explores',
            'can': 'can'
        }

        self._name = name
        self._project_name = project_name
        self._allowed_db_connection_names = allowed_db_connection_names
        self._unlimited_db_connections = unlimited_db_connections
        self._has_content = has_content
        self._label = label
        self._explores = explores
        self._can = can

    @property
    def name(self):
        """
        Gets the name of this LookmlModel.
        Name of the model. Also used as the unique identifier

        :return: The name of this LookmlModel.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LookmlModel.
        Name of the model. Also used as the unique identifier

        :param name: The name of this LookmlModel.
        :type: str
        """

        self._name = name

    @property
    def project_name(self):
        """
        Gets the project_name of this LookmlModel.
        Name of project containing the model

        :return: The project_name of this LookmlModel.
        :rtype: str
        """
        return self._project_name

    @project_name.setter
    def project_name(self, project_name):
        """
        Sets the project_name of this LookmlModel.
        Name of project containing the model

        :param project_name: The project_name of this LookmlModel.
        :type: str
        """

        self._project_name = project_name

    @property
    def allowed_db_connection_names(self):
        """
        Gets the allowed_db_connection_names of this LookmlModel.
        Array of names of connections this model is allowed to use

        :return: The allowed_db_connection_names of this LookmlModel.
        :rtype: list[str]
        """
        return self._allowed_db_connection_names

    @allowed_db_connection_names.setter
    def allowed_db_connection_names(self, allowed_db_connection_names):
        """
        Sets the allowed_db_connection_names of this LookmlModel.
        Array of names of connections this model is allowed to use

        :param allowed_db_connection_names: The allowed_db_connection_names of this LookmlModel.
        :type: list[str]
        """

        self._allowed_db_connection_names = allowed_db_connection_names

    @property
    def unlimited_db_connections(self):
        """
        Gets the unlimited_db_connections of this LookmlModel.
        Is this model allowed to use all current and future connections

        :return: The unlimited_db_connections of this LookmlModel.
        :rtype: bool
        """
        return self._unlimited_db_connections

    @unlimited_db_connections.setter
    def unlimited_db_connections(self, unlimited_db_connections):
        """
        Sets the unlimited_db_connections of this LookmlModel.
        Is this model allowed to use all current and future connections

        :param unlimited_db_connections: The unlimited_db_connections of this LookmlModel.
        :type: bool
        """

        self._unlimited_db_connections = unlimited_db_connections

    @property
    def has_content(self):
        """
        Gets the has_content of this LookmlModel.
        Does this model declaration have have lookml content?

        :return: The has_content of this LookmlModel.
        :rtype: bool
        """
        return self._has_content

    @has_content.setter
    def has_content(self, has_content):
        """
        Sets the has_content of this LookmlModel.
        Does this model declaration have have lookml content?

        :param has_content: The has_content of this LookmlModel.
        :type: bool
        """

        self._has_content = has_content

    @property
    def label(self):
        """
        Gets the label of this LookmlModel.
        UI-friendly name for this model

        :return: The label of this LookmlModel.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this LookmlModel.
        UI-friendly name for this model

        :param label: The label of this LookmlModel.
        :type: str
        """

        self._label = label

    @property
    def explores(self):
        """
        Gets the explores of this LookmlModel.
        Array of explores (if has_content)

        :return: The explores of this LookmlModel.
        :rtype: list[LookmlModelNavExplore]
        """
        return self._explores

    @explores.setter
    def explores(self, explores):
        """
        Sets the explores of this LookmlModel.
        Array of explores (if has_content)

        :param explores: The explores of this LookmlModel.
        :type: list[LookmlModelNavExplore]
        """

        self._explores = explores

    @property
    def can(self):
        """
        Gets the can of this LookmlModel.
        Operations the current user is able to perform on this object

        :return: The can of this LookmlModel.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this LookmlModel.
        Operations the current user is able to perform on this object

        :param can: The can of this LookmlModel.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LookmlModel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
