# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LDAPUser(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, email=None, first_name=None, last_name=None, ldap_id=None, all_emails=None, ldap_dn=None, roles=None, groups=None, attributes=None, url=None, can=None):
        """
        LDAPUser - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'email': 'str',
            'first_name': 'str',
            'last_name': 'str',
            'ldap_id': 'str',
            'all_emails': 'list[str]',
            'ldap_dn': 'str',
            'roles': 'list[str]',
            'groups': 'list[str]',
            'attributes': 'dict(str, str)',
            'url': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'email': 'email',
            'first_name': 'first_name',
            'last_name': 'last_name',
            'ldap_id': 'ldap_id',
            'all_emails': 'all_emails',
            'ldap_dn': 'ldap_dn',
            'roles': 'roles',
            'groups': 'groups',
            'attributes': 'attributes',
            'url': 'url',
            'can': 'can'
        }

        self._email = email
        self._first_name = first_name
        self._last_name = last_name
        self._ldap_id = ldap_id
        self._all_emails = all_emails
        self._ldap_dn = ldap_dn
        self._roles = roles
        self._groups = groups
        self._attributes = attributes
        self._url = url
        self._can = can

    @property
    def email(self):
        """
        Gets the email of this LDAPUser.
        Primary email address

        :return: The email of this LDAPUser.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this LDAPUser.
        Primary email address

        :param email: The email of this LDAPUser.
        :type: str
        """

        self._email = email

    @property
    def first_name(self):
        """
        Gets the first_name of this LDAPUser.
        First name

        :return: The first_name of this LDAPUser.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        Sets the first_name of this LDAPUser.
        First name

        :param first_name: The first_name of this LDAPUser.
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """
        Gets the last_name of this LDAPUser.
        Last Name

        :return: The last_name of this LDAPUser.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Sets the last_name of this LDAPUser.
        Last Name

        :param last_name: The last_name of this LDAPUser.
        :type: str
        """

        self._last_name = last_name

    @property
    def ldap_id(self):
        """
        Gets the ldap_id of this LDAPUser.
        LDAP's Unique ID for the user

        :return: The ldap_id of this LDAPUser.
        :rtype: str
        """
        return self._ldap_id

    @ldap_id.setter
    def ldap_id(self, ldap_id):
        """
        Sets the ldap_id of this LDAPUser.
        LDAP's Unique ID for the user

        :param ldap_id: The ldap_id of this LDAPUser.
        :type: str
        """

        self._ldap_id = ldap_id

    @property
    def all_emails(self):
        """
        Gets the all_emails of this LDAPUser.
        Array of user's email addresses and aliases for use in migration

        :return: The all_emails of this LDAPUser.
        :rtype: list[str]
        """
        return self._all_emails

    @all_emails.setter
    def all_emails(self, all_emails):
        """
        Sets the all_emails of this LDAPUser.
        Array of user's email addresses and aliases for use in migration

        :param all_emails: The all_emails of this LDAPUser.
        :type: list[str]
        """

        self._all_emails = all_emails

    @property
    def ldap_dn(self):
        """
        Gets the ldap_dn of this LDAPUser.
        LDAP's distinguished name for the user record

        :return: The ldap_dn of this LDAPUser.
        :rtype: str
        """
        return self._ldap_dn

    @ldap_dn.setter
    def ldap_dn(self, ldap_dn):
        """
        Sets the ldap_dn of this LDAPUser.
        LDAP's distinguished name for the user record

        :param ldap_dn: The ldap_dn of this LDAPUser.
        :type: str
        """

        self._ldap_dn = ldap_dn

    @property
    def roles(self):
        """
        Gets the roles of this LDAPUser.
        Array of user's roles (role names only)

        :return: The roles of this LDAPUser.
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """
        Sets the roles of this LDAPUser.
        Array of user's roles (role names only)

        :param roles: The roles of this LDAPUser.
        :type: list[str]
        """

        self._roles = roles

    @property
    def groups(self):
        """
        Gets the groups of this LDAPUser.
        Array of user's groups (group names only)

        :return: The groups of this LDAPUser.
        :rtype: list[str]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this LDAPUser.
        Array of user's groups (group names only)

        :param groups: The groups of this LDAPUser.
        :type: list[str]
        """

        self._groups = groups

    @property
    def attributes(self):
        """
        Gets the attributes of this LDAPUser.
        Dictionary of user's attrributes (name/value)

        :return: The attributes of this LDAPUser.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this LDAPUser.
        Dictionary of user's attrributes (name/value)

        :param attributes: The attributes of this LDAPUser.
        :type: dict(str, str)
        """

        self._attributes = attributes

    @property
    def url(self):
        """
        Gets the url of this LDAPUser.
        Link to ldap config

        :return: The url of this LDAPUser.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this LDAPUser.
        Link to ldap config

        :param url: The url of this LDAPUser.
        :type: str
        """

        self._url = url

    @property
    def can(self):
        """
        Gets the can of this LDAPUser.
        Operations the current user is able to perform on this object

        :return: The can of this LDAPUser.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this LDAPUser.
        Operations the current user is able to perform on this object

        :param can: The can of this LDAPUser.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LDAPUser):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
