# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LDAPConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, enabled=None, connection_host=None, connection_port=None, connection_tls=None, connection_tls_no_verify=None, auth_username=None, auth_password=None, has_auth_password=None, user_bind_base_dn=None, user_id_attribute_names=None, user_objectclass=None, user_custom_filter=None, user_attribute_map_email=None, user_attribute_map_first_name=None, user_attribute_map_last_name=None, user_attribute_map_ldap_id=None, merge_new_users_by_email=None, alternate_email_login_allowed=None, modified_at=None, modified_by=None, default_new_user_groups=None, default_new_user_roles=None, default_new_user_role_ids=None, default_new_user_group_ids=None, set_roles_from_groups=None, groups=None, groups_with_role_ids=None, auth_requires_role=None, groups_finder_type=None, groups_base_dn=None, groups_member_attribute=None, groups_user_attribute=None, groups_objectclasses=None, force_no_page=None, test_ldap_user=None, test_ldap_password=None, user_attributes=None, user_attributes_with_ids=None, url=None, can=None):
        """
        LDAPConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'connection_host': 'str',
            'connection_port': 'str',
            'connection_tls': 'bool',
            'connection_tls_no_verify': 'bool',
            'auth_username': 'str',
            'auth_password': 'str',
            'has_auth_password': 'bool',
            'user_bind_base_dn': 'str',
            'user_id_attribute_names': 'str',
            'user_objectclass': 'str',
            'user_custom_filter': 'str',
            'user_attribute_map_email': 'str',
            'user_attribute_map_first_name': 'str',
            'user_attribute_map_last_name': 'str',
            'user_attribute_map_ldap_id': 'str',
            'merge_new_users_by_email': 'bool',
            'alternate_email_login_allowed': 'bool',
            'modified_at': 'str',
            'modified_by': 'str',
            'default_new_user_groups': 'list[Group]',
            'default_new_user_roles': 'list[Role]',
            'default_new_user_role_ids': 'list[int]',
            'default_new_user_group_ids': 'list[int]',
            'set_roles_from_groups': 'bool',
            'groups': 'list[LDAPGroupRead]',
            'groups_with_role_ids': 'list[LDAPGroupWrite]',
            'auth_requires_role': 'bool',
            'groups_finder_type': 'str',
            'groups_base_dn': 'str',
            'groups_member_attribute': 'str',
            'groups_user_attribute': 'str',
            'groups_objectclasses': 'str',
            'force_no_page': 'bool',
            'test_ldap_user': 'str',
            'test_ldap_password': 'str',
            'user_attributes': 'list[LDAPUserAttributeRead]',
            'user_attributes_with_ids': 'list[LDAPUserAttributeWrite]',
            'url': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'connection_host': 'connection_host',
            'connection_port': 'connection_port',
            'connection_tls': 'connection_tls',
            'connection_tls_no_verify': 'connection_tls_no_verify',
            'auth_username': 'auth_username',
            'auth_password': 'auth_password',
            'has_auth_password': 'has_auth_password',
            'user_bind_base_dn': 'user_bind_base_dn',
            'user_id_attribute_names': 'user_id_attribute_names',
            'user_objectclass': 'user_objectclass',
            'user_custom_filter': 'user_custom_filter',
            'user_attribute_map_email': 'user_attribute_map_email',
            'user_attribute_map_first_name': 'user_attribute_map_first_name',
            'user_attribute_map_last_name': 'user_attribute_map_last_name',
            'user_attribute_map_ldap_id': 'user_attribute_map_ldap_id',
            'merge_new_users_by_email': 'merge_new_users_by_email',
            'alternate_email_login_allowed': 'alternate_email_login_allowed',
            'modified_at': 'modified_at',
            'modified_by': 'modified_by',
            'default_new_user_groups': 'default_new_user_groups',
            'default_new_user_roles': 'default_new_user_roles',
            'default_new_user_role_ids': 'default_new_user_role_ids',
            'default_new_user_group_ids': 'default_new_user_group_ids',
            'set_roles_from_groups': 'set_roles_from_groups',
            'groups': 'groups',
            'groups_with_role_ids': 'groups_with_role_ids',
            'auth_requires_role': 'auth_requires_role',
            'groups_finder_type': 'groups_finder_type',
            'groups_base_dn': 'groups_base_dn',
            'groups_member_attribute': 'groups_member_attribute',
            'groups_user_attribute': 'groups_user_attribute',
            'groups_objectclasses': 'groups_objectclasses',
            'force_no_page': 'force_no_page',
            'test_ldap_user': 'test_ldap_user',
            'test_ldap_password': 'test_ldap_password',
            'user_attributes': 'user_attributes',
            'user_attributes_with_ids': 'user_attributes_with_ids',
            'url': 'url',
            'can': 'can'
        }

        self._enabled = enabled
        self._connection_host = connection_host
        self._connection_port = connection_port
        self._connection_tls = connection_tls
        self._connection_tls_no_verify = connection_tls_no_verify
        self._auth_username = auth_username
        self._auth_password = auth_password
        self._has_auth_password = has_auth_password
        self._user_bind_base_dn = user_bind_base_dn
        self._user_id_attribute_names = user_id_attribute_names
        self._user_objectclass = user_objectclass
        self._user_custom_filter = user_custom_filter
        self._user_attribute_map_email = user_attribute_map_email
        self._user_attribute_map_first_name = user_attribute_map_first_name
        self._user_attribute_map_last_name = user_attribute_map_last_name
        self._user_attribute_map_ldap_id = user_attribute_map_ldap_id
        self._merge_new_users_by_email = merge_new_users_by_email
        self._alternate_email_login_allowed = alternate_email_login_allowed
        self._modified_at = modified_at
        self._modified_by = modified_by
        self._default_new_user_groups = default_new_user_groups
        self._default_new_user_roles = default_new_user_roles
        self._default_new_user_role_ids = default_new_user_role_ids
        self._default_new_user_group_ids = default_new_user_group_ids
        self._set_roles_from_groups = set_roles_from_groups
        self._groups = groups
        self._groups_with_role_ids = groups_with_role_ids
        self._auth_requires_role = auth_requires_role
        self._groups_finder_type = groups_finder_type
        self._groups_base_dn = groups_base_dn
        self._groups_member_attribute = groups_member_attribute
        self._groups_user_attribute = groups_user_attribute
        self._groups_objectclasses = groups_objectclasses
        self._force_no_page = force_no_page
        self._test_ldap_user = test_ldap_user
        self._test_ldap_password = test_ldap_password
        self._user_attributes = user_attributes
        self._user_attributes_with_ids = user_attributes_with_ids
        self._url = url
        self._can = can

    @property
    def enabled(self):
        """
        Gets the enabled of this LDAPConfig.
        Enable/Disable LDAP authentication for the server

        :return: The enabled of this LDAPConfig.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this LDAPConfig.
        Enable/Disable LDAP authentication for the server

        :param enabled: The enabled of this LDAPConfig.
        :type: bool
        """

        self._enabled = enabled

    @property
    def connection_host(self):
        """
        Gets the connection_host of this LDAPConfig.
        LDAP server hostname

        :return: The connection_host of this LDAPConfig.
        :rtype: str
        """
        return self._connection_host

    @connection_host.setter
    def connection_host(self, connection_host):
        """
        Sets the connection_host of this LDAPConfig.
        LDAP server hostname

        :param connection_host: The connection_host of this LDAPConfig.
        :type: str
        """

        self._connection_host = connection_host

    @property
    def connection_port(self):
        """
        Gets the connection_port of this LDAPConfig.
        LDAP host port

        :return: The connection_port of this LDAPConfig.
        :rtype: str
        """
        return self._connection_port

    @connection_port.setter
    def connection_port(self, connection_port):
        """
        Sets the connection_port of this LDAPConfig.
        LDAP host port

        :param connection_port: The connection_port of this LDAPConfig.
        :type: str
        """

        self._connection_port = connection_port

    @property
    def connection_tls(self):
        """
        Gets the connection_tls of this LDAPConfig.
        Use Transport Layer Security

        :return: The connection_tls of this LDAPConfig.
        :rtype: bool
        """
        return self._connection_tls

    @connection_tls.setter
    def connection_tls(self, connection_tls):
        """
        Sets the connection_tls of this LDAPConfig.
        Use Transport Layer Security

        :param connection_tls: The connection_tls of this LDAPConfig.
        :type: bool
        """

        self._connection_tls = connection_tls

    @property
    def connection_tls_no_verify(self):
        """
        Gets the connection_tls_no_verify of this LDAPConfig.
        Do not verify peer when using TLS

        :return: The connection_tls_no_verify of this LDAPConfig.
        :rtype: bool
        """
        return self._connection_tls_no_verify

    @connection_tls_no_verify.setter
    def connection_tls_no_verify(self, connection_tls_no_verify):
        """
        Sets the connection_tls_no_verify of this LDAPConfig.
        Do not verify peer when using TLS

        :param connection_tls_no_verify: The connection_tls_no_verify of this LDAPConfig.
        :type: bool
        """

        self._connection_tls_no_verify = connection_tls_no_verify

    @property
    def auth_username(self):
        """
        Gets the auth_username of this LDAPConfig.
        Distinguished name of LDAP account used to access the LDAP server

        :return: The auth_username of this LDAPConfig.
        :rtype: str
        """
        return self._auth_username

    @auth_username.setter
    def auth_username(self, auth_username):
        """
        Sets the auth_username of this LDAPConfig.
        Distinguished name of LDAP account used to access the LDAP server

        :param auth_username: The auth_username of this LDAPConfig.
        :type: str
        """

        self._auth_username = auth_username

    @property
    def auth_password(self):
        """
        Gets the auth_password of this LDAPConfig.
        (Write-Only)  Password for the LDAP account used to access the LDAP server

        :return: The auth_password of this LDAPConfig.
        :rtype: str
        """
        return self._auth_password

    @auth_password.setter
    def auth_password(self, auth_password):
        """
        Sets the auth_password of this LDAPConfig.
        (Write-Only)  Password for the LDAP account used to access the LDAP server

        :param auth_password: The auth_password of this LDAPConfig.
        :type: str
        """

        self._auth_password = auth_password

    @property
    def has_auth_password(self):
        """
        Gets the has_auth_password of this LDAPConfig.
        (Read-only) Has the password been set for the LDAP account used to access the LDAP server

        :return: The has_auth_password of this LDAPConfig.
        :rtype: bool
        """
        return self._has_auth_password

    @has_auth_password.setter
    def has_auth_password(self, has_auth_password):
        """
        Sets the has_auth_password of this LDAPConfig.
        (Read-only) Has the password been set for the LDAP account used to access the LDAP server

        :param has_auth_password: The has_auth_password of this LDAPConfig.
        :type: bool
        """

        self._has_auth_password = has_auth_password

    @property
    def user_bind_base_dn(self):
        """
        Gets the user_bind_base_dn of this LDAPConfig.
        Distinguished name of LDAP node used as the base for user searches

        :return: The user_bind_base_dn of this LDAPConfig.
        :rtype: str
        """
        return self._user_bind_base_dn

    @user_bind_base_dn.setter
    def user_bind_base_dn(self, user_bind_base_dn):
        """
        Sets the user_bind_base_dn of this LDAPConfig.
        Distinguished name of LDAP node used as the base for user searches

        :param user_bind_base_dn: The user_bind_base_dn of this LDAPConfig.
        :type: str
        """

        self._user_bind_base_dn = user_bind_base_dn

    @property
    def user_id_attribute_names(self):
        """
        Gets the user_id_attribute_names of this LDAPConfig.
        Name(s) of user record attributes used for matching user login id (comma separated list)

        :return: The user_id_attribute_names of this LDAPConfig.
        :rtype: str
        """
        return self._user_id_attribute_names

    @user_id_attribute_names.setter
    def user_id_attribute_names(self, user_id_attribute_names):
        """
        Sets the user_id_attribute_names of this LDAPConfig.
        Name(s) of user record attributes used for matching user login id (comma separated list)

        :param user_id_attribute_names: The user_id_attribute_names of this LDAPConfig.
        :type: str
        """

        self._user_id_attribute_names = user_id_attribute_names

    @property
    def user_objectclass(self):
        """
        Gets the user_objectclass of this LDAPConfig.
        (Optional) Name of user record objectclass used for finding user during login id

        :return: The user_objectclass of this LDAPConfig.
        :rtype: str
        """
        return self._user_objectclass

    @user_objectclass.setter
    def user_objectclass(self, user_objectclass):
        """
        Sets the user_objectclass of this LDAPConfig.
        (Optional) Name of user record objectclass used for finding user during login id

        :param user_objectclass: The user_objectclass of this LDAPConfig.
        :type: str
        """

        self._user_objectclass = user_objectclass

    @property
    def user_custom_filter(self):
        """
        Gets the user_custom_filter of this LDAPConfig.
        (Optional) Custom RFC-2254 filter clause for use in finding user during login. Combined via 'and' with the other generated filter clauses.

        :return: The user_custom_filter of this LDAPConfig.
        :rtype: str
        """
        return self._user_custom_filter

    @user_custom_filter.setter
    def user_custom_filter(self, user_custom_filter):
        """
        Sets the user_custom_filter of this LDAPConfig.
        (Optional) Custom RFC-2254 filter clause for use in finding user during login. Combined via 'and' with the other generated filter clauses.

        :param user_custom_filter: The user_custom_filter of this LDAPConfig.
        :type: str
        """

        self._user_custom_filter = user_custom_filter

    @property
    def user_attribute_map_email(self):
        """
        Gets the user_attribute_map_email of this LDAPConfig.
        Name of user record attributes used to indicate email address field

        :return: The user_attribute_map_email of this LDAPConfig.
        :rtype: str
        """
        return self._user_attribute_map_email

    @user_attribute_map_email.setter
    def user_attribute_map_email(self, user_attribute_map_email):
        """
        Sets the user_attribute_map_email of this LDAPConfig.
        Name of user record attributes used to indicate email address field

        :param user_attribute_map_email: The user_attribute_map_email of this LDAPConfig.
        :type: str
        """

        self._user_attribute_map_email = user_attribute_map_email

    @property
    def user_attribute_map_first_name(self):
        """
        Gets the user_attribute_map_first_name of this LDAPConfig.
        Name of user record attributes used to indicate first name

        :return: The user_attribute_map_first_name of this LDAPConfig.
        :rtype: str
        """
        return self._user_attribute_map_first_name

    @user_attribute_map_first_name.setter
    def user_attribute_map_first_name(self, user_attribute_map_first_name):
        """
        Sets the user_attribute_map_first_name of this LDAPConfig.
        Name of user record attributes used to indicate first name

        :param user_attribute_map_first_name: The user_attribute_map_first_name of this LDAPConfig.
        :type: str
        """

        self._user_attribute_map_first_name = user_attribute_map_first_name

    @property
    def user_attribute_map_last_name(self):
        """
        Gets the user_attribute_map_last_name of this LDAPConfig.
        Name of user record attributes used to indicate last name

        :return: The user_attribute_map_last_name of this LDAPConfig.
        :rtype: str
        """
        return self._user_attribute_map_last_name

    @user_attribute_map_last_name.setter
    def user_attribute_map_last_name(self, user_attribute_map_last_name):
        """
        Sets the user_attribute_map_last_name of this LDAPConfig.
        Name of user record attributes used to indicate last name

        :param user_attribute_map_last_name: The user_attribute_map_last_name of this LDAPConfig.
        :type: str
        """

        self._user_attribute_map_last_name = user_attribute_map_last_name

    @property
    def user_attribute_map_ldap_id(self):
        """
        Gets the user_attribute_map_ldap_id of this LDAPConfig.
        Name of user record attributes used to indicate unique record id

        :return: The user_attribute_map_ldap_id of this LDAPConfig.
        :rtype: str
        """
        return self._user_attribute_map_ldap_id

    @user_attribute_map_ldap_id.setter
    def user_attribute_map_ldap_id(self, user_attribute_map_ldap_id):
        """
        Sets the user_attribute_map_ldap_id of this LDAPConfig.
        Name of user record attributes used to indicate unique record id

        :param user_attribute_map_ldap_id: The user_attribute_map_ldap_id of this LDAPConfig.
        :type: str
        """

        self._user_attribute_map_ldap_id = user_attribute_map_ldap_id

    @property
    def merge_new_users_by_email(self):
        """
        Gets the merge_new_users_by_email of this LDAPConfig.
        Merge first-time ldap login to existing user account by email addresses. When a user logs in for the first time via ldap this option will connect this user into their existing account by finding the account with a matching email address. Otherwise a new user account will be created for the user.

        :return: The merge_new_users_by_email of this LDAPConfig.
        :rtype: bool
        """
        return self._merge_new_users_by_email

    @merge_new_users_by_email.setter
    def merge_new_users_by_email(self, merge_new_users_by_email):
        """
        Sets the merge_new_users_by_email of this LDAPConfig.
        Merge first-time ldap login to existing user account by email addresses. When a user logs in for the first time via ldap this option will connect this user into their existing account by finding the account with a matching email address. Otherwise a new user account will be created for the user.

        :param merge_new_users_by_email: The merge_new_users_by_email of this LDAPConfig.
        :type: bool
        """

        self._merge_new_users_by_email = merge_new_users_by_email

    @property
    def alternate_email_login_allowed(self):
        """
        Gets the alternate_email_login_allowed of this LDAPConfig.
        Allow alternate email-based login via '/login/email' for admins and for specified users with the 'login_special_email' permission. This option is useful as a fallback during ldap setup, if ldap config problems occur later, or if you need to support some users who are not in your ldap directory. Looker email/password logins are always disabled for regular users when ldap is enabled.

        :return: The alternate_email_login_allowed of this LDAPConfig.
        :rtype: bool
        """
        return self._alternate_email_login_allowed

    @alternate_email_login_allowed.setter
    def alternate_email_login_allowed(self, alternate_email_login_allowed):
        """
        Sets the alternate_email_login_allowed of this LDAPConfig.
        Allow alternate email-based login via '/login/email' for admins and for specified users with the 'login_special_email' permission. This option is useful as a fallback during ldap setup, if ldap config problems occur later, or if you need to support some users who are not in your ldap directory. Looker email/password logins are always disabled for regular users when ldap is enabled.

        :param alternate_email_login_allowed: The alternate_email_login_allowed of this LDAPConfig.
        :type: bool
        """

        self._alternate_email_login_allowed = alternate_email_login_allowed

    @property
    def modified_at(self):
        """
        Gets the modified_at of this LDAPConfig.
        When this config was last modified

        :return: The modified_at of this LDAPConfig.
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """
        Sets the modified_at of this LDAPConfig.
        When this config was last modified

        :param modified_at: The modified_at of this LDAPConfig.
        :type: str
        """

        self._modified_at = modified_at

    @property
    def modified_by(self):
        """
        Gets the modified_by of this LDAPConfig.
        User id of user who last modified this config

        :return: The modified_by of this LDAPConfig.
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this LDAPConfig.
        User id of user who last modified this config

        :param modified_by: The modified_by of this LDAPConfig.
        :type: str
        """

        self._modified_by = modified_by

    @property
    def default_new_user_groups(self):
        """
        Gets the default_new_user_groups of this LDAPConfig.
        (Read-only) Groups that will be applied to new users the first time they login via LDAP

        :return: The default_new_user_groups of this LDAPConfig.
        :rtype: list[Group]
        """
        return self._default_new_user_groups

    @default_new_user_groups.setter
    def default_new_user_groups(self, default_new_user_groups):
        """
        Sets the default_new_user_groups of this LDAPConfig.
        (Read-only) Groups that will be applied to new users the first time they login via LDAP

        :param default_new_user_groups: The default_new_user_groups of this LDAPConfig.
        :type: list[Group]
        """

        self._default_new_user_groups = default_new_user_groups

    @property
    def default_new_user_roles(self):
        """
        Gets the default_new_user_roles of this LDAPConfig.
        (Read-only) Roles that will be applied to new users the first time they login via LDAP

        :return: The default_new_user_roles of this LDAPConfig.
        :rtype: list[Role]
        """
        return self._default_new_user_roles

    @default_new_user_roles.setter
    def default_new_user_roles(self, default_new_user_roles):
        """
        Sets the default_new_user_roles of this LDAPConfig.
        (Read-only) Roles that will be applied to new users the first time they login via LDAP

        :param default_new_user_roles: The default_new_user_roles of this LDAPConfig.
        :type: list[Role]
        """

        self._default_new_user_roles = default_new_user_roles

    @property
    def default_new_user_role_ids(self):
        """
        Gets the default_new_user_role_ids of this LDAPConfig.
        (Write-Only)  Array of ids of roles that will be applied to new users the first time they login via LDAP

        :return: The default_new_user_role_ids of this LDAPConfig.
        :rtype: list[int]
        """
        return self._default_new_user_role_ids

    @default_new_user_role_ids.setter
    def default_new_user_role_ids(self, default_new_user_role_ids):
        """
        Sets the default_new_user_role_ids of this LDAPConfig.
        (Write-Only)  Array of ids of roles that will be applied to new users the first time they login via LDAP

        :param default_new_user_role_ids: The default_new_user_role_ids of this LDAPConfig.
        :type: list[int]
        """

        self._default_new_user_role_ids = default_new_user_role_ids

    @property
    def default_new_user_group_ids(self):
        """
        Gets the default_new_user_group_ids of this LDAPConfig.
        (Write-Only)  Array of ids of groups that will be applied to new users the first time they login via LDAP

        :return: The default_new_user_group_ids of this LDAPConfig.
        :rtype: list[int]
        """
        return self._default_new_user_group_ids

    @default_new_user_group_ids.setter
    def default_new_user_group_ids(self, default_new_user_group_ids):
        """
        Sets the default_new_user_group_ids of this LDAPConfig.
        (Write-Only)  Array of ids of groups that will be applied to new users the first time they login via LDAP

        :param default_new_user_group_ids: The default_new_user_group_ids of this LDAPConfig.
        :type: list[int]
        """

        self._default_new_user_group_ids = default_new_user_group_ids

    @property
    def set_roles_from_groups(self):
        """
        Gets the set_roles_from_groups of this LDAPConfig.
        Set user roles in Looker based on groups from LDAP

        :return: The set_roles_from_groups of this LDAPConfig.
        :rtype: bool
        """
        return self._set_roles_from_groups

    @set_roles_from_groups.setter
    def set_roles_from_groups(self, set_roles_from_groups):
        """
        Sets the set_roles_from_groups of this LDAPConfig.
        Set user roles in Looker based on groups from LDAP

        :param set_roles_from_groups: The set_roles_from_groups of this LDAPConfig.
        :type: bool
        """

        self._set_roles_from_groups = set_roles_from_groups

    @property
    def groups(self):
        """
        Gets the groups of this LDAPConfig.
        (Read-only) Array of mappings between LDAP Groups and Looker Roles

        :return: The groups of this LDAPConfig.
        :rtype: list[LDAPGroupRead]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this LDAPConfig.
        (Read-only) Array of mappings between LDAP Groups and Looker Roles

        :param groups: The groups of this LDAPConfig.
        :type: list[LDAPGroupRead]
        """

        self._groups = groups

    @property
    def groups_with_role_ids(self):
        """
        Gets the groups_with_role_ids of this LDAPConfig.
        (Read/Write) Array of mappings between LDAP Groups and arrays of Looker Role ids

        :return: The groups_with_role_ids of this LDAPConfig.
        :rtype: list[LDAPGroupWrite]
        """
        return self._groups_with_role_ids

    @groups_with_role_ids.setter
    def groups_with_role_ids(self, groups_with_role_ids):
        """
        Sets the groups_with_role_ids of this LDAPConfig.
        (Read/Write) Array of mappings between LDAP Groups and arrays of Looker Role ids

        :param groups_with_role_ids: The groups_with_role_ids of this LDAPConfig.
        :type: list[LDAPGroupWrite]
        """

        self._groups_with_role_ids = groups_with_role_ids

    @property
    def auth_requires_role(self):
        """
        Gets the auth_requires_role of this LDAPConfig.
        Users will not be allowed to login at all unless a role for them is found in LDAP if set to true

        :return: The auth_requires_role of this LDAPConfig.
        :rtype: bool
        """
        return self._auth_requires_role

    @auth_requires_role.setter
    def auth_requires_role(self, auth_requires_role):
        """
        Sets the auth_requires_role of this LDAPConfig.
        Users will not be allowed to login at all unless a role for them is found in LDAP if set to true

        :param auth_requires_role: The auth_requires_role of this LDAPConfig.
        :type: bool
        """

        self._auth_requires_role = auth_requires_role

    @property
    def groups_finder_type(self):
        """
        Gets the groups_finder_type of this LDAPConfig.
        Identifier for a strategy for how Looker will search for groups in the LDAP server

        :return: The groups_finder_type of this LDAPConfig.
        :rtype: str
        """
        return self._groups_finder_type

    @groups_finder_type.setter
    def groups_finder_type(self, groups_finder_type):
        """
        Sets the groups_finder_type of this LDAPConfig.
        Identifier for a strategy for how Looker will search for groups in the LDAP server

        :param groups_finder_type: The groups_finder_type of this LDAPConfig.
        :type: str
        """

        self._groups_finder_type = groups_finder_type

    @property
    def groups_base_dn(self):
        """
        Gets the groups_base_dn of this LDAPConfig.
        Base dn for finding groups in LDAP searches

        :return: The groups_base_dn of this LDAPConfig.
        :rtype: str
        """
        return self._groups_base_dn

    @groups_base_dn.setter
    def groups_base_dn(self, groups_base_dn):
        """
        Sets the groups_base_dn of this LDAPConfig.
        Base dn for finding groups in LDAP searches

        :param groups_base_dn: The groups_base_dn of this LDAPConfig.
        :type: str
        """

        self._groups_base_dn = groups_base_dn

    @property
    def groups_member_attribute(self):
        """
        Gets the groups_member_attribute of this LDAPConfig.
        LDAP Group attribute that signifies the members of the groups. Most commonly 'member'

        :return: The groups_member_attribute of this LDAPConfig.
        :rtype: str
        """
        return self._groups_member_attribute

    @groups_member_attribute.setter
    def groups_member_attribute(self, groups_member_attribute):
        """
        Sets the groups_member_attribute of this LDAPConfig.
        LDAP Group attribute that signifies the members of the groups. Most commonly 'member'

        :param groups_member_attribute: The groups_member_attribute of this LDAPConfig.
        :type: str
        """

        self._groups_member_attribute = groups_member_attribute

    @property
    def groups_user_attribute(self):
        """
        Gets the groups_user_attribute of this LDAPConfig.
        LDAP Group attribute that signifies the user in a group. Most commonly 'dn'

        :return: The groups_user_attribute of this LDAPConfig.
        :rtype: str
        """
        return self._groups_user_attribute

    @groups_user_attribute.setter
    def groups_user_attribute(self, groups_user_attribute):
        """
        Sets the groups_user_attribute of this LDAPConfig.
        LDAP Group attribute that signifies the user in a group. Most commonly 'dn'

        :param groups_user_attribute: The groups_user_attribute of this LDAPConfig.
        :type: str
        """

        self._groups_user_attribute = groups_user_attribute

    @property
    def groups_objectclasses(self):
        """
        Gets the groups_objectclasses of this LDAPConfig.
        Optional comma-separated list of supported LDAP objectclass for groups when doing groups searches

        :return: The groups_objectclasses of this LDAPConfig.
        :rtype: str
        """
        return self._groups_objectclasses

    @groups_objectclasses.setter
    def groups_objectclasses(self, groups_objectclasses):
        """
        Sets the groups_objectclasses of this LDAPConfig.
        Optional comma-separated list of supported LDAP objectclass for groups when doing groups searches

        :param groups_objectclasses: The groups_objectclasses of this LDAPConfig.
        :type: str
        """

        self._groups_objectclasses = groups_objectclasses

    @property
    def force_no_page(self):
        """
        Gets the force_no_page of this LDAPConfig.
        Don't attempt to do LDAP search result paging (RFC 2696) even if the LDAP server claims to support it.

        :return: The force_no_page of this LDAPConfig.
        :rtype: bool
        """
        return self._force_no_page

    @force_no_page.setter
    def force_no_page(self, force_no_page):
        """
        Sets the force_no_page of this LDAPConfig.
        Don't attempt to do LDAP search result paging (RFC 2696) even if the LDAP server claims to support it.

        :param force_no_page: The force_no_page of this LDAPConfig.
        :type: bool
        """

        self._force_no_page = force_no_page

    @property
    def test_ldap_user(self):
        """
        Gets the test_ldap_user of this LDAPConfig.
        (Write-Only)  Test LDAP user login id. For ldap tests only.

        :return: The test_ldap_user of this LDAPConfig.
        :rtype: str
        """
        return self._test_ldap_user

    @test_ldap_user.setter
    def test_ldap_user(self, test_ldap_user):
        """
        Sets the test_ldap_user of this LDAPConfig.
        (Write-Only)  Test LDAP user login id. For ldap tests only.

        :param test_ldap_user: The test_ldap_user of this LDAPConfig.
        :type: str
        """

        self._test_ldap_user = test_ldap_user

    @property
    def test_ldap_password(self):
        """
        Gets the test_ldap_password of this LDAPConfig.
        (Write-Only)  Test LDAP user password. For ldap tests only.

        :return: The test_ldap_password of this LDAPConfig.
        :rtype: str
        """
        return self._test_ldap_password

    @test_ldap_password.setter
    def test_ldap_password(self, test_ldap_password):
        """
        Sets the test_ldap_password of this LDAPConfig.
        (Write-Only)  Test LDAP user password. For ldap tests only.

        :param test_ldap_password: The test_ldap_password of this LDAPConfig.
        :type: str
        """

        self._test_ldap_password = test_ldap_password

    @property
    def user_attributes(self):
        """
        Gets the user_attributes of this LDAPConfig.
        (Read-only) Array of mappings between LDAP User Attributes and Looker User Attributes

        :return: The user_attributes of this LDAPConfig.
        :rtype: list[LDAPUserAttributeRead]
        """
        return self._user_attributes

    @user_attributes.setter
    def user_attributes(self, user_attributes):
        """
        Sets the user_attributes of this LDAPConfig.
        (Read-only) Array of mappings between LDAP User Attributes and Looker User Attributes

        :param user_attributes: The user_attributes of this LDAPConfig.
        :type: list[LDAPUserAttributeRead]
        """

        self._user_attributes = user_attributes

    @property
    def user_attributes_with_ids(self):
        """
        Gets the user_attributes_with_ids of this LDAPConfig.
        (Read/Write) Array of mappings between LDAP User Attributes and arrays of Looker User Attribute ids

        :return: The user_attributes_with_ids of this LDAPConfig.
        :rtype: list[LDAPUserAttributeWrite]
        """
        return self._user_attributes_with_ids

    @user_attributes_with_ids.setter
    def user_attributes_with_ids(self, user_attributes_with_ids):
        """
        Sets the user_attributes_with_ids of this LDAPConfig.
        (Read/Write) Array of mappings between LDAP User Attributes and arrays of Looker User Attribute ids

        :param user_attributes_with_ids: The user_attributes_with_ids of this LDAPConfig.
        :type: list[LDAPUserAttributeWrite]
        """

        self._user_attributes_with_ids = user_attributes_with_ids

    @property
    def url(self):
        """
        Gets the url of this LDAPConfig.
        Link to get this item

        :return: The url of this LDAPConfig.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this LDAPConfig.
        Link to get this item

        :param url: The url of this LDAPConfig.
        :type: str
        """

        self._url = url

    @property
    def can(self):
        """
        Gets the can of this LDAPConfig.
        Operations the current user is able to perform on this object

        :return: The can of this LDAPConfig.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this LDAPConfig.
        Operations the current user is able to perform on this object

        :param can: The can of this LDAPConfig.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LDAPConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
