# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class IntegrationParam(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, label=None, description=None, required=None, has_value=None, value=None, user_attribute_name=None, sensitive=None):
        """
        IntegrationParam - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'label': 'str',
            'description': 'str',
            'required': 'bool',
            'has_value': 'bool',
            'value': 'str',
            'user_attribute_name': 'str',
            'sensitive': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'label': 'label',
            'description': 'description',
            'required': 'required',
            'has_value': 'has_value',
            'value': 'value',
            'user_attribute_name': 'user_attribute_name',
            'sensitive': 'sensitive'
        }

        self._name = name
        self._label = label
        self._description = description
        self._required = required
        self._has_value = has_value
        self._value = value
        self._user_attribute_name = user_attribute_name
        self._sensitive = sensitive

    @property
    def name(self):
        """
        Gets the name of this IntegrationParam.
        Name of the parameter.

        :return: The name of this IntegrationParam.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this IntegrationParam.
        Name of the parameter.

        :param name: The name of this IntegrationParam.
        :type: str
        """

        self._name = name

    @property
    def label(self):
        """
        Gets the label of this IntegrationParam.
        Label of the parameter.

        :return: The label of this IntegrationParam.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this IntegrationParam.
        Label of the parameter.

        :param label: The label of this IntegrationParam.
        :type: str
        """

        self._label = label

    @property
    def description(self):
        """
        Gets the description of this IntegrationParam.
        Short description of the parameter.

        :return: The description of this IntegrationParam.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this IntegrationParam.
        Short description of the parameter.

        :param description: The description of this IntegrationParam.
        :type: str
        """

        self._description = description

    @property
    def required(self):
        """
        Gets the required of this IntegrationParam.
        Whether the parameter is required to be set to use the destination.

        :return: The required of this IntegrationParam.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this IntegrationParam.
        Whether the parameter is required to be set to use the destination.

        :param required: The required of this IntegrationParam.
        :type: bool
        """

        self._required = required

    @property
    def has_value(self):
        """
        Gets the has_value of this IntegrationParam.
        Whether the parameter has a value set.

        :return: The has_value of this IntegrationParam.
        :rtype: bool
        """
        return self._has_value

    @has_value.setter
    def has_value(self, has_value):
        """
        Sets the has_value of this IntegrationParam.
        Whether the parameter has a value set.

        :param has_value: The has_value of this IntegrationParam.
        :type: bool
        """

        self._has_value = has_value

    @property
    def value(self):
        """
        Gets the value of this IntegrationParam.
        The current value of the parameter. Always null if the value is sensitive. When writing, null values will be ignored. Set the value to an empty string to clear it.

        :return: The value of this IntegrationParam.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this IntegrationParam.
        The current value of the parameter. Always null if the value is sensitive. When writing, null values will be ignored. Set the value to an empty string to clear it.

        :param value: The value of this IntegrationParam.
        :type: str
        """

        self._value = value

    @property
    def user_attribute_name(self):
        """
        Gets the user_attribute_name of this IntegrationParam.
        When present, the param's value comes from this user attribute instead of the 'value' parameter. Set to null to use the 'value'.

        :return: The user_attribute_name of this IntegrationParam.
        :rtype: str
        """
        return self._user_attribute_name

    @user_attribute_name.setter
    def user_attribute_name(self, user_attribute_name):
        """
        Sets the user_attribute_name of this IntegrationParam.
        When present, the param's value comes from this user attribute instead of the 'value' parameter. Set to null to use the 'value'.

        :param user_attribute_name: The user_attribute_name of this IntegrationParam.
        :type: str
        """

        self._user_attribute_name = user_attribute_name

    @property
    def sensitive(self):
        """
        Gets the sensitive of this IntegrationParam.
        Whether the parameter contains sensitive data like API credentials.

        :return: The sensitive of this IntegrationParam.
        :rtype: bool
        """
        return self._sensitive

    @sensitive.setter
    def sensitive(self, sensitive):
        """
        Sets the sensitive of this IntegrationParam.
        Whether the parameter contains sensitive data like API credentials.

        :param sensitive: The sensitive of this IntegrationParam.
        :type: bool
        """

        self._sensitive = sensitive

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, IntegrationParam):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
