# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Integration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, integration_hub_id=None, label=None, description=None, enabled=None, params=None, supported_formats=None, supported_action_types=None, supported_formattings=None, supported_visualization_formattings=None, supported_download_settings=None, icon_url=None, required_fields=None, can=None):
        """
        Integration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'integration_hub_id': 'int',
            'label': 'str',
            'description': 'str',
            'enabled': 'bool',
            'params': 'list[IntegrationParam]',
            'supported_formats': 'list[str]',
            'supported_action_types': 'list[str]',
            'supported_formattings': 'list[str]',
            'supported_visualization_formattings': 'list[str]',
            'supported_download_settings': 'list[str]',
            'icon_url': 'str',
            'required_fields': 'list[IntegrationRequiredField]',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'integration_hub_id': 'integration_hub_id',
            'label': 'label',
            'description': 'description',
            'enabled': 'enabled',
            'params': 'params',
            'supported_formats': 'supported_formats',
            'supported_action_types': 'supported_action_types',
            'supported_formattings': 'supported_formattings',
            'supported_visualization_formattings': 'supported_visualization_formattings',
            'supported_download_settings': 'supported_download_settings',
            'icon_url': 'icon_url',
            'required_fields': 'required_fields',
            'can': 'can'
        }

        self._id = id
        self._integration_hub_id = integration_hub_id
        self._label = label
        self._description = description
        self._enabled = enabled
        self._params = params
        self._supported_formats = supported_formats
        self._supported_action_types = supported_action_types
        self._supported_formattings = supported_formattings
        self._supported_visualization_formattings = supported_visualization_formattings
        self._supported_download_settings = supported_download_settings
        self._icon_url = icon_url
        self._required_fields = required_fields
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this Integration.
        ID of the integration.

        :return: The id of this Integration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Integration.
        ID of the integration.

        :param id: The id of this Integration.
        :type: str
        """

        self._id = id

    @property
    def integration_hub_id(self):
        """
        Gets the integration_hub_id of this Integration.
        ID of the integration hub.

        :return: The integration_hub_id of this Integration.
        :rtype: int
        """
        return self._integration_hub_id

    @integration_hub_id.setter
    def integration_hub_id(self, integration_hub_id):
        """
        Sets the integration_hub_id of this Integration.
        ID of the integration hub.

        :param integration_hub_id: The integration_hub_id of this Integration.
        :type: int
        """

        self._integration_hub_id = integration_hub_id

    @property
    def label(self):
        """
        Gets the label of this Integration.
        Label for the integration.

        :return: The label of this Integration.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this Integration.
        Label for the integration.

        :param label: The label of this Integration.
        :type: str
        """

        self._label = label

    @property
    def description(self):
        """
        Gets the description of this Integration.
        Description of the integration.

        :return: The description of this Integration.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Integration.
        Description of the integration.

        :param description: The description of this Integration.
        :type: str
        """

        self._description = description

    @property
    def enabled(self):
        """
        Gets the enabled of this Integration.
        Whether the integration is available to users.

        :return: The enabled of this Integration.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this Integration.
        Whether the integration is available to users.

        :param enabled: The enabled of this Integration.
        :type: bool
        """

        self._enabled = enabled

    @property
    def params(self):
        """
        Gets the params of this Integration.
        Array of params for the integration.

        :return: The params of this Integration.
        :rtype: list[IntegrationParam]
        """
        return self._params

    @params.setter
    def params(self, params):
        """
        Sets the params of this Integration.
        Array of params for the integration.

        :param params: The params of this Integration.
        :type: list[IntegrationParam]
        """

        self._params = params

    @property
    def supported_formats(self):
        """
        Gets the supported_formats of this Integration.
        A list of data formats the integration supports. Valid values are: \"txt\", \"csv\", \"inline_json\", \"json\", \"json_detail\", \"xlsx\", \"html\", \"wysiwyg_pdf\", \"assembled_pdf\", \"wysiwyg_png\", \"csv_zip\".

        :return: The supported_formats of this Integration.
        :rtype: list[str]
        """
        return self._supported_formats

    @supported_formats.setter
    def supported_formats(self, supported_formats):
        """
        Sets the supported_formats of this Integration.
        A list of data formats the integration supports. Valid values are: \"txt\", \"csv\", \"inline_json\", \"json\", \"json_detail\", \"xlsx\", \"html\", \"wysiwyg_pdf\", \"assembled_pdf\", \"wysiwyg_png\", \"csv_zip\".

        :param supported_formats: The supported_formats of this Integration.
        :type: list[str]
        """

        self._supported_formats = supported_formats

    @property
    def supported_action_types(self):
        """
        Gets the supported_action_types of this Integration.
        A list of action types the integration supports. Valid values are: \"cell\", \"query\", \"dashboard\".

        :return: The supported_action_types of this Integration.
        :rtype: list[str]
        """
        return self._supported_action_types

    @supported_action_types.setter
    def supported_action_types(self, supported_action_types):
        """
        Sets the supported_action_types of this Integration.
        A list of action types the integration supports. Valid values are: \"cell\", \"query\", \"dashboard\".

        :param supported_action_types: The supported_action_types of this Integration.
        :type: list[str]
        """

        self._supported_action_types = supported_action_types

    @property
    def supported_formattings(self):
        """
        Gets the supported_formattings of this Integration.
        A list of formatting options the integration supports. Valid values are: \"formatted\", \"unformatted\".

        :return: The supported_formattings of this Integration.
        :rtype: list[str]
        """
        return self._supported_formattings

    @supported_formattings.setter
    def supported_formattings(self, supported_formattings):
        """
        Sets the supported_formattings of this Integration.
        A list of formatting options the integration supports. Valid values are: \"formatted\", \"unformatted\".

        :param supported_formattings: The supported_formattings of this Integration.
        :type: list[str]
        """

        self._supported_formattings = supported_formattings

    @property
    def supported_visualization_formattings(self):
        """
        Gets the supported_visualization_formattings of this Integration.
        A list of visualization formatting options the integration supports. Valid values are: \"apply\", \"noapply\".

        :return: The supported_visualization_formattings of this Integration.
        :rtype: list[str]
        """
        return self._supported_visualization_formattings

    @supported_visualization_formattings.setter
    def supported_visualization_formattings(self, supported_visualization_formattings):
        """
        Sets the supported_visualization_formattings of this Integration.
        A list of visualization formatting options the integration supports. Valid values are: \"apply\", \"noapply\".

        :param supported_visualization_formattings: The supported_visualization_formattings of this Integration.
        :type: list[str]
        """

        self._supported_visualization_formattings = supported_visualization_formattings

    @property
    def supported_download_settings(self):
        """
        Gets the supported_download_settings of this Integration.
        A list of streaming options the integration supports. Valid values are: \"push\", \"url\".

        :return: The supported_download_settings of this Integration.
        :rtype: list[str]
        """
        return self._supported_download_settings

    @supported_download_settings.setter
    def supported_download_settings(self, supported_download_settings):
        """
        Sets the supported_download_settings of this Integration.
        A list of streaming options the integration supports. Valid values are: \"push\", \"url\".

        :param supported_download_settings: The supported_download_settings of this Integration.
        :type: list[str]
        """

        self._supported_download_settings = supported_download_settings

    @property
    def icon_url(self):
        """
        Gets the icon_url of this Integration.
        URL to an icon for the integration.

        :return: The icon_url of this Integration.
        :rtype: str
        """
        return self._icon_url

    @icon_url.setter
    def icon_url(self, icon_url):
        """
        Sets the icon_url of this Integration.
        URL to an icon for the integration.

        :param icon_url: The icon_url of this Integration.
        :type: str
        """

        self._icon_url = icon_url

    @property
    def required_fields(self):
        """
        Gets the required_fields of this Integration.
        A list of descriptions of required fields that this integration is compatible with. If there are multiple entries in this list, the integration requires more than one field.

        :return: The required_fields of this Integration.
        :rtype: list[IntegrationRequiredField]
        """
        return self._required_fields

    @required_fields.setter
    def required_fields(self, required_fields):
        """
        Sets the required_fields of this Integration.
        A list of descriptions of required fields that this integration is compatible with. If there are multiple entries in this list, the integration requires more than one field.

        :param required_fields: The required_fields of this Integration.
        :type: list[IntegrationRequiredField]
        """

        self._required_fields = required_fields

    @property
    def can(self):
        """
        Gets the can of this Integration.
        Operations the current user is able to perform on this object

        :return: The can of this Integration.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this Integration.
        Operations the current user is able to perform on this object

        :param can: The can of this Integration.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Integration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
