# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DBConnection(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, dialect=None, snippets=None, host=None, port=None, username=None, password=None, certificate=None, file_type=None, database=None, db_timezone=None, query_timezone=None, schema=None, max_connections=None, max_billing_gigabytes=None, ssl=None, verify_ssl=None, tmp_db_name=None, jdbc_additional_params=None, pool_timeout=None, dialect_name=None, created_at=None, user_id=None, example=None, user_db_credentials=None, user_attribute_fields=None, maintenance_cron=None, last_regen_at=None, last_reap_at=None, sql_runner_precache_tables=None, after_connect_statements=None, pdt_context_override=None, can=None):
        """
        DBConnection - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'dialect': 'Dialect',
            'snippets': 'list[Snippet]',
            'host': 'str',
            'port': 'str',
            'username': 'str',
            'password': 'str',
            'certificate': 'str',
            'file_type': 'str',
            'database': 'str',
            'db_timezone': 'str',
            'query_timezone': 'str',
            'schema': 'str',
            'max_connections': 'int',
            'max_billing_gigabytes': 'str',
            'ssl': 'bool',
            'verify_ssl': 'bool',
            'tmp_db_name': 'str',
            'jdbc_additional_params': 'str',
            'pool_timeout': 'int',
            'dialect_name': 'str',
            'created_at': 'str',
            'user_id': 'str',
            'example': 'bool',
            'user_db_credentials': 'bool',
            'user_attribute_fields': 'list[str]',
            'maintenance_cron': 'str',
            'last_regen_at': 'str',
            'last_reap_at': 'str',
            'sql_runner_precache_tables': 'bool',
            'after_connect_statements': 'str',
            'pdt_context_override': 'DBConnectionOverride',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'name': 'name',
            'dialect': 'dialect',
            'snippets': 'snippets',
            'host': 'host',
            'port': 'port',
            'username': 'username',
            'password': 'password',
            'certificate': 'certificate',
            'file_type': 'file_type',
            'database': 'database',
            'db_timezone': 'db_timezone',
            'query_timezone': 'query_timezone',
            'schema': 'schema',
            'max_connections': 'max_connections',
            'max_billing_gigabytes': 'max_billing_gigabytes',
            'ssl': 'ssl',
            'verify_ssl': 'verify_ssl',
            'tmp_db_name': 'tmp_db_name',
            'jdbc_additional_params': 'jdbc_additional_params',
            'pool_timeout': 'pool_timeout',
            'dialect_name': 'dialect_name',
            'created_at': 'created_at',
            'user_id': 'user_id',
            'example': 'example',
            'user_db_credentials': 'user_db_credentials',
            'user_attribute_fields': 'user_attribute_fields',
            'maintenance_cron': 'maintenance_cron',
            'last_regen_at': 'last_regen_at',
            'last_reap_at': 'last_reap_at',
            'sql_runner_precache_tables': 'sql_runner_precache_tables',
            'after_connect_statements': 'after_connect_statements',
            'pdt_context_override': 'pdt_context_override',
            'can': 'can'
        }

        self._name = name
        self._dialect = dialect
        self._snippets = snippets
        self._host = host
        self._port = port
        self._username = username
        self._password = password
        self._certificate = certificate
        self._file_type = file_type
        self._database = database
        self._db_timezone = db_timezone
        self._query_timezone = query_timezone
        self._schema = schema
        self._max_connections = max_connections
        self._max_billing_gigabytes = max_billing_gigabytes
        self._ssl = ssl
        self._verify_ssl = verify_ssl
        self._tmp_db_name = tmp_db_name
        self._jdbc_additional_params = jdbc_additional_params
        self._pool_timeout = pool_timeout
        self._dialect_name = dialect_name
        self._created_at = created_at
        self._user_id = user_id
        self._example = example
        self._user_db_credentials = user_db_credentials
        self._user_attribute_fields = user_attribute_fields
        self._maintenance_cron = maintenance_cron
        self._last_regen_at = last_regen_at
        self._last_reap_at = last_reap_at
        self._sql_runner_precache_tables = sql_runner_precache_tables
        self._after_connect_statements = after_connect_statements
        self._pdt_context_override = pdt_context_override
        self._can = can

    @property
    def name(self):
        """
        Gets the name of this DBConnection.
        Name of the connection. Also used as the unique identifier

        :return: The name of this DBConnection.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DBConnection.
        Name of the connection. Also used as the unique identifier

        :param name: The name of this DBConnection.
        :type: str
        """

        self._name = name

    @property
    def dialect(self):
        """
        Gets the dialect of this DBConnection.
        (Read-only) SQL Dialect details

        :return: The dialect of this DBConnection.
        :rtype: Dialect
        """
        return self._dialect

    @dialect.setter
    def dialect(self, dialect):
        """
        Sets the dialect of this DBConnection.
        (Read-only) SQL Dialect details

        :param dialect: The dialect of this DBConnection.
        :type: Dialect
        """

        self._dialect = dialect

    @property
    def snippets(self):
        """
        Gets the snippets of this DBConnection.
        SQL Runner snippets for this connection

        :return: The snippets of this DBConnection.
        :rtype: list[Snippet]
        """
        return self._snippets

    @snippets.setter
    def snippets(self, snippets):
        """
        Sets the snippets of this DBConnection.
        SQL Runner snippets for this connection

        :param snippets: The snippets of this DBConnection.
        :type: list[Snippet]
        """

        self._snippets = snippets

    @property
    def host(self):
        """
        Gets the host of this DBConnection.
        Host name/address of server

        :return: The host of this DBConnection.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        Sets the host of this DBConnection.
        Host name/address of server

        :param host: The host of this DBConnection.
        :type: str
        """

        self._host = host

    @property
    def port(self):
        """
        Gets the port of this DBConnection.
        Port number on server

        :return: The port of this DBConnection.
        :rtype: str
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this DBConnection.
        Port number on server

        :param port: The port of this DBConnection.
        :type: str
        """

        self._port = port

    @property
    def username(self):
        """
        Gets the username of this DBConnection.
        Username for server authentication

        :return: The username of this DBConnection.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this DBConnection.
        Username for server authentication

        :param username: The username of this DBConnection.
        :type: str
        """

        self._username = username

    @property
    def password(self):
        """
        Gets the password of this DBConnection.
        (Write-Only) Password for server authentication

        :return: The password of this DBConnection.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this DBConnection.
        (Write-Only) Password for server authentication

        :param password: The password of this DBConnection.
        :type: str
        """

        self._password = password

    @property
    def certificate(self):
        """
        Gets the certificate of this DBConnection.
        (Write-Only) Base64 encoded Certificate body for server authentication (when appropriate for dialect).

        :return: The certificate of this DBConnection.
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate):
        """
        Sets the certificate of this DBConnection.
        (Write-Only) Base64 encoded Certificate body for server authentication (when appropriate for dialect).

        :param certificate: The certificate of this DBConnection.
        :type: str
        """

        self._certificate = certificate

    @property
    def file_type(self):
        """
        Gets the file_type of this DBConnection.
        (Write-Only) Certificate keyfile type - .json or .p12

        :return: The file_type of this DBConnection.
        :rtype: str
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """
        Sets the file_type of this DBConnection.
        (Write-Only) Certificate keyfile type - .json or .p12

        :param file_type: The file_type of this DBConnection.
        :type: str
        """

        self._file_type = file_type

    @property
    def database(self):
        """
        Gets the database of this DBConnection.
        Database name

        :return: The database of this DBConnection.
        :rtype: str
        """
        return self._database

    @database.setter
    def database(self, database):
        """
        Sets the database of this DBConnection.
        Database name

        :param database: The database of this DBConnection.
        :type: str
        """

        self._database = database

    @property
    def db_timezone(self):
        """
        Gets the db_timezone of this DBConnection.
        Time zone of database

        :return: The db_timezone of this DBConnection.
        :rtype: str
        """
        return self._db_timezone

    @db_timezone.setter
    def db_timezone(self, db_timezone):
        """
        Sets the db_timezone of this DBConnection.
        Time zone of database

        :param db_timezone: The db_timezone of this DBConnection.
        :type: str
        """

        self._db_timezone = db_timezone

    @property
    def query_timezone(self):
        """
        Gets the query_timezone of this DBConnection.
        Timezone to use in queries

        :return: The query_timezone of this DBConnection.
        :rtype: str
        """
        return self._query_timezone

    @query_timezone.setter
    def query_timezone(self, query_timezone):
        """
        Sets the query_timezone of this DBConnection.
        Timezone to use in queries

        :param query_timezone: The query_timezone of this DBConnection.
        :type: str
        """

        self._query_timezone = query_timezone

    @property
    def schema(self):
        """
        Gets the schema of this DBConnection.
        Scheme name

        :return: The schema of this DBConnection.
        :rtype: str
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this DBConnection.
        Scheme name

        :param schema: The schema of this DBConnection.
        :type: str
        """

        self._schema = schema

    @property
    def max_connections(self):
        """
        Gets the max_connections of this DBConnection.
        Maximum number of concurrent connection to use

        :return: The max_connections of this DBConnection.
        :rtype: int
        """
        return self._max_connections

    @max_connections.setter
    def max_connections(self, max_connections):
        """
        Sets the max_connections of this DBConnection.
        Maximum number of concurrent connection to use

        :param max_connections: The max_connections of this DBConnection.
        :type: int
        """

        self._max_connections = max_connections

    @property
    def max_billing_gigabytes(self):
        """
        Gets the max_billing_gigabytes of this DBConnection.
        Maximum size of query in GBs (BigQuery only, can be a user_attribute name)

        :return: The max_billing_gigabytes of this DBConnection.
        :rtype: str
        """
        return self._max_billing_gigabytes

    @max_billing_gigabytes.setter
    def max_billing_gigabytes(self, max_billing_gigabytes):
        """
        Sets the max_billing_gigabytes of this DBConnection.
        Maximum size of query in GBs (BigQuery only, can be a user_attribute name)

        :param max_billing_gigabytes: The max_billing_gigabytes of this DBConnection.
        :type: str
        """

        self._max_billing_gigabytes = max_billing_gigabytes

    @property
    def ssl(self):
        """
        Gets the ssl of this DBConnection.
        Use SSL/TLS when connecting to server

        :return: The ssl of this DBConnection.
        :rtype: bool
        """
        return self._ssl

    @ssl.setter
    def ssl(self, ssl):
        """
        Sets the ssl of this DBConnection.
        Use SSL/TLS when connecting to server

        :param ssl: The ssl of this DBConnection.
        :type: bool
        """

        self._ssl = ssl

    @property
    def verify_ssl(self):
        """
        Gets the verify_ssl of this DBConnection.
        Verify the SSL

        :return: The verify_ssl of this DBConnection.
        :rtype: bool
        """
        return self._verify_ssl

    @verify_ssl.setter
    def verify_ssl(self, verify_ssl):
        """
        Sets the verify_ssl of this DBConnection.
        Verify the SSL

        :param verify_ssl: The verify_ssl of this DBConnection.
        :type: bool
        """

        self._verify_ssl = verify_ssl

    @property
    def tmp_db_name(self):
        """
        Gets the tmp_db_name of this DBConnection.
        Name of temporary database (if used)

        :return: The tmp_db_name of this DBConnection.
        :rtype: str
        """
        return self._tmp_db_name

    @tmp_db_name.setter
    def tmp_db_name(self, tmp_db_name):
        """
        Sets the tmp_db_name of this DBConnection.
        Name of temporary database (if used)

        :param tmp_db_name: The tmp_db_name of this DBConnection.
        :type: str
        """

        self._tmp_db_name = tmp_db_name

    @property
    def jdbc_additional_params(self):
        """
        Gets the jdbc_additional_params of this DBConnection.
        Additional params to add to JDBC connection string

        :return: The jdbc_additional_params of this DBConnection.
        :rtype: str
        """
        return self._jdbc_additional_params

    @jdbc_additional_params.setter
    def jdbc_additional_params(self, jdbc_additional_params):
        """
        Sets the jdbc_additional_params of this DBConnection.
        Additional params to add to JDBC connection string

        :param jdbc_additional_params: The jdbc_additional_params of this DBConnection.
        :type: str
        """

        self._jdbc_additional_params = jdbc_additional_params

    @property
    def pool_timeout(self):
        """
        Gets the pool_timeout of this DBConnection.
        Pool Timeout

        :return: The pool_timeout of this DBConnection.
        :rtype: int
        """
        return self._pool_timeout

    @pool_timeout.setter
    def pool_timeout(self, pool_timeout):
        """
        Sets the pool_timeout of this DBConnection.
        Pool Timeout

        :param pool_timeout: The pool_timeout of this DBConnection.
        :type: int
        """

        self._pool_timeout = pool_timeout

    @property
    def dialect_name(self):
        """
        Gets the dialect_name of this DBConnection.
        (Read/Write) SQL Dialect name

        :return: The dialect_name of this DBConnection.
        :rtype: str
        """
        return self._dialect_name

    @dialect_name.setter
    def dialect_name(self, dialect_name):
        """
        Sets the dialect_name of this DBConnection.
        (Read/Write) SQL Dialect name

        :param dialect_name: The dialect_name of this DBConnection.
        :type: str
        """

        self._dialect_name = dialect_name

    @property
    def created_at(self):
        """
        Gets the created_at of this DBConnection.
        Creation date for this connection

        :return: The created_at of this DBConnection.
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this DBConnection.
        Creation date for this connection

        :param created_at: The created_at of this DBConnection.
        :type: str
        """

        self._created_at = created_at

    @property
    def user_id(self):
        """
        Gets the user_id of this DBConnection.
        Id of user who last modified this connection configuration

        :return: The user_id of this DBConnection.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this DBConnection.
        Id of user who last modified this connection configuration

        :param user_id: The user_id of this DBConnection.
        :type: str
        """

        self._user_id = user_id

    @property
    def example(self):
        """
        Gets the example of this DBConnection.
        Is this an example connection

        :return: The example of this DBConnection.
        :rtype: bool
        """
        return self._example

    @example.setter
    def example(self, example):
        """
        Sets the example of this DBConnection.
        Is this an example connection

        :param example: The example of this DBConnection.
        :type: bool
        """

        self._example = example

    @property
    def user_db_credentials(self):
        """
        Gets the user_db_credentials of this DBConnection.
        (Limited access feature) Are per user db credentials enabled

        :return: The user_db_credentials of this DBConnection.
        :rtype: bool
        """
        return self._user_db_credentials

    @user_db_credentials.setter
    def user_db_credentials(self, user_db_credentials):
        """
        Sets the user_db_credentials of this DBConnection.
        (Limited access feature) Are per user db credentials enabled

        :param user_db_credentials: The user_db_credentials of this DBConnection.
        :type: bool
        """

        self._user_db_credentials = user_db_credentials

    @property
    def user_attribute_fields(self):
        """
        Gets the user_attribute_fields of this DBConnection.
        Fields whose values map to user attribute names

        :return: The user_attribute_fields of this DBConnection.
        :rtype: list[str]
        """
        return self._user_attribute_fields

    @user_attribute_fields.setter
    def user_attribute_fields(self, user_attribute_fields):
        """
        Sets the user_attribute_fields of this DBConnection.
        Fields whose values map to user attribute names

        :param user_attribute_fields: The user_attribute_fields of this DBConnection.
        :type: list[str]
        """

        self._user_attribute_fields = user_attribute_fields

    @property
    def maintenance_cron(self):
        """
        Gets the maintenance_cron of this DBConnection.
        Cron string specifying when maintenance such as PDT trigger checks and drops should be performed

        :return: The maintenance_cron of this DBConnection.
        :rtype: str
        """
        return self._maintenance_cron

    @maintenance_cron.setter
    def maintenance_cron(self, maintenance_cron):
        """
        Sets the maintenance_cron of this DBConnection.
        Cron string specifying when maintenance such as PDT trigger checks and drops should be performed

        :param maintenance_cron: The maintenance_cron of this DBConnection.
        :type: str
        """

        self._maintenance_cron = maintenance_cron

    @property
    def last_regen_at(self):
        """
        Gets the last_regen_at of this DBConnection.
        Unix timestamp at start of last completed PDT trigger check process

        :return: The last_regen_at of this DBConnection.
        :rtype: str
        """
        return self._last_regen_at

    @last_regen_at.setter
    def last_regen_at(self, last_regen_at):
        """
        Sets the last_regen_at of this DBConnection.
        Unix timestamp at start of last completed PDT trigger check process

        :param last_regen_at: The last_regen_at of this DBConnection.
        :type: str
        """

        self._last_regen_at = last_regen_at

    @property
    def last_reap_at(self):
        """
        Gets the last_reap_at of this DBConnection.
        Unix timestamp at start of last completed PDT reap process

        :return: The last_reap_at of this DBConnection.
        :rtype: str
        """
        return self._last_reap_at

    @last_reap_at.setter
    def last_reap_at(self, last_reap_at):
        """
        Sets the last_reap_at of this DBConnection.
        Unix timestamp at start of last completed PDT reap process

        :param last_reap_at: The last_reap_at of this DBConnection.
        :type: str
        """

        self._last_reap_at = last_reap_at

    @property
    def sql_runner_precache_tables(self):
        """
        Gets the sql_runner_precache_tables of this DBConnection.
        Precache tables in the SQL Runner

        :return: The sql_runner_precache_tables of this DBConnection.
        :rtype: bool
        """
        return self._sql_runner_precache_tables

    @sql_runner_precache_tables.setter
    def sql_runner_precache_tables(self, sql_runner_precache_tables):
        """
        Sets the sql_runner_precache_tables of this DBConnection.
        Precache tables in the SQL Runner

        :param sql_runner_precache_tables: The sql_runner_precache_tables of this DBConnection.
        :type: bool
        """

        self._sql_runner_precache_tables = sql_runner_precache_tables

    @property
    def after_connect_statements(self):
        """
        Gets the after_connect_statements of this DBConnection.
        SQL statements (semicolon separated) to issue after connecting to the database. Requires `custom_after_connect_statements` license feature

        :return: The after_connect_statements of this DBConnection.
        :rtype: str
        """
        return self._after_connect_statements

    @after_connect_statements.setter
    def after_connect_statements(self, after_connect_statements):
        """
        Sets the after_connect_statements of this DBConnection.
        SQL statements (semicolon separated) to issue after connecting to the database. Requires `custom_after_connect_statements` license feature

        :param after_connect_statements: The after_connect_statements of this DBConnection.
        :type: str
        """

        self._after_connect_statements = after_connect_statements

    @property
    def pdt_context_override(self):
        """
        Gets the pdt_context_override of this DBConnection.
        db_connection_override for this connection in the `pdt` maintenance context

        :return: The pdt_context_override of this DBConnection.
        :rtype: DBConnectionOverride
        """
        return self._pdt_context_override

    @pdt_context_override.setter
    def pdt_context_override(self, pdt_context_override):
        """
        Sets the pdt_context_override of this DBConnection.
        db_connection_override for this connection in the `pdt` maintenance context

        :param pdt_context_override: The pdt_context_override of this DBConnection.
        :type: DBConnectionOverride
        """

        self._pdt_context_override = pdt_context_override

    @property
    def can(self):
        """
        Gets the can of this DBConnection.
        Operations the current user is able to perform on this object

        :return: The can of this DBConnection.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this DBConnection.
        Operations the current user is able to perform on this object

        :param can: The can of this DBConnection.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DBConnection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
