# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DataActionFormField(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, label=None, description=None, type=None, default=None, required=None, options=None):
        """
        DataActionFormField - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'label': 'str',
            'description': 'str',
            'type': 'str',
            'default': 'str',
            'required': 'bool',
            'options': 'list[DataActionFormSelectOption]'
        }

        self.attribute_map = {
            'name': 'name',
            'label': 'label',
            'description': 'description',
            'type': 'type',
            'default': 'default',
            'required': 'required',
            'options': 'options'
        }

        self._name = name
        self._label = label
        self._description = description
        self._type = type
        self._default = default
        self._required = required
        self._options = options

    @property
    def name(self):
        """
        Gets the name of this DataActionFormField.
        Name

        :return: The name of this DataActionFormField.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DataActionFormField.
        Name

        :param name: The name of this DataActionFormField.
        :type: str
        """

        self._name = name

    @property
    def label(self):
        """
        Gets the label of this DataActionFormField.
        Human-readable label

        :return: The label of this DataActionFormField.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this DataActionFormField.
        Human-readable label

        :param label: The label of this DataActionFormField.
        :type: str
        """

        self._label = label

    @property
    def description(self):
        """
        Gets the description of this DataActionFormField.
        Description of field

        :return: The description of this DataActionFormField.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DataActionFormField.
        Description of field

        :param description: The description of this DataActionFormField.
        :type: str
        """

        self._description = description

    @property
    def type(self):
        """
        Gets the type of this DataActionFormField.
        Type of field.

        :return: The type of this DataActionFormField.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DataActionFormField.
        Type of field.

        :param type: The type of this DataActionFormField.
        :type: str
        """

        self._type = type

    @property
    def default(self):
        """
        Gets the default of this DataActionFormField.
        Default value of the field.

        :return: The default of this DataActionFormField.
        :rtype: str
        """
        return self._default

    @default.setter
    def default(self, default):
        """
        Sets the default of this DataActionFormField.
        Default value of the field.

        :param default: The default of this DataActionFormField.
        :type: str
        """

        self._default = default

    @property
    def required(self):
        """
        Gets the required of this DataActionFormField.
        Whether or not the field is required. This is a user-interface hint. A user interface displaying this form should not submit it without a value for this field. The action server must also perform this validation.

        :return: The required of this DataActionFormField.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this DataActionFormField.
        Whether or not the field is required. This is a user-interface hint. A user interface displaying this form should not submit it without a value for this field. The action server must also perform this validation.

        :param required: The required of this DataActionFormField.
        :type: bool
        """

        self._required = required

    @property
    def options(self):
        """
        Gets the options of this DataActionFormField.
        If the form type is 'select', a list of options to be selected from.

        :return: The options of this DataActionFormField.
        :rtype: list[DataActionFormSelectOption]
        """
        return self._options

    @options.setter
    def options(self, options):
        """
        Sets the options of this DataActionFormField.
        If the form type is 'select', a list of options to be selected from.

        :param options: The options of this DataActionFormField.
        :type: list[DataActionFormSelectOption]
        """

        self._options = options

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DataActionFormField):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
