# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DashboardLayoutComponent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, dashboard_layout_id=None, dashboard_element_id=None, row=None, column=None, width=None, height=None, deleted=None, can=None):
        """
        DashboardLayoutComponent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'dashboard_layout_id': 'str',
            'dashboard_element_id': 'str',
            'row': 'int',
            'column': 'int',
            'width': 'int',
            'height': 'int',
            'deleted': 'bool',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'dashboard_layout_id': 'dashboard_layout_id',
            'dashboard_element_id': 'dashboard_element_id',
            'row': 'row',
            'column': 'column',
            'width': 'width',
            'height': 'height',
            'deleted': 'deleted',
            'can': 'can'
        }

        self._id = id
        self._dashboard_layout_id = dashboard_layout_id
        self._dashboard_element_id = dashboard_element_id
        self._row = row
        self._column = column
        self._width = width
        self._height = height
        self._deleted = deleted
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this DashboardLayoutComponent.
        Unique Id

        :return: The id of this DashboardLayoutComponent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DashboardLayoutComponent.
        Unique Id

        :param id: The id of this DashboardLayoutComponent.
        :type: str
        """

        self._id = id

    @property
    def dashboard_layout_id(self):
        """
        Gets the dashboard_layout_id of this DashboardLayoutComponent.
        Id of Dashboard Layout

        :return: The dashboard_layout_id of this DashboardLayoutComponent.
        :rtype: str
        """
        return self._dashboard_layout_id

    @dashboard_layout_id.setter
    def dashboard_layout_id(self, dashboard_layout_id):
        """
        Sets the dashboard_layout_id of this DashboardLayoutComponent.
        Id of Dashboard Layout

        :param dashboard_layout_id: The dashboard_layout_id of this DashboardLayoutComponent.
        :type: str
        """

        self._dashboard_layout_id = dashboard_layout_id

    @property
    def dashboard_element_id(self):
        """
        Gets the dashboard_element_id of this DashboardLayoutComponent.
        Id Of Dashboard Element

        :return: The dashboard_element_id of this DashboardLayoutComponent.
        :rtype: str
        """
        return self._dashboard_element_id

    @dashboard_element_id.setter
    def dashboard_element_id(self, dashboard_element_id):
        """
        Sets the dashboard_element_id of this DashboardLayoutComponent.
        Id Of Dashboard Element

        :param dashboard_element_id: The dashboard_element_id of this DashboardLayoutComponent.
        :type: str
        """

        self._dashboard_element_id = dashboard_element_id

    @property
    def row(self):
        """
        Gets the row of this DashboardLayoutComponent.
        Row

        :return: The row of this DashboardLayoutComponent.
        :rtype: int
        """
        return self._row

    @row.setter
    def row(self, row):
        """
        Sets the row of this DashboardLayoutComponent.
        Row

        :param row: The row of this DashboardLayoutComponent.
        :type: int
        """

        self._row = row

    @property
    def column(self):
        """
        Gets the column of this DashboardLayoutComponent.
        Column

        :return: The column of this DashboardLayoutComponent.
        :rtype: int
        """
        return self._column

    @column.setter
    def column(self, column):
        """
        Sets the column of this DashboardLayoutComponent.
        Column

        :param column: The column of this DashboardLayoutComponent.
        :type: int
        """

        self._column = column

    @property
    def width(self):
        """
        Gets the width of this DashboardLayoutComponent.
        Width

        :return: The width of this DashboardLayoutComponent.
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """
        Sets the width of this DashboardLayoutComponent.
        Width

        :param width: The width of this DashboardLayoutComponent.
        :type: int
        """

        self._width = width

    @property
    def height(self):
        """
        Gets the height of this DashboardLayoutComponent.
        Height

        :return: The height of this DashboardLayoutComponent.
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """
        Sets the height of this DashboardLayoutComponent.
        Height

        :param height: The height of this DashboardLayoutComponent.
        :type: int
        """

        self._height = height

    @property
    def deleted(self):
        """
        Gets the deleted of this DashboardLayoutComponent.
        Whether or not the dashboard layout component is deleted

        :return: The deleted of this DashboardLayoutComponent.
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """
        Sets the deleted of this DashboardLayoutComponent.
        Whether or not the dashboard layout component is deleted

        :param deleted: The deleted of this DashboardLayoutComponent.
        :type: bool
        """

        self._deleted = deleted

    @property
    def can(self):
        """
        Gets the can of this DashboardLayoutComponent.
        Operations the current user is able to perform on this object

        :return: The can of this DashboardLayoutComponent.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this DashboardLayoutComponent.
        Operations the current user is able to perform on this object

        :param can: The can of this DashboardLayoutComponent.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DashboardLayoutComponent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
