# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DashboardLayout(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, dashboard_id=None, type=None, active=None, column_width=None, width=None, deleted=None, dashboard_layout_components=None, can=None):
        """
        DashboardLayout - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'dashboard_id': 'str',
            'type': 'str',
            'active': 'bool',
            'column_width': 'int',
            'width': 'int',
            'deleted': 'bool',
            'dashboard_layout_components': 'list[DashboardLayoutComponent]',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'dashboard_id': 'dashboard_id',
            'type': 'type',
            'active': 'active',
            'column_width': 'column_width',
            'width': 'width',
            'deleted': 'deleted',
            'dashboard_layout_components': 'dashboard_layout_components',
            'can': 'can'
        }

        self._id = id
        self._dashboard_id = dashboard_id
        self._type = type
        self._active = active
        self._column_width = column_width
        self._width = width
        self._deleted = deleted
        self._dashboard_layout_components = dashboard_layout_components
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this DashboardLayout.
        Unique Id

        :return: The id of this DashboardLayout.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DashboardLayout.
        Unique Id

        :param id: The id of this DashboardLayout.
        :type: str
        """

        self._id = id

    @property
    def dashboard_id(self):
        """
        Gets the dashboard_id of this DashboardLayout.
        Id of Dashboard

        :return: The dashboard_id of this DashboardLayout.
        :rtype: str
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """
        Sets the dashboard_id of this DashboardLayout.
        Id of Dashboard

        :param dashboard_id: The dashboard_id of this DashboardLayout.
        :type: str
        """

        self._dashboard_id = dashboard_id

    @property
    def type(self):
        """
        Gets the type of this DashboardLayout.
        Type

        :return: The type of this DashboardLayout.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DashboardLayout.
        Type

        :param type: The type of this DashboardLayout.
        :type: str
        """

        self._type = type

    @property
    def active(self):
        """
        Gets the active of this DashboardLayout.
        Is Active

        :return: The active of this DashboardLayout.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this DashboardLayout.
        Is Active

        :param active: The active of this DashboardLayout.
        :type: bool
        """

        self._active = active

    @property
    def column_width(self):
        """
        Gets the column_width of this DashboardLayout.
        Column Width

        :return: The column_width of this DashboardLayout.
        :rtype: int
        """
        return self._column_width

    @column_width.setter
    def column_width(self, column_width):
        """
        Sets the column_width of this DashboardLayout.
        Column Width

        :param column_width: The column_width of this DashboardLayout.
        :type: int
        """

        self._column_width = column_width

    @property
    def width(self):
        """
        Gets the width of this DashboardLayout.
        Width

        :return: The width of this DashboardLayout.
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """
        Sets the width of this DashboardLayout.
        Width

        :param width: The width of this DashboardLayout.
        :type: int
        """

        self._width = width

    @property
    def deleted(self):
        """
        Gets the deleted of this DashboardLayout.
        Whether or not the dashboard layout is deleted.

        :return: The deleted of this DashboardLayout.
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """
        Sets the deleted of this DashboardLayout.
        Whether or not the dashboard layout is deleted.

        :param deleted: The deleted of this DashboardLayout.
        :type: bool
        """

        self._deleted = deleted

    @property
    def dashboard_layout_components(self):
        """
        Gets the dashboard_layout_components of this DashboardLayout.
        Components

        :return: The dashboard_layout_components of this DashboardLayout.
        :rtype: list[DashboardLayoutComponent]
        """
        return self._dashboard_layout_components

    @dashboard_layout_components.setter
    def dashboard_layout_components(self, dashboard_layout_components):
        """
        Sets the dashboard_layout_components of this DashboardLayout.
        Components

        :param dashboard_layout_components: The dashboard_layout_components of this DashboardLayout.
        :type: list[DashboardLayoutComponent]
        """

        self._dashboard_layout_components = dashboard_layout_components

    @property
    def can(self):
        """
        Gets the can of this DashboardLayout.
        Operations the current user is able to perform on this object

        :return: The can of this DashboardLayout.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this DashboardLayout.
        Operations the current user is able to perform on this object

        :param can: The can of this DashboardLayout.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DashboardLayout):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
