# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DashboardFilter(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, dashboard_id=None, name=None, title=None, type=None, default_value=None, model=None, explore=None, dimension=None, field=None, row=None, listens_to_filters=None, allow_multiple_values=None, required=None, can=None):
        """
        DashboardFilter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'dashboard_id': 'str',
            'name': 'str',
            'title': 'str',
            'type': 'str',
            'default_value': 'str',
            'model': 'str',
            'explore': 'str',
            'dimension': 'str',
            'field': 'dict(str, str)',
            'row': 'int',
            'listens_to_filters': 'list[str]',
            'allow_multiple_values': 'bool',
            'required': 'bool',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'dashboard_id': 'dashboard_id',
            'name': 'name',
            'title': 'title',
            'type': 'type',
            'default_value': 'default_value',
            'model': 'model',
            'explore': 'explore',
            'dimension': 'dimension',
            'field': 'field',
            'row': 'row',
            'listens_to_filters': 'listens_to_filters',
            'allow_multiple_values': 'allow_multiple_values',
            'required': 'required',
            'can': 'can'
        }

        self._id = id
        self._dashboard_id = dashboard_id
        self._name = name
        self._title = title
        self._type = type
        self._default_value = default_value
        self._model = model
        self._explore = explore
        self._dimension = dimension
        self._field = field
        self._row = row
        self._listens_to_filters = listens_to_filters
        self._allow_multiple_values = allow_multiple_values
        self._required = required
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this DashboardFilter.
        Unique Id

        :return: The id of this DashboardFilter.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DashboardFilter.
        Unique Id

        :param id: The id of this DashboardFilter.
        :type: str
        """

        self._id = id

    @property
    def dashboard_id(self):
        """
        Gets the dashboard_id of this DashboardFilter.
        Id of Dashboard

        :return: The dashboard_id of this DashboardFilter.
        :rtype: str
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """
        Sets the dashboard_id of this DashboardFilter.
        Id of Dashboard

        :param dashboard_id: The dashboard_id of this DashboardFilter.
        :type: str
        """

        self._dashboard_id = dashboard_id

    @property
    def name(self):
        """
        Gets the name of this DashboardFilter.
        Name of filter

        :return: The name of this DashboardFilter.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DashboardFilter.
        Name of filter

        :param name: The name of this DashboardFilter.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def title(self):
        """
        Gets the title of this DashboardFilter.
        Title of filter

        :return: The title of this DashboardFilter.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this DashboardFilter.
        Title of filter

        :param title: The title of this DashboardFilter.
        :type: str
        """
        if title is None:
            raise ValueError("Invalid value for `title`, must not be `None`")

        self._title = title

    @property
    def type(self):
        """
        Gets the type of this DashboardFilter.
        Type of filter: one of date, number, string, or field

        :return: The type of this DashboardFilter.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DashboardFilter.
        Type of filter: one of date, number, string, or field

        :param type: The type of this DashboardFilter.
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")

        self._type = type

    @property
    def default_value(self):
        """
        Gets the default_value of this DashboardFilter.
        Default value of filter

        :return: The default_value of this DashboardFilter.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this DashboardFilter.
        Default value of filter

        :param default_value: The default_value of this DashboardFilter.
        :type: str
        """

        self._default_value = default_value

    @property
    def model(self):
        """
        Gets the model of this DashboardFilter.
        Model of filter (required if type = field)

        :return: The model of this DashboardFilter.
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """
        Sets the model of this DashboardFilter.
        Model of filter (required if type = field)

        :param model: The model of this DashboardFilter.
        :type: str
        """

        self._model = model

    @property
    def explore(self):
        """
        Gets the explore of this DashboardFilter.
        Explore of filter (required if type = field)

        :return: The explore of this DashboardFilter.
        :rtype: str
        """
        return self._explore

    @explore.setter
    def explore(self, explore):
        """
        Sets the explore of this DashboardFilter.
        Explore of filter (required if type = field)

        :param explore: The explore of this DashboardFilter.
        :type: str
        """

        self._explore = explore

    @property
    def dimension(self):
        """
        Gets the dimension of this DashboardFilter.
        Dimension of filter (required if type = field)

        :return: The dimension of this DashboardFilter.
        :rtype: str
        """
        return self._dimension

    @dimension.setter
    def dimension(self, dimension):
        """
        Sets the dimension of this DashboardFilter.
        Dimension of filter (required if type = field)

        :param dimension: The dimension of this DashboardFilter.
        :type: str
        """

        self._dimension = dimension

    @property
    def field(self):
        """
        Gets the field of this DashboardFilter.
        Field information

        :return: The field of this DashboardFilter.
        :rtype: dict(str, str)
        """
        return self._field

    @field.setter
    def field(self, field):
        """
        Sets the field of this DashboardFilter.
        Field information

        :param field: The field of this DashboardFilter.
        :type: dict(str, str)
        """

        self._field = field

    @property
    def row(self):
        """
        Gets the row of this DashboardFilter.
        Display order of this filter relative to other filters

        :return: The row of this DashboardFilter.
        :rtype: int
        """
        return self._row

    @row.setter
    def row(self, row):
        """
        Sets the row of this DashboardFilter.
        Display order of this filter relative to other filters

        :param row: The row of this DashboardFilter.
        :type: int
        """

        self._row = row

    @property
    def listens_to_filters(self):
        """
        Gets the listens_to_filters of this DashboardFilter.
        Array of listeners for faceted filters

        :return: The listens_to_filters of this DashboardFilter.
        :rtype: list[str]
        """
        return self._listens_to_filters

    @listens_to_filters.setter
    def listens_to_filters(self, listens_to_filters):
        """
        Sets the listens_to_filters of this DashboardFilter.
        Array of listeners for faceted filters

        :param listens_to_filters: The listens_to_filters of this DashboardFilter.
        :type: list[str]
        """

        self._listens_to_filters = listens_to_filters

    @property
    def allow_multiple_values(self):
        """
        Gets the allow_multiple_values of this DashboardFilter.
        Whether the filter allows multiple filter values

        :return: The allow_multiple_values of this DashboardFilter.
        :rtype: bool
        """
        return self._allow_multiple_values

    @allow_multiple_values.setter
    def allow_multiple_values(self, allow_multiple_values):
        """
        Sets the allow_multiple_values of this DashboardFilter.
        Whether the filter allows multiple filter values

        :param allow_multiple_values: The allow_multiple_values of this DashboardFilter.
        :type: bool
        """

        self._allow_multiple_values = allow_multiple_values

    @property
    def required(self):
        """
        Gets the required of this DashboardFilter.
        Whether the filter requires a value to run the dashboard

        :return: The required of this DashboardFilter.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this DashboardFilter.
        Whether the filter requires a value to run the dashboard

        :param required: The required of this DashboardFilter.
        :type: bool
        """

        self._required = required

    @property
    def can(self):
        """
        Gets the can of this DashboardFilter.
        Operations the current user is able to perform on this object

        :return: The can of this DashboardFilter.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this DashboardFilter.
        Operations the current user is able to perform on this object

        :param can: The can of this DashboardFilter.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DashboardFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
