# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DashboardBase(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, user_id=None, title=None, description=None, readonly=None, hidden=None, refresh_interval=None, refresh_interval_to_i=None, space=None, model=None, content_favorite_id=None, scheduled_plan=None, content_metadata_id=None, query_timezone=None, can=None):
        """
        DashboardBase - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'user_id': 'int',
            'title': 'str',
            'description': 'str',
            'readonly': 'bool',
            'hidden': 'bool',
            'refresh_interval': 'str',
            'refresh_interval_to_i': 'int',
            'space': 'SpaceBase',
            'model': 'LookModel',
            'content_favorite_id': 'int',
            'scheduled_plan': 'ScheduledPlan',
            'content_metadata_id': 'int',
            'query_timezone': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'user_id': 'user_id',
            'title': 'title',
            'description': 'description',
            'readonly': 'readonly',
            'hidden': 'hidden',
            'refresh_interval': 'refresh_interval',
            'refresh_interval_to_i': 'refresh_interval_to_i',
            'space': 'space',
            'model': 'model',
            'content_favorite_id': 'content_favorite_id',
            'scheduled_plan': 'scheduled_plan',
            'content_metadata_id': 'content_metadata_id',
            'query_timezone': 'query_timezone',
            'can': 'can'
        }

        self._id = id
        self._user_id = user_id
        self._title = title
        self._description = description
        self._readonly = readonly
        self._hidden = hidden
        self._refresh_interval = refresh_interval
        self._refresh_interval_to_i = refresh_interval_to_i
        self._space = space
        self._model = model
        self._content_favorite_id = content_favorite_id
        self._scheduled_plan = scheduled_plan
        self._content_metadata_id = content_metadata_id
        self._query_timezone = query_timezone
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this DashboardBase.
        Unique Id

        :return: The id of this DashboardBase.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DashboardBase.
        Unique Id

        :param id: The id of this DashboardBase.
        :type: str
        """

        self._id = id

    @property
    def user_id(self):
        """
        Gets the user_id of this DashboardBase.
        Id of User

        :return: The user_id of this DashboardBase.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this DashboardBase.
        Id of User

        :param user_id: The user_id of this DashboardBase.
        :type: int
        """

        self._user_id = user_id

    @property
    def title(self):
        """
        Gets the title of this DashboardBase.
        Look Title

        :return: The title of this DashboardBase.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this DashboardBase.
        Look Title

        :param title: The title of this DashboardBase.
        :type: str
        """

        self._title = title

    @property
    def description(self):
        """
        Gets the description of this DashboardBase.
        Description

        :return: The description of this DashboardBase.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DashboardBase.
        Description

        :param description: The description of this DashboardBase.
        :type: str
        """

        self._description = description

    @property
    def readonly(self):
        """
        Gets the readonly of this DashboardBase.
        Is Read-only

        :return: The readonly of this DashboardBase.
        :rtype: bool
        """
        return self._readonly

    @readonly.setter
    def readonly(self, readonly):
        """
        Sets the readonly of this DashboardBase.
        Is Read-only

        :param readonly: The readonly of this DashboardBase.
        :type: bool
        """

        self._readonly = readonly

    @property
    def hidden(self):
        """
        Gets the hidden of this DashboardBase.
        Is Hidden

        :return: The hidden of this DashboardBase.
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """
        Sets the hidden of this DashboardBase.
        Is Hidden

        :param hidden: The hidden of this DashboardBase.
        :type: bool
        """

        self._hidden = hidden

    @property
    def refresh_interval(self):
        """
        Gets the refresh_interval of this DashboardBase.
        Refresh Interval

        :return: The refresh_interval of this DashboardBase.
        :rtype: str
        """
        return self._refresh_interval

    @refresh_interval.setter
    def refresh_interval(self, refresh_interval):
        """
        Sets the refresh_interval of this DashboardBase.
        Refresh Interval

        :param refresh_interval: The refresh_interval of this DashboardBase.
        :type: str
        """

        self._refresh_interval = refresh_interval

    @property
    def refresh_interval_to_i(self):
        """
        Gets the refresh_interval_to_i of this DashboardBase.
        Refresh Interval as Integer

        :return: The refresh_interval_to_i of this DashboardBase.
        :rtype: int
        """
        return self._refresh_interval_to_i

    @refresh_interval_to_i.setter
    def refresh_interval_to_i(self, refresh_interval_to_i):
        """
        Sets the refresh_interval_to_i of this DashboardBase.
        Refresh Interval as Integer

        :param refresh_interval_to_i: The refresh_interval_to_i of this DashboardBase.
        :type: int
        """

        self._refresh_interval_to_i = refresh_interval_to_i

    @property
    def space(self):
        """
        Gets the space of this DashboardBase.
        Space

        :return: The space of this DashboardBase.
        :rtype: SpaceBase
        """
        return self._space

    @space.setter
    def space(self, space):
        """
        Sets the space of this DashboardBase.
        Space

        :param space: The space of this DashboardBase.
        :type: SpaceBase
        """

        self._space = space

    @property
    def model(self):
        """
        Gets the model of this DashboardBase.
        Model

        :return: The model of this DashboardBase.
        :rtype: LookModel
        """
        return self._model

    @model.setter
    def model(self, model):
        """
        Sets the model of this DashboardBase.
        Model

        :param model: The model of this DashboardBase.
        :type: LookModel
        """

        self._model = model

    @property
    def content_favorite_id(self):
        """
        Gets the content_favorite_id of this DashboardBase.
        Content Favorite Id

        :return: The content_favorite_id of this DashboardBase.
        :rtype: int
        """
        return self._content_favorite_id

    @content_favorite_id.setter
    def content_favorite_id(self, content_favorite_id):
        """
        Sets the content_favorite_id of this DashboardBase.
        Content Favorite Id

        :param content_favorite_id: The content_favorite_id of this DashboardBase.
        :type: int
        """

        self._content_favorite_id = content_favorite_id

    @property
    def scheduled_plan(self):
        """
        Gets the scheduled_plan of this DashboardBase.
        ScheduledPlan

        :return: The scheduled_plan of this DashboardBase.
        :rtype: ScheduledPlan
        """
        return self._scheduled_plan

    @scheduled_plan.setter
    def scheduled_plan(self, scheduled_plan):
        """
        Sets the scheduled_plan of this DashboardBase.
        ScheduledPlan

        :param scheduled_plan: The scheduled_plan of this DashboardBase.
        :type: ScheduledPlan
        """

        self._scheduled_plan = scheduled_plan

    @property
    def content_metadata_id(self):
        """
        Gets the content_metadata_id of this DashboardBase.
        Id of content metadata

        :return: The content_metadata_id of this DashboardBase.
        :rtype: int
        """
        return self._content_metadata_id

    @content_metadata_id.setter
    def content_metadata_id(self, content_metadata_id):
        """
        Sets the content_metadata_id of this DashboardBase.
        Id of content metadata

        :param content_metadata_id: The content_metadata_id of this DashboardBase.
        :type: int
        """

        self._content_metadata_id = content_metadata_id

    @property
    def query_timezone(self):
        """
        Gets the query_timezone of this DashboardBase.
        Timezone in which the Dashboard will run by default.

        :return: The query_timezone of this DashboardBase.
        :rtype: str
        """
        return self._query_timezone

    @query_timezone.setter
    def query_timezone(self, query_timezone):
        """
        Sets the query_timezone of this DashboardBase.
        Timezone in which the Dashboard will run by default.

        :param query_timezone: The query_timezone of this DashboardBase.
        :type: str
        """

        self._query_timezone = query_timezone

    @property
    def can(self):
        """
        Gets the can of this DashboardBase.
        Operations the current user is able to perform on this object

        :return: The can of this DashboardBase.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this DashboardBase.
        Operations the current user is able to perform on this object

        :param can: The can of this DashboardBase.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DashboardBase):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
