# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CreateQueryTask(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, query_id=None, result_format=None, source=None, deferred=None, look_id=None, dashboard_id=None, can=None):
        """
        CreateQueryTask - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'query_id': 'int',
            'result_format': 'str',
            'source': 'str',
            'deferred': 'bool',
            'look_id': 'int',
            'dashboard_id': 'str',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'query_id': 'query_id',
            'result_format': 'result_format',
            'source': 'source',
            'deferred': 'deferred',
            'look_id': 'look_id',
            'dashboard_id': 'dashboard_id',
            'can': 'can'
        }

        self._query_id = query_id
        self._result_format = result_format
        self._source = source
        self._deferred = deferred
        self._look_id = look_id
        self._dashboard_id = dashboard_id
        self._can = can

    @property
    def query_id(self):
        """
        Gets the query_id of this CreateQueryTask.
        Id of query to run

        :return: The query_id of this CreateQueryTask.
        :rtype: int
        """
        return self._query_id

    @query_id.setter
    def query_id(self, query_id):
        """
        Sets the query_id of this CreateQueryTask.
        Id of query to run

        :param query_id: The query_id of this CreateQueryTask.
        :type: int
        """
        if query_id is None:
            raise ValueError("Invalid value for `query_id`, must not be `None`")

        self._query_id = query_id

    @property
    def result_format(self):
        """
        Gets the result_format of this CreateQueryTask.
        Desired result format

        :return: The result_format of this CreateQueryTask.
        :rtype: str
        """
        return self._result_format

    @result_format.setter
    def result_format(self, result_format):
        """
        Sets the result_format of this CreateQueryTask.
        Desired result format

        :param result_format: The result_format of this CreateQueryTask.
        :type: str
        """
        if result_format is None:
            raise ValueError("Invalid value for `result_format`, must not be `None`")

        self._result_format = result_format

    @property
    def source(self):
        """
        Gets the source of this CreateQueryTask.
        Source of query task

        :return: The source of this CreateQueryTask.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this CreateQueryTask.
        Source of query task

        :param source: The source of this CreateQueryTask.
        :type: str
        """

        self._source = source

    @property
    def deferred(self):
        """
        Gets the deferred of this CreateQueryTask.
        Create the task but defer execution

        :return: The deferred of this CreateQueryTask.
        :rtype: bool
        """
        return self._deferred

    @deferred.setter
    def deferred(self, deferred):
        """
        Sets the deferred of this CreateQueryTask.
        Create the task but defer execution

        :param deferred: The deferred of this CreateQueryTask.
        :type: bool
        """

        self._deferred = deferred

    @property
    def look_id(self):
        """
        Gets the look_id of this CreateQueryTask.
        Id of look associated with query.

        :return: The look_id of this CreateQueryTask.
        :rtype: int
        """
        return self._look_id

    @look_id.setter
    def look_id(self, look_id):
        """
        Sets the look_id of this CreateQueryTask.
        Id of look associated with query.

        :param look_id: The look_id of this CreateQueryTask.
        :type: int
        """

        self._look_id = look_id

    @property
    def dashboard_id(self):
        """
        Gets the dashboard_id of this CreateQueryTask.
        Id of dashboard associated with query.

        :return: The dashboard_id of this CreateQueryTask.
        :rtype: str
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """
        Sets the dashboard_id of this CreateQueryTask.
        Id of dashboard associated with query.

        :param dashboard_id: The dashboard_id of this CreateQueryTask.
        :type: str
        """

        self._dashboard_id = dashboard_id

    @property
    def can(self):
        """
        Gets the can of this CreateQueryTask.
        Operations the current user is able to perform on this object

        :return: The can of this CreateQueryTask.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this CreateQueryTask.
        Operations the current user is able to perform on this object

        :param can: The can of this CreateQueryTask.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CreateQueryTask):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
