# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ContentMeta(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, parent_id=None, space_id=None, dashboard_id=None, look_id=None, content_type=None, inherits=None, inheriting_id=None, can=None):
        """
        ContentMeta - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'parent_id': 'int',
            'space_id': 'str',
            'dashboard_id': 'str',
            'look_id': 'int',
            'content_type': 'str',
            'inherits': 'bool',
            'inheriting_id': 'int',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'parent_id': 'parent_id',
            'space_id': 'space_id',
            'dashboard_id': 'dashboard_id',
            'look_id': 'look_id',
            'content_type': 'content_type',
            'inherits': 'inherits',
            'inheriting_id': 'inheriting_id',
            'can': 'can'
        }

        self._id = id
        self._name = name
        self._parent_id = parent_id
        self._space_id = space_id
        self._dashboard_id = dashboard_id
        self._look_id = look_id
        self._content_type = content_type
        self._inherits = inherits
        self._inheriting_id = inheriting_id
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this ContentMeta.
        Unique Id

        :return: The id of this ContentMeta.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContentMeta.
        Unique Id

        :param id: The id of this ContentMeta.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ContentMeta.
        Name or title of underlying content

        :return: The name of this ContentMeta.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ContentMeta.
        Name or title of underlying content

        :param name: The name of this ContentMeta.
        :type: str
        """

        self._name = name

    @property
    def parent_id(self):
        """
        Gets the parent_id of this ContentMeta.
        Id of Parent Content

        :return: The parent_id of this ContentMeta.
        :rtype: int
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """
        Sets the parent_id of this ContentMeta.
        Id of Parent Content

        :param parent_id: The parent_id of this ContentMeta.
        :type: int
        """

        self._parent_id = parent_id

    @property
    def space_id(self):
        """
        Gets the space_id of this ContentMeta.
        Id of associated space when content_type is \"space\"

        :return: The space_id of this ContentMeta.
        :rtype: str
        """
        return self._space_id

    @space_id.setter
    def space_id(self, space_id):
        """
        Sets the space_id of this ContentMeta.
        Id of associated space when content_type is \"space\"

        :param space_id: The space_id of this ContentMeta.
        :type: str
        """

        self._space_id = space_id

    @property
    def dashboard_id(self):
        """
        Gets the dashboard_id of this ContentMeta.
        Id of associated dashboard when content_type is \"dashboard\"

        :return: The dashboard_id of this ContentMeta.
        :rtype: str
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """
        Sets the dashboard_id of this ContentMeta.
        Id of associated dashboard when content_type is \"dashboard\"

        :param dashboard_id: The dashboard_id of this ContentMeta.
        :type: str
        """

        self._dashboard_id = dashboard_id

    @property
    def look_id(self):
        """
        Gets the look_id of this ContentMeta.
        Id of associated look when content_type is \"look\"

        :return: The look_id of this ContentMeta.
        :rtype: int
        """
        return self._look_id

    @look_id.setter
    def look_id(self, look_id):
        """
        Sets the look_id of this ContentMeta.
        Id of associated look when content_type is \"look\"

        :param look_id: The look_id of this ContentMeta.
        :type: int
        """

        self._look_id = look_id

    @property
    def content_type(self):
        """
        Gets the content_type of this ContentMeta.
        Content Type (\"dashboard\", \"look\", or \"space\")

        :return: The content_type of this ContentMeta.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this ContentMeta.
        Content Type (\"dashboard\", \"look\", or \"space\")

        :param content_type: The content_type of this ContentMeta.
        :type: str
        """

        self._content_type = content_type

    @property
    def inherits(self):
        """
        Gets the inherits of this ContentMeta.
        Whether content inherits its access levels from parent

        :return: The inherits of this ContentMeta.
        :rtype: bool
        """
        return self._inherits

    @inherits.setter
    def inherits(self, inherits):
        """
        Sets the inherits of this ContentMeta.
        Whether content inherits its access levels from parent

        :param inherits: The inherits of this ContentMeta.
        :type: bool
        """

        self._inherits = inherits

    @property
    def inheriting_id(self):
        """
        Gets the inheriting_id of this ContentMeta.
        Id of Inherited Content

        :return: The inheriting_id of this ContentMeta.
        :rtype: int
        """
        return self._inheriting_id

    @inheriting_id.setter
    def inheriting_id(self, inheriting_id):
        """
        Sets the inheriting_id of this ContentMeta.
        Id of Inherited Content

        :param inheriting_id: The inheriting_id of this ContentMeta.
        :type: int
        """

        self._inheriting_id = inheriting_id

    @property
    def can(self):
        """
        Gets the can of this ContentMeta.
        Operations the current user is able to perform on this object

        :return: The can of this ContentMeta.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this ContentMeta.
        Operations the current user is able to perform on this object

        :param can: The can of this ContentMeta.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ContentMeta):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
