# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ContentFavorite(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, user_id=None, content_metadata_id=None, look_id=None, dashboard_id=None, look=None, dashboard=None, can=None):
        """
        ContentFavorite - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'user_id': 'int',
            'content_metadata_id': 'int',
            'look_id': 'int',
            'dashboard_id': 'int',
            'look': 'LookBasic',
            'dashboard': 'DashboardBase',
            'can': 'dict(str, bool)'
        }

        self.attribute_map = {
            'id': 'id',
            'user_id': 'user_id',
            'content_metadata_id': 'content_metadata_id',
            'look_id': 'look_id',
            'dashboard_id': 'dashboard_id',
            'look': 'look',
            'dashboard': 'dashboard',
            'can': 'can'
        }

        self._id = id
        self._user_id = user_id
        self._content_metadata_id = content_metadata_id
        self._look_id = look_id
        self._dashboard_id = dashboard_id
        self._look = look
        self._dashboard = dashboard
        self._can = can

    @property
    def id(self):
        """
        Gets the id of this ContentFavorite.
        Unique Id

        :return: The id of this ContentFavorite.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContentFavorite.
        Unique Id

        :param id: The id of this ContentFavorite.
        :type: int
        """

        self._id = id

    @property
    def user_id(self):
        """
        Gets the user_id of this ContentFavorite.
        User Id which owns this ContentFavorite

        :return: The user_id of this ContentFavorite.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this ContentFavorite.
        User Id which owns this ContentFavorite

        :param user_id: The user_id of this ContentFavorite.
        :type: int
        """

        self._user_id = user_id

    @property
    def content_metadata_id(self):
        """
        Gets the content_metadata_id of this ContentFavorite.
        Content Metadata Id associated with this ContentFavorite

        :return: The content_metadata_id of this ContentFavorite.
        :rtype: int
        """
        return self._content_metadata_id

    @content_metadata_id.setter
    def content_metadata_id(self, content_metadata_id):
        """
        Sets the content_metadata_id of this ContentFavorite.
        Content Metadata Id associated with this ContentFavorite

        :param content_metadata_id: The content_metadata_id of this ContentFavorite.
        :type: int
        """

        self._content_metadata_id = content_metadata_id

    @property
    def look_id(self):
        """
        Gets the look_id of this ContentFavorite.
        Id of a look

        :return: The look_id of this ContentFavorite.
        :rtype: int
        """
        return self._look_id

    @look_id.setter
    def look_id(self, look_id):
        """
        Sets the look_id of this ContentFavorite.
        Id of a look

        :param look_id: The look_id of this ContentFavorite.
        :type: int
        """

        self._look_id = look_id

    @property
    def dashboard_id(self):
        """
        Gets the dashboard_id of this ContentFavorite.
        Id of a dashboard

        :return: The dashboard_id of this ContentFavorite.
        :rtype: int
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """
        Sets the dashboard_id of this ContentFavorite.
        Id of a dashboard

        :param dashboard_id: The dashboard_id of this ContentFavorite.
        :type: int
        """

        self._dashboard_id = dashboard_id

    @property
    def look(self):
        """
        Gets the look of this ContentFavorite.
        Associated Look

        :return: The look of this ContentFavorite.
        :rtype: LookBasic
        """
        return self._look

    @look.setter
    def look(self, look):
        """
        Sets the look of this ContentFavorite.
        Associated Look

        :param look: The look of this ContentFavorite.
        :type: LookBasic
        """

        self._look = look

    @property
    def dashboard(self):
        """
        Gets the dashboard of this ContentFavorite.
        Associated Dashboard

        :return: The dashboard of this ContentFavorite.
        :rtype: DashboardBase
        """
        return self._dashboard

    @dashboard.setter
    def dashboard(self, dashboard):
        """
        Sets the dashboard of this ContentFavorite.
        Associated Dashboard

        :param dashboard: The dashboard of this ContentFavorite.
        :type: DashboardBase
        """

        self._dashboard = dashboard

    @property
    def can(self):
        """
        Gets the can of this ContentFavorite.
        Operations the current user is able to perform on this object

        :return: The can of this ContentFavorite.
        :rtype: dict(str, bool)
        """
        return self._can

    @can.setter
    def can(self, can):
        """
        Sets the can of this ContentFavorite.
        Operations the current user is able to perform on this object

        :param can: The can of this ContentFavorite.
        :type: dict(str, bool)
        """

        self._can = can

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ContentFavorite):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
