# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class SpaceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_spaces(self, **kwargs):
        """
        Get All Spaces
        ### Get information about all spaces.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_spaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[SpaceBase]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_spaces_with_http_info(**kwargs)
        else:
            (data) = self.all_spaces_with_http_info(**kwargs)
            return data

    def all_spaces_with_http_info(self, **kwargs):
        """
        Get All Spaces
        ### Get information about all spaces.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_spaces_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[SpaceBase]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_spaces" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/spaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[SpaceBase]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_space(self, **kwargs):
        """
        Create Space
        ### Create a space with specified information.  Caller must have permission to edit the parent space and to create spaces, otherwise the request returns 404 Not Found. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_space(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Space body: Space
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_space_with_http_info(**kwargs)
        else:
            (data) = self.create_space_with_http_info(**kwargs)
            return data

    def create_space_with_http_info(self, **kwargs):
        """
        Create Space
        ### Create a space with specified information.  Caller must have permission to edit the parent space and to create spaces, otherwise the request returns 404 Not Found. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_space_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Space body: Space
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_space" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/spaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Space',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_space(self, space_id, **kwargs):
        """
        Delete Space
        ### Delete the space with a specific id including any children spaces. **DANGER** this will delete all looks and dashboards in the space. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_space(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_space_with_http_info(space_id, **kwargs)
        else:
            (data) = self.delete_space_with_http_info(space_id, **kwargs)
            return data

    def delete_space_with_http_info(self, space_id, **kwargs):
        """
        Delete Space
        ### Delete the space with a specific id including any children spaces. **DANGER** this will delete all looks and dashboards in the space. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_space_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_space" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `delete_space`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_spaces(self, **kwargs):
        """
        Search Spaces
        Search for spaces by creator id, parent id, name, etc
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_spaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param int page: Requested page.
        :param int per_page: Results per page.
        :param int limit: Number of results to return. (used with offset and takes priority over page and per_page)
        :param int offset: Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        :param str sorts: Fields to sort by.
        :param str name: Match Space title.
        :param int id: Match Space id
        :param str parent_id: Filter on a children of a particular space.
        :param str creator_id: Filter on dashboards created by a particular user.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_spaces_with_http_info(**kwargs)
        else:
            (data) = self.search_spaces_with_http_info(**kwargs)
            return data

    def search_spaces_with_http_info(self, **kwargs):
        """
        Search Spaces
        Search for spaces by creator id, parent id, name, etc
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_spaces_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param int page: Requested page.
        :param int per_page: Results per page.
        :param int limit: Number of results to return. (used with offset and takes priority over page and per_page)
        :param int offset: Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        :param str sorts: Fields to sort by.
        :param str name: Match Space title.
        :param int id: Match Space id
        :param str parent_id: Filter on a children of a particular space.
        :param str creator_id: Filter on dashboards created by a particular user.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'page', 'per_page', 'limit', 'offset', 'sorts', 'name', 'id', 'parent_id', 'creator_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_spaces" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/spaces/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'offset' in params:
            query_params['offset'] = params['offset']
        if 'sorts' in params:
            query_params['sorts'] = params['sorts']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'parent_id' in params:
            query_params['parent_id'] = params['parent_id']
        if 'creator_id' in params:
            query_params['creator_id'] = params['creator_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Space]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def space(self, space_id, **kwargs):
        """
        Get Space
        ### Get information about the space with a specific id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.space_with_http_info(space_id, **kwargs)
        else:
            (data) = self.space_with_http_info(space_id, **kwargs)
            return data

    def space_with_http_info(self, space_id, **kwargs):
        """
        Get Space
        ### Get information about the space with a specific id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method space" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `space`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Space',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def space_ancestors(self, space_id, **kwargs):
        """
        Get Space Ancestors
        ### Get the ancestors of a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_ancestors(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.space_ancestors_with_http_info(space_id, **kwargs)
        else:
            (data) = self.space_ancestors_with_http_info(space_id, **kwargs)
            return data

    def space_ancestors_with_http_info(self, space_id, **kwargs):
        """
        Get Space Ancestors
        ### Get the ancestors of a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_ancestors_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method space_ancestors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `space_ancestors`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}/ancestors'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Space]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def space_children(self, space_id, **kwargs):
        """
        Get Space Children
        ### Get the children of a space.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_children(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :param int page: Requested page.
        :param int per_page: Results per page.
        :param str sorts: Fields to sort by.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.space_children_with_http_info(space_id, **kwargs)
        else:
            (data) = self.space_children_with_http_info(space_id, **kwargs)
            return data

    def space_children_with_http_info(self, space_id, **kwargs):
        """
        Get Space Children
        ### Get the children of a space.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_children_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :param int page: Requested page.
        :param int per_page: Results per page.
        :param str sorts: Fields to sort by.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'fields', 'page', 'per_page', 'sorts']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method space_children" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `space_children`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}/children'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'sorts' in params:
            query_params['sorts'] = params['sorts']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Space]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def space_children_search(self, space_id, **kwargs):
        """
        Search Space Children
        ### Search the children of a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_children_search(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :param str sorts: Fields to sort by.
        :param str name: Match Space name.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.space_children_search_with_http_info(space_id, **kwargs)
        else:
            (data) = self.space_children_search_with_http_info(space_id, **kwargs)
            return data

    def space_children_search_with_http_info(self, space_id, **kwargs):
        """
        Search Space Children
        ### Search the children of a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_children_search_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :param str sorts: Fields to sort by.
        :param str name: Match Space name.
        :return: list[Space]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'fields', 'sorts', 'name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method space_children_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `space_children_search`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}/children/search'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']
        if 'sorts' in params:
            query_params['sorts'] = params['sorts']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Space]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def space_dashboards(self, space_id, **kwargs):
        """
        Get Space Dashboards
        ### Get the dashboards in a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_dashboards(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: list[Dashboard]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.space_dashboards_with_http_info(space_id, **kwargs)
        else:
            (data) = self.space_dashboards_with_http_info(space_id, **kwargs)
            return data

    def space_dashboards_with_http_info(self, space_id, **kwargs):
        """
        Get Space Dashboards
        ### Get the dashboards in a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_dashboards_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: list[Dashboard]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method space_dashboards" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `space_dashboards`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}/dashboards'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Dashboard]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def space_looks(self, space_id, **kwargs):
        """
        Get Space Looks
        ### Get the looks in a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_looks(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: list[LookWithQuery]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.space_looks_with_http_info(space_id, **kwargs)
        else:
            (data) = self.space_looks_with_http_info(space_id, **kwargs)
            return data

    def space_looks_with_http_info(self, space_id, **kwargs):
        """
        Get Space Looks
        ### Get the looks in a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_looks_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: list[LookWithQuery]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method space_looks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `space_looks`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}/looks'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[LookWithQuery]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def space_parent(self, space_id, **kwargs):
        """
        Get Space Parent
        ### Get the parent of a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_parent(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.space_parent_with_http_info(space_id, **kwargs)
        else:
            (data) = self.space_parent_with_http_info(space_id, **kwargs)
            return data

    def space_parent_with_http_info(self, space_id, **kwargs):
        """
        Get Space Parent
        ### Get the parent of a space
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.space_parent_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param str fields: Requested fields.
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method space_parent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `space_parent`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}/parent'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Space',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_space(self, space_id, body, **kwargs):
        """
        Update Space
        ### Update the space with a specific id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_space(space_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param Space body: Space (required)
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_space_with_http_info(space_id, body, **kwargs)
        else:
            (data) = self.update_space_with_http_info(space_id, body, **kwargs)
            return data

    def update_space_with_http_info(self, space_id, body, **kwargs):
        """
        Update Space
        ### Update the space with a specific id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_space_with_http_info(space_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str space_id: Id of space (required)
        :param Space body: Space (required)
        :return: Space
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_space" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `update_space`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_space`")


        collection_formats = {}

        resource_path = '/spaces/{space_id}'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Space',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
