# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ScheduledPlanApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_scheduled_plans(self, **kwargs):
        """
        Get All Scheduled Plans
        ### Get All Scheduled Plans  Returns all scheduled plans owned by the caller or given user.  If no user_id is provided, this function returns the scheduled plans owned by the caller.   The caller must have `see_schedules` permission to see other users' scheduled plans.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_scheduled_plans(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int user_id: User Id (default is requesting user if not specified)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_scheduled_plans_with_http_info(**kwargs)
        else:
            (data) = self.all_scheduled_plans_with_http_info(**kwargs)
            return data

    def all_scheduled_plans_with_http_info(self, **kwargs):
        """
        Get All Scheduled Plans
        ### Get All Scheduled Plans  Returns all scheduled plans owned by the caller or given user.  If no user_id is provided, this function returns the scheduled plans owned by the caller.   The caller must have `see_schedules` permission to see other users' scheduled plans.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_scheduled_plans_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int user_id: User Id (default is requesting user if not specified)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_scheduled_plans" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/scheduled_plans'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ScheduledPlan]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_scheduled_plan(self, **kwargs):
        """
        Create Scheduled Plan
        ### Create a Scheduled Plan  Create a scheduled plan to render a Look or Dashboard on a recurring schedule.  The queries that provide the data for the look or dashboard are run in the context of user account that owns the scheduled plan.  Admins can create scheduled plans on behalf of other users by specifying a user id.  Scheduled plan destinations must specify the data format to produce and send to the destination  Scheduled Plan Destination formats:  | format | Description | :-----------: | :--- | | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata. | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination. | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | xlsx | MS Excel spreadsheet | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image ||  Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_scheduled_plan(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScheduledPlan body: Scheduled Plan
        :return: ScheduledPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_scheduled_plan_with_http_info(**kwargs)
        else:
            (data) = self.create_scheduled_plan_with_http_info(**kwargs)
            return data

    def create_scheduled_plan_with_http_info(self, **kwargs):
        """
        Create Scheduled Plan
        ### Create a Scheduled Plan  Create a scheduled plan to render a Look or Dashboard on a recurring schedule.  The queries that provide the data for the look or dashboard are run in the context of user account that owns the scheduled plan.  Admins can create scheduled plans on behalf of other users by specifying a user id.  Scheduled plan destinations must specify the data format to produce and send to the destination  Scheduled Plan Destination formats:  | format | Description | :-----------: | :--- | | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata. | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination. | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | xlsx | MS Excel spreadsheet | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image ||  Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_scheduled_plan_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScheduledPlan body: Scheduled Plan
        :return: ScheduledPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_scheduled_plan" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/scheduled_plans'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ScheduledPlan',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_scheduled_plan(self, scheduled_plan_id, **kwargs):
        """
        Delete Scheduled Plan
        ### Delete a Scheduled Plan  Normal users can only delete their own scheduled plans. Admins can delete other users' scheduled plans. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_scheduled_plan(scheduled_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int scheduled_plan_id: Scheduled Plan Id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_scheduled_plan_with_http_info(scheduled_plan_id, **kwargs)
        else:
            (data) = self.delete_scheduled_plan_with_http_info(scheduled_plan_id, **kwargs)
            return data

    def delete_scheduled_plan_with_http_info(self, scheduled_plan_id, **kwargs):
        """
        Delete Scheduled Plan
        ### Delete a Scheduled Plan  Normal users can only delete their own scheduled plans. Admins can delete other users' scheduled plans. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_scheduled_plan_with_http_info(scheduled_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int scheduled_plan_id: Scheduled Plan Id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scheduled_plan_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scheduled_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'scheduled_plan_id' is set
        if ('scheduled_plan_id' not in params) or (params['scheduled_plan_id'] is None):
            raise ValueError("Missing the required parameter `scheduled_plan_id` when calling `delete_scheduled_plan`")


        collection_formats = {}

        resource_path = '/scheduled_plans/{scheduled_plan_id}'.replace('{format}', 'json')
        path_params = {}
        if 'scheduled_plan_id' in params:
            path_params['scheduled_plan_id'] = params['scheduled_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def scheduled_plan(self, scheduled_plan_id, **kwargs):
        """
        Get Scheduled Plan
        ### Get Information About a Scheduled Plan  Admins can fetch information about other users' Scheduled Plans. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plan(scheduled_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int scheduled_plan_id: Scheduled Plan Id (required)
        :param str fields: Requested fields.
        :return: ScheduledPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.scheduled_plan_with_http_info(scheduled_plan_id, **kwargs)
        else:
            (data) = self.scheduled_plan_with_http_info(scheduled_plan_id, **kwargs)
            return data

    def scheduled_plan_with_http_info(self, scheduled_plan_id, **kwargs):
        """
        Get Scheduled Plan
        ### Get Information About a Scheduled Plan  Admins can fetch information about other users' Scheduled Plans. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plan_with_http_info(scheduled_plan_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int scheduled_plan_id: Scheduled Plan Id (required)
        :param str fields: Requested fields.
        :return: ScheduledPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scheduled_plan_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method scheduled_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'scheduled_plan_id' is set
        if ('scheduled_plan_id' not in params) or (params['scheduled_plan_id'] is None):
            raise ValueError("Missing the required parameter `scheduled_plan_id` when calling `scheduled_plan`")


        collection_formats = {}

        resource_path = '/scheduled_plans/{scheduled_plan_id}'.replace('{format}', 'json')
        path_params = {}
        if 'scheduled_plan_id' in params:
            path_params['scheduled_plan_id'] = params['scheduled_plan_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ScheduledPlan',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def scheduled_plan_run_once(self, **kwargs):
        """
        Run Scheduled Plan Once
        ### Run a Scheduled Plan Immediately  Create a scheduled plan that runs only once, and immediately.  This can be useful for testing a Scheduled Plan before committing to a production schedule.  Admins can create scheduled plans on behalf of other users by specifying a user id.  Scheduled plan destinations must specify the data format to produce and send to the destination  Scheduled Plan Destination formats:  | format | Description | :-----------: | :--- | | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata. | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination. | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | xlsx | MS Excel spreadsheet | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image ||  Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plan_run_once(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScheduledPlan body: Scheduled Plan
        :return: ScheduledPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.scheduled_plan_run_once_with_http_info(**kwargs)
        else:
            (data) = self.scheduled_plan_run_once_with_http_info(**kwargs)
            return data

    def scheduled_plan_run_once_with_http_info(self, **kwargs):
        """
        Run Scheduled Plan Once
        ### Run a Scheduled Plan Immediately  Create a scheduled plan that runs only once, and immediately.  This can be useful for testing a Scheduled Plan before committing to a production schedule.  Admins can create scheduled plans on behalf of other users by specifying a user id.  Scheduled plan destinations must specify the data format to produce and send to the destination  Scheduled Plan Destination formats:  | format | Description | :-----------: | :--- | | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata. | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination. | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | xlsx | MS Excel spreadsheet | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image ||  Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plan_run_once_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScheduledPlan body: Scheduled Plan
        :return: ScheduledPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method scheduled_plan_run_once" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/scheduled_plans/run_once'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ScheduledPlan',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def scheduled_plans_for_dashboard(self, dashboard_id, **kwargs):
        """
        Scheduled Plans for Dashboard
        ### Get Scheduled Plans for a Dashboard  Returns all scheduled plans owned by the caller or given user, for a given dashboard.  If no user_id is provided, this function returns the scheduled plans owned by the caller.   The caller must have `see_schedules` permission to see other users' scheduled plans.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plans_for_dashboard(dashboard_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int dashboard_id: Dashboard Id (required)
        :param int user_id: User Id (default is requesting user if not specified)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.scheduled_plans_for_dashboard_with_http_info(dashboard_id, **kwargs)
        else:
            (data) = self.scheduled_plans_for_dashboard_with_http_info(dashboard_id, **kwargs)
            return data

    def scheduled_plans_for_dashboard_with_http_info(self, dashboard_id, **kwargs):
        """
        Scheduled Plans for Dashboard
        ### Get Scheduled Plans for a Dashboard  Returns all scheduled plans owned by the caller or given user, for a given dashboard.  If no user_id is provided, this function returns the scheduled plans owned by the caller.   The caller must have `see_schedules` permission to see other users' scheduled plans.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plans_for_dashboard_with_http_info(dashboard_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int dashboard_id: Dashboard Id (required)
        :param int user_id: User Id (default is requesting user if not specified)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dashboard_id', 'user_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method scheduled_plans_for_dashboard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dashboard_id' is set
        if ('dashboard_id' not in params) or (params['dashboard_id'] is None):
            raise ValueError("Missing the required parameter `dashboard_id` when calling `scheduled_plans_for_dashboard`")


        collection_formats = {}

        resource_path = '/scheduled_plans/dashboard/{dashboard_id}'.replace('{format}', 'json')
        path_params = {}
        if 'dashboard_id' in params:
            path_params['dashboard_id'] = params['dashboard_id']

        query_params = {}
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ScheduledPlan]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def scheduled_plans_for_look(self, look_id, **kwargs):
        """
        Scheduled Plans for Look
        ### Get Scheduled Plans for a Look  Returns all scheduled plans owned by the caller or given user, for a given look.  If no user_id is provided, this function returns the scheduled plans owned by the caller.   The caller must have `see_schedules` permission to see other users' scheduled plans.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plans_for_look(look_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Look Id (required)
        :param int user_id: User Id (default is requesting user if not specified)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.scheduled_plans_for_look_with_http_info(look_id, **kwargs)
        else:
            (data) = self.scheduled_plans_for_look_with_http_info(look_id, **kwargs)
            return data

    def scheduled_plans_for_look_with_http_info(self, look_id, **kwargs):
        """
        Scheduled Plans for Look
        ### Get Scheduled Plans for a Look  Returns all scheduled plans owned by the caller or given user, for a given look.  If no user_id is provided, this function returns the scheduled plans owned by the caller.   The caller must have `see_schedules` permission to see other users' scheduled plans.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plans_for_look_with_http_info(look_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Look Id (required)
        :param int user_id: User Id (default is requesting user if not specified)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['look_id', 'user_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method scheduled_plans_for_look" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'look_id' is set
        if ('look_id' not in params) or (params['look_id'] is None):
            raise ValueError("Missing the required parameter `look_id` when calling `scheduled_plans_for_look`")


        collection_formats = {}

        resource_path = '/scheduled_plans/look/{look_id}'.replace('{format}', 'json')
        path_params = {}
        if 'look_id' in params:
            path_params['look_id'] = params['look_id']

        query_params = {}
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ScheduledPlan]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def scheduled_plans_for_lookml_dashboard(self, lookml_dashboard_id, **kwargs):
        """
        Scheduled Plans for LookML Dashboard
        ### Get Scheduled Plans for a LookML Dashboard  Returns all scheduled plans owned by the caller or given user, for a given LookML dashboard.  If no user_id is provided, this function returns the scheduled plans owned by the caller.   The caller must have `see_schedules` permission to see other users' scheduled plans.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plans_for_lookml_dashboard(lookml_dashboard_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int lookml_dashboard_id: LookML Dashboard Id (required)
        :param int user_id: User Id (default is requesting user if not specified)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.scheduled_plans_for_lookml_dashboard_with_http_info(lookml_dashboard_id, **kwargs)
        else:
            (data) = self.scheduled_plans_for_lookml_dashboard_with_http_info(lookml_dashboard_id, **kwargs)
            return data

    def scheduled_plans_for_lookml_dashboard_with_http_info(self, lookml_dashboard_id, **kwargs):
        """
        Scheduled Plans for LookML Dashboard
        ### Get Scheduled Plans for a LookML Dashboard  Returns all scheduled plans owned by the caller or given user, for a given LookML dashboard.  If no user_id is provided, this function returns the scheduled plans owned by the caller.   The caller must have `see_schedules` permission to see other users' scheduled plans.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plans_for_lookml_dashboard_with_http_info(lookml_dashboard_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int lookml_dashboard_id: LookML Dashboard Id (required)
        :param int user_id: User Id (default is requesting user if not specified)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookml_dashboard_id', 'user_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method scheduled_plans_for_lookml_dashboard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lookml_dashboard_id' is set
        if ('lookml_dashboard_id' not in params) or (params['lookml_dashboard_id'] is None):
            raise ValueError("Missing the required parameter `lookml_dashboard_id` when calling `scheduled_plans_for_lookml_dashboard`")


        collection_formats = {}

        resource_path = '/scheduled_plans/lookml_dashboard/{lookml_dashboard_id}'.replace('{format}', 'json')
        path_params = {}
        if 'lookml_dashboard_id' in params:
            path_params['lookml_dashboard_id'] = params['lookml_dashboard_id']

        query_params = {}
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ScheduledPlan]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def scheduled_plans_for_space(self, space_id, **kwargs):
        """
        Scheduled Plans for Space
        ### Get Scheduled Plans for a Space  Returns scheduled plans owned by the caller for a given space id. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plans_for_space(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int space_id: Space Id (required)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.scheduled_plans_for_space_with_http_info(space_id, **kwargs)
        else:
            (data) = self.scheduled_plans_for_space_with_http_info(space_id, **kwargs)
            return data

    def scheduled_plans_for_space_with_http_info(self, space_id, **kwargs):
        """
        Scheduled Plans for Space
        ### Get Scheduled Plans for a Space  Returns scheduled plans owned by the caller for a given space id. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scheduled_plans_for_space_with_http_info(space_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int space_id: Space Id (required)
        :param str fields: Requested fields.
        :return: list[ScheduledPlan]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['space_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method scheduled_plans_for_space" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'space_id' is set
        if ('space_id' not in params) or (params['space_id'] is None):
            raise ValueError("Missing the required parameter `space_id` when calling `scheduled_plans_for_space`")


        collection_formats = {}

        resource_path = '/scheduled_plans/space/{space_id}'.replace('{format}', 'json')
        path_params = {}
        if 'space_id' in params:
            path_params['space_id'] = params['space_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ScheduledPlan]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_scheduled_plan(self, scheduled_plan_id, body, **kwargs):
        """
        Update Scheduled Plan
        ### Update a Scheduled Plan  Admins can update other users' Scheduled Plans.  Note: Any scheduled plan destinations specified in an update will **replace** all scheduled plan destinations currently defined for the scheduled plan.  For Example: If a scheduled plan has destinations A, B, and C, and you call update on this scheduled plan specifying only B in the destinations, then destinations A and C will be deleted by the update.  Scheduled plan destinations must specify the data format to produce and send to the destination  Scheduled Plan Destination formats:  | format | Description | :-----------: | :--- | | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata. | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination. | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | xlsx | MS Excel spreadsheet | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image ||  Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_scheduled_plan(scheduled_plan_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int scheduled_plan_id: Scheduled Plan Id (required)
        :param ScheduledPlan body: Scheduled Plan (required)
        :return: ScheduledPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_scheduled_plan_with_http_info(scheduled_plan_id, body, **kwargs)
        else:
            (data) = self.update_scheduled_plan_with_http_info(scheduled_plan_id, body, **kwargs)
            return data

    def update_scheduled_plan_with_http_info(self, scheduled_plan_id, body, **kwargs):
        """
        Update Scheduled Plan
        ### Update a Scheduled Plan  Admins can update other users' Scheduled Plans.  Note: Any scheduled plan destinations specified in an update will **replace** all scheduled plan destinations currently defined for the scheduled plan.  For Example: If a scheduled plan has destinations A, B, and C, and you call update on this scheduled plan specifying only B in the destinations, then destinations A and C will be deleted by the update.  Scheduled plan destinations must specify the data format to produce and send to the destination  Scheduled Plan Destination formats:  | format | Description | :-----------: | :--- | | json | A JSON object containing a `data` property which contains an array of JSON objects, one per row. No metadata. | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | inline_json | Same as the JSON format, except that the `data` property is a string containing JSON-escaped row data. Additional properties describe the data operation. This format is primarily used to send data to web hooks so that the web hook doesn't have to re-encode the JSON row data in order to pass it on to its ultimate destination. | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | xlsx | MS Excel spreadsheet | wysiwyg_pdf | Dashboard rendered in a tiled layout to produce a PDF document | assembled_pdf | Dashboard rendered in a single column layout to produce a PDF document | wysiwyg_png | Dashboard rendered in a tiled layout to produce a PNG image ||  Valid formats vary by destination type and source object. `wysiwyg_pdf` is only valid for dashboards, for example.   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_scheduled_plan_with_http_info(scheduled_plan_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int scheduled_plan_id: Scheduled Plan Id (required)
        :param ScheduledPlan body: Scheduled Plan (required)
        :return: ScheduledPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scheduled_plan_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_scheduled_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'scheduled_plan_id' is set
        if ('scheduled_plan_id' not in params) or (params['scheduled_plan_id'] is None):
            raise ValueError("Missing the required parameter `scheduled_plan_id` when calling `update_scheduled_plan`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_scheduled_plan`")


        collection_formats = {}

        resource_path = '/scheduled_plans/{scheduled_plan_id}'.replace('{format}', 'json')
        path_params = {}
        if 'scheduled_plan_id' in params:
            path_params['scheduled_plan_id'] = params['scheduled_plan_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ScheduledPlan',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
