# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class QueryApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_query(self, **kwargs):
        """
        Create Query
        ### Create a query.  This allows you to create a new query that you can later run. Looker queries are immutable once created and are not deleted. If you create a query that is exactly like an existing query then the existing query will be returned and no new query will be created. Whether a new query is created or not, you can use the 'id' in the returned query with the 'run' method.  The query parameters are passed as json in the body of the request.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Query body: Query
        :param str fields: Requested fields.
        :return: Query
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_query_with_http_info(**kwargs)
        else:
            (data) = self.create_query_with_http_info(**kwargs)
            return data

    def create_query_with_http_info(self, **kwargs):
        """
        Create Query
        ### Create a query.  This allows you to create a new query that you can later run. Looker queries are immutable once created and are not deleted. If you create a query that is exactly like an existing query then the existing query will be returned and no new query will be created. Whether a new query is created or not, you can use the 'id' in the returned query with the 'run' method.  The query parameters are passed as json in the body of the request.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_query_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Query body: Query
        :param str fields: Requested fields.
        :return: Query
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_query" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/queries'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Query',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_query_task(self, body, **kwargs):
        """
        Run Query Async
        ### Run a saved query asynchronously.  Runs a previously created query asynchronously. Returns a Query Task ID which can be used to fetch the results from the Query Tasks results endpoint. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_query_task(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateQueryTask body: Query parameters (required)
        :param int limit: Row limit (may override the limit in the saved query).
        :param bool apply_formatting: Apply model-specified formatting to each result.
        :param bool apply_vis: Apply visualization options to results.
        :param bool cache: Get results from cache if available.
        :param int image_width: Render width for image formats.
        :param int image_height: Render height for image formats.
        :param bool generate_drill_links: Generate drill links (only applicable to 'json_detail' format.
        :param bool force_production: Force use of production models even if the user is in development mode.
        :param bool cache_only: Retrieve any results from cache even if the results have expired.
        :param str path_prefix: Prefix to use for drill links (url encoded).
        :param bool rebuild_pdts: Rebuild PDTS used in query.
        :param bool server_table_calcs: Perform table calculations on query results
        :param str fields: Requested fields
        :return: QueryTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_query_task_with_http_info(body, **kwargs)
        else:
            (data) = self.create_query_task_with_http_info(body, **kwargs)
            return data

    def create_query_task_with_http_info(self, body, **kwargs):
        """
        Run Query Async
        ### Run a saved query asynchronously.  Runs a previously created query asynchronously. Returns a Query Task ID which can be used to fetch the results from the Query Tasks results endpoint. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_query_task_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateQueryTask body: Query parameters (required)
        :param int limit: Row limit (may override the limit in the saved query).
        :param bool apply_formatting: Apply model-specified formatting to each result.
        :param bool apply_vis: Apply visualization options to results.
        :param bool cache: Get results from cache if available.
        :param int image_width: Render width for image formats.
        :param int image_height: Render height for image formats.
        :param bool generate_drill_links: Generate drill links (only applicable to 'json_detail' format.
        :param bool force_production: Force use of production models even if the user is in development mode.
        :param bool cache_only: Retrieve any results from cache even if the results have expired.
        :param str path_prefix: Prefix to use for drill links (url encoded).
        :param bool rebuild_pdts: Rebuild PDTS used in query.
        :param bool server_table_calcs: Perform table calculations on query results
        :param str fields: Requested fields
        :return: QueryTask
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'limit', 'apply_formatting', 'apply_vis', 'cache', 'image_width', 'image_height', 'generate_drill_links', 'force_production', 'cache_only', 'path_prefix', 'rebuild_pdts', 'server_table_calcs', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_query_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_query_task`")


        collection_formats = {}

        resource_path = '/query_tasks'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'apply_formatting' in params:
            query_params['apply_formatting'] = params['apply_formatting']
        if 'apply_vis' in params:
            query_params['apply_vis'] = params['apply_vis']
        if 'cache' in params:
            query_params['cache'] = params['cache']
        if 'image_width' in params:
            query_params['image_width'] = params['image_width']
        if 'image_height' in params:
            query_params['image_height'] = params['image_height']
        if 'generate_drill_links' in params:
            query_params['generate_drill_links'] = params['generate_drill_links']
        if 'force_production' in params:
            query_params['force_production'] = params['force_production']
        if 'cache_only' in params:
            query_params['cache_only'] = params['cache_only']
        if 'path_prefix' in params:
            query_params['path_prefix'] = params['path_prefix']
        if 'rebuild_pdts' in params:
            query_params['rebuild_pdts'] = params['rebuild_pdts']
        if 'server_table_calcs' in params:
            query_params['server_table_calcs'] = params['server_table_calcs']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='QueryTask',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query(self, query_id, **kwargs):
        """
        Get Query
        ### Get a previously created query by id.  A Looker query object includes the various parameters that define a database query that has been run or could be run in the future. These parameters include: model, view, fields, filters, pivots, etc. Query *results* are not part of the query object.  Query objects are unique and immutable. Query objects are created automatically in Looker as users explore data. Looker does not delete them; they become part of the query history. When asked to create a query for any given set of parameters, Looker will first try to find an existing query object with matching parameters and will only create a new object when an appropriate object can not be found.  This 'get' method is used to get the details about a query for a given id. See the other methods here to 'create' and 'run' queries.  Note that some fields like 'filter_config' and 'vis_config' etc are specific to how the Looker UI builds queries and visualizations and are not generally useful for API use. They are not required when creating new queries and can usually just be ignored.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query(query_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int query_id: Id of query (required)
        :param str fields: Requested fields.
        :return: Query
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_with_http_info(query_id, **kwargs)
        else:
            (data) = self.query_with_http_info(query_id, **kwargs)
            return data

    def query_with_http_info(self, query_id, **kwargs):
        """
        Get Query
        ### Get a previously created query by id.  A Looker query object includes the various parameters that define a database query that has been run or could be run in the future. These parameters include: model, view, fields, filters, pivots, etc. Query *results* are not part of the query object.  Query objects are unique and immutable. Query objects are created automatically in Looker as users explore data. Looker does not delete them; they become part of the query history. When asked to create a query for any given set of parameters, Looker will first try to find an existing query object with matching parameters and will only create a new object when an appropriate object can not be found.  This 'get' method is used to get the details about a query for a given id. See the other methods here to 'create' and 'run' queries.  Note that some fields like 'filter_config' and 'vis_config' etc are specific to how the Looker UI builds queries and visualizations and are not generally useful for API use. They are not required when creating new queries and can usually just be ignored.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_with_http_info(query_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int query_id: Id of query (required)
        :param str fields: Requested fields.
        :return: Query
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_id' is set
        if ('query_id' not in params) or (params['query_id'] is None):
            raise ValueError("Missing the required parameter `query_id` when calling `query`")


        collection_formats = {}

        resource_path = '/queries/{query_id}'.replace('{format}', 'json')
        path_params = {}
        if 'query_id' in params:
            path_params['query_id'] = params['query_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Query',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_for_slug(self, slug, **kwargs):
        """
        Get Query for Slug
        ### Get the query for a given query slug.  This returns the query for the 'slug' in a query share URL.  The 'slug' is a randomly chosen short string that is used as an alternative to the query's id value for use in URLs etc. This method exists as a convenience to help you use the API to 'find' queries that have been created using the Looker UI.  You can use the Looker explore page to build a query and then choose the 'Share' option to show the share url for the query. Share urls generally look something like 'https://looker.yourcompany/x/vwGSbfc'. The trailing 'vwGSbfc' is the share slug. You can pass that string to this api method to get details about the query. Those details include the 'id' that you can use to run the query. Or, you can copy the query body (perhaps with your own modification) and use that as the basis to make/run new queries.  This will also work with slugs from Looker explore urls like 'https://looker.yourcompany/explore/ecommerce/orders?qid=aogBgL6o3cKK1jN3RoZl5s'. In this case 'aogBgL6o3cKK1jN3RoZl5s' is the slug. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_for_slug(slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: Slug of query (required)
        :param str fields: Requested fields.
        :return: Query
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_for_slug_with_http_info(slug, **kwargs)
        else:
            (data) = self.query_for_slug_with_http_info(slug, **kwargs)
            return data

    def query_for_slug_with_http_info(self, slug, **kwargs):
        """
        Get Query for Slug
        ### Get the query for a given query slug.  This returns the query for the 'slug' in a query share URL.  The 'slug' is a randomly chosen short string that is used as an alternative to the query's id value for use in URLs etc. This method exists as a convenience to help you use the API to 'find' queries that have been created using the Looker UI.  You can use the Looker explore page to build a query and then choose the 'Share' option to show the share url for the query. Share urls generally look something like 'https://looker.yourcompany/x/vwGSbfc'. The trailing 'vwGSbfc' is the share slug. You can pass that string to this api method to get details about the query. Those details include the 'id' that you can use to run the query. Or, you can copy the query body (perhaps with your own modification) and use that as the basis to make/run new queries.  This will also work with slugs from Looker explore urls like 'https://looker.yourcompany/explore/ecommerce/orders?qid=aogBgL6o3cKK1jN3RoZl5s'. In this case 'aogBgL6o3cKK1jN3RoZl5s' is the slug. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_for_slug_with_http_info(slug, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str slug: Slug of query (required)
        :param str fields: Requested fields.
        :return: Query
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['slug', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_for_slug" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'slug' is set
        if ('slug' not in params) or (params['slug'] is None):
            raise ValueError("Missing the required parameter `slug` when calling `query_for_slug`")


        collection_formats = {}

        resource_path = '/queries/slug/{slug}'.replace('{format}', 'json')
        path_params = {}
        if 'slug' in params:
            path_params['slug'] = params['slug']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Query',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_task(self, query_task_id, **kwargs):
        """
        Get Async Query Info
        Returns information about a Query Task.  Query Tasks are generated by running queries asynchronously. They are represented by a GUID returned from one of the async query endpoints. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_task(query_task_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str query_task_id: ID of the Query Task (required)
        :param str fields: Requested fields.
        :return: QueryTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_task_with_http_info(query_task_id, **kwargs)
        else:
            (data) = self.query_task_with_http_info(query_task_id, **kwargs)
            return data

    def query_task_with_http_info(self, query_task_id, **kwargs):
        """
        Get Async Query Info
        Returns information about a Query Task.  Query Tasks are generated by running queries asynchronously. They are represented by a GUID returned from one of the async query endpoints. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_task_with_http_info(query_task_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str query_task_id: ID of the Query Task (required)
        :param str fields: Requested fields.
        :return: QueryTask
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_task_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_task_id' is set
        if ('query_task_id' not in params) or (params['query_task_id'] is None):
            raise ValueError("Missing the required parameter `query_task_id` when calling `query_task`")


        collection_formats = {}

        resource_path = '/query_tasks/{query_task_id}'.replace('{format}', 'json')
        path_params = {}
        if 'query_task_id' in params:
            path_params['query_task_id'] = params['query_task_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='QueryTask',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_task_multi_results(self, query_task_ids, **kwargs):
        """
        Get Multiple Async Query Results
        Fetch the results of multiple async Query Tasks in one response.  Query Tasks that are not ready will be skipped and will not appear in the response. Query Tasks whose results have expired will have a status of 'expired'. If the user making the API request does not have sufficient privileges to view a Query Task result, the result will have a status of 'missing' 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_task_multi_results(query_task_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] query_task_ids: List of Query Task IDs (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_task_multi_results_with_http_info(query_task_ids, **kwargs)
        else:
            (data) = self.query_task_multi_results_with_http_info(query_task_ids, **kwargs)
            return data

    def query_task_multi_results_with_http_info(self, query_task_ids, **kwargs):
        """
        Get Multiple Async Query Results
        Fetch the results of multiple async Query Tasks in one response.  Query Tasks that are not ready will be skipped and will not appear in the response. Query Tasks whose results have expired will have a status of 'expired'. If the user making the API request does not have sufficient privileges to view a Query Task result, the result will have a status of 'missing' 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_task_multi_results_with_http_info(query_task_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] query_task_ids: List of Query Task IDs (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_task_ids']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_task_multi_results" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_task_ids' is set
        if ('query_task_ids' not in params) or (params['query_task_ids'] is None):
            raise ValueError("Missing the required parameter `query_task_ids` when calling `query_task_multi_results`")


        collection_formats = {}

        resource_path = '/query_tasks/multi_results'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'query_task_ids' in params:
            query_params['query_task_ids'] = params['query_task_ids']
            collection_formats['query_task_ids'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='dict(str, str)',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_task_results(self, query_task_id, **kwargs):
        """
        Get Async Query Results
        Returns the results of an async Query Task if the query has completed. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_task_results(query_task_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str query_task_id: ID of the Query Task (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_task_results_with_http_info(query_task_id, **kwargs)
        else:
            (data) = self.query_task_results_with_http_info(query_task_id, **kwargs)
            return data

    def query_task_results_with_http_info(self, query_task_id, **kwargs):
        """
        Get Async Query Results
        Returns the results of an async Query Task if the query has completed. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_task_results_with_http_info(query_task_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str query_task_id: ID of the Query Task (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_task_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_task_results" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_task_id' is set
        if ('query_task_id' not in params) or (params['query_task_id'] is None):
            raise ValueError("Missing the required parameter `query_task_id` when calling `query_task_results`")


        collection_formats = {}

        resource_path = '/query_tasks/{query_task_id}/results'.replace('{format}', 'json')
        path_params = {}
        if 'query_task_id' in params:
            path_params['query_task_id'] = params['query_task_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text', 'application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='dict(str, str)',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_inline_query(self, result_format, body, **kwargs):
        """
        Run Inline Query
        ### Run the query that is specified inline in the posted body.  This allows running a query as defined in json in the posted body. This combines the two actions of posting & running a query into one step.  Here is an example body in json: ``` {   \"model\":\"thelook\",   \"view\":\"inventory_items\",   \"fields\":[\"category.name\",\"inventory_items.days_in_inventory_tier\",\"products.count\"],   \"filters\":{\"category.name\":\"socks\"},   \"sorts\":[\"products.count desc 0\"],   \"limit\":\"500\",   \"query_timezone\":\"America/Los_Angeles\" } ```  When using the Ruby SDK this would be passed as a Ruby hash like: ``` {  :model=>\"thelook\",  :view=>\"inventory_items\",  :fields=>   [\"category.name\",    \"inventory_items.days_in_inventory_tier\",    \"products.count\"],  :filters=>{:\"category.name\"=>\"socks\"},  :sorts=>[\"products.count desc 0\"],  :limit=>\"500\",  :query_timezone=>\"America/Los_Angeles\", } ```  This will return the result of running the query in the format specified by the 'result_format' parameter.  Suported formats:  | result_format | Description | :-----------: | :--- | | json | Plain json | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | md | Simple markdown | xlsx | MS Excel spreadsheet | sql | Returns the generated SQL rather than running the query | png | A PNG image of the visualization of the query | jpg | A JPG image of the visualization of the query   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_inline_query(result_format, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str result_format: Format of result (required)
        :param Query body: inline query (required)
        :param int limit: Row limit (may override the limit in the saved query).
        :param bool apply_formatting: Apply model-specified formatting to each result.
        :param bool apply_vis: Apply visualization options to results.
        :param bool cache: Get results from cache if available.
        :param int image_width: Render width for image formats.
        :param int image_height: Render height for image formats.
        :param bool generate_drill_links: Generate drill links (only applicable to 'json_detail' format.
        :param bool force_production: Force use of production models even if the user is in development mode.
        :param bool cache_only: Retrieve any results from cache even if the results have expired.
        :param str path_prefix: Prefix to use for drill links (url encoded).
        :param bool rebuild_pdts: Rebuild PDTS used in query.
        :param bool server_table_calcs: Perform table calculations on query results
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_inline_query_with_http_info(result_format, body, **kwargs)
        else:
            (data) = self.run_inline_query_with_http_info(result_format, body, **kwargs)
            return data

    def run_inline_query_with_http_info(self, result_format, body, **kwargs):
        """
        Run Inline Query
        ### Run the query that is specified inline in the posted body.  This allows running a query as defined in json in the posted body. This combines the two actions of posting & running a query into one step.  Here is an example body in json: ``` {   \"model\":\"thelook\",   \"view\":\"inventory_items\",   \"fields\":[\"category.name\",\"inventory_items.days_in_inventory_tier\",\"products.count\"],   \"filters\":{\"category.name\":\"socks\"},   \"sorts\":[\"products.count desc 0\"],   \"limit\":\"500\",   \"query_timezone\":\"America/Los_Angeles\" } ```  When using the Ruby SDK this would be passed as a Ruby hash like: ``` {  :model=>\"thelook\",  :view=>\"inventory_items\",  :fields=>   [\"category.name\",    \"inventory_items.days_in_inventory_tier\",    \"products.count\"],  :filters=>{:\"category.name\"=>\"socks\"},  :sorts=>[\"products.count desc 0\"],  :limit=>\"500\",  :query_timezone=>\"America/Los_Angeles\", } ```  This will return the result of running the query in the format specified by the 'result_format' parameter.  Suported formats:  | result_format | Description | :-----------: | :--- | | json | Plain json | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | md | Simple markdown | xlsx | MS Excel spreadsheet | sql | Returns the generated SQL rather than running the query | png | A PNG image of the visualization of the query | jpg | A JPG image of the visualization of the query   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_inline_query_with_http_info(result_format, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str result_format: Format of result (required)
        :param Query body: inline query (required)
        :param int limit: Row limit (may override the limit in the saved query).
        :param bool apply_formatting: Apply model-specified formatting to each result.
        :param bool apply_vis: Apply visualization options to results.
        :param bool cache: Get results from cache if available.
        :param int image_width: Render width for image formats.
        :param int image_height: Render height for image formats.
        :param bool generate_drill_links: Generate drill links (only applicable to 'json_detail' format.
        :param bool force_production: Force use of production models even if the user is in development mode.
        :param bool cache_only: Retrieve any results from cache even if the results have expired.
        :param str path_prefix: Prefix to use for drill links (url encoded).
        :param bool rebuild_pdts: Rebuild PDTS used in query.
        :param bool server_table_calcs: Perform table calculations on query results
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['result_format', 'body', 'limit', 'apply_formatting', 'apply_vis', 'cache', 'image_width', 'image_height', 'generate_drill_links', 'force_production', 'cache_only', 'path_prefix', 'rebuild_pdts', 'server_table_calcs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_inline_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'result_format' is set
        if ('result_format' not in params) or (params['result_format'] is None):
            raise ValueError("Missing the required parameter `result_format` when calling `run_inline_query`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `run_inline_query`")


        collection_formats = {}

        resource_path = '/queries/run/{result_format}'.replace('{format}', 'json')
        path_params = {}
        if 'result_format' in params:
            path_params['result_format'] = params['result_format']

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'apply_formatting' in params:
            query_params['apply_formatting'] = params['apply_formatting']
        if 'apply_vis' in params:
            query_params['apply_vis'] = params['apply_vis']
        if 'cache' in params:
            query_params['cache'] = params['cache']
        if 'image_width' in params:
            query_params['image_width'] = params['image_width']
        if 'image_height' in params:
            query_params['image_height'] = params['image_height']
        if 'generate_drill_links' in params:
            query_params['generate_drill_links'] = params['generate_drill_links']
        if 'force_production' in params:
            query_params['force_production'] = params['force_production']
        if 'cache_only' in params:
            query_params['cache_only'] = params['cache_only']
        if 'path_prefix' in params:
            query_params['path_prefix'] = params['path_prefix']
        if 'rebuild_pdts' in params:
            query_params['rebuild_pdts'] = params['rebuild_pdts']
        if 'server_table_calcs' in params:
            query_params['server_table_calcs'] = params['server_table_calcs']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text', 'application/json', 'image/png', 'image/jpg'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_query(self, query_id, result_format, **kwargs):
        """
        Run Query
        ### Run a saved query.  This runs a previously saved query. You can use this on a query that was generated in the Looker UI or one that you have explicitly created using the API. You can also use a query 'id' from a saved 'Look'.  The 'result_format' parameter specifies the desired structure and format of the response.  Suported formats:  | result_format | Description | :-----------: | :--- | | json | Plain json | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | md | Simple markdown | xlsx | MS Excel spreadsheet | sql | Returns the generated SQL rather than running the query | png | A PNG image of the visualization of the query | jpg | A JPG image of the visualization of the query   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_query(query_id, result_format, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int query_id: Id of query (required)
        :param str result_format: Format of result (required)
        :param int limit: Row limit (may override the limit in the saved query).
        :param bool apply_formatting: Apply model-specified formatting to each result.
        :param bool apply_vis: Apply visualization options to results.
        :param bool cache: Get results from cache if available.
        :param int image_width: Render width for image formats.
        :param int image_height: Render height for image formats.
        :param bool generate_drill_links: Generate drill links (only applicable to 'json_detail' format.
        :param bool force_production: Force use of production models even if the user is in development mode.
        :param bool cache_only: Retrieve any results from cache even if the results have expired.
        :param str path_prefix: Prefix to use for drill links (url encoded).
        :param bool rebuild_pdts: Rebuild PDTS used in query.
        :param bool server_table_calcs: Perform table calculations on query results
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_query_with_http_info(query_id, result_format, **kwargs)
        else:
            (data) = self.run_query_with_http_info(query_id, result_format, **kwargs)
            return data

    def run_query_with_http_info(self, query_id, result_format, **kwargs):
        """
        Run Query
        ### Run a saved query.  This runs a previously saved query. You can use this on a query that was generated in the Looker UI or one that you have explicitly created using the API. You can also use a query 'id' from a saved 'Look'.  The 'result_format' parameter specifies the desired structure and format of the response.  Suported formats:  | result_format | Description | :-----------: | :--- | | json | Plain json | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | md | Simple markdown | xlsx | MS Excel spreadsheet | sql | Returns the generated SQL rather than running the query | png | A PNG image of the visualization of the query | jpg | A JPG image of the visualization of the query   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_query_with_http_info(query_id, result_format, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int query_id: Id of query (required)
        :param str result_format: Format of result (required)
        :param int limit: Row limit (may override the limit in the saved query).
        :param bool apply_formatting: Apply model-specified formatting to each result.
        :param bool apply_vis: Apply visualization options to results.
        :param bool cache: Get results from cache if available.
        :param int image_width: Render width for image formats.
        :param int image_height: Render height for image formats.
        :param bool generate_drill_links: Generate drill links (only applicable to 'json_detail' format.
        :param bool force_production: Force use of production models even if the user is in development mode.
        :param bool cache_only: Retrieve any results from cache even if the results have expired.
        :param str path_prefix: Prefix to use for drill links (url encoded).
        :param bool rebuild_pdts: Rebuild PDTS used in query.
        :param bool server_table_calcs: Perform table calculations on query results
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_id', 'result_format', 'limit', 'apply_formatting', 'apply_vis', 'cache', 'image_width', 'image_height', 'generate_drill_links', 'force_production', 'cache_only', 'path_prefix', 'rebuild_pdts', 'server_table_calcs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_id' is set
        if ('query_id' not in params) or (params['query_id'] is None):
            raise ValueError("Missing the required parameter `query_id` when calling `run_query`")
        # verify the required parameter 'result_format' is set
        if ('result_format' not in params) or (params['result_format'] is None):
            raise ValueError("Missing the required parameter `result_format` when calling `run_query`")


        collection_formats = {}

        resource_path = '/queries/{query_id}/run/{result_format}'.replace('{format}', 'json')
        path_params = {}
        if 'query_id' in params:
            path_params['query_id'] = params['query_id']
        if 'result_format' in params:
            path_params['result_format'] = params['result_format']

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'apply_formatting' in params:
            query_params['apply_formatting'] = params['apply_formatting']
        if 'apply_vis' in params:
            query_params['apply_vis'] = params['apply_vis']
        if 'cache' in params:
            query_params['cache'] = params['cache']
        if 'image_width' in params:
            query_params['image_width'] = params['image_width']
        if 'image_height' in params:
            query_params['image_height'] = params['image_height']
        if 'generate_drill_links' in params:
            query_params['generate_drill_links'] = params['generate_drill_links']
        if 'force_production' in params:
            query_params['force_production'] = params['force_production']
        if 'cache_only' in params:
            query_params['cache_only'] = params['cache_only']
        if 'path_prefix' in params:
            query_params['path_prefix'] = params['path_prefix']
        if 'rebuild_pdts' in params:
            query_params['rebuild_pdts'] = params['rebuild_pdts']
        if 'server_table_calcs' in params:
            query_params['server_table_calcs'] = params['server_table_calcs']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text', 'application/json', 'image/png', 'image/jpg'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_url_encoded_query(self, model_name, view_name, result_format, **kwargs):
        """
        Run Url Encoded Query
        ### Run an URL encoded query.  This requires the caller to encode the specifiers for the query into the URL query part using Looker-specific syntax as explained below.  Generally, you would want to use one of the methods that takes the parameters as json in the POST body for creating and/or running queries. This method exists for cases where one really needs to encode the parameters into the URL of a single 'GET' request. This matches the way that the Looker UI formats 'explore' URLs etc.  The parameters here are very similar to the json body formatting except that the filter syntax is tricky. Unfortunately, this format makes this method not currently callible via the 'Try it out!' button in this documentation page. But, this is callable  when creating URLs manually or when using the Looker SDK.  Here is an example inline query URL:  ``` https://looker.mycompany.com:19999/api/3.0/queries/models/thelook/views/inventory_items/run/json?fields=category.name,inventory_items.days_in_inventory_tier,products.count&f[category.name]=socks&sorts=products.count+desc+0&limit=500&query_timezone=America/Los_Angeles ```  When invoking this endpoint with the Ruby SDK, pass the query parameter parts as a hash. The hash to match the above would look like:  ```ruby query_params = {   :fields => \"category.name,inventory_items.days_in_inventory_tier,products.count\",   :\"f[category.name]\" => \"socks\",   :sorts => \"products.count desc 0\",   :limit => \"500\",   :query_timezone => \"America/Los_Angeles\" } response = ruby_sdk.run_url_encoded_query('thelook','inventory_items','json', query_params)  ```  Again, it is generally easier to use the variant of this method that passes the full query in the POST body. This method is available for cases where other alternatives won't fit the need.  Suported formats:  | result_format | Description | :-----------: | :--- | | json | Plain json | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | md | Simple markdown | xlsx | MS Excel spreadsheet | sql | Returns the generated SQL rather than running the query | png | A PNG image of the visualization of the query | jpg | A JPG image of the visualization of the query   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_url_encoded_query(model_name, view_name, result_format, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str model_name: Model name (required)
        :param str view_name: View name (required)
        :param str result_format: Format of result (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_url_encoded_query_with_http_info(model_name, view_name, result_format, **kwargs)
        else:
            (data) = self.run_url_encoded_query_with_http_info(model_name, view_name, result_format, **kwargs)
            return data

    def run_url_encoded_query_with_http_info(self, model_name, view_name, result_format, **kwargs):
        """
        Run Url Encoded Query
        ### Run an URL encoded query.  This requires the caller to encode the specifiers for the query into the URL query part using Looker-specific syntax as explained below.  Generally, you would want to use one of the methods that takes the parameters as json in the POST body for creating and/or running queries. This method exists for cases where one really needs to encode the parameters into the URL of a single 'GET' request. This matches the way that the Looker UI formats 'explore' URLs etc.  The parameters here are very similar to the json body formatting except that the filter syntax is tricky. Unfortunately, this format makes this method not currently callible via the 'Try it out!' button in this documentation page. But, this is callable  when creating URLs manually or when using the Looker SDK.  Here is an example inline query URL:  ``` https://looker.mycompany.com:19999/api/3.0/queries/models/thelook/views/inventory_items/run/json?fields=category.name,inventory_items.days_in_inventory_tier,products.count&f[category.name]=socks&sorts=products.count+desc+0&limit=500&query_timezone=America/Los_Angeles ```  When invoking this endpoint with the Ruby SDK, pass the query parameter parts as a hash. The hash to match the above would look like:  ```ruby query_params = {   :fields => \"category.name,inventory_items.days_in_inventory_tier,products.count\",   :\"f[category.name]\" => \"socks\",   :sorts => \"products.count desc 0\",   :limit => \"500\",   :query_timezone => \"America/Los_Angeles\" } response = ruby_sdk.run_url_encoded_query('thelook','inventory_items','json', query_params)  ```  Again, it is generally easier to use the variant of this method that passes the full query in the POST body. This method is available for cases where other alternatives won't fit the need.  Suported formats:  | result_format | Description | :-----------: | :--- | | json | Plain json | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | md | Simple markdown | xlsx | MS Excel spreadsheet | sql | Returns the generated SQL rather than running the query | png | A PNG image of the visualization of the query | jpg | A JPG image of the visualization of the query   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_url_encoded_query_with_http_info(model_name, view_name, result_format, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str model_name: Model name (required)
        :param str view_name: View name (required)
        :param str result_format: Format of result (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_name', 'view_name', 'result_format']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_url_encoded_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_name' is set
        if ('model_name' not in params) or (params['model_name'] is None):
            raise ValueError("Missing the required parameter `model_name` when calling `run_url_encoded_query`")
        # verify the required parameter 'view_name' is set
        if ('view_name' not in params) or (params['view_name'] is None):
            raise ValueError("Missing the required parameter `view_name` when calling `run_url_encoded_query`")
        # verify the required parameter 'result_format' is set
        if ('result_format' not in params) or (params['result_format'] is None):
            raise ValueError("Missing the required parameter `result_format` when calling `run_url_encoded_query`")


        collection_formats = {}

        resource_path = '/queries/models/{model_name}/views/{view_name}/run/{result_format}'.replace('{format}', 'json')
        path_params = {}
        if 'model_name' in params:
            path_params['model_name'] = params['model_name']
        if 'view_name' in params:
            path_params['view_name'] = params['view_name']
        if 'result_format' in params:
            path_params['result_format'] = params['result_format']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text', 'application/json', 'image/png', 'image/jpg'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
