# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ProjectApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_git_branches(self, project_id, **kwargs):
        """
        Get All Git Branchs
        ### Get All Git Branches  Returns a list of git branches in the project repository 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_git_branches(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :return: list[GitBranch]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_git_branches_with_http_info(project_id, **kwargs)
        else:
            (data) = self.all_git_branches_with_http_info(project_id, **kwargs)
            return data

    def all_git_branches_with_http_info(self, project_id, **kwargs):
        """
        Get All Git Branchs
        ### Get All Git Branches  Returns a list of git branches in the project repository 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_git_branches_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :return: list[GitBranch]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_git_branches" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `all_git_branches`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/git_branches'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[GitBranch]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def all_git_connection_tests(self, project_id, **kwargs):
        """
        Get All Git Connection Tests
        ### Get All Git Connection Tests  Returns a list of tests which can be run against a project's git connection 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_git_connection_tests(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :return: list[GitConnectionTest]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_git_connection_tests_with_http_info(project_id, **kwargs)
        else:
            (data) = self.all_git_connection_tests_with_http_info(project_id, **kwargs)
            return data

    def all_git_connection_tests_with_http_info(self, project_id, **kwargs):
        """
        Get All Git Connection Tests
        ### Get All Git Connection Tests  Returns a list of tests which can be run against a project's git connection 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_git_connection_tests_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :return: list[GitConnectionTest]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_git_connection_tests" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `all_git_connection_tests`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/git_connection_tests'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[GitConnectionTest]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def all_project_files(self, project_id, **kwargs):
        """
        Get All Project Files
        ### Get All Project Files  Returns a list of the files in the project 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_project_files(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: list[ProjectFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_project_files_with_http_info(project_id, **kwargs)
        else:
            (data) = self.all_project_files_with_http_info(project_id, **kwargs)
            return data

    def all_project_files_with_http_info(self, project_id, **kwargs):
        """
        Get All Project Files
        ### Get All Project Files  Returns a list of the files in the project 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_project_files_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: list[ProjectFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_project_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `all_project_files`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/files'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ProjectFile]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def all_projects(self, **kwargs):
        """
        Get All Projects
        ### Get All Projects  Returns all projects visible to the current user 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_projects(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields
        :return: list[Project]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_projects_with_http_info(**kwargs)
        else:
            (data) = self.all_projects_with_http_info(**kwargs)
            return data

    def all_projects_with_http_info(self, **kwargs):
        """
        Get All Projects
        ### Get All Projects  Returns all projects visible to the current user 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_projects_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields
        :return: list[Project]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_projects" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/projects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Project]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_git_deploy_key(self, project_id, **kwargs):
        """
        Create Deploy Key
        ### Create Git Deploy Key  Create a public/private key pair for authenticating ssh git requests from Looker to a remote git repository for a particular Looker project.  Returns the public key of the generated ssh key pair.  Copy this public key to your remote git repository's ssh keys configuration so that the remote git service can validate and accept git requests from the Looker server. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_git_deploy_key(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_git_deploy_key_with_http_info(project_id, **kwargs)
        else:
            (data) = self.create_git_deploy_key_with_http_info(project_id, **kwargs)
            return data

    def create_git_deploy_key_with_http_info(self, project_id, **kwargs):
        """
        Create Deploy Key
        ### Create Git Deploy Key  Create a public/private key pair for authenticating ssh git requests from Looker to a remote git repository for a particular Looker project.  Returns the public key of the generated ssh key pair.  Copy this public key to your remote git repository's ssh keys configuration so that the remote git service can validate and accept git requests from the Looker server. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_git_deploy_key_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_git_deploy_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `create_git_deploy_key`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/git/deploy_key'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_project(self, **kwargs):
        """
        Create Project
        ### Create A Project  dev mode required. - Call `update_session` to select the 'dev' workspace.  `name` is required. `git_remote_url` is not allowed. To configure Git for the newly created project, follow the instructions in `update_project`.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Project body: Project
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_with_http_info(**kwargs)
        else:
            (data) = self.create_project_with_http_info(**kwargs)
            return data

    def create_project_with_http_info(self, **kwargs):
        """
        Create Project
        ### Create A Project  dev mode required. - Call `update_session` to select the 'dev' workspace.  `name` is required. `git_remote_url` is not allowed. To configure Git for the newly created project, follow the instructions in `update_project`.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Project body: Project
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/projects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Project',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def git_deploy_key(self, project_id, **kwargs):
        """
        Git Deploy Key
        ### Git Deploy Key  Returns the ssh public key previously created for a project's git repository. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.git_deploy_key(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.git_deploy_key_with_http_info(project_id, **kwargs)
        else:
            (data) = self.git_deploy_key_with_http_info(project_id, **kwargs)
            return data

    def git_deploy_key_with_http_info(self, project_id, **kwargs):
        """
        Git Deploy Key
        ### Git Deploy Key  Returns the ssh public key previously created for a project's git repository. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.git_deploy_key_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method git_deploy_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `git_deploy_key`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/git/deploy_key'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def project(self, project_id, **kwargs):
        """
        Get Project
        ### Get A Project  Returns the project with the given project id 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.project(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.project_with_http_info(project_id, **kwargs)
        else:
            (data) = self.project_with_http_info(project_id, **kwargs)
            return data

    def project_with_http_info(self, project_id, **kwargs):
        """
        Get Project
        ### Get A Project  Returns the project with the given project id 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.project_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project`")


        collection_formats = {}

        resource_path = '/projects/{project_id}'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Project',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def project_file(self, project_id, file_id, **kwargs):
        """
        Get Project File
        ### Get Project File Info  Returns information about a file in the project 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.project_file(project_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str file_id: File Id (required)
        :param str fields: Requested fields
        :return: ProjectFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.project_file_with_http_info(project_id, file_id, **kwargs)
        else:
            (data) = self.project_file_with_http_info(project_id, file_id, **kwargs)
            return data

    def project_file_with_http_info(self, project_id, file_id, **kwargs):
        """
        Get Project File
        ### Get Project File Info  Returns information about a file in the project 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.project_file_with_http_info(project_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str file_id: File Id (required)
        :param str fields: Requested fields
        :return: ProjectFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'file_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `project_file`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/files/file'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}
        if 'file_id' in params:
            query_params['file_id'] = params['file_id']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ProjectFile',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def project_validation_results(self, project_id, **kwargs):
        """
        Cached Project Validation Results
        ### Get Cached Project Validation Results  Returns the cached results of a previous project validation calculation, if any. Returns http status 204 No Content if no validation results exist.  Validating the content of all the files in a project can be computationally intensive for large projects. Use this API to simply fetch the results of the most recent project validation rather than revalidating the entire project from scratch.  A value of `\"stale\": true` in the response indicates that the project has changed since the cached validation results were computed. The cached validation results may no longer reflect the current state of the project. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.project_validation_results(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: ProjectValidationCache
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.project_validation_results_with_http_info(project_id, **kwargs)
        else:
            (data) = self.project_validation_results_with_http_info(project_id, **kwargs)
            return data

    def project_validation_results_with_http_info(self, project_id, **kwargs):
        """
        Cached Project Validation Results
        ### Get Cached Project Validation Results  Returns the cached results of a previous project validation calculation, if any. Returns http status 204 No Content if no validation results exist.  Validating the content of all the files in a project can be computationally intensive for large projects. Use this API to simply fetch the results of the most recent project validation rather than revalidating the entire project from scratch.  A value of `\"stale\": true` in the response indicates that the project has changed since the cached validation results were computed. The cached validation results may no longer reflect the current state of the project. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.project_validation_results_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: ProjectValidationCache
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_validation_results" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_validation_results`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/validate'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ProjectValidationCache',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def project_workspace(self, project_id, **kwargs):
        """
        Get Project Workspace
        ### Get Project Workspace  Returns information about the state of the project files in the currently selected workspace 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.project_workspace(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: ProjectWorkspace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.project_workspace_with_http_info(project_id, **kwargs)
        else:
            (data) = self.project_workspace_with_http_info(project_id, **kwargs)
            return data

    def project_workspace_with_http_info(self, project_id, **kwargs):
        """
        Get Project Workspace
        ### Get Project Workspace  Returns information about the state of the project files in the currently selected workspace 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.project_workspace_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: ProjectWorkspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_workspace`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/current_workspace'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ProjectWorkspace',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def reset_project_to_production(self, project_id, **kwargs):
        """
        Reset To Production
        ### Reset a project to the revision of the project that is in production.  **DANGER** this will delete any changes that have not been pushed to a remote repository. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_project_to_production(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Id of project (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.reset_project_to_production_with_http_info(project_id, **kwargs)
        else:
            (data) = self.reset_project_to_production_with_http_info(project_id, **kwargs)
            return data

    def reset_project_to_production_with_http_info(self, project_id, **kwargs):
        """
        Reset To Production
        ### Reset a project to the revision of the project that is in production.  **DANGER** this will delete any changes that have not been pushed to a remote repository. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_project_to_production_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Id of project (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_project_to_production" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `reset_project_to_production`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/reset_to_production'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def reset_project_to_remote(self, project_id, **kwargs):
        """
        Reset To Remote
        ### Reset a project development branch to the revision of the project that is on the remote.  **DANGER** this will delete any changes that have not been pushed to a remote repository. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_project_to_remote(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Id of project (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.reset_project_to_remote_with_http_info(project_id, **kwargs)
        else:
            (data) = self.reset_project_to_remote_with_http_info(project_id, **kwargs)
            return data

    def reset_project_to_remote_with_http_info(self, project_id, **kwargs):
        """
        Reset To Remote
        ### Reset a project development branch to the revision of the project that is on the remote.  **DANGER** this will delete any changes that have not been pushed to a remote repository. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_project_to_remote_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Id of project (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_project_to_remote" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `reset_project_to_remote`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/reset_to_remote'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_git_connection_test(self, project_id, test_id, **kwargs):
        """
        Run Git Connection Test
        ### Run a git connection test  Run the named test on the git service used by this project and return the result. This is intended to help debug git connections when things do not work properly, to give more helpful information about why a git url is not working with Looker. They are intended to be run in the order they are returned from the /projects/ID/git_connection_tests endpoint. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_git_connection_test(project_id, test_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str test_id: Test Id (required)
        :return: GitConnectionTestResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_git_connection_test_with_http_info(project_id, test_id, **kwargs)
        else:
            (data) = self.run_git_connection_test_with_http_info(project_id, test_id, **kwargs)
            return data

    def run_git_connection_test_with_http_info(self, project_id, test_id, **kwargs):
        """
        Run Git Connection Test
        ### Run a git connection test  Run the named test on the git service used by this project and return the result. This is intended to help debug git connections when things do not work properly, to give more helpful information about why a git url is not working with Looker. They are intended to be run in the order they are returned from the /projects/ID/git_connection_tests endpoint. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_git_connection_test_with_http_info(project_id, test_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str test_id: Test Id (required)
        :return: GitConnectionTestResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'test_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_git_connection_test" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `run_git_connection_test`")
        # verify the required parameter 'test_id' is set
        if ('test_id' not in params) or (params['test_id'] is None):
            raise ValueError("Missing the required parameter `test_id` when calling `run_git_connection_test`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/git_connection_tests/{test_id}'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']
        if 'test_id' in params:
            path_params['test_id'] = params['test_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='GitConnectionTestResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_project(self, project_id, body, **kwargs):
        """
        Update Project
        ### Update Project Configuration  Apply changes to a project's configuration.   #### Configuring Git for a Project  To set up a Looker project with a remote git repository, follow these steps:  1. Call `update_session` to select the 'dev' workspace. 1. Call `create_git_deploy_key` to create a new deploy key for the project 1. Copy the deploy key text into the remote git repository's ssh key configuration 1. Call `update_project` to set project's `git_remote_url` ()and `git_service_name`, if necessary).  When you modify a project's `git_remote_url`, Looker connects to the remote repository to fetch metadata. The remote git repository MUST be configured with the Looker-generated deploy key for this project prior to setting the project's `git_remote_url`.  To set up a Looker project with a git repository residing on the Looker server (a 'bare' git repo): 1. Call `update_session` to select the 'dev' workspace. 1. Call `update_project` setting `git_remote_url` to nil and `git_service_name` to \"bare\".  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project(project_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param Project body: Project (required)
        :param str fields: Requested fields
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_with_http_info(project_id, body, **kwargs)
        else:
            (data) = self.update_project_with_http_info(project_id, body, **kwargs)
            return data

    def update_project_with_http_info(self, project_id, body, **kwargs):
        """
        Update Project
        ### Update Project Configuration  Apply changes to a project's configuration.   #### Configuring Git for a Project  To set up a Looker project with a remote git repository, follow these steps:  1. Call `update_session` to select the 'dev' workspace. 1. Call `create_git_deploy_key` to create a new deploy key for the project 1. Copy the deploy key text into the remote git repository's ssh key configuration 1. Call `update_project` to set project's `git_remote_url` ()and `git_service_name`, if necessary).  When you modify a project's `git_remote_url`, Looker connects to the remote repository to fetch metadata. The remote git repository MUST be configured with the Looker-generated deploy key for this project prior to setting the project's `git_remote_url`.  To set up a Looker project with a git repository residing on the Looker server (a 'bare' git repo): 1. Call `update_session` to select the 'dev' workspace. 1. Call `update_project` setting `git_remote_url` to nil and `git_service_name` to \"bare\".  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_with_http_info(project_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param Project body: Project (required)
        :param str fields: Requested fields
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_project`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_project`")


        collection_formats = {}

        resource_path = '/projects/{project_id}'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Project',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def validate_project(self, project_id, **kwargs):
        """
        Validate Project
        ### Validate Project  Performs lint validation of all lookml files in the project. Returns a list of errors found, if any.  Validating the content of all the files in a project can be computationally intensive for large projects. For best performance, call `validate_project(project_id)` only when you really want to recompute project validation. To quickly display the results of the most recent project validation (without recomputing), use `project_validation_results(project_id)` 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.validate_project(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: ProjectValidation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.validate_project_with_http_info(project_id, **kwargs)
        else:
            (data) = self.validate_project_with_http_info(project_id, **kwargs)
            return data

    def validate_project_with_http_info(self, project_id, **kwargs):
        """
        Validate Project
        ### Validate Project  Performs lint validation of all lookml files in the project. Returns a list of errors found, if any.  Validating the content of all the files in a project can be computationally intensive for large projects. For best performance, call `validate_project(project_id)` only when you really want to recompute project validation. To quickly display the results of the most recent project validation (without recomputing), use `project_validation_results(project_id)` 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.validate_project_with_http_info(project_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str project_id: Project Id (required)
        :param str fields: Requested fields
        :return: ProjectValidation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params) or (params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `validate_project`")


        collection_formats = {}

        resource_path = '/projects/{project_id}/validate'.replace('{format}', 'json')
        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ProjectValidation',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
