# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class LookmlModelApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_lookml_models(self, **kwargs):
        """
        Get All LookML Models
        ### Get information about all lookml models. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_lookml_models(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[LookmlModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_lookml_models_with_http_info(**kwargs)
        else:
            (data) = self.all_lookml_models_with_http_info(**kwargs)
            return data

    def all_lookml_models_with_http_info(self, **kwargs):
        """
        Get All LookML Models
        ### Get information about all lookml models. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_lookml_models_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[LookmlModel]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_lookml_models" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/lookml_models'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[LookmlModel]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_lookml_model(self, **kwargs):
        """
        Create LookML Model
        ### Create a lookml model using the specified configuration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_lookml_model(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LookmlModel body: LookML Model
        :return: LookmlModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_lookml_model_with_http_info(**kwargs)
        else:
            (data) = self.create_lookml_model_with_http_info(**kwargs)
            return data

    def create_lookml_model_with_http_info(self, **kwargs):
        """
        Create LookML Model
        ### Create a lookml model using the specified configuration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_lookml_model_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LookmlModel body: LookML Model
        :return: LookmlModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_lookml_model" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/lookml_models'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LookmlModel',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_lookml_model(self, lookml_model_name, **kwargs):
        """
        Delete LookML Model
        ### Delete a lookml model. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_lookml_model(lookml_model_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookml_model_name: Name of lookml model. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_lookml_model_with_http_info(lookml_model_name, **kwargs)
        else:
            (data) = self.delete_lookml_model_with_http_info(lookml_model_name, **kwargs)
            return data

    def delete_lookml_model_with_http_info(self, lookml_model_name, **kwargs):
        """
        Delete LookML Model
        ### Delete a lookml model. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_lookml_model_with_http_info(lookml_model_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookml_model_name: Name of lookml model. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookml_model_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_lookml_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lookml_model_name' is set
        if ('lookml_model_name' not in params) or (params['lookml_model_name'] is None):
            raise ValueError("Missing the required parameter `lookml_model_name` when calling `delete_lookml_model`")


        collection_formats = {}

        resource_path = '/lookml_models/{lookml_model_name}'.replace('{format}', 'json')
        path_params = {}
        if 'lookml_model_name' in params:
            path_params['lookml_model_name'] = params['lookml_model_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def lookml_model(self, lookml_model_name, **kwargs):
        """
        Get LookML Model
        ### Get information about a lookml model. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.lookml_model(lookml_model_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookml_model_name: Name of lookml model. (required)
        :param str fields: Requested fields.
        :return: LookmlModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.lookml_model_with_http_info(lookml_model_name, **kwargs)
        else:
            (data) = self.lookml_model_with_http_info(lookml_model_name, **kwargs)
            return data

    def lookml_model_with_http_info(self, lookml_model_name, **kwargs):
        """
        Get LookML Model
        ### Get information about a lookml model. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.lookml_model_with_http_info(lookml_model_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookml_model_name: Name of lookml model. (required)
        :param str fields: Requested fields.
        :return: LookmlModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookml_model_name', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lookml_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lookml_model_name' is set
        if ('lookml_model_name' not in params) or (params['lookml_model_name'] is None):
            raise ValueError("Missing the required parameter `lookml_model_name` when calling `lookml_model`")


        collection_formats = {}

        resource_path = '/lookml_models/{lookml_model_name}'.replace('{format}', 'json')
        path_params = {}
        if 'lookml_model_name' in params:
            path_params['lookml_model_name'] = params['lookml_model_name']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LookmlModel',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def lookml_model_explore(self, lookml_model_name, explore_name, **kwargs):
        """
        Get LookML Model Explore
        ### Get information about a lookml model explore. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.lookml_model_explore(lookml_model_name, explore_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookml_model_name: Name of lookml model. (required)
        :param str explore_name: Name of explore. (required)
        :param str fields: Requested fields.
        :return: LookmlModelExplore
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.lookml_model_explore_with_http_info(lookml_model_name, explore_name, **kwargs)
        else:
            (data) = self.lookml_model_explore_with_http_info(lookml_model_name, explore_name, **kwargs)
            return data

    def lookml_model_explore_with_http_info(self, lookml_model_name, explore_name, **kwargs):
        """
        Get LookML Model Explore
        ### Get information about a lookml model explore. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.lookml_model_explore_with_http_info(lookml_model_name, explore_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookml_model_name: Name of lookml model. (required)
        :param str explore_name: Name of explore. (required)
        :param str fields: Requested fields.
        :return: LookmlModelExplore
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookml_model_name', 'explore_name', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lookml_model_explore" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lookml_model_name' is set
        if ('lookml_model_name' not in params) or (params['lookml_model_name'] is None):
            raise ValueError("Missing the required parameter `lookml_model_name` when calling `lookml_model_explore`")
        # verify the required parameter 'explore_name' is set
        if ('explore_name' not in params) or (params['explore_name'] is None):
            raise ValueError("Missing the required parameter `explore_name` when calling `lookml_model_explore`")


        collection_formats = {}

        resource_path = '/lookml_models/{lookml_model_name}/explores/{explore_name}'.replace('{format}', 'json')
        path_params = {}
        if 'lookml_model_name' in params:
            path_params['lookml_model_name'] = params['lookml_model_name']
        if 'explore_name' in params:
            path_params['explore_name'] = params['explore_name']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LookmlModelExplore',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_lookml_model(self, lookml_model_name, body, **kwargs):
        """
        Update LookML Model
        ### Update a lookml model using the specified configuration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_lookml_model(lookml_model_name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookml_model_name: Name of lookml model. (required)
        :param LookmlModel body: LookML Model (required)
        :return: LookmlModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_lookml_model_with_http_info(lookml_model_name, body, **kwargs)
        else:
            (data) = self.update_lookml_model_with_http_info(lookml_model_name, body, **kwargs)
            return data

    def update_lookml_model_with_http_info(self, lookml_model_name, body, **kwargs):
        """
        Update LookML Model
        ### Update a lookml model using the specified configuration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_lookml_model_with_http_info(lookml_model_name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookml_model_name: Name of lookml model. (required)
        :param LookmlModel body: LookML Model (required)
        :return: LookmlModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookml_model_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_lookml_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lookml_model_name' is set
        if ('lookml_model_name' not in params) or (params['lookml_model_name'] is None):
            raise ValueError("Missing the required parameter `lookml_model_name` when calling `update_lookml_model`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_lookml_model`")


        collection_formats = {}

        resource_path = '/lookml_models/{lookml_model_name}'.replace('{format}', 'json')
        path_params = {}
        if 'lookml_model_name' in params:
            path_params['lookml_model_name'] = params['lookml_model_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LookmlModel',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
