# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class LookApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_looks(self, **kwargs):
        """
        Get All Looks
        ### Get all the looks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_looks(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[Look]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_looks_with_http_info(**kwargs)
        else:
            (data) = self.all_looks_with_http_info(**kwargs)
            return data

    def all_looks_with_http_info(self, **kwargs):
        """
        Get All Looks
        ### Get all the looks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_looks_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[Look]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_looks" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/looks'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Look]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_look(self, **kwargs):
        """
        Create Look
        ### Create a Look with specified information.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_look(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LookWithQuery body: Look
        :param str fields: Requested fields.
        :return: LookWithQuery
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_look_with_http_info(**kwargs)
        else:
            (data) = self.create_look_with_http_info(**kwargs)
            return data

    def create_look_with_http_info(self, **kwargs):
        """
        Create Look
        ### Create a Look with specified information.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_look_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LookWithQuery body: Look
        :param str fields: Requested fields.
        :return: LookWithQuery
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_look" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/looks'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LookWithQuery',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_look(self, look_id, **kwargs):
        """
        Delete Look
        ### Delete the look with a specific id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_look(look_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Id of look (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_look_with_http_info(look_id, **kwargs)
        else:
            (data) = self.delete_look_with_http_info(look_id, **kwargs)
            return data

    def delete_look_with_http_info(self, look_id, **kwargs):
        """
        Delete Look
        ### Delete the look with a specific id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_look_with_http_info(look_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Id of look (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['look_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_look" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'look_id' is set
        if ('look_id' not in params) or (params['look_id'] is None):
            raise ValueError("Missing the required parameter `look_id` when calling `delete_look`")


        collection_formats = {}

        resource_path = '/looks/{look_id}'.replace('{format}', 'json')
        path_params = {}
        if 'look_id' in params:
            path_params['look_id'] = params['look_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def look(self, look_id, **kwargs):
        """
        Get Look
        ### Get a Look.  Return detailed information about the Look and its associated Query.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.look(look_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Id of look (required)
        :param str fields: Requested fields.
        :return: LookWithQuery
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.look_with_http_info(look_id, **kwargs)
        else:
            (data) = self.look_with_http_info(look_id, **kwargs)
            return data

    def look_with_http_info(self, look_id, **kwargs):
        """
        Get Look
        ### Get a Look.  Return detailed information about the Look and its associated Query.  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.look_with_http_info(look_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Id of look (required)
        :param str fields: Requested fields.
        :return: LookWithQuery
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['look_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method look" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'look_id' is set
        if ('look_id' not in params) or (params['look_id'] is None):
            raise ValueError("Missing the required parameter `look_id` when calling `look`")


        collection_formats = {}

        resource_path = '/looks/{look_id}'.replace('{format}', 'json')
        path_params = {}
        if 'look_id' in params:
            path_params['look_id'] = params['look_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LookWithQuery',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_look(self, look_id, result_format, **kwargs):
        """
        Run Look
        ### Run a Look.  Runs a given look's query and returns the results in the requested format.  Suported formats:  | result_format | Description | :-----------: | :--- | | json | Plain json | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | md | Simple markdown | xlsx | MS Excel spreadsheet | sql | Returns the generated SQL rather than running the query | png | A PNG image of the visualization of the query | jpg | A JPG image of the visualization of the query   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_look(look_id, result_format, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Id of look (required)
        :param str result_format: Format of result (required)
        :param int limit: Row limit (may override the limit in the saved query).
        :param bool apply_formatting: Apply model-specified formatting to each result.
        :param bool apply_vis: Apply visualization options to results.
        :param bool cache: Get results from cache if available.
        :param int image_width: Render width for image formats.
        :param int image_height: Render height for image formats.
        :param bool generate_drill_links: Generate drill links (only applicable to 'json_detail' format.
        :param bool force_production: Force use of production models even if the user is in development mode.
        :param bool cache_only: Retrieve any results from cache even if the results have expired.
        :param str path_prefix: Prefix to use for drill links (url encoded).
        :param bool rebuild_pdts: Rebuild PDTS used in query.
        :param bool server_table_calcs: Perform table calculations on query results
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_look_with_http_info(look_id, result_format, **kwargs)
        else:
            (data) = self.run_look_with_http_info(look_id, result_format, **kwargs)
            return data

    def run_look_with_http_info(self, look_id, result_format, **kwargs):
        """
        Run Look
        ### Run a Look.  Runs a given look's query and returns the results in the requested format.  Suported formats:  | result_format | Description | :-----------: | :--- | | json | Plain json | json_detail | Row data plus metadata describing the fields, pivots, table calcs, and other aspects of the query | csv | Comma separated values with a header | txt | Tab separated values with a header | html | Simple html | md | Simple markdown | xlsx | MS Excel spreadsheet | sql | Returns the generated SQL rather than running the query | png | A PNG image of the visualization of the query | jpg | A JPG image of the visualization of the query   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_look_with_http_info(look_id, result_format, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Id of look (required)
        :param str result_format: Format of result (required)
        :param int limit: Row limit (may override the limit in the saved query).
        :param bool apply_formatting: Apply model-specified formatting to each result.
        :param bool apply_vis: Apply visualization options to results.
        :param bool cache: Get results from cache if available.
        :param int image_width: Render width for image formats.
        :param int image_height: Render height for image formats.
        :param bool generate_drill_links: Generate drill links (only applicable to 'json_detail' format.
        :param bool force_production: Force use of production models even if the user is in development mode.
        :param bool cache_only: Retrieve any results from cache even if the results have expired.
        :param str path_prefix: Prefix to use for drill links (url encoded).
        :param bool rebuild_pdts: Rebuild PDTS used in query.
        :param bool server_table_calcs: Perform table calculations on query results
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['look_id', 'result_format', 'limit', 'apply_formatting', 'apply_vis', 'cache', 'image_width', 'image_height', 'generate_drill_links', 'force_production', 'cache_only', 'path_prefix', 'rebuild_pdts', 'server_table_calcs']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_look" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'look_id' is set
        if ('look_id' not in params) or (params['look_id'] is None):
            raise ValueError("Missing the required parameter `look_id` when calling `run_look`")
        # verify the required parameter 'result_format' is set
        if ('result_format' not in params) or (params['result_format'] is None):
            raise ValueError("Missing the required parameter `result_format` when calling `run_look`")


        collection_formats = {}

        resource_path = '/looks/{look_id}/run/{result_format}'.replace('{format}', 'json')
        path_params = {}
        if 'look_id' in params:
            path_params['look_id'] = params['look_id']
        if 'result_format' in params:
            path_params['result_format'] = params['result_format']

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'apply_formatting' in params:
            query_params['apply_formatting'] = params['apply_formatting']
        if 'apply_vis' in params:
            query_params['apply_vis'] = params['apply_vis']
        if 'cache' in params:
            query_params['cache'] = params['cache']
        if 'image_width' in params:
            query_params['image_width'] = params['image_width']
        if 'image_height' in params:
            query_params['image_height'] = params['image_height']
        if 'generate_drill_links' in params:
            query_params['generate_drill_links'] = params['generate_drill_links']
        if 'force_production' in params:
            query_params['force_production'] = params['force_production']
        if 'cache_only' in params:
            query_params['cache_only'] = params['cache_only']
        if 'path_prefix' in params:
            query_params['path_prefix'] = params['path_prefix']
        if 'rebuild_pdts' in params:
            query_params['rebuild_pdts'] = params['rebuild_pdts']
        if 'server_table_calcs' in params:
            query_params['server_table_calcs'] = params['server_table_calcs']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text', 'application/json', 'image/png', 'image/jpg'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_looks(self, **kwargs):
        """
        Search Looks
        Search looks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_looks(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param int page: Requested page.
        :param int per_page: Results per page.
        :param int limit: Number of results to return. (used with offset and takes priority over page and per_page)
        :param int offset: Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        :param str sorts: Fields to sort by.
        :param str title: Match Look title.
        :param str description: Match Look description.
        :param int content_favorite_id: Match content favorite id
        :param str space_id: Filter on a particular space.
        :param str user_id: Filter on dashboards created by a particular user.
        :param str view_count: Filter on a particular value of view_count
        :return: list[Look]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_looks_with_http_info(**kwargs)
        else:
            (data) = self.search_looks_with_http_info(**kwargs)
            return data

    def search_looks_with_http_info(self, **kwargs):
        """
        Search Looks
        Search looks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_looks_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param int page: Requested page.
        :param int per_page: Results per page.
        :param int limit: Number of results to return. (used with offset and takes priority over page and per_page)
        :param int offset: Number of results to skip before returning any. (used with limit and takes priority over page and per_page)
        :param str sorts: Fields to sort by.
        :param str title: Match Look title.
        :param str description: Match Look description.
        :param int content_favorite_id: Match content favorite id
        :param str space_id: Filter on a particular space.
        :param str user_id: Filter on dashboards created by a particular user.
        :param str view_count: Filter on a particular value of view_count
        :return: list[Look]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'page', 'per_page', 'limit', 'offset', 'sorts', 'title', 'description', 'content_favorite_id', 'space_id', 'user_id', 'view_count']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_looks" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/looks/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'offset' in params:
            query_params['offset'] = params['offset']
        if 'sorts' in params:
            query_params['sorts'] = params['sorts']
        if 'title' in params:
            query_params['title'] = params['title']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'content_favorite_id' in params:
            query_params['content_favorite_id'] = params['content_favorite_id']
        if 'space_id' in params:
            query_params['space_id'] = params['space_id']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'view_count' in params:
            query_params['view_count'] = params['view_count']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Look]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_look(self, look_id, body, **kwargs):
        """
        Update Look
        ### Update the Look with a specific id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_look(look_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Id of look (required)
        :param LookWithQuery body: Look (required)
        :param str fields: Requested fields.
        :return: LookWithQuery
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_look_with_http_info(look_id, body, **kwargs)
        else:
            (data) = self.update_look_with_http_info(look_id, body, **kwargs)
            return data

    def update_look_with_http_info(self, look_id, body, **kwargs):
        """
        Update Look
        ### Update the Look with a specific id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_look_with_http_info(look_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int look_id: Id of look (required)
        :param LookWithQuery body: Look (required)
        :param str fields: Requested fields.
        :return: LookWithQuery
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['look_id', 'body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_look" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'look_id' is set
        if ('look_id' not in params) or (params['look_id'] is None):
            raise ValueError("Missing the required parameter `look_id` when calling `update_look`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_look`")


        collection_formats = {}

        resource_path = '/looks/{look_id}'.replace('{format}', 'json')
        path_params = {}
        if 'look_id' in params:
            path_params['look_id'] = params['look_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LookWithQuery',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
