# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class IntegrationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def accept_integration_hub_legal_agreement(self, integration_hub_id, **kwargs):
        """
        Accept Integration Hub Legal Agreement
        Accepts the legal agreement for a given integration hub. This only works for integration hubs that have legal_agreement_required set to true and legal_agreement_signed set to false.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.accept_integration_hub_legal_agreement(integration_hub_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_hub_id: Id of integration_hub (required)
        :return: IntegrationHub
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.accept_integration_hub_legal_agreement_with_http_info(integration_hub_id, **kwargs)
        else:
            (data) = self.accept_integration_hub_legal_agreement_with_http_info(integration_hub_id, **kwargs)
            return data

    def accept_integration_hub_legal_agreement_with_http_info(self, integration_hub_id, **kwargs):
        """
        Accept Integration Hub Legal Agreement
        Accepts the legal agreement for a given integration hub. This only works for integration hubs that have legal_agreement_required set to true and legal_agreement_signed set to false.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.accept_integration_hub_legal_agreement_with_http_info(integration_hub_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_hub_id: Id of integration_hub (required)
        :return: IntegrationHub
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_hub_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method accept_integration_hub_legal_agreement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_hub_id' is set
        if ('integration_hub_id' not in params) or (params['integration_hub_id'] is None):
            raise ValueError("Missing the required parameter `integration_hub_id` when calling `accept_integration_hub_legal_agreement`")


        collection_formats = {}

        resource_path = '/integration_hubs/{integration_hub_id}/accept_legal_agreement'.replace('{format}', 'json')
        path_params = {}
        if 'integration_hub_id' in params:
            path_params['integration_hub_id'] = params['integration_hub_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='IntegrationHub',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def all_integration_hubs(self, **kwargs):
        """
        Get All Integration Hubs
        ### Get information about all Integration Hubs. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_integration_hubs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[IntegrationHub]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_integration_hubs_with_http_info(**kwargs)
        else:
            (data) = self.all_integration_hubs_with_http_info(**kwargs)
            return data

    def all_integration_hubs_with_http_info(self, **kwargs):
        """
        Get All Integration Hubs
        ### Get information about all Integration Hubs. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_integration_hubs_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[IntegrationHub]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_integration_hubs" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/integration_hubs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[IntegrationHub]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def all_integrations(self, **kwargs):
        """
        Get All Integrations
        ### Get information about all Integrations. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_integrations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param str integration_hub_id: Filter to a specific provider
        :return: list[Integration]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_integrations_with_http_info(**kwargs)
        else:
            (data) = self.all_integrations_with_http_info(**kwargs)
            return data

    def all_integrations_with_http_info(self, **kwargs):
        """
        Get All Integrations
        ### Get information about all Integrations. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_integrations_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param str integration_hub_id: Filter to a specific provider
        :return: list[Integration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'integration_hub_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_integrations" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/integrations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']
        if 'integration_hub_id' in params:
            query_params['integration_hub_id'] = params['integration_hub_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Integration]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_integration_hub(self, **kwargs):
        """
        Create Integration Hub
        ### Create a new Integration Hub. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_integration_hub(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param IntegrationHub body: Integration Hub
        :param str fields: Requested fields.
        :return: IntegrationHub
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_integration_hub_with_http_info(**kwargs)
        else:
            (data) = self.create_integration_hub_with_http_info(**kwargs)
            return data

    def create_integration_hub_with_http_info(self, **kwargs):
        """
        Create Integration Hub
        ### Create a new Integration Hub. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_integration_hub_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param IntegrationHub body: Integration Hub
        :param str fields: Requested fields.
        :return: IntegrationHub
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_integration_hub" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/integration_hubs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='IntegrationHub',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_integration_hub(self, integration_hub_id, **kwargs):
        """
        Delete Integration Hub
        ### Delete a Integration Hub. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_integration_hub(integration_hub_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_hub_id: Id of integration_hub (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_integration_hub_with_http_info(integration_hub_id, **kwargs)
        else:
            (data) = self.delete_integration_hub_with_http_info(integration_hub_id, **kwargs)
            return data

    def delete_integration_hub_with_http_info(self, integration_hub_id, **kwargs):
        """
        Delete Integration Hub
        ### Delete a Integration Hub. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_integration_hub_with_http_info(integration_hub_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_hub_id: Id of integration_hub (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_hub_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_integration_hub" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_hub_id' is set
        if ('integration_hub_id' not in params) or (params['integration_hub_id'] is None):
            raise ValueError("Missing the required parameter `integration_hub_id` when calling `delete_integration_hub`")


        collection_formats = {}

        resource_path = '/integration_hubs/{integration_hub_id}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_hub_id' in params:
            path_params['integration_hub_id'] = params['integration_hub_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def fetch_integration_form(self, integration_id, **kwargs):
        """
        Fetch Remote Integration Form
        Returns the Integration form for presentation to the user.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.fetch_integration_form(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_id: Id of Integration (required)
        :return: DataActionForm
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.fetch_integration_form_with_http_info(integration_id, **kwargs)
        else:
            (data) = self.fetch_integration_form_with_http_info(integration_id, **kwargs)
            return data

    def fetch_integration_form_with_http_info(self, integration_id, **kwargs):
        """
        Fetch Remote Integration Form
        Returns the Integration form for presentation to the user.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.fetch_integration_form_with_http_info(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_id: Id of Integration (required)
        :return: DataActionForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch_integration_form" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `fetch_integration_form`")


        collection_formats = {}

        resource_path = '/integrations/{integration_id}/form'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integration_id'] = params['integration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DataActionForm',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def integration(self, integration_id, **kwargs):
        """
        Get Integration
        ### Get information about a Integration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.integration(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_id: Id of Integration (required)
        :param str fields: Requested fields.
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.integration_with_http_info(integration_id, **kwargs)
        else:
            (data) = self.integration_with_http_info(integration_id, **kwargs)
            return data

    def integration_with_http_info(self, integration_id, **kwargs):
        """
        Get Integration
        ### Get information about a Integration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.integration_with_http_info(integration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_id: Id of Integration (required)
        :param str fields: Requested fields.
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `integration`")


        collection_formats = {}

        resource_path = '/integrations/{integration_id}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integration_id'] = params['integration_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Integration',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def integration_hub(self, integration_hub_id, **kwargs):
        """
        Get Integration Hub
        ### Get information about a Integration Hub. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.integration_hub(integration_hub_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_hub_id: Id of Integration Hub (required)
        :param str fields: Requested fields.
        :return: IntegrationHub
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.integration_hub_with_http_info(integration_hub_id, **kwargs)
        else:
            (data) = self.integration_hub_with_http_info(integration_hub_id, **kwargs)
            return data

    def integration_hub_with_http_info(self, integration_hub_id, **kwargs):
        """
        Get Integration Hub
        ### Get information about a Integration Hub. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.integration_hub_with_http_info(integration_hub_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_hub_id: Id of Integration Hub (required)
        :param str fields: Requested fields.
        :return: IntegrationHub
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_hub_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration_hub" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_hub_id' is set
        if ('integration_hub_id' not in params) or (params['integration_hub_id'] is None):
            raise ValueError("Missing the required parameter `integration_hub_id` when calling `integration_hub`")


        collection_formats = {}

        resource_path = '/integration_hubs/{integration_hub_id}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_hub_id' in params:
            path_params['integration_hub_id'] = params['integration_hub_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='IntegrationHub',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_integration(self, integration_id, body, **kwargs):
        """
        Update Integration
        ### Update parameters on a Integration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_integration(integration_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_id: Id of Integration (required)
        :param Integration body: Integration (required)
        :param str fields: Requested fields.
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_integration_with_http_info(integration_id, body, **kwargs)
        else:
            (data) = self.update_integration_with_http_info(integration_id, body, **kwargs)
            return data

    def update_integration_with_http_info(self, integration_id, body, **kwargs):
        """
        Update Integration
        ### Update parameters on a Integration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_integration_with_http_info(integration_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_id: Id of Integration (required)
        :param Integration body: Integration (required)
        :param str fields: Requested fields.
        :return: Integration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id', 'body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_id' is set
        if ('integration_id' not in params) or (params['integration_id'] is None):
            raise ValueError("Missing the required parameter `integration_id` when calling `update_integration`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_integration`")


        collection_formats = {}

        resource_path = '/integrations/{integration_id}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_id' in params:
            path_params['integration_id'] = params['integration_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Integration',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_integration_hub(self, integration_hub_id, body, **kwargs):
        """
        Update Integration Hub
        ### Update a Integration Hub definition. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_integration_hub(integration_hub_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_hub_id: Id of Integration Hub (required)
        :param IntegrationHub body: Integration Hub (required)
        :param str fields: Requested fields.
        :return: IntegrationHub
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_integration_hub_with_http_info(integration_hub_id, body, **kwargs)
        else:
            (data) = self.update_integration_hub_with_http_info(integration_hub_id, body, **kwargs)
            return data

    def update_integration_hub_with_http_info(self, integration_hub_id, body, **kwargs):
        """
        Update Integration Hub
        ### Update a Integration Hub definition. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_integration_hub_with_http_info(integration_hub_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int integration_hub_id: Id of Integration Hub (required)
        :param IntegrationHub body: Integration Hub (required)
        :param str fields: Requested fields.
        :return: IntegrationHub
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_hub_id', 'body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_integration_hub" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_hub_id' is set
        if ('integration_hub_id' not in params) or (params['integration_hub_id'] is None):
            raise ValueError("Missing the required parameter `integration_hub_id` when calling `update_integration_hub`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_integration_hub`")


        collection_formats = {}

        resource_path = '/integration_hubs/{integration_hub_id}'.replace('{format}', 'json')
        path_params = {}
        if 'integration_hub_id' in params:
            path_params['integration_hub_id'] = params['integration_hub_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='IntegrationHub',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
