# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class HomepageApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_homepage_items(self, **kwargs):
        """
        Get All Homepage Items
        ### Get information about all homepage items. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_homepage_items(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param str sorts: Fields to sort by.
        :param str homepage_section_id: Filter to a specific homepage section
        :return: list[HomepageItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_homepage_items_with_http_info(**kwargs)
        else:
            (data) = self.all_homepage_items_with_http_info(**kwargs)
            return data

    def all_homepage_items_with_http_info(self, **kwargs):
        """
        Get All Homepage Items
        ### Get information about all homepage items. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_homepage_items_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param str sorts: Fields to sort by.
        :param str homepage_section_id: Filter to a specific homepage section
        :return: list[HomepageItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'sorts', 'homepage_section_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_homepage_items" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/homepage_items'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']
        if 'sorts' in params:
            query_params['sorts'] = params['sorts']
        if 'homepage_section_id' in params:
            query_params['homepage_section_id'] = params['homepage_section_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[HomepageItem]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def all_homepage_sections(self, **kwargs):
        """
        Get All Homepage sections
        ### Get information about all homepage sections. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_homepage_sections(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param str sorts: Fields to sort by.
        :return: list[HomepageSection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_homepage_sections_with_http_info(**kwargs)
        else:
            (data) = self.all_homepage_sections_with_http_info(**kwargs)
            return data

    def all_homepage_sections_with_http_info(self, **kwargs):
        """
        Get All Homepage sections
        ### Get information about all homepage sections. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_homepage_sections_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :param str sorts: Fields to sort by.
        :return: list[HomepageSection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'sorts']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_homepage_sections" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/homepage_sections'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']
        if 'sorts' in params:
            query_params['sorts'] = params['sorts']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[HomepageSection]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_homepage_item(self, **kwargs):
        """
        Create Homepage Item
        ### Create a new homepage item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_homepage_item(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param HomepageItem body: Homepage Item
        :param str fields: Requested fields.
        :return: HomepageItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_homepage_item_with_http_info(**kwargs)
        else:
            (data) = self.create_homepage_item_with_http_info(**kwargs)
            return data

    def create_homepage_item_with_http_info(self, **kwargs):
        """
        Create Homepage Item
        ### Create a new homepage item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_homepage_item_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param HomepageItem body: Homepage Item
        :param str fields: Requested fields.
        :return: HomepageItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_homepage_item" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/homepage_items'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HomepageItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_homepage_section(self, **kwargs):
        """
        Create Homepage section
        ### Create a new homepage section. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_homepage_section(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param HomepageSection body: Homepage section
        :param str fields: Requested fields.
        :return: HomepageSection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_homepage_section_with_http_info(**kwargs)
        else:
            (data) = self.create_homepage_section_with_http_info(**kwargs)
            return data

    def create_homepage_section_with_http_info(self, **kwargs):
        """
        Create Homepage section
        ### Create a new homepage section. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_homepage_section_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param HomepageSection body: Homepage section
        :param str fields: Requested fields.
        :return: HomepageSection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_homepage_section" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/homepage_sections'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HomepageSection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_homepage_item(self, homepage_item_id, **kwargs):
        """
        Delete Homepage Item
        ### Delete a homepage item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_homepage_item(homepage_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_item_id: Id of homepage_item (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_homepage_item_with_http_info(homepage_item_id, **kwargs)
        else:
            (data) = self.delete_homepage_item_with_http_info(homepage_item_id, **kwargs)
            return data

    def delete_homepage_item_with_http_info(self, homepage_item_id, **kwargs):
        """
        Delete Homepage Item
        ### Delete a homepage item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_homepage_item_with_http_info(homepage_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_item_id: Id of homepage_item (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['homepage_item_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_homepage_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'homepage_item_id' is set
        if ('homepage_item_id' not in params) or (params['homepage_item_id'] is None):
            raise ValueError("Missing the required parameter `homepage_item_id` when calling `delete_homepage_item`")


        collection_formats = {}

        resource_path = '/homepage_items/{homepage_item_id}'.replace('{format}', 'json')
        path_params = {}
        if 'homepage_item_id' in params:
            path_params['homepage_item_id'] = params['homepage_item_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_homepage_section(self, homepage_section_id, **kwargs):
        """
        Delete Homepage section
        ### Delete a homepage section. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_homepage_section(homepage_section_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_section_id: Id of homepage_section (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_homepage_section_with_http_info(homepage_section_id, **kwargs)
        else:
            (data) = self.delete_homepage_section_with_http_info(homepage_section_id, **kwargs)
            return data

    def delete_homepage_section_with_http_info(self, homepage_section_id, **kwargs):
        """
        Delete Homepage section
        ### Delete a homepage section. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_homepage_section_with_http_info(homepage_section_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_section_id: Id of homepage_section (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['homepage_section_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_homepage_section" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'homepage_section_id' is set
        if ('homepage_section_id' not in params) or (params['homepage_section_id'] is None):
            raise ValueError("Missing the required parameter `homepage_section_id` when calling `delete_homepage_section`")


        collection_formats = {}

        resource_path = '/homepage_sections/{homepage_section_id}'.replace('{format}', 'json')
        path_params = {}
        if 'homepage_section_id' in params:
            path_params['homepage_section_id'] = params['homepage_section_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def homepage_item(self, homepage_item_id, **kwargs):
        """
        Get Homepage Item
        ### Get information about a homepage item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.homepage_item(homepage_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_item_id: Id of homepage item (required)
        :param str fields: Requested fields.
        :return: HomepageItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.homepage_item_with_http_info(homepage_item_id, **kwargs)
        else:
            (data) = self.homepage_item_with_http_info(homepage_item_id, **kwargs)
            return data

    def homepage_item_with_http_info(self, homepage_item_id, **kwargs):
        """
        Get Homepage Item
        ### Get information about a homepage item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.homepage_item_with_http_info(homepage_item_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_item_id: Id of homepage item (required)
        :param str fields: Requested fields.
        :return: HomepageItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['homepage_item_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method homepage_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'homepage_item_id' is set
        if ('homepage_item_id' not in params) or (params['homepage_item_id'] is None):
            raise ValueError("Missing the required parameter `homepage_item_id` when calling `homepage_item`")


        collection_formats = {}

        resource_path = '/homepage_items/{homepage_item_id}'.replace('{format}', 'json')
        path_params = {}
        if 'homepage_item_id' in params:
            path_params['homepage_item_id'] = params['homepage_item_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HomepageItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def homepage_section(self, homepage_section_id, **kwargs):
        """
        Get Homepage section
        ### Get information about a homepage section. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.homepage_section(homepage_section_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_section_id: Id of homepage section (required)
        :param str fields: Requested fields.
        :return: HomepageSection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.homepage_section_with_http_info(homepage_section_id, **kwargs)
        else:
            (data) = self.homepage_section_with_http_info(homepage_section_id, **kwargs)
            return data

    def homepage_section_with_http_info(self, homepage_section_id, **kwargs):
        """
        Get Homepage section
        ### Get information about a homepage section. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.homepage_section_with_http_info(homepage_section_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_section_id: Id of homepage section (required)
        :param str fields: Requested fields.
        :return: HomepageSection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['homepage_section_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method homepage_section" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'homepage_section_id' is set
        if ('homepage_section_id' not in params) or (params['homepage_section_id'] is None):
            raise ValueError("Missing the required parameter `homepage_section_id` when calling `homepage_section`")


        collection_formats = {}

        resource_path = '/homepage_sections/{homepage_section_id}'.replace('{format}', 'json')
        path_params = {}
        if 'homepage_section_id' in params:
            path_params['homepage_section_id'] = params['homepage_section_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HomepageSection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_homepage_item(self, homepage_item_id, body, **kwargs):
        """
        Update Homepage Item
        ### Update a homepage item definition. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_homepage_item(homepage_item_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_item_id: Id of homepage item (required)
        :param HomepageItem body: Homepage Item (required)
        :param str fields: Requested fields.
        :return: HomepageItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_homepage_item_with_http_info(homepage_item_id, body, **kwargs)
        else:
            (data) = self.update_homepage_item_with_http_info(homepage_item_id, body, **kwargs)
            return data

    def update_homepage_item_with_http_info(self, homepage_item_id, body, **kwargs):
        """
        Update Homepage Item
        ### Update a homepage item definition. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_homepage_item_with_http_info(homepage_item_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_item_id: Id of homepage item (required)
        :param HomepageItem body: Homepage Item (required)
        :param str fields: Requested fields.
        :return: HomepageItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['homepage_item_id', 'body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_homepage_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'homepage_item_id' is set
        if ('homepage_item_id' not in params) or (params['homepage_item_id'] is None):
            raise ValueError("Missing the required parameter `homepage_item_id` when calling `update_homepage_item`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_homepage_item`")


        collection_formats = {}

        resource_path = '/homepage_items/{homepage_item_id}'.replace('{format}', 'json')
        path_params = {}
        if 'homepage_item_id' in params:
            path_params['homepage_item_id'] = params['homepage_item_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HomepageItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_homepage_section(self, homepage_section_id, body, **kwargs):
        """
        Update Homepage section
        ### Update a homepage section definition. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_homepage_section(homepage_section_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_section_id: Id of homepage section (required)
        :param HomepageSection body: Homepage section (required)
        :param str fields: Requested fields.
        :return: HomepageSection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_homepage_section_with_http_info(homepage_section_id, body, **kwargs)
        else:
            (data) = self.update_homepage_section_with_http_info(homepage_section_id, body, **kwargs)
            return data

    def update_homepage_section_with_http_info(self, homepage_section_id, body, **kwargs):
        """
        Update Homepage section
        ### Update a homepage section definition. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_homepage_section_with_http_info(homepage_section_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int homepage_section_id: Id of homepage section (required)
        :param HomepageSection body: Homepage section (required)
        :param str fields: Requested fields.
        :return: HomepageSection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['homepage_section_id', 'body', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_homepage_section" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'homepage_section_id' is set
        if ('homepage_section_id' not in params) or (params['homepage_section_id'] is None):
            raise ValueError("Missing the required parameter `homepage_section_id` when calling `update_homepage_section`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_homepage_section`")


        collection_formats = {}

        resource_path = '/homepage_sections/{homepage_section_id}'.replace('{format}', 'json')
        path_params = {}
        if 'homepage_section_id' in params:
            path_params['homepage_section_id'] = params['homepage_section_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HomepageSection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
