# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class DatagroupApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_datagroups(self, **kwargs):
        """
        Get All Datagroups
        ### Get information about all datagroups. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_datagroups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[Datagroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_datagroups_with_http_info(**kwargs)
        else:
            (data) = self.all_datagroups_with_http_info(**kwargs)
            return data

    def all_datagroups_with_http_info(self, **kwargs):
        """
        Get All Datagroups
        ### Get information about all datagroups. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_datagroups_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[Datagroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_datagroups" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        resource_path = '/datagroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[Datagroup]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def datagroup(self, datagroup_id, **kwargs):
        """
        Get Datagroup
        ### Get information about a datagroup. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.datagroup(datagroup_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datagroup_id: ID of datagroup. (required)
        :return: Datagroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.datagroup_with_http_info(datagroup_id, **kwargs)
        else:
            (data) = self.datagroup_with_http_info(datagroup_id, **kwargs)
            return data

    def datagroup_with_http_info(self, datagroup_id, **kwargs):
        """
        Get Datagroup
        ### Get information about a datagroup. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.datagroup_with_http_info(datagroup_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datagroup_id: ID of datagroup. (required)
        :return: Datagroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datagroup_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method datagroup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datagroup_id' is set
        if ('datagroup_id' not in params) or (params['datagroup_id'] is None):
            raise ValueError("Missing the required parameter `datagroup_id` when calling `datagroup`")


        collection_formats = {}

        resource_path = '/datagroups/{datagroup_id}'.replace('{format}', 'json')
        path_params = {}
        if 'datagroup_id' in params:
            path_params['datagroup_id'] = params['datagroup_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Datagroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_datagroup(self, datagroup_id, body, **kwargs):
        """
        Update Datagroup
        ### Update a datagroup using the specified params. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_datagroup(datagroup_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datagroup_id: ID of datagroup. (required)
        :param Datagroup body: Datagroup (required)
        :return: Datagroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_datagroup_with_http_info(datagroup_id, body, **kwargs)
        else:
            (data) = self.update_datagroup_with_http_info(datagroup_id, body, **kwargs)
            return data

    def update_datagroup_with_http_info(self, datagroup_id, body, **kwargs):
        """
        Update Datagroup
        ### Update a datagroup using the specified params. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_datagroup_with_http_info(datagroup_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datagroup_id: ID of datagroup. (required)
        :param Datagroup body: Datagroup (required)
        :return: Datagroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datagroup_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_datagroup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datagroup_id' is set
        if ('datagroup_id' not in params) or (params['datagroup_id'] is None):
            raise ValueError("Missing the required parameter `datagroup_id` when calling `update_datagroup`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_datagroup`")


        collection_formats = {}

        resource_path = '/datagroups/{datagroup_id}'.replace('{format}', 'json')
        path_params = {}
        if 'datagroup_id' in params:
            path_params['datagroup_id'] = params['datagroup_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Datagroup',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
