# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ContentApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_content_metadata_accesss(self, **kwargs):
        """
        Get All Content Metadata Accesss
        ### All content metadata access records for a content metadata item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_content_metadata_accesss(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_id: Id of content metadata
        :param str fields: Requested fields.
        :return: list[ContentMetaGroupUser]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_content_metadata_accesss_with_http_info(**kwargs)
        else:
            (data) = self.all_content_metadata_accesss_with_http_info(**kwargs)
            return data

    def all_content_metadata_accesss_with_http_info(self, **kwargs):
        """
        Get All Content Metadata Accesss
        ### All content metadata access records for a content metadata item. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_content_metadata_accesss_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_id: Id of content metadata
        :param str fields: Requested fields.
        :return: list[ContentMetaGroupUser]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_metadata_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_content_metadata_accesss" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/content_metadata_access'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'content_metadata_id' in params:
            query_params['content_metadata_id'] = params['content_metadata_id']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ContentMetaGroupUser]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def all_content_metadatas(self, parent_id, **kwargs):
        """
        Get All Content Metadatas
        ### Get information about all content metadata in a space. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_content_metadatas(parent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int parent_id: Parent space of content. (required)
        :param str fields: Requested fields.
        :return: list[ContentMeta]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_content_metadatas_with_http_info(parent_id, **kwargs)
        else:
            (data) = self.all_content_metadatas_with_http_info(parent_id, **kwargs)
            return data

    def all_content_metadatas_with_http_info(self, parent_id, **kwargs):
        """
        Get All Content Metadatas
        ### Get information about all content metadata in a space. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_content_metadatas_with_http_info(parent_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int parent_id: Parent space of content. (required)
        :param str fields: Requested fields.
        :return: list[ContentMeta]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['parent_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_content_metadatas" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'parent_id' is set
        if ('parent_id' not in params) or (params['parent_id'] is None):
            raise ValueError("Missing the required parameter `parent_id` when calling `all_content_metadatas`")


        collection_formats = {}

        resource_path = '/content_metadata'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'parent_id' in params:
            query_params['parent_id'] = params['parent_id']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ContentMeta]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def content_favorite(self, content_favorite_id, **kwargs):
        """
        Get Favorite Content
        ### Get favorite content by its id
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.content_favorite(content_favorite_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_favorite_id: Id of favorite content (required)
        :param str fields: Requested fields.
        :return: ContentFavorite
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.content_favorite_with_http_info(content_favorite_id, **kwargs)
        else:
            (data) = self.content_favorite_with_http_info(content_favorite_id, **kwargs)
            return data

    def content_favorite_with_http_info(self, content_favorite_id, **kwargs):
        """
        Get Favorite Content
        ### Get favorite content by its id
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.content_favorite_with_http_info(content_favorite_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_favorite_id: Id of favorite content (required)
        :param str fields: Requested fields.
        :return: ContentFavorite
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_favorite_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method content_favorite" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'content_favorite_id' is set
        if ('content_favorite_id' not in params) or (params['content_favorite_id'] is None):
            raise ValueError("Missing the required parameter `content_favorite_id` when calling `content_favorite`")


        collection_formats = {}

        resource_path = '/content_favorite/{content_favorite_id}'.replace('{format}', 'json')
        path_params = {}
        if 'content_favorite_id' in params:
            path_params['content_favorite_id'] = params['content_favorite_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ContentFavorite',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def content_metadata(self, content_metadata_id, **kwargs):
        """
        Get Content Metadata
        ### Get information about an individual content metadata record. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.content_metadata(content_metadata_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_id: Id of content metadata (required)
        :param str fields: Requested fields.
        :return: ContentMeta
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.content_metadata_with_http_info(content_metadata_id, **kwargs)
        else:
            (data) = self.content_metadata_with_http_info(content_metadata_id, **kwargs)
            return data

    def content_metadata_with_http_info(self, content_metadata_id, **kwargs):
        """
        Get Content Metadata
        ### Get information about an individual content metadata record. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.content_metadata_with_http_info(content_metadata_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_id: Id of content metadata (required)
        :param str fields: Requested fields.
        :return: ContentMeta
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_metadata_id', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method content_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'content_metadata_id' is set
        if ('content_metadata_id' not in params) or (params['content_metadata_id'] is None):
            raise ValueError("Missing the required parameter `content_metadata_id` when calling `content_metadata`")


        collection_formats = {}

        resource_path = '/content_metadata/{content_metadata_id}'.replace('{format}', 'json')
        path_params = {}
        if 'content_metadata_id' in params:
            path_params['content_metadata_id'] = params['content_metadata_id']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ContentMeta',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_content_favorite(self, **kwargs):
        """
        Create Favorite Content
        ### Create favorite content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_content_favorite(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContentFavorite body: Favorite Content
        :return: ContentFavorite
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_content_favorite_with_http_info(**kwargs)
        else:
            (data) = self.create_content_favorite_with_http_info(**kwargs)
            return data

    def create_content_favorite_with_http_info(self, **kwargs):
        """
        Create Favorite Content
        ### Create favorite content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_content_favorite_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContentFavorite body: Favorite Content
        :return: ContentFavorite
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_content_favorite" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/content_favorite'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ContentFavorite',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_content_metadata_access(self, **kwargs):
        """
        Create Content Metadata Access
        ### Create content metadata access. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_content_metadata_access(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContentMetaGroupUser body: Content Metadata Access
        :return: ContentMetaGroupUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_content_metadata_access_with_http_info(**kwargs)
        else:
            (data) = self.create_content_metadata_access_with_http_info(**kwargs)
            return data

    def create_content_metadata_access_with_http_info(self, **kwargs):
        """
        Create Content Metadata Access
        ### Create content metadata access. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_content_metadata_access_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContentMetaGroupUser body: Content Metadata Access
        :return: ContentMetaGroupUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_content_metadata_access" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/content_metadata_access'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ContentMetaGroupUser',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_content_favorite(self, content_favorite_id, **kwargs):
        """
        Delete Favorite Content
        ### Delete favorite content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_content_favorite(content_favorite_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_favorite_id: Id of favorite content (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_content_favorite_with_http_info(content_favorite_id, **kwargs)
        else:
            (data) = self.delete_content_favorite_with_http_info(content_favorite_id, **kwargs)
            return data

    def delete_content_favorite_with_http_info(self, content_favorite_id, **kwargs):
        """
        Delete Favorite Content
        ### Delete favorite content
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_content_favorite_with_http_info(content_favorite_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_favorite_id: Id of favorite content (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_favorite_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_content_favorite" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'content_favorite_id' is set
        if ('content_favorite_id' not in params) or (params['content_favorite_id'] is None):
            raise ValueError("Missing the required parameter `content_favorite_id` when calling `delete_content_favorite`")


        collection_formats = {}

        resource_path = '/content_favorite/{content_favorite_id}'.replace('{format}', 'json')
        path_params = {}
        if 'content_favorite_id' in params:
            path_params['content_favorite_id'] = params['content_favorite_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_content_metadata_access(self, content_metadata_access_id, **kwargs):
        """
        Delete Content Metadata Access
        ### Remove content metadata access. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_content_metadata_access(content_metadata_access_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_access_id: Id of content metadata access (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_content_metadata_access_with_http_info(content_metadata_access_id, **kwargs)
        else:
            (data) = self.delete_content_metadata_access_with_http_info(content_metadata_access_id, **kwargs)
            return data

    def delete_content_metadata_access_with_http_info(self, content_metadata_access_id, **kwargs):
        """
        Delete Content Metadata Access
        ### Remove content metadata access. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_content_metadata_access_with_http_info(content_metadata_access_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_access_id: Id of content metadata access (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_metadata_access_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_content_metadata_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'content_metadata_access_id' is set
        if ('content_metadata_access_id' not in params) or (params['content_metadata_access_id'] is None):
            raise ValueError("Missing the required parameter `content_metadata_access_id` when calling `delete_content_metadata_access`")


        collection_formats = {}

        resource_path = '/content_metadata_access/{content_metadata_access_id}'.replace('{format}', 'json')
        path_params = {}
        if 'content_metadata_access_id' in params:
            path_params['content_metadata_access_id'] = params['content_metadata_access_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_content_favorites(self, **kwargs):
        """
        Search Favorite Contents
        ### Search Favorite Content 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_content_favorites(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int user_id: Match User Id
        :param int limit: Number of results to return. (used with offset)
        :param int offset: Number of results to skip before returning any. (used with limit)
        :param str sorts: Fields to sort by.
        :param str fields: Requested fields.
        :return: list[ContentFavorite]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_content_favorites_with_http_info(**kwargs)
        else:
            (data) = self.search_content_favorites_with_http_info(**kwargs)
            return data

    def search_content_favorites_with_http_info(self, **kwargs):
        """
        Search Favorite Contents
        ### Search Favorite Content 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_content_favorites_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int user_id: Match User Id
        :param int limit: Number of results to return. (used with offset)
        :param int offset: Number of results to skip before returning any. (used with limit)
        :param str sorts: Fields to sort by.
        :param str fields: Requested fields.
        :return: list[ContentFavorite]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'limit', 'offset', 'sorts', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_content_favorites" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/content_favorite/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'offset' in params:
            query_params['offset'] = params['offset']
        if 'sorts' in params:
            query_params['sorts'] = params['sorts']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ContentFavorite]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_content_views(self, **kwargs):
        """
        Search Content Views
        ### Search Content View 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_content_views(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int view_count: Match view count
        :param int group_id: Match Group Id
        :param str look_id: Match look_id
        :param str dashboard_id: Match dashboard_id
        :param int content_metadata_id: Match content metadata id
        :param str start_of_week_date: Match start of week date
        :param bool all_time: True if only all time view records should be returned
        :param int user_id: Match user id
        :param int limit: Number of results to return. Use with `offset` to manage pagination of results
        :param int offset: Number of results to skip before returning data
        :param str sorts: Fields to sort by
        :param str fields: Requested fields.
        :return: list[ContentView]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_content_views_with_http_info(**kwargs)
        else:
            (data) = self.search_content_views_with_http_info(**kwargs)
            return data

    def search_content_views_with_http_info(self, **kwargs):
        """
        Search Content Views
        ### Search Content View 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_content_views_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int view_count: Match view count
        :param int group_id: Match Group Id
        :param str look_id: Match look_id
        :param str dashboard_id: Match dashboard_id
        :param int content_metadata_id: Match content metadata id
        :param str start_of_week_date: Match start of week date
        :param bool all_time: True if only all time view records should be returned
        :param int user_id: Match user id
        :param int limit: Number of results to return. Use with `offset` to manage pagination of results
        :param int offset: Number of results to skip before returning data
        :param str sorts: Fields to sort by
        :param str fields: Requested fields.
        :return: list[ContentView]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_count', 'group_id', 'look_id', 'dashboard_id', 'content_metadata_id', 'start_of_week_date', 'all_time', 'user_id', 'limit', 'offset', 'sorts', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_content_views" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/content_view/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'view_count' in params:
            query_params['view_count'] = params['view_count']
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']
        if 'look_id' in params:
            query_params['look_id'] = params['look_id']
        if 'dashboard_id' in params:
            query_params['dashboard_id'] = params['dashboard_id']
        if 'content_metadata_id' in params:
            query_params['content_metadata_id'] = params['content_metadata_id']
        if 'start_of_week_date' in params:
            query_params['start_of_week_date'] = params['start_of_week_date']
        if 'all_time' in params:
            query_params['all_time'] = params['all_time']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'offset' in params:
            query_params['offset'] = params['offset']
        if 'sorts' in params:
            query_params['sorts'] = params['sorts']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ContentView]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_content_metadata(self, content_metadata_id, body, **kwargs):
        """
        Update Content Metadata
        ### Move a piece of content. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_content_metadata(content_metadata_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_id: Id of content metadata (required)
        :param ContentMeta body: Content Metadata (required)
        :return: ContentMeta
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_content_metadata_with_http_info(content_metadata_id, body, **kwargs)
        else:
            (data) = self.update_content_metadata_with_http_info(content_metadata_id, body, **kwargs)
            return data

    def update_content_metadata_with_http_info(self, content_metadata_id, body, **kwargs):
        """
        Update Content Metadata
        ### Move a piece of content. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_content_metadata_with_http_info(content_metadata_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_id: Id of content metadata (required)
        :param ContentMeta body: Content Metadata (required)
        :return: ContentMeta
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_metadata_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_content_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'content_metadata_id' is set
        if ('content_metadata_id' not in params) or (params['content_metadata_id'] is None):
            raise ValueError("Missing the required parameter `content_metadata_id` when calling `update_content_metadata`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_content_metadata`")


        collection_formats = {}

        resource_path = '/content_metadata/{content_metadata_id}'.replace('{format}', 'json')
        path_params = {}
        if 'content_metadata_id' in params:
            path_params['content_metadata_id'] = params['content_metadata_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ContentMeta',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_content_metadata_access(self, content_metadata_access_id, body, **kwargs):
        """
        Update Content Metadata Access
        ### Update type of access for content metadata. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_content_metadata_access(content_metadata_access_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_access_id: Id of content metadata access (required)
        :param ContentMetaGroupUser body: Content Metadata Access (required)
        :return: ContentMetaGroupUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_content_metadata_access_with_http_info(content_metadata_access_id, body, **kwargs)
        else:
            (data) = self.update_content_metadata_access_with_http_info(content_metadata_access_id, body, **kwargs)
            return data

    def update_content_metadata_access_with_http_info(self, content_metadata_access_id, body, **kwargs):
        """
        Update Content Metadata Access
        ### Update type of access for content metadata. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_content_metadata_access_with_http_info(content_metadata_access_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int content_metadata_access_id: Id of content metadata access (required)
        :param ContentMetaGroupUser body: Content Metadata Access (required)
        :return: ContentMetaGroupUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_metadata_access_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_content_metadata_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'content_metadata_access_id' is set
        if ('content_metadata_access_id' not in params) or (params['content_metadata_access_id'] is None):
            raise ValueError("Missing the required parameter `content_metadata_access_id` when calling `update_content_metadata_access`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_content_metadata_access`")


        collection_formats = {}

        resource_path = '/content_metadata_access/{content_metadata_access_id}'.replace('{format}', 'json')
        path_params = {}
        if 'content_metadata_access_id' in params:
            path_params['content_metadata_access_id'] = params['content_metadata_access_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ContentMetaGroupUser',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
