# coding: utf-8

"""
    Looker API 3.0 Reference

    ### Authorization  The Looker API uses Looker **API3** credentials for authorization and access control. Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  ### Client SDKs  The Looker API is a RESTful system that should be usable by any programming language capable of making HTTPS requests. Client SDKs for a variety of programming languages can be generated from the Looker API's Swagger JSON metadata to streamline use of the Looker API in your applications. A client SDK for Ruby is available as an example. For more information, see [Looker API Client SDKs](https://looker.com/docs/r/api/client_sdks)  ### Try It Out!  The 'api-docs' page served by the Looker instance includes 'Try It Out!' buttons for each API method. After logging in with API3 credentials, you can use the \"Try It Out!\" buttons to call the API directly from the documentation page to interactively explore API features and responses.  ### Versioning  Future releases of Looker will expand this API release-by-release to securely expose more and more of the core power of Looker to API client applications. API endpoints marked as \"beta\" may receive breaking changes without warning. Stable (non-beta) API endpoints should not receive breaking changes in future releases. For more information, see [Looker API Versioning](https://looker.com/docs/r/api/versioning) 

    OpenAPI spec version: 3.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ConnectionApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def all_connections(self, **kwargs):
        """
        Get All Connections
        ### Get information about all connections. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_connections(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[DBConnection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_connections_with_http_info(**kwargs)
        else:
            (data) = self.all_connections_with_http_info(**kwargs)
            return data

    def all_connections_with_http_info(self, **kwargs):
        """
        Get All Connections
        ### Get information about all connections. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_connections_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[DBConnection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_connections" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/connections'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[DBConnection]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def all_dialect_infos(self, **kwargs):
        """
        Get All Dialect Infos
        ### Get information about all dialects. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_dialect_infos(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[DialectInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.all_dialect_infos_with_http_info(**kwargs)
        else:
            (data) = self.all_dialect_infos_with_http_info(**kwargs)
            return data

    def all_dialect_infos_with_http_info(self, **kwargs):
        """
        Get All Dialect Infos
        ### Get information about all dialects. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.all_dialect_infos_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str fields: Requested fields.
        :return: list[DialectInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_dialect_infos" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/dialect_info'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[DialectInfo]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def connection(self, connection_name, **kwargs):
        """
        Get Connection
        ### Get information about a connection. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connection(connection_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :param str fields: Requested fields.
        :return: DBConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.connection_with_http_info(connection_name, **kwargs)
        else:
            (data) = self.connection_with_http_info(connection_name, **kwargs)
            return data

    def connection_with_http_info(self, connection_name, **kwargs):
        """
        Get Connection
        ### Get information about a connection. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connection_with_http_info(connection_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :param str fields: Requested fields.
        :return: DBConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_name', 'fields']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `connection`")


        collection_formats = {}

        resource_path = '/connections/{connection_name}'.replace('{format}', 'json')
        path_params = {}
        if 'connection_name' in params:
            path_params['connection_name'] = params['connection_name']

        query_params = {}
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DBConnection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_connection(self, **kwargs):
        """
        Create Connection
        ### Create a connection using the specified configuration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_connection(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DBConnection body: Connection
        :return: DBConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_connection_with_http_info(**kwargs)
        else:
            (data) = self.create_connection_with_http_info(**kwargs)
            return data

    def create_connection_with_http_info(self, **kwargs):
        """
        Create Connection
        ### Create a connection using the specified configuration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_connection_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DBConnection body: Connection
        :return: DBConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_connection" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/connections'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DBConnection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_connection(self, connection_name, **kwargs):
        """
        Delete Connection
        ### Delete a connection. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_connection(connection_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_connection_with_http_info(connection_name, **kwargs)
        else:
            (data) = self.delete_connection_with_http_info(connection_name, **kwargs)
            return data

    def delete_connection_with_http_info(self, connection_name, **kwargs):
        """
        Delete Connection
        ### Delete a connection. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_connection_with_http_info(connection_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `delete_connection`")


        collection_formats = {}

        resource_path = '/connections/{connection_name}'.replace('{format}', 'json')
        path_params = {}
        if 'connection_name' in params:
            path_params['connection_name'] = params['connection_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_connection_override(self, connection_name, override_context, **kwargs):
        """
        Delete Connection
        ### Delete a connection override. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_connection_override(connection_name, override_context, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :param str override_context: Context of connection override (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_connection_override_with_http_info(connection_name, override_context, **kwargs)
        else:
            (data) = self.delete_connection_override_with_http_info(connection_name, override_context, **kwargs)
            return data

    def delete_connection_override_with_http_info(self, connection_name, override_context, **kwargs):
        """
        Delete Connection
        ### Delete a connection override. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_connection_override_with_http_info(connection_name, override_context, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :param str override_context: Context of connection override (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_name', 'override_context']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_connection_override" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `delete_connection_override`")
        # verify the required parameter 'override_context' is set
        if ('override_context' not in params) or (params['override_context'] is None):
            raise ValueError("Missing the required parameter `override_context` when calling `delete_connection_override`")


        collection_formats = {}

        resource_path = '/connections/{connection_name}/connection_override/{override_context}'.replace('{format}', 'json')
        path_params = {}
        if 'connection_name' in params:
            path_params['connection_name'] = params['connection_name']
        if 'override_context' in params:
            path_params['override_context'] = params['override_context']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def test_connection(self, connection_name, **kwargs):
        """
        Test Connection
        ### Test an existing connection.  Note that a connection's 'dialect' property has a 'connection_tests' property that lists the specific types of tests that the connection supports.  Unsupported tests in the request will be ignored. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.test_connection(connection_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :param list[str] tests: Array of names of tests to run
        :return: list[DBConnectionTestResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.test_connection_with_http_info(connection_name, **kwargs)
        else:
            (data) = self.test_connection_with_http_info(connection_name, **kwargs)
            return data

    def test_connection_with_http_info(self, connection_name, **kwargs):
        """
        Test Connection
        ### Test an existing connection.  Note that a connection's 'dialect' property has a 'connection_tests' property that lists the specific types of tests that the connection supports.  Unsupported tests in the request will be ignored. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.test_connection_with_http_info(connection_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :param list[str] tests: Array of names of tests to run
        :return: list[DBConnectionTestResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_name', 'tests']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `test_connection`")


        collection_formats = {}

        resource_path = '/connections/{connection_name}/test'.replace('{format}', 'json')
        path_params = {}
        if 'connection_name' in params:
            path_params['connection_name'] = params['connection_name']

        query_params = {}
        if 'tests' in params:
            query_params['tests'] = params['tests']
            collection_formats['tests'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[DBConnectionTestResult]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def test_connection_config(self, **kwargs):
        """
        Test Connection Configuration
        ### Test a connection configuration.  Note that a connection's 'dialect' property has a 'connection_tests' property that lists the specific types of tests that the connection supports.  Unsupported tests in the request will be ignored. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.test_connection_config(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DBConnection body: Connection
        :param list[str] tests: Array of names of tests to run
        :return: list[DBConnectionTestResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.test_connection_config_with_http_info(**kwargs)
        else:
            (data) = self.test_connection_config_with_http_info(**kwargs)
            return data

    def test_connection_config_with_http_info(self, **kwargs):
        """
        Test Connection Configuration
        ### Test a connection configuration.  Note that a connection's 'dialect' property has a 'connection_tests' property that lists the specific types of tests that the connection supports.  Unsupported tests in the request will be ignored. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.test_connection_config_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DBConnection body: Connection
        :param list[str] tests: Array of names of tests to run
        :return: list[DBConnectionTestResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'tests']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_connection_config" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/connections/test'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'tests' in params:
            query_params['tests'] = params['tests']
            collection_formats['tests'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[DBConnectionTestResult]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_connection(self, connection_name, body, **kwargs):
        """
        Update Connection
        ### Update a connection using the specified configuration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_connection(connection_name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :param DBConnection body: Connection (required)
        :return: DBConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_connection_with_http_info(connection_name, body, **kwargs)
        else:
            (data) = self.update_connection_with_http_info(connection_name, body, **kwargs)
            return data

    def update_connection_with_http_info(self, connection_name, body, **kwargs):
        """
        Update Connection
        ### Update a connection using the specified configuration. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_connection_with_http_info(connection_name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str connection_name: Name of connection (required)
        :param DBConnection body: Connection (required)
        :return: DBConnection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['connection_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'connection_name' is set
        if ('connection_name' not in params) or (params['connection_name'] is None):
            raise ValueError("Missing the required parameter `connection_name` when calling `update_connection`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_connection`")


        collection_formats = {}

        resource_path = '/connections/{connection_name}'.replace('{format}', 'json')
        path_params = {}
        if 'connection_name' in params:
            path_params['connection_name'] = params['connection_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DBConnection',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
