# lookerapi
This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 3.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

Looker admins can create API3 credentials on Looker's **Admin/Users** page. Pass API3 credentials to the **/login** endpoint to obtain a temporary access_token. Include that access_token in the Authorization header of Looker API requests. For details, see [Looker API Authorization](https://looker.com/docs/r/api/authorization)  

## Requirements.
Python 2.7 and 3.4+

## Installation & Usage
### pip install

The package is hosted in pip::

```sh
pip install lookerapi
```
(you may need to run `pip` with root permission: `sudo pip install lookerapi`)

Then import the package:
```python
import lookerapi 
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import lookerapi as looker

# replace with your custom Looker API Host domain and port, if applicable.
base_url = 'https://<<>>.looker.com:19999/api/3.0/'
#Looker admins can create API3 credentials on Looker's **Admin/Users** page
client_id = '<<>>'
client_secret = '<<>>'

# instantiate Auth API
unauthenticated_client = looker.ApiClient(base_url)
unauthenticated_authApi = looker.ApiAuthApi(unauthenticated_client)

# authenticate client
token = unauthenticated_authApi.login(client_id=client_id, client_secret=client_secret)
client = looker.ApiClient(base_url, 'Authorization', 'token ' + token.access_token)

# instantiate User API client
userApi = looker.UserApi(client)
me = userApi.me();
print(me)

# instantiate Look API client
queryAPI = looker.QueryApi(client)
body = {
  "model":"thelook",
  "view":"order_items",
  "fields":["category.name","inventory_items.days_in_inventory_tier","products.count"],
  "filters":{"category.name":"socks"},
  "sorts":["products.count desc 0"],
  "limit":"500",
  "query_timezone":"America/Los_Angeles"
}
resp = queryAPI.run_inline_query("json",body)

print(resp)

```

## Documentation for API Endpoints

All URIs are relative to *https://demo.looker.com:19999/api/3.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiAuthApi* | [**login**](docs/ApiAuthApi.md#login) | **POST** /login | Login
*ApiAuthApi* | [**login_user**](docs/ApiAuthApi.md#login_user) | **POST** /login/{user_id} | Login user
*ApiAuthApi* | [**logout**](docs/ApiAuthApi.md#logout) | **DELETE** /logout | Logout
*AuthApi* | [**create_oidc_test_config**](docs/AuthApi.md#create_oidc_test_config) | **POST** /oidc_test_configs | Create OIDC Test Configuration
*AuthApi* | [**create_saml_test_config**](docs/AuthApi.md#create_saml_test_config) | **POST** /saml_test_configs | Create SAML Test Configuration
*AuthApi* | [**delete_oidc_test_config**](docs/AuthApi.md#delete_oidc_test_config) | **DELETE** /oidc_test_configs/{test_slug} | Delete OIDC Test Configuration
*AuthApi* | [**delete_saml_test_config**](docs/AuthApi.md#delete_saml_test_config) | **DELETE** /saml_test_configs/{test_slug} | Delete SAML Test Configuration
*AuthApi* | [**fetch_and_parse_saml_idp_metadata**](docs/AuthApi.md#fetch_and_parse_saml_idp_metadata) | **POST** /fetch_and_parse_saml_idp_metadata | Parse SAML IdP Url
*AuthApi* | [**ldap_config**](docs/AuthApi.md#ldap_config) | **GET** /ldap_config | Get LDAP Configuration
*AuthApi* | [**oidc_config**](docs/AuthApi.md#oidc_config) | **GET** /oidc_config | Get OIDC Configuration
*AuthApi* | [**oidc_test_config**](docs/AuthApi.md#oidc_test_config) | **GET** /oidc_test_configs/{test_slug} | Get OIDC Test Configuration
*AuthApi* | [**parse_saml_idp_metadata**](docs/AuthApi.md#parse_saml_idp_metadata) | **POST** /parse_saml_idp_metadata | Parse SAML IdP XML
*AuthApi* | [**saml_config**](docs/AuthApi.md#saml_config) | **GET** /saml_config | Get SAML Configuration
*AuthApi* | [**saml_test_config**](docs/AuthApi.md#saml_test_config) | **GET** /saml_test_configs/{test_slug} | Get SAML Test Configuration
*AuthApi* | [**test_ldap_config_auth**](docs/AuthApi.md#test_ldap_config_auth) | **PUT** /ldap_config/test_auth | Test LDAP Auth
*AuthApi* | [**test_ldap_config_connection**](docs/AuthApi.md#test_ldap_config_connection) | **PUT** /ldap_config/test_connection | Test LDAP Connection
*AuthApi* | [**test_ldap_config_user_auth**](docs/AuthApi.md#test_ldap_config_user_auth) | **PUT** /ldap_config/test_user_auth | Test LDAP User Auth
*AuthApi* | [**test_ldap_config_user_info**](docs/AuthApi.md#test_ldap_config_user_info) | **PUT** /ldap_config/test_user_info | Test LDAP User Info
*AuthApi* | [**update_ldap_config**](docs/AuthApi.md#update_ldap_config) | **PATCH** /ldap_config | Update LDAP Configuration
*AuthApi* | [**update_oidc_config**](docs/AuthApi.md#update_oidc_config) | **PATCH** /oidc_config | Update OIDC Configuration
*AuthApi* | [**update_saml_config**](docs/AuthApi.md#update_saml_config) | **PATCH** /saml_config | Update SAML Configuration
*ConfigApi* | [**all_legacy_features**](docs/ConfigApi.md#all_legacy_features) | **GET** /legacy_features | Get All Legacy Features
*ConfigApi* | [**all_timezones**](docs/ConfigApi.md#all_timezones) | **GET** /timezones | Get All Timezones
*ConfigApi* | [**backup_configuration**](docs/ConfigApi.md#backup_configuration) | **GET** /backup_configuration | Get Backup Configuration
*ConfigApi* | [**legacy_feature**](docs/ConfigApi.md#legacy_feature) | **GET** /legacy_features/{legacy_feature_id} | Get Legacy Feature
*ConfigApi* | [**update_backup_configuration**](docs/ConfigApi.md#update_backup_configuration) | **PATCH** /backup_configuration | Update Backup Configuration
*ConfigApi* | [**update_legacy_feature**](docs/ConfigApi.md#update_legacy_feature) | **PATCH** /legacy_features/{legacy_feature_id} | Update Legacy Feature
*ConfigApi* | [**update_whitelabel_configuration**](docs/ConfigApi.md#update_whitelabel_configuration) | **PUT** /whitelabel_configuration | Update Whitelabel configuration
*ConfigApi* | [**versions**](docs/ConfigApi.md#versions) | **GET** /versions | Get ApiVersion
*ConfigApi* | [**whitelabel_configuration**](docs/ConfigApi.md#whitelabel_configuration) | **GET** /whitelabel_configuration | Get Whitelabel configuration
*ConnectionApi* | [**all_connections**](docs/ConnectionApi.md#all_connections) | **GET** /connections | Get All Connections
*ConnectionApi* | [**all_dialect_infos**](docs/ConnectionApi.md#all_dialect_infos) | **GET** /dialect_info | Get All Dialect Infos
*ConnectionApi* | [**connection**](docs/ConnectionApi.md#connection) | **GET** /connections/{connection_name} | Get Connection
*ConnectionApi* | [**create_connection**](docs/ConnectionApi.md#create_connection) | **POST** /connections | Create Connection
*ConnectionApi* | [**delete_connection**](docs/ConnectionApi.md#delete_connection) | **DELETE** /connections/{connection_name} | Delete Connection
*ConnectionApi* | [**delete_connection_override**](docs/ConnectionApi.md#delete_connection_override) | **DELETE** /connections/{connection_name}/connection_override/{override_context} | Delete Connection
*ConnectionApi* | [**test_connection**](docs/ConnectionApi.md#test_connection) | **PUT** /connections/{connection_name}/test | Test Connection
*ConnectionApi* | [**test_connection_config**](docs/ConnectionApi.md#test_connection_config) | **PUT** /connections/test | Test Connection Configuration
*ConnectionApi* | [**update_connection**](docs/ConnectionApi.md#update_connection) | **PATCH** /connections/{connection_name} | Update Connection
*ContentApi* | [**all_content_metadata_accesss**](docs/ContentApi.md#all_content_metadata_accesss) | **GET** /content_metadata_access | Get All Content Metadata Accesss
*ContentApi* | [**all_content_metadatas**](docs/ContentApi.md#all_content_metadatas) | **GET** /content_metadata | Get All Content Metadatas
*ContentApi* | [**content_favorite**](docs/ContentApi.md#content_favorite) | **GET** /content_favorite/{content_favorite_id} | Get Favorite Content
*ContentApi* | [**content_metadata**](docs/ContentApi.md#content_metadata) | **GET** /content_metadata/{content_metadata_id} | Get Content Metadata
*ContentApi* | [**create_content_favorite**](docs/ContentApi.md#create_content_favorite) | **POST** /content_favorite | Create Favorite Content
*ContentApi* | [**create_content_metadata_access**](docs/ContentApi.md#create_content_metadata_access) | **POST** /content_metadata_access | Create Content Metadata Access
*ContentApi* | [**delete_content_favorite**](docs/ContentApi.md#delete_content_favorite) | **DELETE** /content_favorite/{content_favorite_id} | Delete Favorite Content
*ContentApi* | [**delete_content_metadata_access**](docs/ContentApi.md#delete_content_metadata_access) | **DELETE** /content_metadata_access/{content_metadata_access_id} | Delete Content Metadata Access
*ContentApi* | [**search_content_favorites**](docs/ContentApi.md#search_content_favorites) | **GET** /content_favorite/search | Search Favorite Contents
*ContentApi* | [**search_content_views**](docs/ContentApi.md#search_content_views) | **GET** /content_view/search | Search Content Views
*ContentApi* | [**update_content_metadata**](docs/ContentApi.md#update_content_metadata) | **PATCH** /content_metadata/{content_metadata_id} | Update Content Metadata
*ContentApi* | [**update_content_metadata_access**](docs/ContentApi.md#update_content_metadata_access) | **PUT** /content_metadata_access/{content_metadata_access_id} | Update Content Metadata Access
*DashboardApi* | [**all_dashboards**](docs/DashboardApi.md#all_dashboards) | **GET** /dashboards | Get All Dashboards
*DashboardApi* | [**create_dashboard**](docs/DashboardApi.md#create_dashboard) | **POST** /dashboards | Create Dashboard
*DashboardApi* | [**create_dashboard_prefetch**](docs/DashboardApi.md#create_dashboard_prefetch) | **POST** /dashboards/{dashboard_id}/prefetch | Create Dashboard Prefetch
*DashboardApi* | [**dashboard**](docs/DashboardApi.md#dashboard) | **GET** /dashboards/{dashboard_id} | Get Dashboard
*DashboardApi* | [**dashboard_prefetch**](docs/DashboardApi.md#dashboard_prefetch) | **GET** /dashboards/{dashboard_id}/prefetch | Get Dashboard Prefetch
*DashboardApi* | [**delete_dashboard**](docs/DashboardApi.md#delete_dashboard) | **DELETE** /dashboards/{dashboard_id} | Delete Dashboard
*DashboardApi* | [**search_dashboards**](docs/DashboardApi.md#search_dashboards) | **GET** /dashboards/search | Search Dashboards
*DashboardApi* | [**update_dashboard**](docs/DashboardApi.md#update_dashboard) | **PATCH** /dashboards/{dashboard_id} | Update Dashboard
*DataActionApi* | [**fetch_remote_data_action_form**](docs/DataActionApi.md#fetch_remote_data_action_form) | **POST** /data_actions/form | Fetch Remote Data Action Form
*DataActionApi* | [**perform_data_action**](docs/DataActionApi.md#perform_data_action) | **POST** /data_actions | Send a Data Action
*DatagroupApi* | [**all_datagroups**](docs/DatagroupApi.md#all_datagroups) | **GET** /datagroups | Get All Datagroups
*DatagroupApi* | [**datagroup**](docs/DatagroupApi.md#datagroup) | **GET** /datagroups/{datagroup_id} | Get Datagroup
*DatagroupApi* | [**update_datagroup**](docs/DatagroupApi.md#update_datagroup) | **PATCH** /datagroups/{datagroup_id} | Update Datagroup
*GroupApi* | [**add_group_group**](docs/GroupApi.md#add_group_group) | **POST** /groups/{group_id}/groups | Add a Group to Group
*GroupApi* | [**add_group_user**](docs/GroupApi.md#add_group_user) | **POST** /groups/{group_id}/users | Add a User to Group
*GroupApi* | [**all_group_groups**](docs/GroupApi.md#all_group_groups) | **GET** /groups/{group_id}/groups | Get All Groups in Group
*GroupApi* | [**all_group_users**](docs/GroupApi.md#all_group_users) | **GET** /groups/{group_id}/users | Get All Users in Group
*GroupApi* | [**all_groups**](docs/GroupApi.md#all_groups) | **GET** /groups | Get All Groups
*GroupApi* | [**create_group**](docs/GroupApi.md#create_group) | **POST** /groups | Create Group
*GroupApi* | [**delete_group**](docs/GroupApi.md#delete_group) | **DELETE** /groups/{group_id} | Delete Group
*GroupApi* | [**delete_group_from_group**](docs/GroupApi.md#delete_group_from_group) | **DELETE** /groups/{group_id}/groups/{deleting_group_id} | Deletes a Group from Group
*GroupApi* | [**delete_group_user**](docs/GroupApi.md#delete_group_user) | **DELETE** /groups/{group_id}/users/{user_id} | Remove a User from Group
*GroupApi* | [**delete_user_attribute_group_value**](docs/GroupApi.md#delete_user_attribute_group_value) | **DELETE** /groups/{group_id}/attribute_values/{user_attribute_id} | Delete User Attribute Group Value
*GroupApi* | [**group**](docs/GroupApi.md#group) | **GET** /groups/{group_id} | Get Group
*GroupApi* | [**update_group**](docs/GroupApi.md#update_group) | **PATCH** /groups/{group_id} | Update Group
*GroupApi* | [**update_user_attribute_group_value**](docs/GroupApi.md#update_user_attribute_group_value) | **PATCH** /groups/{group_id}/attribute_values/{user_attribute_id} | Set User Attribute Group Value
*HomepageApi* | [**all_homepage_items**](docs/HomepageApi.md#all_homepage_items) | **GET** /homepage_items | Get All Homepage Items
*HomepageApi* | [**all_homepage_sections**](docs/HomepageApi.md#all_homepage_sections) | **GET** /homepage_sections | Get All Homepage sections
*HomepageApi* | [**create_homepage_item**](docs/HomepageApi.md#create_homepage_item) | **POST** /homepage_items | Create Homepage Item
*HomepageApi* | [**create_homepage_section**](docs/HomepageApi.md#create_homepage_section) | **POST** /homepage_sections | Create Homepage section
*HomepageApi* | [**delete_homepage_item**](docs/HomepageApi.md#delete_homepage_item) | **DELETE** /homepage_items/{homepage_item_id} | Delete Homepage Item
*HomepageApi* | [**delete_homepage_section**](docs/HomepageApi.md#delete_homepage_section) | **DELETE** /homepage_sections/{homepage_section_id} | Delete Homepage section
*HomepageApi* | [**homepage_item**](docs/HomepageApi.md#homepage_item) | **GET** /homepage_items/{homepage_item_id} | Get Homepage Item
*HomepageApi* | [**homepage_section**](docs/HomepageApi.md#homepage_section) | **GET** /homepage_sections/{homepage_section_id} | Get Homepage section
*HomepageApi* | [**update_homepage_item**](docs/HomepageApi.md#update_homepage_item) | **PATCH** /homepage_items/{homepage_item_id} | Update Homepage Item
*HomepageApi* | [**update_homepage_section**](docs/HomepageApi.md#update_homepage_section) | **PATCH** /homepage_sections/{homepage_section_id} | Update Homepage section
*IntegrationApi* | [**accept_integration_hub_legal_agreement**](docs/IntegrationApi.md#accept_integration_hub_legal_agreement) | **POST** /integration_hubs/{integration_hub_id}/accept_legal_agreement | Accept Integration Hub Legal Agreement
*IntegrationApi* | [**all_integration_hubs**](docs/IntegrationApi.md#all_integration_hubs) | **GET** /integration_hubs | Get All Integration Hubs
*IntegrationApi* | [**all_integrations**](docs/IntegrationApi.md#all_integrations) | **GET** /integrations | Get All Integrations
*IntegrationApi* | [**create_integration_hub**](docs/IntegrationApi.md#create_integration_hub) | **POST** /integration_hubs | Create Integration Hub
*IntegrationApi* | [**delete_integration_hub**](docs/IntegrationApi.md#delete_integration_hub) | **DELETE** /integration_hubs/{integration_hub_id} | Delete Integration Hub
*IntegrationApi* | [**fetch_integration_form**](docs/IntegrationApi.md#fetch_integration_form) | **POST** /integrations/{integration_id}/form | Fetch Remote Integration Form
*IntegrationApi* | [**integration**](docs/IntegrationApi.md#integration) | **GET** /integrations/{integration_id} | Get Integration
*IntegrationApi* | [**integration_hub**](docs/IntegrationApi.md#integration_hub) | **GET** /integration_hubs/{integration_hub_id} | Get Integration Hub
*IntegrationApi* | [**update_integration**](docs/IntegrationApi.md#update_integration) | **PATCH** /integrations/{integration_id} | Update Integration
*IntegrationApi* | [**update_integration_hub**](docs/IntegrationApi.md#update_integration_hub) | **PATCH** /integration_hubs/{integration_hub_id} | Update Integration Hub
*LookApi* | [**all_looks**](docs/LookApi.md#all_looks) | **GET** /looks | Get All Looks
*LookApi* | [**create_look**](docs/LookApi.md#create_look) | **POST** /looks | Create Look
*LookApi* | [**delete_look**](docs/LookApi.md#delete_look) | **DELETE** /looks/{look_id} | Delete Look
*LookApi* | [**look**](docs/LookApi.md#look) | **GET** /looks/{look_id} | Get Look
*LookApi* | [**run_look**](docs/LookApi.md#run_look) | **GET** /looks/{look_id}/run/{result_format} | Run Look
*LookApi* | [**search_looks**](docs/LookApi.md#search_looks) | **GET** /looks/search | Search Looks
*LookApi* | [**update_look**](docs/LookApi.md#update_look) | **PATCH** /looks/{look_id} | Update Look
*LookmlModelApi* | [**all_lookml_models**](docs/LookmlModelApi.md#all_lookml_models) | **GET** /lookml_models | Get All LookML Models
*LookmlModelApi* | [**create_lookml_model**](docs/LookmlModelApi.md#create_lookml_model) | **POST** /lookml_models | Create LookML Model
*LookmlModelApi* | [**delete_lookml_model**](docs/LookmlModelApi.md#delete_lookml_model) | **DELETE** /lookml_models/{lookml_model_name} | Delete LookML Model
*LookmlModelApi* | [**lookml_model**](docs/LookmlModelApi.md#lookml_model) | **GET** /lookml_models/{lookml_model_name} | Get LookML Model
*LookmlModelApi* | [**lookml_model_explore**](docs/LookmlModelApi.md#lookml_model_explore) | **GET** /lookml_models/{lookml_model_name}/explores/{explore_name} | Get LookML Model Explore
*LookmlModelApi* | [**update_lookml_model**](docs/LookmlModelApi.md#update_lookml_model) | **PATCH** /lookml_models/{lookml_model_name} | Update LookML Model
*ProjectApi* | [**all_git_branches**](docs/ProjectApi.md#all_git_branches) | **GET** /projects/{project_id}/git_branches | Get All Git Branchs
*ProjectApi* | [**all_git_connection_tests**](docs/ProjectApi.md#all_git_connection_tests) | **GET** /projects/{project_id}/git_connection_tests | Get All Git Connection Tests
*ProjectApi* | [**all_project_files**](docs/ProjectApi.md#all_project_files) | **GET** /projects/{project_id}/files | Get All Project Files
*ProjectApi* | [**all_projects**](docs/ProjectApi.md#all_projects) | **GET** /projects | Get All Projects
*ProjectApi* | [**create_git_deploy_key**](docs/ProjectApi.md#create_git_deploy_key) | **POST** /projects/{project_id}/git/deploy_key | Create Deploy Key
*ProjectApi* | [**create_project**](docs/ProjectApi.md#create_project) | **POST** /projects | Create Project
*ProjectApi* | [**git_deploy_key**](docs/ProjectApi.md#git_deploy_key) | **GET** /projects/{project_id}/git/deploy_key | Git Deploy Key
*ProjectApi* | [**project**](docs/ProjectApi.md#project) | **GET** /projects/{project_id} | Get Project
*ProjectApi* | [**project_file**](docs/ProjectApi.md#project_file) | **GET** /projects/{project_id}/files/file | Get Project File
*ProjectApi* | [**project_validation_results**](docs/ProjectApi.md#project_validation_results) | **GET** /projects/{project_id}/validate | Cached Project Validation Results
*ProjectApi* | [**project_workspace**](docs/ProjectApi.md#project_workspace) | **GET** /projects/{project_id}/current_workspace | Get Project Workspace
*ProjectApi* | [**reset_project_to_production**](docs/ProjectApi.md#reset_project_to_production) | **POST** /projects/{project_id}/reset_to_production | Reset To Production
*ProjectApi* | [**reset_project_to_remote**](docs/ProjectApi.md#reset_project_to_remote) | **POST** /projects/{project_id}/reset_to_remote | Reset To Remote
*ProjectApi* | [**run_git_connection_test**](docs/ProjectApi.md#run_git_connection_test) | **GET** /projects/{project_id}/git_connection_tests/{test_id} | Run Git Connection Test
*ProjectApi* | [**update_project**](docs/ProjectApi.md#update_project) | **PATCH** /projects/{project_id} | Update Project
*ProjectApi* | [**validate_project**](docs/ProjectApi.md#validate_project) | **POST** /projects/{project_id}/validate | Validate Project
*QueryApi* | [**create_query**](docs/QueryApi.md#create_query) | **POST** /queries | Create Query
*QueryApi* | [**create_query_task**](docs/QueryApi.md#create_query_task) | **POST** /query_tasks | Run Query Async
*QueryApi* | [**query**](docs/QueryApi.md#query) | **GET** /queries/{query_id} | Get Query
*QueryApi* | [**query_for_slug**](docs/QueryApi.md#query_for_slug) | **GET** /queries/slug/{slug} | Get Query for Slug
*QueryApi* | [**query_task**](docs/QueryApi.md#query_task) | **GET** /query_tasks/{query_task_id} | Get Async Query Info
*QueryApi* | [**query_task_multi_results**](docs/QueryApi.md#query_task_multi_results) | **GET** /query_tasks/multi_results | Get Multiple Async Query Results
*QueryApi* | [**query_task_results**](docs/QueryApi.md#query_task_results) | **GET** /query_tasks/{query_task_id}/results | Get Async Query Results
*QueryApi* | [**run_inline_query**](docs/QueryApi.md#run_inline_query) | **POST** /queries/run/{result_format} | Run Inline Query
*QueryApi* | [**run_query**](docs/QueryApi.md#run_query) | **GET** /queries/{query_id}/run/{result_format} | Run Query
*QueryApi* | [**run_url_encoded_query**](docs/QueryApi.md#run_url_encoded_query) | **GET** /queries/models/{model_name}/views/{view_name}/run/{result_format} | Run Url Encoded Query
*RenderTaskApi* | [**create_dashboard_render_task**](docs/RenderTaskApi.md#create_dashboard_render_task) | **POST** /render_tasks/dashboards/{dashboard_id}/{result_format} | Create Dashboard Render Task
*RenderTaskApi* | [**create_look_render_task**](docs/RenderTaskApi.md#create_look_render_task) | **POST** /render_tasks/looks/{look_id}/{result_format} | Create Look Render Task
*RenderTaskApi* | [**create_lookml_dashboard_render_task**](docs/RenderTaskApi.md#create_lookml_dashboard_render_task) | **POST** /render_tasks/lookml_dashboards/{dashboard_id}/{result_format} | Create Lookml Dashboard Render Task
*RenderTaskApi* | [**create_query_render_task**](docs/RenderTaskApi.md#create_query_render_task) | **POST** /render_tasks/queries/{query_id}/{result_format} | Create Query Render Task
*RenderTaskApi* | [**render_task**](docs/RenderTaskApi.md#render_task) | **GET** /render_tasks/{render_task_id} | Get Render Task
*RenderTaskApi* | [**render_task_results**](docs/RenderTaskApi.md#render_task_results) | **GET** /render_tasks/{render_task_id}/results | Render Task Results
*RoleApi* | [**all_model_sets**](docs/RoleApi.md#all_model_sets) | **GET** /model_sets | Get All Model Sets
*RoleApi* | [**all_permission_sets**](docs/RoleApi.md#all_permission_sets) | **GET** /permission_sets | Get All Permission Sets
*RoleApi* | [**all_permissions**](docs/RoleApi.md#all_permissions) | **GET** /permissions | Get All Permissions
*RoleApi* | [**all_roles**](docs/RoleApi.md#all_roles) | **GET** /roles | Get All Roles
*RoleApi* | [**create_model_set**](docs/RoleApi.md#create_model_set) | **POST** /model_sets | Create Model Set
*RoleApi* | [**create_permission_set**](docs/RoleApi.md#create_permission_set) | **POST** /permission_sets | Create Permission Set
*RoleApi* | [**create_role**](docs/RoleApi.md#create_role) | **POST** /roles | Create Role
*RoleApi* | [**delete_model_set**](docs/RoleApi.md#delete_model_set) | **DELETE** /model_sets/{model_set_id} | Delete Model Set
*RoleApi* | [**delete_permission_set**](docs/RoleApi.md#delete_permission_set) | **DELETE** /permission_sets/{permission_set_id} | Delete Permission Set
*RoleApi* | [**delete_role**](docs/RoleApi.md#delete_role) | **DELETE** /roles/{role_id} | Delete Role
*RoleApi* | [**model_set**](docs/RoleApi.md#model_set) | **GET** /model_sets/{model_set_id} | Get Model Set
*RoleApi* | [**permission_set**](docs/RoleApi.md#permission_set) | **GET** /permission_sets/{permission_set_id} | Get Permission Set
*RoleApi* | [**role**](docs/RoleApi.md#role) | **GET** /roles/{role_id} | Get Role
*RoleApi* | [**role_groups**](docs/RoleApi.md#role_groups) | **GET** /roles/{role_id}/groups | Get Role Groups
*RoleApi* | [**role_users**](docs/RoleApi.md#role_users) | **GET** /roles/{role_id}/users | Get Role Users
*RoleApi* | [**set_role_groups**](docs/RoleApi.md#set_role_groups) | **PUT** /roles/{role_id}/groups | Update Role Groups
*RoleApi* | [**set_role_users**](docs/RoleApi.md#set_role_users) | **PUT** /roles/{role_id}/users | Update Role Users
*RoleApi* | [**update_model_set**](docs/RoleApi.md#update_model_set) | **PATCH** /model_sets/{model_set_id} | Update Model Set
*RoleApi* | [**update_permission_set**](docs/RoleApi.md#update_permission_set) | **PATCH** /permission_sets/{permission_set_id} | Update Permission Set
*RoleApi* | [**update_role**](docs/RoleApi.md#update_role) | **PATCH** /roles/{role_id} | Update Role
*RunningQueriesApi* | [**all_running_queries**](docs/RunningQueriesApi.md#all_running_queries) | **GET** /running_queries | Get All Running Queries
*RunningQueriesApi* | [**kill_query**](docs/RunningQueriesApi.md#kill_query) | **DELETE** /running_queries/{query_task_id} | Kill Running Query
*ScheduledPlanApi* | [**all_scheduled_plans**](docs/ScheduledPlanApi.md#all_scheduled_plans) | **GET** /scheduled_plans | Get All Scheduled Plans
*ScheduledPlanApi* | [**create_scheduled_plan**](docs/ScheduledPlanApi.md#create_scheduled_plan) | **POST** /scheduled_plans | Create Scheduled Plan
*ScheduledPlanApi* | [**delete_scheduled_plan**](docs/ScheduledPlanApi.md#delete_scheduled_plan) | **DELETE** /scheduled_plans/{scheduled_plan_id} | Delete Scheduled Plan
*ScheduledPlanApi* | [**scheduled_plan**](docs/ScheduledPlanApi.md#scheduled_plan) | **GET** /scheduled_plans/{scheduled_plan_id} | Get Scheduled Plan
*ScheduledPlanApi* | [**scheduled_plan_run_once**](docs/ScheduledPlanApi.md#scheduled_plan_run_once) | **POST** /scheduled_plans/run_once | Run Scheduled Plan Once
*ScheduledPlanApi* | [**scheduled_plans_for_dashboard**](docs/ScheduledPlanApi.md#scheduled_plans_for_dashboard) | **GET** /scheduled_plans/dashboard/{dashboard_id} | Scheduled Plans for Dashboard
*ScheduledPlanApi* | [**scheduled_plans_for_look**](docs/ScheduledPlanApi.md#scheduled_plans_for_look) | **GET** /scheduled_plans/look/{look_id} | Scheduled Plans for Look
*ScheduledPlanApi* | [**scheduled_plans_for_lookml_dashboard**](docs/ScheduledPlanApi.md#scheduled_plans_for_lookml_dashboard) | **GET** /scheduled_plans/lookml_dashboard/{lookml_dashboard_id} | Scheduled Plans for LookML Dashboard
*ScheduledPlanApi* | [**scheduled_plans_for_space**](docs/ScheduledPlanApi.md#scheduled_plans_for_space) | **GET** /scheduled_plans/space/{space_id} | Scheduled Plans for Space
*ScheduledPlanApi* | [**update_scheduled_plan**](docs/ScheduledPlanApi.md#update_scheduled_plan) | **PATCH** /scheduled_plans/{scheduled_plan_id} | Update Scheduled Plan
*SessionApi* | [**session**](docs/SessionApi.md#session) | **GET** /session | Get Session
*SessionApi* | [**update_session**](docs/SessionApi.md#update_session) | **PATCH** /session | Update Session
*SpaceApi* | [**all_spaces**](docs/SpaceApi.md#all_spaces) | **GET** /spaces | Get All Spaces
*SpaceApi* | [**create_space**](docs/SpaceApi.md#create_space) | **POST** /spaces | Create Space
*SpaceApi* | [**delete_space**](docs/SpaceApi.md#delete_space) | **DELETE** /spaces/{space_id} | Delete Space
*SpaceApi* | [**search_spaces**](docs/SpaceApi.md#search_spaces) | **GET** /spaces/search | Search Spaces
*SpaceApi* | [**space**](docs/SpaceApi.md#space) | **GET** /spaces/{space_id} | Get Space
*SpaceApi* | [**space_ancestors**](docs/SpaceApi.md#space_ancestors) | **GET** /spaces/{space_id}/ancestors | Get Space Ancestors
*SpaceApi* | [**space_children**](docs/SpaceApi.md#space_children) | **GET** /spaces/{space_id}/children | Get Space Children
*SpaceApi* | [**space_children_search**](docs/SpaceApi.md#space_children_search) | **GET** /spaces/{space_id}/children/search | Search Space Children
*SpaceApi* | [**space_dashboards**](docs/SpaceApi.md#space_dashboards) | **GET** /spaces/{space_id}/dashboards | Get Space Dashboards
*SpaceApi* | [**space_looks**](docs/SpaceApi.md#space_looks) | **GET** /spaces/{space_id}/looks | Get Space Looks
*SpaceApi* | [**space_parent**](docs/SpaceApi.md#space_parent) | **GET** /spaces/{space_id}/parent | Get Space Parent
*SpaceApi* | [**update_space**](docs/SpaceApi.md#update_space) | **PATCH** /spaces/{space_id} | Update Space
*SqlQueryApi* | [**create_sql_query**](docs/SqlQueryApi.md#create_sql_query) | **POST** /sql_queries | Create SQL Runner Query
*SqlQueryApi* | [**sql_query**](docs/SqlQueryApi.md#sql_query) | **GET** /sql_queries/{slug} | Get SQL Runner Query
*UserApi* | [**all_user_access_filters**](docs/UserApi.md#all_user_access_filters) | **GET** /users/{user_id}/access_filters | Get All Access Filters
*UserApi* | [**all_user_credentials_api3s**](docs/UserApi.md#all_user_credentials_api3s) | **GET** /users/{user_id}/credentials_api3 | Get All API 3 Credentials
*UserApi* | [**all_user_credentials_embeds**](docs/UserApi.md#all_user_credentials_embeds) | **GET** /users/{user_id}/credentials_embed | Get All Embedding Credentials
*UserApi* | [**all_user_sessions**](docs/UserApi.md#all_user_sessions) | **GET** /users/{user_id}/sessions | Get All Web Login Sessions
*UserApi* | [**all_users**](docs/UserApi.md#all_users) | **GET** /users | Get All Users
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /users | Create User
*UserApi* | [**create_user_access_filter**](docs/UserApi.md#create_user_access_filter) | **POST** /users/{user_id}/access_filters | Create Access Filter
*UserApi* | [**create_user_credentials_api**](docs/UserApi.md#create_user_credentials_api) | **POST** /users/{user_id}/credentials_api | Create API Credential
*UserApi* | [**create_user_credentials_api3**](docs/UserApi.md#create_user_credentials_api3) | **POST** /users/{user_id}/credentials_api3 | Create API 3 Credential
*UserApi* | [**create_user_credentials_email**](docs/UserApi.md#create_user_credentials_email) | **POST** /users/{user_id}/credentials_email | Create Email/Password Credential
*UserApi* | [**create_user_credentials_email_password_reset**](docs/UserApi.md#create_user_credentials_email_password_reset) | **POST** /users/{user_id}/credentials_email/password_reset | Create Password Reset Token
*UserApi* | [**create_user_credentials_totp**](docs/UserApi.md#create_user_credentials_totp) | **POST** /users/{user_id}/credentials_totp | Create Two-Factor Credential
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /users/{user_id} | Delete User
*UserApi* | [**delete_user_access_filter**](docs/UserApi.md#delete_user_access_filter) | **DELETE** /users/{user_id}/access_filters/{access_filter_id} | Delete Access Filter
*UserApi* | [**delete_user_attribute_user_value**](docs/UserApi.md#delete_user_attribute_user_value) | **DELETE** /users/{user_id}/attribute_values/{user_attribute_id} | Delete User Attribute User Value
*UserApi* | [**delete_user_credentials_api**](docs/UserApi.md#delete_user_credentials_api) | **DELETE** /users/{user_id}/credentials_api | Delete API Credential
*UserApi* | [**delete_user_credentials_api3**](docs/UserApi.md#delete_user_credentials_api3) | **DELETE** /users/{user_id}/credentials_api3/{credentials_api3_id} | Delete API 3 Credential
*UserApi* | [**delete_user_credentials_email**](docs/UserApi.md#delete_user_credentials_email) | **DELETE** /users/{user_id}/credentials_email | Delete Email/Password Credential
*UserApi* | [**delete_user_credentials_embed**](docs/UserApi.md#delete_user_credentials_embed) | **DELETE** /users/{user_id}/credentials_embed/{credentials_embed_id} | Delete Embedding Credential
*UserApi* | [**delete_user_credentials_google**](docs/UserApi.md#delete_user_credentials_google) | **DELETE** /users/{user_id}/credentials_google | Delete Google Auth Credential
*UserApi* | [**delete_user_credentials_ldap**](docs/UserApi.md#delete_user_credentials_ldap) | **DELETE** /users/{user_id}/credentials_ldap | Delete LDAP Credential
*UserApi* | [**delete_user_credentials_looker_openid**](docs/UserApi.md#delete_user_credentials_looker_openid) | **DELETE** /users/{user_id}/credentials_looker_openid | Delete Looker OpenId Credential
*UserApi* | [**delete_user_credentials_oidc**](docs/UserApi.md#delete_user_credentials_oidc) | **DELETE** /users/{user_id}/credentials_oidc | Delete OIDC Auth Credential
*UserApi* | [**delete_user_credentials_saml**](docs/UserApi.md#delete_user_credentials_saml) | **DELETE** /users/{user_id}/credentials_saml | Delete Saml Auth Credential
*UserApi* | [**delete_user_credentials_totp**](docs/UserApi.md#delete_user_credentials_totp) | **DELETE** /users/{user_id}/credentials_totp | Delete Two-Factor Credential
*UserApi* | [**delete_user_session**](docs/UserApi.md#delete_user_session) | **DELETE** /users/{user_id}/sessions/{session_id} | Delete Web Login Session
*UserApi* | [**me**](docs/UserApi.md#me) | **GET** /user | Get Current User
*UserApi* | [**search_users**](docs/UserApi.md#search_users) | **GET** /users/search | Search Users
*UserApi* | [**search_users_names**](docs/UserApi.md#search_users_names) | **GET** /users/search/names/{pattern} | Search User Names
*UserApi* | [**set_user_attribute_user_value**](docs/UserApi.md#set_user_attribute_user_value) | **PATCH** /users/{user_id}/attribute_values/{user_attribute_id} | Set User Attribute User Value
*UserApi* | [**set_user_roles**](docs/UserApi.md#set_user_roles) | **PUT** /users/{user_id}/roles | Set User Roles
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PATCH** /users/{user_id} | Update User
*UserApi* | [**update_user_access_filter**](docs/UserApi.md#update_user_access_filter) | **PATCH** /users/{user_id}/access_filters/{access_filter_id} | Update Access Filter
*UserApi* | [**update_user_credentials_email**](docs/UserApi.md#update_user_credentials_email) | **PATCH** /users/{user_id}/credentials_email | Update Email/Password Credential
*UserApi* | [**user**](docs/UserApi.md#user) | **GET** /users/{user_id} | Get User by Id
*UserApi* | [**user_access_filter**](docs/UserApi.md#user_access_filter) | **GET** /users/{user_id}/access_filters/{access_filter_id} | Get Access Filter
*UserApi* | [**user_attribute_user_values**](docs/UserApi.md#user_attribute_user_values) | **GET** /users/{user_id}/attribute_values | Get User Attribute Values
*UserApi* | [**user_credentials_api**](docs/UserApi.md#user_credentials_api) | **GET** /users/{user_id}/credentials_api | Get API Credential
*UserApi* | [**user_credentials_api3**](docs/UserApi.md#user_credentials_api3) | **GET** /users/{user_id}/credentials_api3/{credentials_api3_id} | Get API 3 Credential
*UserApi* | [**user_credentials_email**](docs/UserApi.md#user_credentials_email) | **GET** /users/{user_id}/credentials_email | Get Email/Password Credential
*UserApi* | [**user_credentials_embed**](docs/UserApi.md#user_credentials_embed) | **GET** /users/{user_id}/credentials_embed/{credentials_embed_id} | Get Embedding Credential
*UserApi* | [**user_credentials_google**](docs/UserApi.md#user_credentials_google) | **GET** /users/{user_id}/credentials_google | Get Google Auth Credential
*UserApi* | [**user_credentials_ldap**](docs/UserApi.md#user_credentials_ldap) | **GET** /users/{user_id}/credentials_ldap | Get LDAP Credential
*UserApi* | [**user_credentials_looker_openid**](docs/UserApi.md#user_credentials_looker_openid) | **GET** /users/{user_id}/credentials_looker_openid | Get Looker OpenId Credential
*UserApi* | [**user_credentials_oidc**](docs/UserApi.md#user_credentials_oidc) | **GET** /users/{user_id}/credentials_oidc | Get OIDC Auth Credential
*UserApi* | [**user_credentials_saml**](docs/UserApi.md#user_credentials_saml) | **GET** /users/{user_id}/credentials_saml | Get Saml Auth Credential
*UserApi* | [**user_credentials_totp**](docs/UserApi.md#user_credentials_totp) | **GET** /users/{user_id}/credentials_totp | Get Two-Factor Credential
*UserApi* | [**user_for_credential**](docs/UserApi.md#user_for_credential) | **GET** /users/credential/{credential_type}/{credential_id} | Get User by Credential Id
*UserApi* | [**user_roles**](docs/UserApi.md#user_roles) | **GET** /users/{user_id}/roles | Get User Roles
*UserApi* | [**user_session**](docs/UserApi.md#user_session) | **GET** /users/{user_id}/sessions/{session_id} | Get Web Login Session
*UserAttributeApi* | [**all_user_attribute_group_values**](docs/UserAttributeApi.md#all_user_attribute_group_values) | **GET** /user_attributes/{user_attribute_id}/group_values | Get User Attribute Group Values
*UserAttributeApi* | [**all_user_attributes**](docs/UserAttributeApi.md#all_user_attributes) | **GET** /user_attributes | Get All User Attributes
*UserAttributeApi* | [**create_user_attribute**](docs/UserAttributeApi.md#create_user_attribute) | **POST** /user_attributes | Create User Attribute
*UserAttributeApi* | [**delete_user_attribute**](docs/UserAttributeApi.md#delete_user_attribute) | **DELETE** /user_attributes/{user_attribute_id} | Delete User Attribute
*UserAttributeApi* | [**set_user_attribute_group_values**](docs/UserAttributeApi.md#set_user_attribute_group_values) | **POST** /user_attributes/{user_attribute_id}/group_values | Set User Attribute Group Values
*UserAttributeApi* | [**update_user_attribute**](docs/UserAttributeApi.md#update_user_attribute) | **PATCH** /user_attributes/{user_attribute_id} | Update User Attribute
*UserAttributeApi* | [**user_attribute**](docs/UserAttributeApi.md#user_attribute) | **GET** /user_attributes/{user_attribute_id} | Get User Attribute
*WorkspaceApi* | [**all_workspaces**](docs/WorkspaceApi.md#all_workspaces) | **GET** /workspaces | Get All Workspaces
*WorkspaceApi* | [**workspace**](docs/WorkspaceApi.md#workspace) | **GET** /workspaces/{workspace_id} | Get Workspace


## Documentation For Models

 - [AccessFilter](docs/AccessFilter.md)
 - [AccessToken](docs/AccessToken.md)
 - [ApiSession](docs/ApiSession.md)
 - [ApiVersion](docs/ApiVersion.md)
 - [ApiVersionElement](docs/ApiVersionElement.md)
 - [BackupConfiguration](docs/BackupConfiguration.md)
 - [ContentFavorite](docs/ContentFavorite.md)
 - [ContentMeta](docs/ContentMeta.md)
 - [ContentMetaGroupUser](docs/ContentMetaGroupUser.md)
 - [ContentView](docs/ContentView.md)
 - [CreateDashboardRenderTask](docs/CreateDashboardRenderTask.md)
 - [CreateQueryTask](docs/CreateQueryTask.md)
 - [CredentialsApi](docs/CredentialsApi.md)
 - [CredentialsApi3](docs/CredentialsApi3.md)
 - [CredentialsEmail](docs/CredentialsEmail.md)
 - [CredentialsEmbed](docs/CredentialsEmbed.md)
 - [CredentialsGoogle](docs/CredentialsGoogle.md)
 - [CredentialsLDAP](docs/CredentialsLDAP.md)
 - [CredentialsLookerOpenid](docs/CredentialsLookerOpenid.md)
 - [CredentialsOIDC](docs/CredentialsOIDC.md)
 - [CredentialsSaml](docs/CredentialsSaml.md)
 - [CredentialsTotp](docs/CredentialsTotp.md)
 - [DBConnection](docs/DBConnection.md)
 - [DBConnectionBase](docs/DBConnectionBase.md)
 - [DBConnectionOverride](docs/DBConnectionOverride.md)
 - [DBConnectionTestResult](docs/DBConnectionTestResult.md)
 - [Dashboard](docs/Dashboard.md)
 - [DashboardBase](docs/DashboardBase.md)
 - [DashboardElement](docs/DashboardElement.md)
 - [DashboardFilter](docs/DashboardFilter.md)
 - [DashboardLayout](docs/DashboardLayout.md)
 - [DashboardLayoutComponent](docs/DashboardLayoutComponent.md)
 - [DataActionForm](docs/DataActionForm.md)
 - [DataActionFormField](docs/DataActionFormField.md)
 - [DataActionFormSelectOption](docs/DataActionFormSelectOption.md)
 - [DataActionRequest](docs/DataActionRequest.md)
 - [DataActionResponse](docs/DataActionResponse.md)
 - [Datagroup](docs/Datagroup.md)
 - [Dialect](docs/Dialect.md)
 - [DialectInfo](docs/DialectInfo.md)
 - [DialectInfoOptions](docs/DialectInfoOptions.md)
 - [Error](docs/Error.md)
 - [GitBranch](docs/GitBranch.md)
 - [GitConnectionTest](docs/GitConnectionTest.md)
 - [GitConnectionTestResult](docs/GitConnectionTestResult.md)
 - [GitStatus](docs/GitStatus.md)
 - [Group](docs/Group.md)
 - [GroupIdForGroupInclusion](docs/GroupIdForGroupInclusion.md)
 - [GroupIdForGroupUserInclusion](docs/GroupIdForGroupUserInclusion.md)
 - [HomepageItem](docs/HomepageItem.md)
 - [HomepageSection](docs/HomepageSection.md)
 - [Integration](docs/Integration.md)
 - [IntegrationHub](docs/IntegrationHub.md)
 - [IntegrationParam](docs/IntegrationParam.md)
 - [IntegrationRequiredField](docs/IntegrationRequiredField.md)
 - [LDAPConfig](docs/LDAPConfig.md)
 - [LDAPConfigTestResult](docs/LDAPConfigTestResult.md)
 - [LDAPGroupRead](docs/LDAPGroupRead.md)
 - [LDAPGroupWrite](docs/LDAPGroupWrite.md)
 - [LDAPUser](docs/LDAPUser.md)
 - [LDAPUserAttributeRead](docs/LDAPUserAttributeRead.md)
 - [LDAPUserAttributeWrite](docs/LDAPUserAttributeWrite.md)
 - [LegacyFeature](docs/LegacyFeature.md)
 - [Look](docs/Look.md)
 - [LookBasic](docs/LookBasic.md)
 - [LookModel](docs/LookModel.md)
 - [LookWithDashboards](docs/LookWithDashboards.md)
 - [LookWithQuery](docs/LookWithQuery.md)
 - [LookmlModel](docs/LookmlModel.md)
 - [LookmlModelExplore](docs/LookmlModelExplore.md)
 - [LookmlModelExploreAccessFilter](docs/LookmlModelExploreAccessFilter.md)
 - [LookmlModelExploreAlias](docs/LookmlModelExploreAlias.md)
 - [LookmlModelExploreAlwaysFilter](docs/LookmlModelExploreAlwaysFilter.md)
 - [LookmlModelExploreConditionallyFilter](docs/LookmlModelExploreConditionallyFilter.md)
 - [LookmlModelExploreError](docs/LookmlModelExploreError.md)
 - [LookmlModelExploreField](docs/LookmlModelExploreField.md)
 - [LookmlModelExploreFieldEnumeration](docs/LookmlModelExploreFieldEnumeration.md)
 - [LookmlModelExploreFieldMapLayer](docs/LookmlModelExploreFieldMapLayer.md)
 - [LookmlModelExploreFieldSqlCase](docs/LookmlModelExploreFieldSqlCase.md)
 - [LookmlModelExploreFieldTimeInterval](docs/LookmlModelExploreFieldTimeInterval.md)
 - [LookmlModelExploreFieldset](docs/LookmlModelExploreFieldset.md)
 - [LookmlModelExploreJoins](docs/LookmlModelExploreJoins.md)
 - [LookmlModelExploreSet](docs/LookmlModelExploreSet.md)
 - [LookmlModelExploreSupportedMeasureType](docs/LookmlModelExploreSupportedMeasureType.md)
 - [LookmlModelNavExplore](docs/LookmlModelNavExplore.md)
 - [ModelSet](docs/ModelSet.md)
 - [ModelsNotValidated](docs/ModelsNotValidated.md)
 - [OIDCConfig](docs/OIDCConfig.md)
 - [OIDCGroupRead](docs/OIDCGroupRead.md)
 - [OIDCGroupWrite](docs/OIDCGroupWrite.md)
 - [OIDCUserAttributeRead](docs/OIDCUserAttributeRead.md)
 - [OIDCUserAttributeWrite](docs/OIDCUserAttributeWrite.md)
 - [Permission](docs/Permission.md)
 - [PermissionSet](docs/PermissionSet.md)
 - [Prefetch](docs/Prefetch.md)
 - [PrefetchAccessFilterValue](docs/PrefetchAccessFilterValue.md)
 - [PrefetchDashboardFilterValue](docs/PrefetchDashboardFilterValue.md)
 - [PrefetchDashboardRequest](docs/PrefetchDashboardRequest.md)
 - [Project](docs/Project.md)
 - [ProjectError](docs/ProjectError.md)
 - [ProjectFile](docs/ProjectFile.md)
 - [ProjectValidation](docs/ProjectValidation.md)
 - [ProjectValidationCache](docs/ProjectValidationCache.md)
 - [ProjectWorkspace](docs/ProjectWorkspace.md)
 - [Query](docs/Query.md)
 - [QueryTask](docs/QueryTask.md)
 - [RenderTask](docs/RenderTask.md)
 - [ResultMakerFilterables](docs/ResultMakerFilterables.md)
 - [ResultMakerFilterablesListen](docs/ResultMakerFilterablesListen.md)
 - [ResultMakerWithIdVisConfigAndDynamicFields](docs/ResultMakerWithIdVisConfigAndDynamicFields.md)
 - [Role](docs/Role.md)
 - [RunningQueries](docs/RunningQueries.md)
 - [SamlConfig](docs/SamlConfig.md)
 - [SamlGroupRead](docs/SamlGroupRead.md)
 - [SamlGroupWrite](docs/SamlGroupWrite.md)
 - [SamlMetadataParseResult](docs/SamlMetadataParseResult.md)
 - [SamlUserAttributeRead](docs/SamlUserAttributeRead.md)
 - [SamlUserAttributeWrite](docs/SamlUserAttributeWrite.md)
 - [ScheduledPlan](docs/ScheduledPlan.md)
 - [ScheduledPlanDestination](docs/ScheduledPlanDestination.md)
 - [Session](docs/Session.md)
 - [Snippet](docs/Snippet.md)
 - [Space](docs/Space.md)
 - [SpaceBase](docs/SpaceBase.md)
 - [SqlQuery](docs/SqlQuery.md)
 - [SqlQueryCreate](docs/SqlQueryCreate.md)
 - [Timezone](docs/Timezone.md)
 - [User](docs/User.md)
 - [UserAttribute](docs/UserAttribute.md)
 - [UserAttributeGroupValue](docs/UserAttributeGroupValue.md)
 - [UserAttributeWithValue](docs/UserAttributeWithValue.md)
 - [UserIdOnly](docs/UserIdOnly.md)
 - [UserPublic](docs/UserPublic.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorDetail](docs/ValidationErrorDetail.md)
 - [WhitelabelConfiguration](docs/WhitelabelConfiguration.md)
 - [Workspace](docs/Workspace.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author



