"""
Providers module for Omnimancer.

This module contains AI provider implementations and the base provider interface.
Supports multiple AI services including Claude, OpenAI, Gemini, Cohere, and Ollama.
"""

from .base import BaseProvider
from .claude import ClaudeProvider
from .cohere import CohereProvider
from .factory import ProviderFactory
from .gemini import GeminiProvider
from .ollama import OllamaProvider
from .openai import OpenAIProvider

__all__ = [
    "BaseProvider",
    "ClaudeProvider",
    "OpenAIProvider",
    "GeminiProvider",
    "CohereProvider",
    "OllamaProvider",
    "ProviderFactory",
]
