# generated by datamodel-codegen:
#   filename:  openapi_clean.json

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field, RootModel


class BondsResponseItemAccess(BaseModel):
    global_: Optional[str] = Field(
        None,
        alias="global",
        description="Level of access to the symbol",
        examples=["Level A"],
    )
    plan: Optional[str] = Field(
        None, description="The plan name for the symbol", examples=["Grow"]
    )


class CommoditiesResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="Currency pair according to ISO 4217 standard codes with slash(/) delimiter",
        examples=["XAU/USD"],
    )
    name: Optional[str] = Field(
        None, description="Full name of the instrument", examples=["Gold Spot"]
    )
    category: Optional[str] = Field(
        None, description="Category of commodity", examples=["Precious Metal"]
    )
    description: Optional[str] = Field(
        None, description="Short description of the commodity"
    )


class CountryResponseItem(BaseModel):
    iso2: Optional[str] = Field(
        None, description="Two-letter country code defined in ISO 3166", examples=["US"]
    )
    iso3: Optional[str] = Field(
        None,
        description="Three-letter country code defined in ISO 3166",
        examples=["USA"],
    )
    numeric: Optional[str] = Field(
        None, description="Numeric country code defined in ISO 3166", examples=["840"]
    )
    name: Optional[str] = Field(
        None, description="The full name of country", examples=["United States"]
    )
    official_name: Optional[str] = Field(
        None,
        description="Official name of country",
        examples=["United States of America"],
    )
    capital: Optional[str] = Field(
        None, description="Capital of country", examples=["Washington D.C."]
    )
    currency: Optional[str] = Field(
        None, description="Currency of country", examples=["USD"]
    )


class CrossListingsItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["NVDA"]
    )
    name: Optional[str] = Field(
        None, description="Name of symbol", examples=["NVIDIA Corp"]
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNGS"],
    )


class CrossListingsResult(BaseModel):
    count: Optional[int] = Field(
        None, description="Number of cross listings found", examples=[7]
    )
    list: Optional[List[CrossListingsItem]] = Field(
        None, description="List of cross listings"
    )


class CrossMeta(BaseModel):
    base_instrument: Optional[str] = Field(
        None, description="Base instrument symbol", examples=["JPY/USD"]
    )
    base_currency: Optional[str] = Field(None, description="Base currency")
    base_exchange: Optional[str] = Field(
        None, description="Base exchange", examples=["PHYSICAL CURRENCY"]
    )
    interval: Optional[str] = Field(
        None,
        description="Interval between two consecutive points in time series",
        examples=["1min"],
    )
    quote_instrument: Optional[str] = Field(
        None, description="Quote instrument symbol", examples=["BTC/USD"]
    )
    quote_currency: Optional[str] = Field(None, description="Quote currency")
    quote_exchange: Optional[str] = Field(
        None, description="Quote exchange", examples=["Coinbase Pro"]
    )


class CryptocurrencyExchangesResponseItem(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of cryptocurrency exchange", examples=["Binance"]
    )


class CryptocurrencyResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="Cryptocurrency pair codes with slash(/) delimiter",
        examples=["BTC/USD"],
    )
    available_exchanges: Optional[List[str]] = Field(
        None,
        description="List of exchanges where the cryptocurrency is available",
        examples=[
            [
                "ABCC",
                "Allcoin",
                "BTC-Alpha",
                "BTCTurk",
                "Bibox",
                "n.exchange",
                "p2pb2b",
                "xBTCe",
            ]
        ],
    )
    currency_base: Optional[str] = Field(
        None,
        description="Base currency of the cryptocurrency pair",
        examples=["Bitcoin"],
    )
    currency_quote: Optional[str] = Field(
        None,
        description="Quote currency of the cryptocurrency pair",
        examples=["US Dollar"],
    )


class DividendsCalendarItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["MSFT"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNGS"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    ex_date: Optional[str] = Field(
        None, description="Ex-dividend date", examples=["2024-02-14"]
    )
    amount: Optional[float] = Field(
        None, description="Dividend payment amount", examples=[0.75]
    )


class ETFsListResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Instrument symbol (ticker)", examples=["IVV"]
    )
    name: Optional[str] = Field(
        None, description="Full name of the fund", examples=["iShares Core S&P 500 ETF"]
    )
    country: Optional[str] = Field(
        None, description="Country of fund incorporation", examples=["United States"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    fund_family: Optional[str] = Field(
        None,
        description="Investment company that manages the fund",
        examples=["iShares"],
    )
    fund_type: Optional[str] = Field(
        None, description="Type of fund", examples=["Large Blend"]
    )


class EarningsItem(BaseModel):
    date: Optional[str] = Field(
        None, description="Date of earning release", examples=["2020-04-30"]
    )
    time: Optional[str] = Field(
        None,
        description="Time of earning release, can be either of the following values: `Pre Market`, `After Hours`, `Time Not Supplied`",
        examples=["After Hours"],
    )
    eps_estimate: Optional[float] = Field(
        None,
        description="Analyst estimate of the future company earning",
        examples=[2.09],
    )
    eps_actual: Optional[float] = Field(
        None, description="Actual value of reported earning", examples=[2.55]
    )
    difference: Optional[float] = Field(
        None,
        description="Delta between `eps_actual` and `eps_estimate`",
        examples=[0.46],
    )
    surprise_prc: Optional[float] = Field(
        None,
        description="Surprise in the percentage of the `eps_actual` related to `eps_estimate`",
        examples=[22.01],
    )


class EdgarFilingFile(BaseModel):
    name: Optional[str] = Field(
        None, description="File name", examples=["primary_doc.html"]
    )
    size: Optional[int] = Field(None, description="File size", examples=[2980])
    type: Optional[str] = Field(None, description="File type", examples=["144"])
    url: Optional[str] = Field(
        None,
        description="File full url",
        examples=[
            "https://www.sec.gov/Archives/edgar/data/1711463/000197185724000581/primary_doc.xml"
        ],
    )


class EdgarFilingValue(BaseModel):
    cik: Optional[int] = Field(None, description="CIK code", examples=[1711463])
    filed_at: Optional[int] = Field(
        None, description="Filing date in UNIX timestamp", examples=[1726617600]
    )
    form_type: Optional[str] = Field(
        None, description="Filing form type", examples=["144"]
    )
    files: Optional[List[EdgarFilingFile]] = Field(None, description="Filing files")
    filing_url: Optional[str] = Field(
        None,
        description="Full URL of the filing",
        examples=[
            "https://www.sec.gov/Archives/edgar/data/1711463/0001971857-24-000581-index.htm"
        ],
    )


class ExchangeScheduleSession(BaseModel):
    open_time: Optional[str] = Field(
        None, description="Opening time of the session", examples=["04:00:00"]
    )
    close_time: Optional[str] = Field(
        None, description="Closing time of the session", examples=["09:30:00"]
    )
    session_name: Optional[str] = Field(
        None, description="Name of the session", examples=["Pre market"]
    )
    session_type: Optional[str] = Field(
        None, description="Type of the session", examples=["pre"]
    )


ExchangesResponseItemAccess = BondsResponseItemAccess


class ForexResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="Currency pair according to ISO 4217 standard codes with slash(/) delimiter",
        examples=["EUR/USD"],
    )
    currency_group: Optional[str] = Field(
        None,
        description="Group to which currency pair belongs to, could be: Major, Minor, Exotic and Exotic-Cross",
        examples=["Major"],
    )
    currency_base: Optional[str] = Field(
        None,
        description="Base currency name according to ISO 4217 standard",
        examples=["EUR"],
    )
    currency_quote: Optional[str] = Field(
        None,
        description="Quote currency name according to ISO 4217 standard",
        examples=["USD"],
    )


class GetAssetsResponseItem(BaseModel):
    code: Optional[str] = Field(None, description="Currency code", examples=["AUD"])
    description: Optional[str] = Field(
        None, description="Description of the asset", examples=["Australian Dollar"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code, e.g. DIGITAL_CURRENCY, PHYSICAL_CURRENCY, etc.",
        examples=["PHYSICAL_CURRENCY"],
    )
    symbol: Optional[str] = Field(None, description="Currency symbol", examples=["A$"])


class HolderItem(BaseModel):
    entity_name: Optional[str] = Field(
        None,
        description="Refers to the legal name of the institution",
        examples=["Vanguard Group, Inc. (The)"],
    )
    date_reported: Optional[str] = Field(
        None, description="Refers to date reported", examples=["2021-06-30"]
    )
    shares: Optional[int] = Field(
        None, description="Refers to the number of shares owned", examples=[1264936543]
    )
    value: Optional[int] = Field(
        None,
        description="Total value of shares owned, calculated by multiplying `shares` by the current price",
        examples=[173245708929],
    )
    percent_held: Optional[float] = Field(
        None,
        description="Represents the percentage of shares outstanding that are owned by the financial institution",
        examples=[0.0765],
    )


class Index(BaseModel):
    country: Optional[str] = None
    currency: Optional[str] = None
    exchange: Optional[str] = None
    mic_code: Optional[str] = None
    name: Optional[str] = None
    symbol: Optional[str] = None


class LastChangeResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker of the company", examples=["AAPL"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market Identifier Code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    last_change: Optional[datetime] = Field(
        None,
        description="The date and time of last changes, in `2006-01-02 15:04:05` format",
    )


class MarketMoversResponseValue(BaseModel):
    symbol: Optional[str] = Field(
        None, description="The exchange symbol ticker", examples=["BSET"]
    )
    name: Optional[str] = Field(
        None,
        description="The official name of the instrument",
        examples=["Bassett Furniture Industries Inc"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    datetime: Optional[str] = Field(
        None,
        description="The last updated datetime timestamp",
        examples=["2023-10-01T12:00:00Z"],
    )
    last: Optional[float] = Field(
        None,
        description="The latest available price for the symbol today",
        examples=[17.25],
    )
    high: Optional[float] = Field(
        None, description="The highest price for the symbol today", examples=[18]
    )
    low: Optional[float] = Field(
        None, description="The lowest price for the symbol today", examples=[16.5]
    )
    volume: Optional[int] = Field(
        None, description="The trading volume of the symbol today", examples=[108297]
    )
    change: Optional[float] = Field(
        None,
        description="The value of the change since the previous day",
        examples=[3.31],
    )
    percent_change: Optional[float] = Field(
        None,
        description="The percentage change since the previous day",
        examples=[23.74462],
    )


class MarketStateResponseItem(BaseModel):
    name: Optional[str] = Field(
        None, description="The full name of exchange", examples=["NYSE"]
    )
    code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNYS"],
    )
    country: Optional[str] = Field(
        None,
        description="Country where the exchange is located",
        examples=["United States"],
    )
    is_market_open: Optional[bool] = Field(
        None, description="Indicates if the market is currently open", examples=[True]
    )
    time_after_open: Optional[str] = Field(
        None,
        description="Time after market opening in <code>HH:MM:SS</code> format; if currently closed - returns <code>00:00:00</code>",
        examples=["02:39:03"],
    )
    time_to_open: Optional[str] = Field(
        None,
        description="Time to market opening in <code>HH:MM:SS</code> format; if currently open - returns <code>00:00:00</code>",
        examples=["00:00:00"],
    )
    time_to_close: Optional[str] = Field(
        None,
        description="Time to market closing in <code>HH:MM:SS</code> format; if currently closed - returns <code>00:00:00</code>",
        examples=["05:20:57"],
    )


class MutualFundsListResponseListItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Fund symbol ticker", examples=["0P0001LCQ3"]
    )
    name: Optional[str] = Field(
        None, description="Fund name", examples=["JNL Small Cap Index Fund (I)"]
    )
    country: Optional[str] = Field(
        None, description="Country of fund incorporation", examples=["United States"]
    )
    fund_family: Optional[str] = Field(
        None,
        description="Investment company that manages the fund",
        examples=["Jackson National"],
    )
    fund_type: Optional[str] = Field(
        None, description="Type of fund", examples=["Small Blend"]
    )
    performance_rating: Optional[int] = Field(
        None, description="Performance rating from `0` to `5`", examples=[2]
    )
    risk_rating: Optional[int] = Field(
        None, description="Risk rating from `0` to `5`", examples=[4]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency code in which the fund is denominated",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange name where the fund is listed", examples=["OTC"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["OTCM"],
    )


class OptionSide(BaseModel):
    ask: Optional[float] = None
    bid: Optional[float] = None
    change: Optional[float] = None
    contract_name: Optional[str] = None
    implied_volatility: Optional[float] = None
    in_the_money: Optional[bool] = None
    last_price: Optional[float] = None
    last_trade_date: Optional[str] = None
    open_interest: Optional[int] = None
    option_id: Optional[str] = None
    percent_change: Optional[float] = None
    strike: Optional[float] = None
    volume: Optional[int] = None


class ResponseMutualFundWorldRatings(BaseModel):
    performance_rating: Optional[int] = Field(
        None, description="Performance rating from 0 to 5", examples=[2]
    )
    risk_rating: Optional[int] = Field(
        None, description="Risk rating from 0 to 5", examples=[4]
    )
    return_rating: Optional[int] = Field(
        None, description="Return rating from 0 to 5", examples=[0]
    )


class ResponseSanctionItemList(BaseModel):
    name: Optional[str] = Field(
        None, description="The sanction list name", examples=["SDN List"]
    )
    published_at: Optional[str] = Field(
        None,
        description="The sanction published date in the current sanctions list",
        examples=["2024-10-30"],
    )


class SplitsCalendarResponseItem(BaseModel):
    date: Optional[str] = Field(
        None, description="Stands for the split date", examples=["2024-04-23"]
    )
    symbol: Optional[str] = Field(
        None, description="Ticker of the company", examples=["AAPL"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market Identifier Code (MIC) under ISO 10383 standard",
        examples=["XNGS"],
    )
    exchange: Optional[str] = Field(
        None,
        description="Exchange name where the company is listed",
        examples=["NASDAQ"],
    )
    description: Optional[str] = Field(
        None, description="Specification of the split event", examples=["1-for-1 split"]
    )
    ratio: Optional[float] = Field(
        None,
        description="The ratio by which the number of a company's outstanding shares of stock are increased following a stock split. For example, a `4-for-1 split` results in four times as many outstanding shares, with each share selling at one forth of its pre-split price",
        examples=[1],
    )
    from_factor: Optional[float] = Field(
        None, description="From factor of the split", examples=[1]
    )
    to_factor: Optional[float] = Field(
        None, description="To factor of the split", examples=[1]
    )


class StockExchange(BaseModel):
    country: Optional[str] = None
    name: Optional[str] = None


class SymbolSearchResponseItemAccess(BaseModel):
    global_: Optional[str] = Field(
        None,
        alias="global",
        description="Level of access to the symbol",
        examples=["Basic"],
    )
    plan: Optional[str] = Field(
        None, description="The plan name for the symbol", examples=["Basic"]
    )


class Display(Enum):
    line = "line"
    histogram = "histogram"
    candle = "candle"
    points = "points"


class TechnicalIndicatorsResponseMacdOutputValue(BaseModel):
    default_color: Optional[str] = Field(
        None,
        description="Suggested color for displaying returns hex color code",
        examples=["#FF0000"],
    )
    display: Optional[Display] = Field(
        None, description="How output value should be rendered", examples=["line"]
    )
    min_range: Optional[int] = Field(
        None, description="If output value has minimum bound", examples=[0]
    )
    max_range: Optional[int] = Field(
        None, description="If output value has maximum bound", examples=[5]
    )


class TechnicalIndicatorsResponseMacdOutputValues(BaseModel):
    parameter_name: Optional[TechnicalIndicatorsResponseMacdOutputValue] = None


class TechnicalIndicatorsResponseMacdParameter(BaseModel):
    default: Optional[int] = Field(
        None, description="Specifies parameter value set by default", examples=[12]
    )
    max_range: Optional[int] = Field(
        None,
        description="If the parameter has upper bound in order to ensure correct calculation",
        examples=[1],
    )
    min_range: Optional[int] = Field(
        None,
        description="If the parameter has lower bound in order to ensure correct calculation",
        examples=[1],
    )
    range: Optional[List[str]] = Field(
        None,
        description="An array of available parameter values",
        examples=[["open", "high", "low", "close"]],
    )
    type: Optional[str] = Field(
        None,
        description="Type of parameter might be <code>string</code>, <code>int</code>, <code>float</code> or <code>array</code>",
        examples=["int"],
    )


class TechnicalIndicatorsResponseMacdParameters(BaseModel):
    parameter_name: Optional[TechnicalIndicatorsResponseMacdParameter] = None


class TechnicalIndicatorsResponseMacdTinting(BaseModel):
    display: Optional[str] = Field(
        None, description="How the tinting should be rendered", examples=["fill"]
    )
    color: Optional[str] = Field(
        None, description="Hex color code for the tinting", examples=["#FF0000"]
    )
    transparency: Optional[float] = Field(
        None,
        description="Transparency level, float value from <code>0</code> to <code>1</code>",
        examples=[0.5],
    )
    lower_bound: Optional[Dict[str, Any]] = Field(
        None,
        description="Lower bound of tinting, can be a number or a return parameter name",
        examples=["0"],
    )
    upper_bound: Optional[Dict[str, Any]] = Field(
        None,
        description="Upper bound of tinting, can be a number or a return parameter name",
        examples=["macd"],
    )


class TimeSeriesCrossItem(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime at local exchange time referring to when the bar with specified interval was opened",
        examples=["2025-02-28 14:30:00"],
    )
    open: Optional[str] = Field(
        None,
        description="Price at the opening of the current bar",
        examples=["0.0000081115665"],
    )
    high: Optional[str] = Field(
        None,
        description="Highest price which occurred during the current bar",
        examples=["0.0000081273069"],
    )
    low: Optional[str] = Field(
        None,
        description="Lowest price which occurred during the current bar",
        examples=["0.0000081088287"],
    )
    close: Optional[str] = Field(
        None,
        description="Close price at the end of the bar",
        examples=["0.0000081268066"],
    )


class TimeSeriesItem(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime at local exchange time referring to when the bar with specified interval was opened.",
        examples=["2021-09-16 15:59:00"],
    )
    open: Optional[str] = Field(
        None, description="Price at the opening of current bar", examples=["148.73500"]
    )
    high: Optional[str] = Field(
        None,
        description="Highest price which occurred during the current bar.",
        examples=["148.86000"],
    )
    low: Optional[str] = Field(
        None,
        description="Lowest price which occurred during the current bar.",
        examples=["148.73000"],
    )
    close: Optional[str] = Field(
        None, description="Close price at the end of the bar.", examples=["148.85001"]
    )
    volume: Optional[str] = Field(
        None,
        description="Trading volume which occurred during the current bar",
        examples=["624277"],
    )


class GetTimeSeriesAd200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["AD - Chaikin A/D Line"],
    )


class GetTimeSeriesAd200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAd200ResponseMetaIndicator] = None


class GetTimeSeriesAd200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ad: Optional[str] = Field(None, description="AD value", examples=["2262629.83773"])


class GetTimeSeriesAd200Response(BaseModel):
    meta: Optional[GetTimeSeriesAd200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAd200ResponseValuesInner]] = None
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAdd200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ADD - Arithmetic Addition"],
    )
    series_type_1: Optional[str] = Field(
        None,
        description="Price type used as the first part of technical indicator",
        examples=["open"],
    )
    series_type_2: Optional[str] = Field(
        None,
        description="Price type used as the second part of technical indicator",
        examples=["close"],
    )


class GetTimeSeriesAdd200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAdd200ResponseMetaIndicator] = None


class GetTimeSeriesAdd200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    add: Optional[str] = Field(None, description="Add value", examples=["402.10798"])


class GetTimeSeriesAdd200Response(BaseModel):
    meta: Optional[GetTimeSeriesAdd200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAdd200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAdOsc200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ADOSC - Chaikin A/D Oscillator"],
    )
    fast_period: Optional[int] = Field(
        None, description="Number of periods for fast moving average", examples=[12]
    )
    slow_period: Optional[int] = Field(
        None, description="Number of periods for slow moving average", examples=[26]
    )


class GetTimeSeriesAdOsc200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAdOsc200ResponseMetaIndicator] = None


class GetTimeSeriesAdOsc200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    adosc: Optional[str] = Field(
        None, description="Adosc value", examples=["-233315.15185"]
    )


class GetTimeSeriesAdOsc200Response(BaseModel):
    meta: Optional[GetTimeSeriesAdOsc200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAdOsc200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAdx200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ADX - Average Directional Index"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[14]
    )


class GetTimeSeriesAdx200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAdx200ResponseMetaIndicator] = None


class GetTimeSeriesAdx200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    adx: Optional[str] = Field(None, description="ADX value", examples=["49.22897"])


class GetTimeSeriesAdx200Response(BaseModel):
    meta: Optional[GetTimeSeriesAdx200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAdx200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAdxr200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ADXR - Average Directional Movement Index Rating"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[14]
    )


class GetTimeSeriesAdxr200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAdxr200ResponseMetaIndicator] = None


class GetTimeSeriesAdxr200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    adxr: Optional[str] = Field(None, description="Adxr value", examples=["37.43665"])


class GetTimeSeriesAdxr200Response(BaseModel):
    meta: Optional[GetTimeSeriesAdxr200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAdxr200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetAnalystRatingsLight200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Symbol ticker of the instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the instrument", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None, description="Currency in which the instrument is traded", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Timezone of the exchange", examples=["America/New_York"]
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where the instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNGS"],
    )
    type: Optional[str] = Field(
        None, description="Type of the instrument", examples=["Common Stock"]
    )


class GetAnalystRatingsLight200ResponseRatingsInner(BaseModel):
    date: Optional[str] = Field(
        None, description="Date when the rating was released", examples=["2022-08-19"]
    )
    firm: Optional[str] = Field(
        None, description="Firm that issued the ranking", examples=["Keybanc"]
    )
    rating_change: Optional[str] = Field(
        None,
        description="Defines the action of the firm to ranking, could be `Maintains`, `Upgrade`, `Downgrade`, `Initiates` or `Reiterates`",
        examples=["Maintains"],
    )
    rating_current: Optional[str] = Field(
        None,
        description="Current firm's ranking of the instrument",
        examples=["Overweight"],
    )
    rating_prior: Optional[str] = Field(
        None,
        description="Prior firm's ranking of the instrument",
        examples=["Overweight"],
    )


class GetAnalystRatingsLight200Response(BaseModel):
    meta: Optional[GetAnalystRatingsLight200ResponseMeta] = None
    ratings: Optional[List[GetAnalystRatingsLight200ResponseRatingsInner]] = Field(
        None, description="List of analyst ratings"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetAnalystRatingsUsEquities200ResponseRatingsInner(BaseModel):
    date: Optional[str] = Field(
        None, description="Date when the rating was released", examples=["2022-08-19"]
    )
    firm: Optional[str] = Field(
        None, description="Firm that issued the ranking", examples=["Keybanc"]
    )
    analyst_name: Optional[str] = Field(
        None, description="Name of an analyst", examples=["Brandon Nispel"]
    )
    rating_change: Optional[str] = Field(
        None,
        description="Defines the action of the firm to ranking, could be `Maintains`, `Upgrade`, `Downgrade`, `Initiates`, `Reiterates`, `Assumes`, or `Reinstates`",
        examples=["Maintains"],
    )
    rating_current: Optional[str] = Field(
        None,
        description="Current firm's ranking of the instrument",
        examples=["Overweight"],
    )
    rating_prior: Optional[str] = Field(
        None,
        description="Prior firm's ranking of the instrument",
        examples=["Overweight"],
    )
    time: Optional[str] = Field(
        None,
        description="Time when the rating was released or updated",
        examples=["08:29:48"],
    )
    action_price_target: Optional[str] = Field(
        None,
        description="Action that firm took towards target price",
        examples=["Raises"],
    )
    price_target_current: Optional[float] = Field(
        None,
        description="Current firm's price target for the instrument",
        examples=[185.14],
    )
    price_target_prior: Optional[float] = Field(
        None,
        description="Prior firm's price target for the instrument",
        examples=[177.01],
    )


class GetAnalystRatingsUsEquities200Response(BaseModel):
    meta: Optional[GetAnalystRatingsLight200ResponseMeta] = None
    ratings: Optional[List[GetAnalystRatingsUsEquities200ResponseRatingsInner]] = Field(
        None, description="List of analyst ratings"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetApiUsage200Response(BaseModel):
    timestamp: Optional[str] = Field(
        None,
        description="Current timestamp in UTC timezone",
        examples=["2025-05-07 11:10:12"],
    )
    current_usage: Optional[int] = Field(
        None, description="Number of requests made in last minute", examples=[4003]
    )
    plan_limit: Optional[int] = Field(
        None,
        description="Your personal API limit (requests/minute) depending on the plan",
        examples=[4181],
    )


class GetTimeSeriesApo200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["APO - Absolute Price Oscillator"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    fast_period: Optional[int] = Field(
        None, description="Number of periods for fast moving average", examples=[12]
    )
    slow_period: Optional[int] = Field(
        None, description="Number of periods for slow moving average", examples=[26]
    )
    ma_type: Optional[str] = Field(
        None, description="Type of moving average used", examples=["SMA"]
    )


class GetTimeSeriesApo200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesApo200ResponseMetaIndicator] = None


class GetTimeSeriesApo200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    apo: Optional[str] = Field(None, description="APO value", examples=["-0.54508"])


class GetTimeSeriesApo200Response(BaseModel):
    meta: Optional[GetTimeSeriesApo200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesApo200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAroon200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["AROON - Aroon Indicator"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[14]
    )


class GetTimeSeriesAroon200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAroon200ResponseMetaIndicator] = None


class GetTimeSeriesAroon200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    aroon_down: Optional[str] = Field(
        None, description="Aroon down value", examples=["92.85714"]
    )
    aroon_up: Optional[str] = Field(
        None, description="Aroon up value", examples=["0.0"]
    )


class GetTimeSeriesAroon200Response(BaseModel):
    meta: Optional[GetTimeSeriesAroon200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAroon200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAroonOsc200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["AROONOSC - Aroon Oscillator"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[14]
    )


class GetTimeSeriesAroonOsc200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAroonOsc200ResponseMetaIndicator] = None


class GetTimeSeriesAroonOsc200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    aroonosc: Optional[str] = Field(
        None, description="Aroon oscillator value", examples=["-92.85714"]
    )


class GetTimeSeriesAroonOsc200Response(BaseModel):
    meta: Optional[GetTimeSeriesAroonOsc200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAroonOsc200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAtr200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ATR - Average True Range"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[14]
    )


class GetTimeSeriesAtr200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAtr200ResponseMetaIndicator] = None


class GetTimeSeriesAtr200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    atr: Optional[str] = Field(None, description="ATR value", examples=["0.19828"])


class GetTimeSeriesAtr200Response(BaseModel):
    meta: Optional[GetTimeSeriesAtr200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAtr200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAvg200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["AVG - Average"]
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesAvg200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAvg200ResponseMetaIndicator] = None


class GetTimeSeriesAvg200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    avg: Optional[str] = Field(None, description="Avg value", examples=["201.53871"])


class GetTimeSeriesAvg200Response(BaseModel):
    meta: Optional[GetTimeSeriesAvg200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAvg200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesAvgPrice200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["AVGPRICE - Average Price"],
    )


class GetTimeSeriesAvgPrice200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesAvgPrice200ResponseMetaIndicator] = None


class GetTimeSeriesAvgPrice200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    avgprice: Optional[str] = Field(
        None, description="Avgprice value", examples=["201.02449"]
    )


class GetTimeSeriesAvgPrice200Response(BaseModel):
    meta: Optional[GetTimeSeriesAvgPrice200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesAvgPrice200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetBalanceSheet200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the balance sheet according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Exchange timezone", examples=["America/New_York"]
    )
    period: Optional[str] = Field(
        None, description="Values can be annual or quarterly", examples=["Quarterly"]
    )


class GetBalanceSheet200ResponseBalanceSheetInnerAssetsCurrentAssets(BaseModel):
    cash: Optional[float] = Field(
        None,
        description="Cash includes currency, bank accounts, and undeposited checks",
        examples=[17305000000],
    )
    cash_equivalents: Optional[float] = Field(
        None,
        description="Represents cash equivalents that have high credit quality and are highly liquid",
        examples=[17635000000],
    )
    cash_and_cash_equivalents: Optional[float] = Field(
        None,
        description="Combined value of cash and cash equivalents when company doesn't report a breakdown",
        examples=[34940000000],
    )
    other_short_term_investments: Optional[float] = Field(
        None,
        description="Represents other short term investments",
        examples=[27699000000],
    )
    accounts_receivable: Optional[float] = Field(
        None,
        description="Represents the balance of money due to a firm for goods or services delivered or used but not yet paid for by customers",
        examples=[26278000000],
    )
    other_receivables: Optional[float] = Field(
        None, description="Represents other receivables", examples=[25228000000]
    )
    inventory: Optional[float] = Field(
        None,
        description="Represents the goods available for sale and raw materials used to produce goods available for sale",
        examples=[6580000000],
    )
    prepaid_assets: Optional[float] = Field(
        None,
        description="Represents expense that has already been paid for, but which has not yet been consumed",
        examples=[0],
    )
    restricted_cash: Optional[float] = Field(
        None,
        description="Represents money that is held for a specific purpose and thus not available to the company for immediate or general business use",
        examples=[0],
    )
    assets_held_for_sale: Optional[float] = Field(
        None, description="Represents assets which company plans to sell", examples=[0]
    )
    hedging_assets: Optional[float] = Field(
        None,
        description="Represents money that is spent on hedging assets",
        examples=[0],
    )
    other_current_assets: Optional[float] = Field(
        None, description="Represents other current assets", examples=[14111000000]
    )
    total_current_assets: Optional[float] = Field(
        None,
        description="All current assets values in a total",
        examples=[134836000000],
    )


class GetBalanceSheet200ResponseBalanceSheetInnerAssetsNonCurrentAssets(BaseModel):
    properties: Optional[float] = Field(
        None, description="Represents property owned", examples=[0]
    )
    land_and_improvements: Optional[float] = Field(
        None,
        description="Represents land and improvements owned",
        examples=[20041000000],
    )
    machinery_furniture_equipment: Optional[float] = Field(
        None,
        description="Represents office equipment, furniture, and vehicles owned",
        examples=[78659000000],
    )
    construction_in_progress: Optional[float] = Field(
        None,
        description="Represents the cost of construction work, which is not yet completed",
        examples=[0],
    )
    leases: Optional[float] = Field(
        None,
        description="Represents operating and financial leases",
        examples=[11023000000],
    )
    accumulated_depreciation: Optional[float] = Field(
        None,
        description="Represents the cumulative depreciation of an asset that has been recorded",
        examples=[-70283000000],
    )
    goodwill: Optional[float] = Field(
        None,
        description="Represents the value of a brand name, solid customer base, good customer relations, good employee relations, and proprietary technology",
        examples=[0],
    )
    investment_properties: Optional[float] = Field(
        None,
        description="Represents real estate property purchased with the intention of earning a return on the investment",
        examples=[0],
    )
    financial_assets: Optional[float] = Field(
        None,
        description="Represents liquid asset that gets its value from a contractual right or ownership claim",
        examples=[0],
    )
    intangible_assets: Optional[float] = Field(
        None,
        description="Represents the patents, trademarks, and other intellectual properties",
        examples=[0],
    )
    investments_and_advances: Optional[float] = Field(
        None,
        description="Represents available for sale financial securities",
        examples=[127877000000],
    )
    other_non_current_assets: Optional[float] = Field(
        None, description="Represents other long-term assets", examples=[48849000000]
    )
    total_non_current_assets: Optional[float] = Field(
        None,
        description="All long-term assets values in total",
        examples=[216166000000],
    )


class GetBalanceSheet200ResponseBalanceSheetInnerAssets(BaseModel):
    current_assets: Optional[
        GetBalanceSheet200ResponseBalanceSheetInnerAssetsCurrentAssets
    ] = None
    non_current_assets: Optional[
        GetBalanceSheet200ResponseBalanceSheetInnerAssetsNonCurrentAssets
    ] = None
    total_assets: Optional[float] = Field(
        None,
        description="The sum of total_current_assets + total_non_current_assets",
        examples=[351002000000],
    )


class GetBalanceSheet200ResponseBalanceSheetInnerLiabilitiesCurrentLiabilities(
    BaseModel
):
    accounts_payable: Optional[float] = Field(
        None,
        description="Refers to an account within the general ledger that represents an obligation to pay off a short-term debt to creditors or suppliers",
        examples=[54763000000],
    )
    accrued_expenses: Optional[float] = Field(
        None,
        description="Represents payments that a company is obligated to pay in the future for which goods and services have already been delivered",
        examples=[0],
    )
    short_term_debt: Optional[float] = Field(
        None,
        description="Represents current debt and capital lease obligations",
        examples=[15613000000],
    )
    deferred_revenue: Optional[float] = Field(
        None,
        description="Represents advance payments a company receives for products or services that are to be delivered or performed in the future",
        examples=[7612000000],
    )
    tax_payable: Optional[float] = Field(
        None,
        description="Represents taxes due to the government within one year",
        examples=[0],
    )
    pensions: Optional[float] = Field(
        None, description="Represents to pensions to be paid out", examples=[0]
    )
    other_current_liabilities: Optional[float] = Field(
        None, description="Represents other current liabilities", examples=[47493000000]
    )
    total_current_liabilities: Optional[float] = Field(
        None,
        description="Represents total current liabilities",
        examples=[125481000000],
    )


class GetBalanceSheet200ResponseBalanceSheetInnerLiabilitiesNonCurrentLiabilities(
    BaseModel
):
    long_term_provisions: Optional[float] = Field(
        None,
        description="Represents money set aside for employee benefits such as gratuity",
        examples=[0],
    )
    long_term_debt: Optional[float] = Field(
        None,
        description="Represents amount of outstanding debt that has a maturity of 12 months or longer",
        examples=[109106000000],
    )
    provision_for_risks_and_charges: Optional[float] = Field(
        None,
        description="Represents funds set aside as assets to pay for anticipated future losses",
        examples=[24689000000],
    )
    deferred_liabilities: Optional[float] = Field(
        None,
        description="Represents revenue producing activity for which revenue has not yet been recognized, and is not expected to be recognized in the next 12 months",
        examples=[0],
    )
    derivative_product_liabilities: Optional[float] = Field(
        None,
        description="Represents the value of derivative financial instruments that a company has issued",
        examples=[0],
    )
    other_non_current_liabilities: Optional[float] = Field(
        None,
        description="Represents other non-current liabilities",
        examples=[28636000000],
    )
    total_non_current_liabilities: Optional[float] = Field(
        None,
        description="Represents total non-current liabilities",
        examples=[162431000000],
    )


class GetBalanceSheet200ResponseBalanceSheetInnerLiabilities(BaseModel):
    current_liabilities: Optional[
        GetBalanceSheet200ResponseBalanceSheetInnerLiabilitiesCurrentLiabilities
    ] = None
    non_current_liabilities: Optional[
        GetBalanceSheet200ResponseBalanceSheetInnerLiabilitiesNonCurrentLiabilities
    ] = None
    total_liabilities: Optional[float] = Field(
        None,
        description="The sum of total_current_liabilities + total_non_current_liabilities",
        examples=[287912000000],
    )


class GetBalanceSheet200ResponseBalanceSheetInnerShareholdersEquity(BaseModel):
    common_stock: Optional[float] = Field(
        None,
        description="Represents net worth of investors shares, which is equal to the total_assets - total_liabilities",
        examples=[57365000000],
    )
    retained_earnings: Optional[float] = Field(
        None,
        description="Refers to the profits earned minus dividends paid",
        examples=[5562000000],
    )
    other_shareholders_equity: Optional[float] = Field(
        None,
        description="Represents other not affecting retained earnings gains and looses",
        examples=[163000000],
    )
    total_shareholders_equity: Optional[float] = Field(
        None,
        description="Represents the net worth of a company, which is the amount that would be returned to shareholders if a company's total assets were liquidated, and all of its debts were repaid",
        examples=[63090000000],
    )
    additional_paid_in_capital: Optional[float] = Field(
        None,
        description="Represents the additional paid-in capital, which is the amount shareholders have invested in a company above the par value of its stock",
    )
    treasury_stock: Optional[float] = Field(
        None,
        description="Represents the value of shares that have been repurchased by the company and are held in its treasury",
    )
    minority_interest: Optional[float] = Field(
        None,
        description="Represents the portion of shareholders' equity that is attributable to minority shareholders in a subsidiary company",
    )


class GetBalanceSheet200ResponseBalanceSheetInner(BaseModel):
    fiscal_date: Optional[str] = Field(
        None, description="Date of the balance sheet release", examples=["2021-09-30"]
    )
    year: Optional[int] = Field(None, description="Fiscal year", examples=[2022])
    assets: Optional[GetBalanceSheet200ResponseBalanceSheetInnerAssets] = None
    liabilities: Optional[GetBalanceSheet200ResponseBalanceSheetInnerLiabilities] = None
    shareholders_equity: Optional[
        GetBalanceSheet200ResponseBalanceSheetInnerShareholdersEquity
    ] = None


class GetBalanceSheet200Response(BaseModel):
    meta: Optional[GetBalanceSheet200ResponseMeta] = None
    balance_sheet: Optional[List[GetBalanceSheet200ResponseBalanceSheetInner]] = Field(
        None, description="Array of balance sheet records"
    )


class AdvancedRequestValue(BaseModel):
    url: Optional[str] = Field(
        None,
        description="Requested url",
        examples=[
            "/time_series?symbol=AAPL&interval=1min&apikey=demo&source=docs&outputsize=2"
        ],
    )


class Advanced200Response(BaseModel):
    code: Optional[int] = Field(None, description="HTTP status code", examples=[200])
    status: Optional[str] = Field(
        None, description="Status of the request", examples=["success"]
    )
    data: Optional[Dict[str, Dict[str, Any]]] = Field(
        None,
        description="Response data containing individual request results",
        examples=[
            {
                "req_1": {
                    "response": {
                        "meta": {
                            "currency": "USD",
                            "exchange": "NASDAQ",
                            "exchange_timezone": "America/New_York",
                            "interval": "1min",
                            "mic_code": "XNGS",
                            "symbol": "AAPL",
                            "type": "Common Stock",
                        },
                        "status": "ok",
                        "values": [
                            {
                                "close": "248.6",
                                "datetime": "2025-02-21 12:51:00",
                                "high": "248.6",
                                "low": "248.4",
                                "open": "248.5",
                                "volume": "22290",
                            },
                            {
                                "close": "248.52",
                                "datetime": "2025-02-21 12:50:00",
                                "high": "248.59",
                                "low": "248.43",
                                "open": "248.52",
                                "volume": "64085",
                            },
                        ],
                    },
                    "status": "success",
                },
                "req_2": {
                    "response": {
                        "rate": 149.25999,
                        "symbol": "USD/JPY",
                        "timestamp": 1740160260,
                    },
                    "status": "success",
                },
                "req_3": {
                    "response": {
                        "amount": 18209.71933,
                        "rate": 149.25999,
                        "symbol": "USD/JPY",
                        "timestamp": 1740160260,
                    },
                    "status": "success",
                },
            }
        ],
    )


class GetTimeSeriesBBands200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["BBANDS - Bollinger Bands®"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[20]
    )
    sd: Optional[float] = Field(
        None, description="Number of standard deviations", examples=[2]
    )
    ma_type: Optional[str] = Field(
        None, description="Moving average type", examples=["SMA"]
    )


class GetTimeSeriesBBands200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesBBands200ResponseMetaIndicator] = None


class GetTimeSeriesBBands200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    upper_band: Optional[str] = Field(
        None, description="Upper band value", examples=["203.36511"]
    )
    middle_band: Optional[str] = Field(
        None, description="Middle band value", examples=["202.04999"]
    )
    lower_band: Optional[str] = Field(
        None, description="Lower band value", examples=["200.73486"]
    )


class GetTimeSeriesBBands200Response(BaseModel):
    meta: Optional[GetTimeSeriesBBands200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesBBands200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesBeta200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["BETA - Beta"]
    )
    series_type_1: Optional[str] = Field(
        None,
        description="Price type used as the first part of technical indicator",
        examples=["open"],
    )
    series_type_2: Optional[str] = Field(
        None,
        description="Price type used as the second part of technical indicator",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesBeta200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesBeta200ResponseMetaIndicator] = None


class GetTimeSeriesBeta200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    beta: Optional[str] = Field(None, description="Beta value", examples=["-0.05742"])


class GetTimeSeriesBeta200Response(BaseModel):
    meta: Optional[GetTimeSeriesBeta200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesBeta200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesBop200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["BOP - Balance of Power"],
    )


class GetTimeSeriesBop200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesBop200ResponseMetaIndicator] = None


class GetTimeSeriesBop200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    bop: Optional[str] = Field(None, description="Bop value", examples=["0.27231"])


class GetTimeSeriesBop200Response(BaseModel):
    meta: Optional[GetTimeSeriesBop200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesBop200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetCashFlow200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Symbol ticker of instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the cash flow data according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Exchange timezone", examples=["America/New_York"]
    )
    period: Optional[str] = Field(
        None,
        description="Period of the cash flow data (Annual or Quarterly)",
        examples=["Quarterly"],
    )


class GetTimeSeriesCci200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["CCI - Commodity Channel Index"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[20]
    )


class GetTimeSeriesCci200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesCci200ResponseMetaIndicator] = None


class GetTimeSeriesCci200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    cci: Optional[str] = Field(None, description="CCI value", examples=["-122.30794"])


class GetTimeSeriesCci200Response(BaseModel):
    meta: Optional[GetTimeSeriesCci200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesCci200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesCeil200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["CEIL - Vector CEIL"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesCeil200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesCeil200ResponseMetaIndicator] = None


class GetTimeSeriesCeil200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ceil: Optional[str] = Field(None, description="Ceil value", examples=["202.0"])


class GetTimeSeriesCeil200Response(BaseModel):
    meta: Optional[GetTimeSeriesCeil200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesCeil200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesCmo200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["CMO - Chande Momentum Oscillator"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesCmo200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesCmo200ResponseMetaIndicator] = None


class GetTimeSeriesCmo200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    cmo: Optional[str] = Field(None, description="CMO value", examples=["-71.24979"])


class GetTimeSeriesCmo200Response(BaseModel):
    meta: Optional[GetTimeSeriesCmo200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesCmo200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetCommodities200Response(BaseModel):
    data: Optional[List[CommoditiesResponseItem]] = Field(
        None, description="List of commodities"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesCoppock200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["COPPOCK - Coppock Curve"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    wma_period: Optional[int] = Field(
        None, description="Number of periods for weighted moving average", examples=[10]
    )
    long_roc_period: Optional[int] = Field(
        None,
        description="Number of periods for long term rate of change",
        examples=[14],
    )
    short_roc_period: Optional[int] = Field(
        None,
        description="Number of periods for short term rate of change",
        examples=[11],
    )


class GetTimeSeriesCoppock200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesCoppock200ResponseMetaIndicator] = None


class GetTimeSeriesCoppock200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    coppock: Optional[str] = Field(
        None, description="Coppock value", examples=["-1.37253"]
    )


class GetTimeSeriesCoppock200Response(BaseModel):
    meta: Optional[GetTimeSeriesCoppock200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesCoppock200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesCorrel200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["CORREL - Pearson's Correlation Coefficient"],
    )
    series_type_1: Optional[str] = Field(
        None,
        description="Price type used as the first part of technical indicator",
        examples=["open"],
    )
    series_type_2: Optional[str] = Field(
        None,
        description="Price type used as the second part of technical indicator",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesCorrel200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesCorrel200ResponseMetaIndicator] = None


class GetTimeSeriesCorrel200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    correl: Optional[str] = Field(
        None, description="Correl value", examples=["0.93282"]
    )


class GetTimeSeriesCorrel200Response(BaseModel):
    meta: Optional[GetTimeSeriesCorrel200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesCorrel200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetCountries200Response(BaseModel):
    data: List[CountryResponseItem] = Field(
        ...,
        description="List of countries with their ISO codes, names, capital, and currency",
    )


class GetCrossListings200Response(BaseModel):
    result: Optional[CrossListingsResult] = None


class GetTimeSeriesCrsi200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["CRSI - ConnorsRSI"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    rsi_period: Optional[int] = Field(
        None,
        description="Number of periods for RSI used to calculate price momentum",
        examples=[3],
    )
    up_down_length: Optional[int] = Field(
        None,
        description="Number of periods for RSI used to calculate up/down trend",
        examples=[2],
    )
    percent_rank_period: Optional[int] = Field(
        None,
        description="Number of periods used to calculate PercentRank",
        examples=[100],
    )


class GetTimeSeriesCrsi200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesCrsi200ResponseMetaIndicator] = None


class GetTimeSeriesCrsi200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    crsi: Optional[str] = Field(None, description="crsi value", examples=["74.76102"])


class GetTimeSeriesCrsi200Response(BaseModel):
    meta: Optional[GetTimeSeriesCrsi200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesCrsi200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetCryptocurrencies200Response(BaseModel):
    data: Optional[List[CryptocurrencyResponseItem]] = Field(
        None, description="List of cryptocurrencies"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetCryptocurrencyExchanges200Response(BaseModel):
    data: Optional[List[CryptocurrencyExchangesResponseItem]] = Field(
        None, description="List of cryptocurrency exchanges"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetCurrencyConversion200Response(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Requested currency symbol", examples=["USD/JPY"]
    )
    rate: Optional[float] = Field(
        None,
        description="Real-time exchange rate for the corresponding symbol",
        examples=[105.12],
    )
    amount: Optional[float] = Field(
        None, description="Amount of converted currency", examples=[12824.64]
    )
    timestamp: Optional[int] = Field(
        None, description="Unix timestamp of the rate", examples=[1602714051]
    )


class GetTimeSeriesDema200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["DEMA - Double Exponential Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesDema200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesDema200ResponseMetaIndicator] = None


class GetTimeSeriesDema200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    dema: Optional[str] = Field(None, description="Dema value", examples=["200.93371"])


class GetTimeSeriesDema200Response(BaseModel):
    meta: Optional[GetTimeSeriesDema200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesDema200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetDirectHolders200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of symbol", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the instrument according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Timezone of the exchange", examples=["America/New_York"]
    )


class GetDirectHolders200Response(BaseModel):
    meta: Optional[GetDirectHolders200ResponseMeta] = None
    direct_holders: Optional[List[HolderItem]] = Field(
        None, description="List of direct holders for the financial instrument"
    )


class GetTimeSeriesDiv200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["DIV - Arithmetic Division"],
    )
    series_type_1: Optional[str] = Field(
        None,
        description="Price type used as the first part of technical indicator",
        examples=["open"],
    )
    series_type_2: Optional[str] = Field(
        None,
        description="Price type used as the second part of technical indicator",
        examples=["close"],
    )


class GetTimeSeriesDiv200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesDiv200ResponseMetaIndicator] = None


class GetTimeSeriesDiv200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    div: Optional[str] = Field(None, description="Div value", examples=["1.00201"])


class GetTimeSeriesDiv200Response(BaseModel):
    meta: Optional[GetTimeSeriesDiv200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesDiv200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetDividends200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of symbol", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None, description="Currency in which instrument is traded", examples=["USD"]
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Timezone of the exchange", examples=["America/New_York"]
    )


class GetDividends200ResponseDividendsInner(BaseModel):
    ex_date: Optional[str] = Field(
        None, description="Stands for the ex date", examples=["2021-08-06"]
    )
    amount: Optional[float] = Field(
        None, description="Stands for the payment amount", examples=[0.22]
    )


class GetDividends200Response(BaseModel):
    meta: Optional[GetDividends200ResponseMeta] = None
    dividends: Optional[List[GetDividends200ResponseDividendsInner]] = Field(
        None, description="List of dividends"
    )


class GetTimeSeriesDpo200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["DPO - Detrended Price Oscillator"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[21]
    )
    centered: Optional[bool] = Field(
        None,
        description="Specifies if there should be a shift to match the current price",
        examples=[False],
    )


class GetTimeSeriesDpo200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesDpo200ResponseMetaIndicator] = None


class GetTimeSeriesDpo200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-04-01"],
    )
    dpo: Optional[str] = Field(None, description="DPO value", examples=["-7.99619"])


class GetTimeSeriesDpo200Response(BaseModel):
    meta: Optional[GetTimeSeriesDpo200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesDpo200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesDx200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["DX - Directional Movement Index"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[14]
    )


class GetTimeSeriesDx200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesDx200ResponseMetaIndicator] = None


class GetTimeSeriesDx200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    dx: Optional[str] = Field(None, description="dx value", examples=["68.70803"])


class GetTimeSeriesDx200Response(BaseModel):
    meta: Optional[GetTimeSeriesDx200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesDx200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetEarliestTimestamp200Response(BaseModel):
    unix_time: Optional[int] = Field(
        None, description="Datetime converted to UNIX timestamp", examples=[345479400]
    )
    datetime: Optional[str] = Field(
        None,
        description="Earliest datetime, the format depends on interval",
        examples=["1980-12-12"],
    )


class GetEarnings200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Symbol of the instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None, description="Currency in which the instrument is traded", examples=["USD"]
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where the instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Timezone of the exchange", examples=["America/New_York"]
    )


class GetEarnings200Response(BaseModel):
    meta: Optional[GetEarnings200ResponseMeta] = None
    earnings: Optional[List[EarningsItem]] = Field(
        None, description="List of earnings data"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetEarningsCalendar200ResponseEarningsValue(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Instrument symbol (ticker)", examples=["BR"]
    )
    name: Optional[str] = Field(
        None,
        description="Full name of instrument",
        examples=["Broadridge Financial Solutions Inc"],
    )
    currency: Optional[str] = Field(
        None,
        description="Currency in which instrument is traded by ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NYSE"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNYS"],
    )
    country: Optional[str] = Field(
        None,
        description="Country where exchange is located",
        examples=["United States"],
    )
    time: Optional[str] = Field(
        None,
        description="Can be either of the following values: `Pre Market`, `After Hours`, `Time Not Supplied`",
        examples=["Time Not Supplied"],
    )
    eps_estimate: Optional[float] = Field(
        None,
        description="Analyst estimate of the future company earning",
        examples=[1.72],
    )
    eps_actual: Optional[float] = Field(
        None, description="Actual value of reported earning", examples=[1.67]
    )
    difference: Optional[float] = Field(
        None,
        description="Delta between `eps_actual` and `eps_estimate`",
        examples=[-0.05],
    )
    surprise_prc: Optional[float] = Field(
        None,
        description="Surprise in percentage of the `eps_actual` related to `eps_estimate`",
        examples=[-2.9],
    )


class GetEarningsCalendar200Response(BaseModel):
    earnings: Optional[Dict[str, List[GetEarningsCalendar200ResponseEarningsValue]]] = Field(
        None, description="Map of dates to earnings data"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


GetEarningsEstimate200ResponseMeta = GetAnalystRatingsLight200ResponseMeta


class GetEarningsEstimate200ResponseEarningsEstimateInner(BaseModel):
    date: Optional[str] = Field(
        None, description="Date of the earnings estimate", examples=["2022-09-30"]
    )
    period: Optional[str] = Field(
        None,
        description="Period of estimation, can be `current_quarter`, `next_quarter`, `current_year`, or `next_year`",
        examples=["current_quarter"],
    )
    number_of_analysts: Optional[int] = Field(
        None, description="Number of analysts that made the estimation", examples=[27]
    )
    avg_estimate: Optional[float] = Field(
        None, description="Average estimation across analysts", examples=[1.26]
    )
    low_estimate: Optional[float] = Field(
        None, description="Lowest estimation given by an analyst", examples=[1.13]
    )
    high_estimate: Optional[float] = Field(
        None, description="Highest estimation given by an analyst", examples=[1.35]
    )
    year_ago_eps: Optional[float] = Field(
        None,
        description="Average estimation of this period's earnings given a year ago",
        examples=[1.24],
    )


class GetEarningsEstimate200Response(BaseModel):
    meta: Optional[GetEarningsEstimate200ResponseMeta] = None
    earnings_estimate: Optional[
        List[GetEarningsEstimate200ResponseEarningsEstimateInner]
    ] = Field(None, description="List of earnings estimates")
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetEdgarFilingsArchive200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker of the company", examples=["AAPL"]
    )
    exchange: Optional[str] = Field(
        None,
        description="Exchange name where the company is listed",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market Identifier Code (MIC) under ISO 10383 standard",
        examples=["XNGS"],
    )
    type: Optional[str] = Field(
        None, description="Issue type of the stock", examples=["Common Stock"]
    )


class GetEdgarFilingsArchive200Response(BaseModel):
    meta: Optional[GetEdgarFilingsArchive200ResponseMeta] = None
    values: Optional[List[EdgarFilingValue]] = Field(
        None, description="List of filings"
    )


class GetTimeSeriesEma200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["EMA - Exponential Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesEma200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesEma200ResponseMetaIndicator] = None


class GetTimeSeriesEma200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ema: Optional[str] = Field(None, description="EMA value", examples=["201.38109"])


class GetTimeSeriesEma200Response(BaseModel):
    meta: Optional[GetTimeSeriesEma200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesEma200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetEod200Response(BaseModel):
    symbol: Optional[str] = Field(None, description="Symbol passed", examples=["AAPL"])
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    currency: Optional[str] = Field(
        None,
        description="Currency in which instrument is denominated",
        examples=["USD"],
    )
    datetime: Optional[str] = Field(
        None,
        description="Datetime in defined timezone referring to when the bar with specified interval was opened",
        examples=["2021-09-16"],
    )
    close: Optional[str] = Field(
        None, description="The most recent end of day close price", examples=["148.79"]
    )


class GetEpsRevisions200ResponseEpsRevisionInner(BaseModel):
    date: Optional[str] = Field(
        None, description="Date of the EPS estimate", examples=["2022-09-30"]
    )
    period: Optional[str] = Field(
        None,
        description="Period of estimation, can be `current_quarter`, `next_quarter`, `current_year`, or `next_year`",
        examples=["current_quarter"],
    )
    up_last_week: Optional[int] = Field(
        None, description="Number of up revisions over the last 7 days", examples=[1]
    )
    up_last_month: Optional[int] = Field(
        None, description="Number of up revisions over the last 30 days", examples=[5]
    )
    down_last_week: Optional[int] = Field(
        None, description="Number of down revisions over the last 7 days", examples=[0]
    )
    down_last_month: Optional[int] = Field(
        None, description="Number of down revisions over the last 30 days", examples=[0]
    )


class GetEpsRevisions200Response(BaseModel):
    meta: Optional[GetEarningsEstimate200ResponseMeta] = None
    eps_revision: Optional[List[GetEpsRevisions200ResponseEpsRevisionInner]] = Field(
        None, description="EPS revision data"
    )
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetEpsTrend200ResponseEpsTrendInner(BaseModel):
    date: Optional[str] = Field(
        None, description="Date of the estimation", examples=["2022-09-30"]
    )
    period: Optional[str] = Field(
        None,
        description="Period of estimation, can be `current_quarter`, `next_quarter`, `current_year`, or `next_year`",
        examples=["current_quarter"],
    )
    current_estimate: Optional[float] = Field(
        None, description="Actual EPS estimation for the period", examples=[1.26]
    )
    field_7_days_ago: Optional[float] = Field(
        None,
        alias="7_days_ago",
        description="EPS estimation value 7 days ago",
        examples=[1.26],
    )
    field_30_days_ago: Optional[float] = Field(
        None,
        alias="30_days_ago",
        description="EPS estimation value 30 days ago",
        examples=[1.31],
    )
    field_60_days_ago: Optional[float] = Field(
        None,
        alias="60_days_ago",
        description="EPS estimation value 60 days ago",
        examples=[1.32],
    )
    field_90_days_ago: Optional[float] = Field(
        None,
        alias="90_days_ago",
        description="EPS estimation value 90 days ago",
        examples=[1.33],
    )


class GetEpsTrend200Response(BaseModel):
    meta: Optional[GetEarningsEstimate200ResponseMeta] = None
    eps_trend: Optional[List[GetEpsTrend200ResponseEpsTrendInner]] = Field(
        None, description="EPS trend data"
    )
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetETFsFamily200Response(BaseModel):
    result: Optional[Dict[str, List[str]]] = Field(
        None,
        description="List of ETFs by country",
        examples=[
            {
                "India": [
                    "Aberdeen Standard Fund Managers Limited",
                    "Aditya Birla Sun Life AMC Ltd",
                ],
                "United States": [
                    "Aegon Asset Management UK PLC",
                    "Ampega Investment GmbH",
                    "Aviva SpA",
                ],
            }
        ],
    )
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetETFsList200ResponseResult(BaseModel):
    count: Optional[int] = Field(
        None, description="Total number of matching funds", examples=[1000]
    )
    list: Optional[List[ETFsListResponseItem]] = Field(None, description="List of ETFs")


class GetETFsList200Response(BaseModel):
    result: Optional[GetETFsList200ResponseResult] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetETFsType200Response(BaseModel):
    result: Optional[Dict[str, List[str]]] = Field(
        None,
        description="List of ETFs by type",
        examples=[
            {
                "Singapore": ["Property - Indirect Asia", "Sector Equity Water"],
                "United States": [
                    "Asia-Pacific ex-Japan Equity",
                    "EUR Flexible Allocation - Global",
                ],
            }
        ],
    )
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetETFsWorld200ResponseEtfSummary(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="All available fund types segmented by country",
        examples=["IVV"],
    )
    name: Optional[str] = Field(
        None, description="Fund name", examples=["iShares Core S&P 500 ETF"]
    )
    fund_family: Optional[str] = Field(
        None,
        description="Investment company that manages the fund",
        examples=["iShares"],
    )
    fund_type: Optional[str] = Field(
        None, description="Type of the fund", examples=["Large Blend"]
    )
    currency: Optional[str] = Field(
        None, description="Currency of fund price", examples=["USD"]
    )
    share_class_inception_date: Optional[str] = Field(
        None,
        description="The date from which the fund started operations and the returns are calculated",
        examples=["2000-11-13"],
    )
    ytd_return: Optional[float] = Field(
        None,
        description="Percentage of profit of the fund since the first trading day of the current calendar year",
        examples=[-0.0537],
    )
    expense_ratio_net: Optional[float] = Field(
        None,
        description="Percentage of ETF assets steered toward a fund's operating expenses and fund management fees",
        examples=[-0.004],
    )
    yield_: Optional[float] = Field(
        None,
        alias="yield",
        description="Income returned to its investors through interest and dividends generated by the fund's investments",
        examples=[0.0133],
    )
    nav: Optional[float] = Field(
        None,
        description="Net Asset Value: fund value minus liabilities",
        examples=[413.24],
    )
    last_price: Optional[float] = Field(
        None, description="Last price of the fund", examples=[413.24]
    )
    turnover_rate: Optional[float] = Field(
        None,
        description="Percentage rate at which ETF replaces its holdings on investment every year",
        examples=[0.04],
    )
    net_assets: Optional[int] = Field(
        None,
        description="Total assets of a fund minus its total liabilities",
        examples=[753409982464],
    )
    overview: Optional[str] = Field(
        None,
        description="Description of the fund",
        examples=[
            "The investment seeks to track the performance of the Standard & Poor's 500..."
        ],
    )


class GetETFsWorld200ResponseEtfPerformanceTrailingReturnsInner(BaseModel):
    period: Optional[str] = Field(
        None, description="Period of trailing returns", examples=["ytd"]
    )
    share_class_return: Optional[float] = Field(
        None,
        description="Fund returns (%) generated over a given period",
        examples=[-0.0751],
    )
    category_return: Optional[float] = Field(
        None,
        description="Same category average returns (%) generated over a given period",
        examples=[0.1484],
    )


class GetETFsWorld200ResponseEtfPerformanceAnnualTotalReturnsInner(BaseModel):
    year: Optional[int] = Field(
        None, description="Year of total returns", examples=[2021]
    )
    share_class_return: Optional[float] = Field(
        None,
        description="Fund total returns (%) generated over a given year",
        examples=[0.2866],
    )
    category_return: Optional[float] = Field(
        None,
        description="Same category average total returns (%) generated over a given year",
        examples=[0],
    )


class GetETFsWorld200ResponseEtfPerformance(BaseModel):
    trailing_returns: Optional[
        List[GetETFsWorld200ResponseEtfPerformanceTrailingReturnsInner]
    ] = Field(
        None,
        description="Performance returns of the fund and its category over various trailing time periods",
    )
    annual_total_returns: Optional[
        List[GetETFsWorld200ResponseEtfPerformanceAnnualTotalReturnsInner]
    ] = Field(
        None, description="Fund and category total returns (%) for each calendar year"
    )


class GetETFsWorld200ResponseEtfRiskVolatilityMeasuresInner(BaseModel):
    period: Optional[str] = Field(
        None, description="Period of a measure", examples=["3_year"]
    )
    alpha: Optional[float] = Field(
        None, description="Alpha score of a fund", examples=[-0.03]
    )
    alpha_category: Optional[float] = Field(
        None, description="Average alpha score of a fund's category", examples=[-0.02]
    )
    beta: Optional[float] = Field(
        None, description="Beta score of a fund", examples=[1]
    )
    beta_category: Optional[float] = Field(
        None, description="Average beta score of a fund's category", examples=[0.01]
    )
    mean_annual_return: Optional[float] = Field(
        None, description="Mean annual return of a fund", examples=[1.58]
    )
    mean_annual_return_category: Optional[float] = Field(
        None,
        description="Average mean annual return of a fund's category",
        examples=[0.01],
    )
    r_squared: Optional[float] = Field(
        None, description="R-squared metric of a fund", examples=[100]
    )
    r_squared_category: Optional[float] = Field(
        None,
        description="Average r-squared metric of a fund's category",
        examples=[0.95],
    )
    std: Optional[float] = Field(
        None, description="Standard deviation of a fund", examples=[18.52]
    )
    std_category: Optional[float] = Field(
        None,
        description="Average standard deviation of a fund's category",
        examples=[0.19],
    )
    sharpe_ratio: Optional[float] = Field(
        None, description="Sharpe ratio of a fund", examples=[0.95]
    )
    sharpe_ratio_category: Optional[float] = Field(
        None, description="Average sharpe ratio of a fund's category", examples=[0.01]
    )
    treynor_ratio: Optional[float] = Field(
        None, description="Treynor ratio of a fund", examples=[17.41]
    )
    treynor_ratio_category: Optional[float] = Field(
        None, description="Average treynor ratio of a fund's category", examples=[0.16]
    )


class GetETFsWorld200ResponseEtfRiskValuationMetrics(BaseModel):
    price_to_earnings: Optional[float] = Field(
        None, description="Fund price to earnings metric", examples=[26.46]
    )
    price_to_book: Optional[float] = Field(
        None, description="Fund price to book metric", examples=[4.42]
    )
    price_to_sales: Optional[float] = Field(
        None, description="Fund price to sales metric", examples=[2.96]
    )
    price_to_cashflow: Optional[float] = Field(
        None, description="Fund price to cashflow metric", examples=[17.57]
    )


class GetETFsWorld200ResponseEtfRisk(BaseModel):
    volatility_measures: Optional[
        List[GetETFsWorld200ResponseEtfRiskVolatilityMeasuresInner]
    ] = Field(
        None,
        description="Risk and volatility statistics of the fund and its category over different periods",
    )
    valuation_metrics: Optional[GetETFsWorld200ResponseEtfRiskValuationMetrics] = None


class GetETFsWorld200ResponseEtfCompositionMajorMarketSectorsInner(BaseModel):
    sector: Optional[str] = Field(
        None, description="Sector category of a fund exposure", examples=["Technology"]
    )
    weight: Optional[float] = Field(
        None, description="Weight (%) of a fund exposure in a sector", examples=[0.2424]
    )


class GetETFsWorld200ResponseEtfCompositionCountryAllocationInner(BaseModel):
    country: Optional[str] = Field(
        None, description="Country name", examples=["United Kingdom"]
    )
    allocation: Optional[float] = Field(
        None,
        description="Percentages of a fund's net assets distributed to securities of the country",
        examples=[0.9855],
    )


class GetETFsWorld200ResponseEtfCompositionAssetAllocation(BaseModel):
    cash: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in cash",
        examples=[0.0004],
    )
    stocks: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in stocks",
        examples=[0.9996],
    )
    preferred_stocks: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in preferred stocks",
        examples=[0],
    )
    convertables: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in convertable securities",
        examples=[0],
    )
    bonds: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in bond",
        examples=[0],
    )
    others: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in other forms of holding",
        examples=[0],
    )


class GetETFsWorld200ResponseEtfCompositionTopHoldingsInner(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Symbol ticker of a holding instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of a holding instrument", examples=["Apple Inc"]
    )
    weight: Optional[float] = Field(
        None,
        description="Weight (%) of a holding instrument in overall portfolio composition",
        examples=[0.0592],
    )


class GetETFsWorld200ResponseEtfCompositionBondBreakdownAverageMaturity(BaseModel):
    fund: Optional[float] = Field(
        None, description="Average maturity of bond holding of a fund", examples=[6.65]
    )
    category: Optional[float] = Field(
        None,
        description="Average maturity of bond holding of funds in the same category",
        examples=[7.81],
    )


class GetETFsWorld200ResponseEtfCompositionBondBreakdownAverageDuration(BaseModel):
    fund: Optional[float] = Field(
        None, description="Average duration of bond holding of a fund", examples=[5.72]
    )
    category: Optional[float] = Field(
        None,
        description="Average duration of bond holding of funds in the same category",
        examples=[5.64],
    )


class GetETFsWorld200ResponseEtfCompositionBondBreakdownCreditQualityInner(BaseModel):
    grade: Optional[str] = Field(
        None,
        description="Rating of bond holding of a fund from AAA to below B",
        examples=["AAA"],
    )
    weight: Optional[float] = Field(
        None, description="Weight of bond holding in fund portfolio", examples=[0]
    )


class GetETFsWorld200ResponseEtfCompositionBondBreakdown(BaseModel):
    average_maturity: Optional[
        GetETFsWorld200ResponseEtfCompositionBondBreakdownAverageMaturity
    ] = None
    average_duration: Optional[
        GetETFsWorld200ResponseEtfCompositionBondBreakdownAverageDuration
    ] = None
    credit_quality: Optional[
        List[GetETFsWorld200ResponseEtfCompositionBondBreakdownCreditQualityInner]
    ] = Field(
        None,
        description="Breakdown of the fund’s bond holdings by credit rating and their respective portfolio weights",
    )


class GetETFsWorld200ResponseEtfComposition(BaseModel):
    major_market_sectors: Optional[
        List[GetETFsWorld200ResponseEtfCompositionMajorMarketSectorsInner]
    ] = Field(
        None,
        description="Breakdown of the fund’s portfolio by major industry sectors and their respective weights",
    )
    country_allocation: Optional[
        List[GetETFsWorld200ResponseEtfCompositionCountryAllocationInner]
    ] = Field(
        None,
        description="Breakdown of the fund’s portfolio by country and their respective weights",
    )
    asset_allocation: Optional[GetETFsWorld200ResponseEtfCompositionAssetAllocation] = (
        None
    )
    top_holdings: Optional[
        List[GetETFsWorld200ResponseEtfCompositionTopHoldingsInner]
    ] = Field(
        None,
        description="Top holdings of a fund with their respective weights in the overall portfolio composition",
    )
    bond_breakdown: Optional[GetETFsWorld200ResponseEtfCompositionBondBreakdown] = None


class GetETFsWorld200ResponseEtf(BaseModel):
    summary: Optional[GetETFsWorld200ResponseEtfSummary] = None
    performance: Optional[GetETFsWorld200ResponseEtfPerformance] = None
    risk: Optional[GetETFsWorld200ResponseEtfRisk] = None
    composition: Optional[GetETFsWorld200ResponseEtfComposition] = None


class GetETFsWorld200Response(BaseModel):
    etf: Optional[GetETFsWorld200ResponseEtf] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


GetETFsWorldComposition200ResponseEtfComposition = GetETFsWorld200ResponseEtfComposition


class GetETFsWorldComposition200ResponseEtf(BaseModel):
    composition: Optional[GetETFsWorldComposition200ResponseEtfComposition] = None


class GetETFsWorldComposition200Response(BaseModel):
    etf: Optional[GetETFsWorldComposition200ResponseEtf] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


GetETFsWorldPerformance200ResponseEtfPerformance = GetETFsWorld200ResponseEtfPerformance


class GetETFsWorldPerformance200ResponseEtf(BaseModel):
    performance: Optional[GetETFsWorldPerformance200ResponseEtfPerformance] = None


class GetETFsWorldPerformance200Response(BaseModel):
    etf: Optional[GetETFsWorldPerformance200ResponseEtf] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


GetETFsWorldRisk200ResponseEtfRisk = GetETFsWorld200ResponseEtfRisk


class GetETFsWorldRisk200ResponseEtf(BaseModel):
    risk: Optional[GetETFsWorldRisk200ResponseEtfRisk] = None


class GetETFsWorldRisk200Response(BaseModel):
    etf: Optional[GetETFsWorldRisk200ResponseEtf] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


GetETFsWorldSummary200ResponseEtfSummary = GetETFsWorld200ResponseEtfSummary


class GetETFsWorldSummary200ResponseEtf(BaseModel):
    summary: Optional[GetETFsWorldSummary200ResponseEtfSummary] = None


class GetETFsWorldSummary200Response(BaseModel):
    etf: Optional[GetETFsWorldSummary200ResponseEtf] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetExchangeRate200Response(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Requested currency symbol", examples=["USD/JPY"]
    )
    rate: Optional[float] = Field(
        None,
        description="Real-time exchange rate for the corresponding symbol",
        examples=[105.12],
    )
    timestamp: Optional[int] = Field(
        None, description="Unix timestamp of the rate", examples=[1602714051]
    )


class GetTimeSeriesExp200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["EXP - Exponential"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesExp200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesExp200ResponseMetaIndicator] = None


class GetTimeSeriesExp200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    exp: Optional[str] = Field(
        None, description="Exp value", examples=["2.0649375034375067e+87"]
    )


class GetTimeSeriesExp200Response(BaseModel):
    meta: Optional[GetTimeSeriesExp200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesExp200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesFloor200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["FLOOR - Vector FLOOR"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesFloor200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesFloor200ResponseMetaIndicator] = None


class GetTimeSeriesFloor200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    floor: Optional[str] = Field(None, description="Floor value", examples=["201.0"])


class GetTimeSeriesFloor200Response(BaseModel):
    meta: Optional[GetTimeSeriesFloor200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesFloor200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetForexPairs200Response(BaseModel):
    data: Optional[List[ForexResponseItem]] = Field(
        None, description="List of forex pairs"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetFundHolders200Response(BaseModel):
    meta: Optional[GetDirectHolders200ResponseMeta] = None
    fund_holders: Optional[List[HolderItem]] = Field(
        None, description="List of fund holders for the financial instrument"
    )


class GetGrowthEstimates200ResponseGrowthEstimates(BaseModel):
    current_quarter: Optional[float] = Field(
        None,
        description="Projected growth of the current quarter in percentage (%)",
        examples=[0.016],
    )
    next_quarter: Optional[float] = Field(
        None,
        description="Projected growth of the next quarter in percentage (%)",
        examples=[0.01],
    )
    current_year: Optional[float] = Field(
        None,
        description="Projected growth of the current year in percentage (%)",
        examples=[0.087],
    )
    next_year: Optional[float] = Field(
        None,
        description="Projected growth of the next year in percentage (%)",
        examples=[0.055999998],
    )
    next_5_years_pa: Optional[float] = Field(
        None,
        description="Projected growth during the next 5 years in percentage (%) per annum",
        examples=[0.094799995],
    )
    past_5_years_pa: Optional[float] = Field(
        None,
        description="Actual growth over the last 5 years in percentage (%) per annum",
        examples=[0.23867],
    )


class GetGrowthEstimates200Response(BaseModel):
    meta: Optional[GetEarningsEstimate200ResponseMeta] = None
    growth_estimates: Optional[GetGrowthEstimates200ResponseGrowthEstimates] = None
    status: Optional[str] = Field(
        None, description="Status of the request", examples=["ok"]
    )


class GetTimeSeriesHeikinashiCandles200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["HEIKINASHICANDLES - Heikin-Ashi Candles"],
    )


class GetTimeSeriesHeikinashiCandles200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesHeikinashiCandles200ResponseMetaIndicator] = None


class GetTimeSeriesHeikinashiCandles200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    heikinhighs: Optional[str] = Field(
        None, description="Heikin-Ashi highs value", examples=["201.25599"]
    )
    heikinopens: Optional[str] = Field(
        None, description="Heikin-Ashi opens value", examples=["200.9825"]
    )
    heikincloses: Optional[str] = Field(
        None, description="Heikin-Ashi closes value", examples=["201.02449"]
    )
    heikinlows: Optional[str] = Field(
        None, description="Heikin-Ashi lows value", examples=["200.85199"]
    )


class GetTimeSeriesHeikinashiCandles200Response(BaseModel):
    meta: Optional[GetTimeSeriesHeikinashiCandles200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesHeikinashiCandles200ResponseValuesInner]] = (
        Field(None, description="Array of time series data points")
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesHlc3200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["HLC3 - High, Low, Close Average Values"],
    )


class GetTimeSeriesHlc3200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesHlc3200ResponseMetaIndicator] = None


class GetTimeSeriesHlc3200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    hlc3: Optional[str] = Field(None, description="hlc3 value", examples=["201.05266"])


class GetTimeSeriesHlc3200Response(BaseModel):
    meta: Optional[GetTimeSeriesHlc3200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesHlc3200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesHtDcPeriod200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["HT_DCPERIOD - Hilbert Transform Dominant Cycle Period"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesHtDcPeriod200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesHtDcPeriod200ResponseMetaIndicator] = None


class GetTimeSeriesHtDcPeriod200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ht_dcperiod: Optional[str] = Field(
        None, description="ht_dcperiod value", examples=["28.12565"]
    )


class GetTimeSeriesHtDcPeriod200Response(BaseModel):
    meta: Optional[GetTimeSeriesHtDcPeriod200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesHtDcPeriod200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesHtDcPhase200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["HT_DCPHASE - Hilbert Transform Dominant Cycle Phase"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesHtDcPhase200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesHtDcPhase200ResponseMetaIndicator] = None


class GetTimeSeriesHtDcPhase200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ht_dcphase: Optional[str] = Field(
        None, description="HT_DCPHASE value", examples=["-38.50975"]
    )


class GetTimeSeriesHtDcPhase200Response(BaseModel):
    meta: Optional[GetTimeSeriesHtDcPhase200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesHtDcPhase200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesHtPhasor200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["HT_PHASOR - Hilbert Transform Phasor Components"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesHtPhasor200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesHtPhasor200ResponseMetaIndicator] = None


class GetTimeSeriesHtPhasor200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    in_phase: Optional[str] = Field(
        None, description="In_phase value", examples=["-0.56826"]
    )
    quadrature: Optional[str] = Field(
        None, description="Quadrature value", examples=["-0.43318"]
    )


class GetTimeSeriesHtPhasor200Response(BaseModel):
    meta: Optional[GetTimeSeriesHtPhasor200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesHtPhasor200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesHtSine200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["HT_SINE - Hilbert Transform SineWave"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesHtSine200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesHtSine200ResponseMetaIndicator] = None


class GetTimeSeriesHtSine200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ht_sine: Optional[str] = Field(
        None, description="ht_sine value", examples=["-0.62265"]
    )
    ht_leadsine: Optional[str] = Field(
        None, description="ht_leadsine value", examples=["0.11303"]
    )


class GetTimeSeriesHtSine200Response(BaseModel):
    meta: Optional[GetTimeSeriesHtSine200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesHtSine200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesHtTrendline200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["HT_TRENDLINE - Hilbert Transform Instantaneous Trendline"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesHtTrendline200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesHtTrendline200ResponseMetaIndicator] = None


class GetTimeSeriesHtTrendline200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ht_trendline: Optional[str] = Field(
        None, description="HT_TRENDLINE value", examples=["202.26597"]
    )


class GetTimeSeriesHtTrendline200Response(BaseModel):
    meta: Optional[GetTimeSeriesHtTrendline200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesHtTrendline200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesHtTrendMode200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["HT_TRENDMODE - Hilbert Transform Trend vs Cycle Mode"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesHtTrendMode200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesHtTrendMode200ResponseMetaIndicator] = None


class GetTimeSeriesHtTrendMode200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ht_trendmode: Optional[str] = Field(
        None, description="ht_trendmode value", examples=["0"]
    )


class GetTimeSeriesHtTrendMode200Response(BaseModel):
    meta: Optional[GetTimeSeriesHtTrendMode200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesHtTrendMode200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesIchimoku200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ICHIMOKU - Ichimoku Kinkō Hyō"],
    )
    conversion_line_period: Optional[int] = Field(
        None,
        description="The time period used for generating the conversation line",
        examples=[9],
    )
    base_line_period: Optional[int] = Field(
        None,
        description="The time period used for generating the base line",
        examples=[26],
    )
    leading_span_b_period: Optional[int] = Field(
        None,
        description="The time period used for generating the leading span B line",
        examples=[52],
    )
    lagging_span_period: Optional[int] = Field(
        None,
        description="The time period used for generating the lagging span line",
        examples=[26],
    )
    include_ahead_span_period: Optional[bool] = Field(
        None,
        description="Indicates whether to include ahead span period",
        examples=[True],
    )


class GetTimeSeriesIchimoku200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesIchimoku200ResponseMetaIndicator] = None


class GetTimeSeriesIchimoku200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    tenkan_sen: Optional[str] = Field(
        None, description="Tenkan-sen value", examples=["200.33"]
    )
    kijun_sen: Optional[str] = Field(
        None, description="Kijun-sen value", examples=["201.42"]
    )
    senkou_span_a: Optional[str] = Field(
        None, description="Senkou span A value", examples=["201.49"]
    )
    senkou_span_b: Optional[str] = Field(
        None, description="Senkou span B value", examples=["200.35501"]
    )
    chikou_span: Optional[str] = Field(
        None, description="Chikou span value", examples=["199.95499"]
    )


class GetTimeSeriesIchimoku200Response(BaseModel):
    meta: Optional[GetTimeSeriesIchimoku200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesIchimoku200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetIncomeStatement200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Symbol ticker of the instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the instrument according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where the instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Exchange timezone", examples=["America/New_York"]
    )
    period: Optional[str] = Field(
        None,
        description="Period of the income statement (Annual or Quarterly)",
        examples=["Quarterly"],
    )


class GetInsiderTransactions200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the instrument according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Timezone of the exchange", examples=["America/New_York"]
    )


class GetInsiderTransactions200ResponseInsiderTransactionsInner(BaseModel):
    full_name: Optional[str] = Field(
        None,
        description="Full name of an individual, including first name, middle name, last name, and suffix",
        examples=["ADAMS KATHERINE L"],
    )
    position: Optional[str] = Field(
        None, description="Job position of insider", examples=["General Counsel"]
    )
    date_reported: Optional[str] = Field(
        None, description="Date the transaction was reported", examples=["2021-05-03"]
    )
    is_direct: Optional[bool] = Field(
        None, description="`true` if direct, `false` if indirect", examples=[True]
    )
    shares: Optional[int] = Field(
        None,
        description="As per report the number of shares acquired or disposed of the transaction",
        examples=[17000],
    )
    value: Optional[int] = Field(
        None,
        description="Represents the value of transaction, calculated as price multiplied by the volume",
        examples=[2257631],
    )
    description: Optional[str] = Field(
        None,
        description="Exact price or price range of the transaction if available",
        examples=["Sale at price 132.57 - 133.93 per share."],
    )


class GetInsiderTransactions200Response(BaseModel):
    meta: Optional[GetInsiderTransactions200ResponseMeta] = None
    insider_transactions: Optional[
        List[GetInsiderTransactions200ResponseInsiderTransactionsInner]
    ] = Field(None, description="List of insider transactions")


class GetInstitutionalHolders200Response(BaseModel):
    meta: Optional[GetDirectHolders200ResponseMeta] = None
    institutional_holders: Optional[List[HolderItem]] = Field(
        None, description="List of institutional holders for the financial instrument"
    )


class GetInstrumentType200Response(BaseModel):
    result: Optional[List[str]] = Field(
        None,
        description="List of instrument types available at Twelve Data API.",
        examples=[
            [
                "Agricultural Product",
                "American Depositary Receipt",
                "Bond",
                "Bond Fund",
                "Closed-end Fund",
                "Common Stock",
                "Depositary Receipt",
                "Digital Currency",
                "Energy Resource",
                "ETF",
                "Exchange-Traded Note",
                "Global Depositary Receipt",
                "Index",
                "Industrial Metal",
                "Limited Partnership",
                "Livestock",
                "Mutual Fund",
                "Physical Currency",
                "Precious Metal",
                "Preferred Stock",
                "REIT",
                "Right",
                "Structured Product",
                "Trust",
                "Unit",
                "Warrant",
            ]
        ],
    )
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetIntervals200Response(BaseModel):
    data: Optional[List[str]] = Field(
        None,
        description="List of available intervals",
        examples=[
            [
                "1min",
                "5min",
                "15min",
                "30min",
                "45min",
                "1h",
                "2h",
                "4h",
                "8h",
                "1day",
                "1week",
                "1month",
            ]
        ],
    )
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetIpoCalendar200ResponseValueInner(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker of the company", examples=["DWACU"]
    )
    name: Optional[str] = Field(
        None,
        description="Name of the company",
        examples=["Digital World Acquisition Corp."],
    )
    exchange: Optional[str] = Field(
        None,
        description="Exchange name where the company is listed",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market Identifier Code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    price_range_low: Optional[float] = Field(
        None,
        description="The lower bound of stock price range if available",
        examples=[10],
    )
    price_range_high: Optional[float] = Field(
        None,
        description="The upper bound of stock price range if available",
        examples=[10],
    )
    offer_price: Optional[float] = Field(
        None, description="Initial offer price if available", examples=[0]
    )
    currency: Optional[str] = Field(
        None, description="Currency of the stock", examples=["USD"]
    )
    shares: Optional[int] = Field(
        None, description="Number of shares, if available", examples=[0]
    )


class GetTimeSeriesKama200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["KAMA - Kaufman's Adaptive Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesKama200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesKama200ResponseMetaIndicator] = None


class GetTimeSeriesKama200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    kama: Optional[str] = Field(None, description="Kama value", examples=["201.06741"])


class GetTimeSeriesKama200Response(BaseModel):
    meta: Optional[GetTimeSeriesKama200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesKama200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesKeltner200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["KELTNER - Keltner Channels"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[20]
    )
    atr_time_period: Optional[int] = Field(
        None,
        description="The time period used for calculating the Average True Range",
        examples=[10],
    )
    multiplier: Optional[int] = Field(
        None,
        description="The factor used to adjust the indicator's sensitivity",
        examples=[2],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    ma_type: Optional[str] = Field(
        None, description="The type of moving average used", examples=["SMA"]
    )


class GetTimeSeriesKeltner200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesKeltner200ResponseMetaIndicator] = None


class GetTimeSeriesKeltner200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    upper_line: Optional[str] = Field(
        None, description="Upper line value", examples=["202.25298"]
    )
    middle_line: Optional[str] = Field(
        None, description="Middle line value", examples=["201.80985"]
    )
    lower_line: Optional[str] = Field(
        None, description="Lower line value", examples=["201.36672"]
    )


class GetTimeSeriesKeltner200Response(BaseModel):
    meta: Optional[GetTimeSeriesKeltner200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesKeltner200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetKeyExecutives200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency code in which the instrument is denominated",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Timezone of the exchange", examples=["America/New_York"]
    )


class GetKeyExecutives200ResponseKeyExecutivesInner(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Full name of an executive, including first name, middle name, last name, and suffix",
        examples=["Mr. Timothy D. Cook"],
    )
    title: Optional[str] = Field(
        None, description="Refers to job title", examples=["CEO & Director"]
    )
    age: Optional[int] = Field(
        None, description="Current age of an executive if available", examples=[59]
    )
    year_born: Optional[int] = Field(
        None, description="Year of birth of an executive if available", examples=[1961]
    )
    pay: Optional[int] = Field(
        None,
        description="Total salary of an executive if available",
        examples=[14769259],
    )


class GetKeyExecutives200Response(BaseModel):
    meta: Optional[GetKeyExecutives200ResponseMeta] = None
    key_executives: Optional[List[GetKeyExecutives200ResponseKeyExecutivesInner]] = (
        Field(None, description="List of key executives")
    )


class GetTimeSeriesKst200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["KST - Know Sure Thing"],
    )
    roc_period_1: Optional[int] = Field(
        None,
        description="The time period for the first Rate of Change calculation",
        examples=[10],
    )
    roc_period_2: Optional[int] = Field(
        None,
        description="The time period for the second Rate of Change calculation",
        examples=[15],
    )
    roc_period_3: Optional[int] = Field(
        None,
        description="The time period for the third Rate of Change calculation",
        examples=[20],
    )
    roc_period_4: Optional[int] = Field(
        None,
        description="The time period for the forth Rate of Change calculation",
        examples=[30],
    )
    sma_period_1: Optional[int] = Field(
        None,
        description="The time period for the first Simple Moving Average",
        examples=[10],
    )
    sma_period_2: Optional[int] = Field(
        None,
        description="The time period for the second Simple Moving Average",
        examples=[10],
    )
    sma_period_3: Optional[int] = Field(
        None,
        description="The time period for the third Simple Moving Average",
        examples=[10],
    )
    sma_period_4: Optional[int] = Field(
        None,
        description="The time period for the forth Simple Moving Average",
        examples=[15],
    )
    signal_period: Optional[int] = Field(
        None,
        description="The time period used for generating the signal line",
        examples=[9],
    )


class GetTimeSeriesKst200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesKst200ResponseMetaIndicator] = None


class GetTimeSeriesKst200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    kst: Optional[str] = Field(None, description="KST value", examples=["-4.58644"])
    kst_signal: Optional[str] = Field(
        None, description="KST signal value", examples=["-2.05236"]
    )


class GetTimeSeriesKst200Response(BaseModel):
    meta: Optional[GetTimeSeriesKst200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesKst200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetLastChanges200ResponsePagination(BaseModel):
    current_page: Optional[int] = Field(
        None, description="Current page number", examples=[1]
    )
    per_page: Optional[int] = Field(None, description="Records per page", examples=[30])


class GetLastChanges200Response(BaseModel):
    pagination: Optional[GetLastChanges200ResponsePagination] = None
    data: Optional[List[LastChangeResponseItem]] = Field(
        None, description="Data contains the list of last changes"
    )


class GetTimeSeriesLinearReg200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["LINEARREG - Linear Regression"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesLinearReg200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesLinearReg200ResponseMetaIndicator] = None


class GetTimeSeriesLinearReg200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    linearreg: Optional[str] = Field(
        None, description="linearreg value", examples=["200.79327"]
    )


class GetTimeSeriesLinearReg200Response(BaseModel):
    meta: Optional[GetTimeSeriesLinearReg200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesLinearReg200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesLinearRegAngle200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["LINEARREGANGLE - Linear Regression Angle"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesLinearRegAngle200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesLinearRegAngle200ResponseMetaIndicator] = None


class GetTimeSeriesLinearRegAngle200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    linearregangle: Optional[str] = Field(
        None, description="Linear regression angle value", examples=["-8.79357"]
    )


class GetTimeSeriesLinearRegAngle200Response(BaseModel):
    meta: Optional[GetTimeSeriesLinearRegAngle200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesLinearRegAngle200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesLinearRegIntercept200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["LINEARREGINTERCEPT - Linear Regression Intercept"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesLinearRegIntercept200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesLinearRegIntercept200ResponseMetaIndicator] = None


class GetTimeSeriesLinearRegIntercept200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    linearregintercept: Optional[str] = Field(
        None, description="Linear Regression Intercept value", examples=["202.03082"]
    )


class GetTimeSeriesLinearRegIntercept200Response(BaseModel):
    meta: Optional[GetTimeSeriesLinearRegIntercept200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesLinearRegIntercept200ResponseValuesInner]] = (
        Field(None, description="Array of time series data points")
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesLinearRegSlope200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["LINEARREGSLOPE - Linear Regression Slope"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesLinearRegSlope200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesLinearRegSlope200ResponseMetaIndicator] = None


class GetTimeSeriesLinearRegSlope200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    linearregslope: Optional[str] = Field(
        None, description="linearregslope value", examples=["-0.15469"]
    )


class GetTimeSeriesLinearRegSlope200Response(BaseModel):
    meta: Optional[GetTimeSeriesLinearRegSlope200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesLinearRegSlope200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesLn200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["LN - Natural Logarithm to the base of constant e"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesLn200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesLn200ResponseMetaIndicator] = None


class GetTimeSeriesLn200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ln: Optional[str] = Field(
        None, description="Natural logarithm value", examples=["5.30355"]
    )


class GetTimeSeriesLn200Response(BaseModel):
    meta: Optional[GetTimeSeriesLn200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesLn200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesLog10200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["LOG10 - Logarithm to base 10"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesLog10200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesLog10200ResponseMetaIndicator] = None


class GetTimeSeriesLog10200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    log10: Optional[str] = Field(None, description="Log10 value", examples=["2.3033"])


class GetTimeSeriesLog10200Response(BaseModel):
    meta: Optional[GetTimeSeriesLog10200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesLog10200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetLogo200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="The ticker symbol of an instrument", examples=["AAPL"]
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange where the instrument is traded (for `crypto` only)",
        examples=["NASDAQ"],
    )


class GetLogo200Response(BaseModel):
    meta: Optional[GetLogo200ResponseMeta] = None
    url: Optional[str] = Field(
        None,
        description="Link to download the logo (for stocks only)",
        examples=["https://api.twelvedata.com/logo/apple.com"],
    )
    logo_base: Optional[str] = Field(
        None,
        description="Link to download the base currency logo (for `forex` and `crypto` only)",
        examples=["https://logo.twelvedata.com/forex/eur.png"],
    )
    logo_quote: Optional[str] = Field(
        None,
        description="Link to download the quote currency logo (for `forex` and `crypto` only)",
        examples=["https://logo.twelvedata.com/forex/usd.png"],
    )


class GetTimeSeriesMa200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MA - Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )
    ma_type: Optional[str] = Field(
        None, description="The type of moving average used", examples=["SMA"]
    )


class GetTimeSeriesMa200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMa200ResponseMetaIndicator] = None


class GetTimeSeriesMa200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ma: Optional[str] = Field(None, description="MA value", examples=["201.41205"])


class GetTimeSeriesMa200Response(BaseModel):
    meta: Optional[GetTimeSeriesMa200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMa200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMacd200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MACD - Moving Average Convergence Divergence"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    fast_period: Optional[int] = Field(
        None, description="Fast period value", examples=[12]
    )
    slow_period: Optional[int] = Field(
        None, description="Slow period value", examples=[26]
    )
    signal_period: Optional[int] = Field(
        None, description="Signal period value", examples=[9]
    )


class GetTimeSeriesMacd200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMacd200ResponseMetaIndicator] = None


class GetTimeSeriesMacd200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    macd: Optional[str] = Field(None, description="MACD value", examples=["-0.3998"])
    macd_signal: Optional[str] = Field(
        None, description="MACD signal line value", examples=["-0.25279"]
    )
    macd_hist: Optional[str] = Field(
        None, description="MACD histogram value", examples=["-0.147"]
    )


class GetTimeSeriesMacd200Response(BaseModel):
    meta: Optional[GetTimeSeriesMacd200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMacd200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMacdSlope200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=[
            "MACD_SLOPE - Moving Average Convergence Divergence Regression Slope"
        ],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    fast_period: Optional[int] = Field(
        None, description="The shorter time period for calculation", examples=[12]
    )
    slow_period: Optional[int] = Field(
        None, description="The longer time period for calculation", examples=[26]
    )
    signal_period: Optional[int] = Field(
        None,
        description="The time period used for generating the signal line",
        examples=[9],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesMacdSlope200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMacdSlope200ResponseMetaIndicator] = None


class GetTimeSeriesMacdSlope200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    macd_slope: Optional[str] = Field(
        None, description="MACD slope value", examples=["0.13358"]
    )
    macd_signal_slope: Optional[str] = Field(
        None, description="MACD signal slope value", examples=["0.05345"]
    )
    macd_hist_slope: Optional[str] = Field(
        None, description="MACD histogram slope value", examples=["0.08013"]
    )


class GetTimeSeriesMacdSlope200Response(BaseModel):
    meta: Optional[GetTimeSeriesMacdSlope200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMacdSlope200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMacdExt200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MACDEXT - Moving Average Convergence Divergence Extended"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    fast_period: Optional[int] = Field(
        None, description="The shorter time period for calculation", examples=[12]
    )
    fast_ma_type: Optional[str] = Field(
        None,
        description="The type of fast moving average used in the calculation",
        examples=["SMA"],
    )
    slow_period: Optional[int] = Field(
        None, description="The longer time period for calculation", examples=[26]
    )
    slow_ma_type: Optional[str] = Field(
        None,
        description="The type of slow moving average used in the calculation",
        examples=["SMA"],
    )
    signal_period: Optional[int] = Field(
        None,
        description="The time period used for generating the signal line",
        examples=[9],
    )
    signal_ma_type: Optional[str] = Field(
        None,
        description="The type of moving average used for generating the signal line",
        examples=["SMA"],
    )


class GetTimeSeriesMacdExt200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMacdExt200ResponseMetaIndicator] = None


class GetTimeSeriesMacdExt200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    macd: Optional[str] = Field(None, description="MACD value", examples=["-0.54508"])
    macd_signal: Optional[str] = Field(
        None, description="MACD signal line value", examples=["-0.25615"]
    )
    macd_hist: Optional[str] = Field(
        None, description="MACD histogram value", examples=["-0.28894"]
    )


class GetTimeSeriesMacdExt200Response(BaseModel):
    meta: Optional[GetTimeSeriesMacdExt200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMacdExt200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMama200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MAMA - MESA Adaptive Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    fast_limit: Optional[float] = Field(
        None, description="The limit for the fast moving average", examples=[0.5]
    )
    slow_limit: Optional[float] = Field(
        None, description="The limit for the slow moving average", examples=[0.05]
    )


class GetTimeSeriesMama200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMama200ResponseMetaIndicator] = None


class GetTimeSeriesMama200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    mama: Optional[str] = Field(None, description="MAMA value", examples=["201.38887"])
    fama: Optional[str] = Field(None, description="FAMA value", examples=["202.05517"])


class GetTimeSeriesMama200Response(BaseModel):
    meta: Optional[GetTimeSeriesMama200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMama200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetMarketCap200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker of the company", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency in which instrument is traded by ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None,
        description="Exchange name where the company is listed",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market Identifier Code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Exchange timezone", examples=["America/New_York"]
    )


class GetMarketCap200ResponseMarketCapInner(BaseModel):
    date: Optional[str] = Field(
        None, description="Market capitalization date", examples=["2021-08-06"]
    )
    value: Optional[int] = Field(
        None, description="Market capitalization value", examples=[10000000000]
    )


class GetMarketCap200Response(BaseModel):
    meta: Optional[GetMarketCap200ResponseMeta] = None
    market_cap: Optional[List[GetMarketCap200ResponseMarketCapInner]] = Field(
        None, description="Market capitalization values"
    )


class GetTimeSeriesMax200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MAX - Highest value over period"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesMax200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMax200ResponseMetaIndicator] = None


class GetTimeSeriesMax200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    max: Optional[str] = Field(None, description="Max value", examples=["202.05"])


class GetTimeSeriesMax200Response(BaseModel):
    meta: Optional[GetTimeSeriesMax200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMax200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMaxIndex200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MAXINDEX - Index of highest value over period"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesMaxIndex200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMaxIndex200ResponseMetaIndicator] = None


class GetTimeSeriesMaxIndex200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    maxidx: Optional[str] = Field(None, description="maxidx value", examples=["491"])


class GetTimeSeriesMaxIndex200Response(BaseModel):
    meta: Optional[GetTimeSeriesMaxIndex200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMaxIndex200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMcGinleyDynamic200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MCGINLEY_DYNAMIC - McGinley Dynamic"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[14]
    )


class GetTimeSeriesMcGinleyDynamic200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMcGinleyDynamic200ResponseMetaIndicator] = None


class GetTimeSeriesMcGinleyDynamic200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    mcginley_dynamic: Optional[str] = Field(
        None, description="McGinley Dynamic value", examples=["201.93983"]
    )


class GetTimeSeriesMcGinleyDynamic200Response(BaseModel):
    meta: Optional[GetTimeSeriesMcGinleyDynamic200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMcGinleyDynamic200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMedPrice200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MEDPRICE - Median Price"],
    )


class GetTimeSeriesMedPrice200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMedPrice200ResponseMetaIndicator] = None


class GetTimeSeriesMedPrice200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    medprice: Optional[str] = Field(
        None, description="Medprice value", examples=["201.05399"]
    )


class GetTimeSeriesMedPrice200Response(BaseModel):
    meta: Optional[GetTimeSeriesMedPrice200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMedPrice200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMfi200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MFI - Money Flow Index"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[14]
    )


class GetTimeSeriesMfi200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMfi200ResponseMetaIndicator] = None


class GetTimeSeriesMfi200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    mfi: Optional[str] = Field(None, description="MFI value", examples=["22.68525"])


class GetTimeSeriesMfi200Response(BaseModel):
    meta: Optional[GetTimeSeriesMfi200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMfi200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMidPoint200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MIDPOINT - MidPoint over period"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesMidPoint200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMidPoint200ResponseMetaIndicator] = None


class GetTimeSeriesMidPoint200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    midpoint: Optional[str] = Field(
        None, description="Midpoint value", examples=["201.4925"]
    )


class GetTimeSeriesMidPoint200Response(BaseModel):
    meta: Optional[GetTimeSeriesMidPoint200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMidPoint200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMidPrice200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MIDPRICE - Midpoint Price over period"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesMidPrice200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMidPrice200ResponseMetaIndicator] = None


class GetTimeSeriesMidPrice200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    midprice: Optional[str] = Field(
        None, description="Midprice value", examples=["201.535"]
    )


class GetTimeSeriesMidPrice200Response(BaseModel):
    meta: Optional[GetTimeSeriesMidPrice200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMidPrice200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMin200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MIN - Lowest value over period"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesMin200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMin200ResponseMetaIndicator] = None


class GetTimeSeriesMin200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    min: Optional[str] = Field(None, description="Min value", examples=["200.935"])


class GetTimeSeriesMin200Response(BaseModel):
    meta: Optional[GetTimeSeriesMin200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMin200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMinIndex200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MININDEX - Index of lowest value over period"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesMinIndex200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMinIndex200ResponseMetaIndicator] = None


class GetTimeSeriesMinIndex200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    minidx: Optional[str] = Field(
        None, description="Index of lowest value over period", examples=["498"]
    )


class GetTimeSeriesMinIndex200Response(BaseModel):
    meta: Optional[GetTimeSeriesMinIndex200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMinIndex200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMinMax200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MINMAX - Lowest and highest values over period"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesMinMax200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMinMax200ResponseMetaIndicator] = None


class GetTimeSeriesMinMax200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    min: Optional[str] = Field(None, description="Min value", examples=["200.935"])
    max: Optional[str] = Field(None, description="Max value", examples=["202.05"])


class GetTimeSeriesMinMax200Response(BaseModel):
    meta: Optional[GetTimeSeriesMinMax200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMinMax200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMinMaxIndex200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MINMAXINDEX - Indexes of lowest and highest values over period"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesMinMaxIndex200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMinMaxIndex200ResponseMetaIndicator] = None


class GetTimeSeriesMinMaxIndex200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    minidx: Optional[str] = Field(
        None,
        description="Index of the lowest value over the specified period",
        examples=["498"],
    )
    maxidx: Optional[str] = Field(
        None,
        description="Index of the highest value over the specified period",
        examples=["491"],
    )


class GetTimeSeriesMinMaxIndex200Response(BaseModel):
    meta: Optional[GetTimeSeriesMinMaxIndex200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMinMaxIndex200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMinusDI200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MINUS_DI - Minus Directional Indicator"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesMinusDI200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMinusDI200ResponseMetaIndicator] = None


class GetTimeSeriesMinusDI200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    minus_di: Optional[str] = Field(
        None, description="Minus_di value", examples=["46.60579"]
    )


class GetTimeSeriesMinusDI200Response(BaseModel):
    meta: Optional[GetTimeSeriesMinusDI200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMinusDI200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMinusDM200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MINUS_DM - Minus Directional Movement"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesMinusDM200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMinusDM200ResponseMetaIndicator] = None


class GetTimeSeriesMinusDM200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    minus_dm: Optional[str] = Field(
        None, description="Minus Directional Movement value", examples=["0.96291"]
    )


class GetTimeSeriesMinusDM200Response(BaseModel):
    meta: Optional[GetTimeSeriesMinusDM200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMinusDM200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMom200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["MOM - Momentum"]
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesMom200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMom200ResponseMetaIndicator] = None


class GetTimeSeriesMom200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    mom: Optional[str] = Field(None, description="Mom value", examples=["-1.14"])


class GetTimeSeriesMom200Response(BaseModel):
    meta: Optional[GetTimeSeriesMom200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMom200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesMult200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["MULT - Arithmetic Multiply"],
    )
    series_type_1: Optional[str] = Field(
        None, description="Specifies the first price data type", examples=["open"]
    )
    series_type_2: Optional[str] = Field(
        None, description="Specifies the second price data type", examples=["close"]
    )


class GetTimeSeriesMult200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesMult200ResponseMetaIndicator] = None


class GetTimeSeriesMult200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    mult: Optional[str] = Field(
        None, description="Mult value", examples=["40422.66609"]
    )


class GetTimeSeriesMult200Response(BaseModel):
    meta: Optional[GetTimeSeriesMult200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesMult200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetMutualFundsFamily200Response(BaseModel):
    result: Optional[Dict[str, List[str]]] = Field(
        None,
        description="List of fund families by country",
        examples=[
            {
                "India": [
                    "Aberdeen Standard Fund Managers Limited",
                    "Aditya Birla Sun Life AMC Ltd",
                ],
                "United States": [
                    "Aegon Asset Management UK PLC",
                    "Ampega Investment GmbH",
                    "Aviva SpA",
                ],
            }
        ],
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetMutualFundsList200ResponseResult(BaseModel):
    count: Optional[int] = Field(
        None, description="Total number of matching funds", examples=[1000]
    )
    list: Optional[List[MutualFundsListResponseListItem]] = Field(
        None, description="List of mutual funds"
    )


class GetMutualFundsList200Response(BaseModel):
    result: Optional[GetMutualFundsList200ResponseResult] = None
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetMutualFundsType200Response(BaseModel):
    result: Optional[Dict[str, List[str]]] = Field(
        None,
        description="List of fund types by country",
        examples=[
            {
                "Singapore": [
                    "Property - Indirect Asia",
                    "Sector Equity Water",
                    "SGD Bond",
                    "Singapore Equity",
                    "Taiwan Large-Cap Equity",
                ],
                "United States": [
                    "Asia-Pacific ex-Japan Equity",
                    "EUR Flexible Allocation - Global",
                    "Euro Short Bond PP",
                    "Large Blend",
                    "Other Allocation",
                ],
            }
        ],
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetMutualFundsWorld200ResponseMutualFundSummaryPeopleInner(BaseModel):
    name: Optional[str] = Field(None, description="Manager name", examples=["John Doe"])
    tenure_since: Optional[str] = Field(
        None, description="Manager tenuring date", examples=["2018-01-01"]
    )


class GetMutualFundsWorld200ResponseMutualFundSummary(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="All available fund types segmented by country",
        examples=["0P0001LCQ3"],
    )
    name: Optional[str] = Field(
        None, description="Fund name", examples=["JNL Small Cap Index Fund (I)"]
    )
    fund_family: Optional[str] = Field(
        None,
        description="Investment company that manages the fund",
        examples=["Jackson National"],
    )
    fund_type: Optional[str] = Field(
        None, description="Type of the fund", examples=["Small Blend"]
    )
    currency: Optional[str] = Field(
        None, description="Currency of fund price", examples=["USD"]
    )
    share_class_inception_date: Optional[str] = Field(
        None,
        description="The date from which the fund started operations and the returns are calculated",
        examples=["2021-04-26"],
    )
    ytd_return: Optional[float] = Field(
        None,
        description="Percentage of profit of the fund since the first trading day of the current calendar year",
        examples=[-0.02986],
    )
    expense_ratio_net: Optional[float] = Field(
        None,
        description="Percentage of mutual fund assets steered toward a fund's operating expenses and fund management fees",
        examples=[0.001],
    )
    yield_: Optional[float] = Field(
        None,
        alias="yield",
        description="Income returned to its investors through interest and dividends generated by the fund's investments",
        examples=[0],
    )
    nav: Optional[float] = Field(
        None,
        description="Net Asset Value: fund value minus liabilities",
        examples=[10.09],
    )
    min_investment: Optional[int] = Field(
        None, description="Investment minimum", examples=[0]
    )
    turnover_rate: Optional[float] = Field(
        None,
        description="Percentage rate at which mutual fund replaces its holdings on investment every year",
        examples=[0.32],
    )
    net_assets: Optional[int] = Field(
        None,
        description="Total assets of a fund minus its total liabilities",
        examples=[2400762112],
    )
    overview: Optional[str] = Field(
        None,
        description="Description of the fund",
        examples=[
            "The fund invests, normally, at least 80% of its assets in the stocks..."
        ],
    )
    people: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundSummaryPeopleInner]
    ] = Field(None, description="Information about the fund’s managers")


class GetMutualFundsWorld200ResponseMutualFundPerformanceTrailingReturnsInner(
    BaseModel
):
    period: Optional[str] = Field(
        None, description="Period of trailing returns", examples=["ytd"]
    )
    share_class_return: Optional[float] = Field(
        None,
        description="Fund returns (%) generated over a given period",
        examples=[-0.02986],
    )
    category_return: Optional[float] = Field(
        None,
        description="Same category average returns (%) generated over a given period",
        examples=[0.2019],
    )
    rank_in_category: Optional[int] = Field(
        None, description="Rank of a fund in category by total returns", examples=[76]
    )


class GetMutualFundsWorld200ResponseMutualFundPerformanceAnnualTotalReturnsInner(
    BaseModel
):
    year: Optional[int] = Field(
        None, description="Year of total returns", examples=[2024]
    )
    share_class_return: Optional[float] = Field(
        None,
        description="Fund total returns (%) generated over a given year",
        examples=[0.08546],
    )
    category_return: Optional[float] = Field(
        None,
        description="Same category average total returns (%) generated over a given year",
        examples=[0.1119],
    )


class GetMutualFundsWorld200ResponseMutualFundPerformanceQuarterlyTotalReturnsInner(
    BaseModel
):
    year: Optional[int] = Field(
        None, description="Year of a fund quarter return", examples=[2024]
    )
    q1: Optional[float] = Field(
        None,
        description="Total return (%) of a fund in the first quarter",
        examples=[0.02358],
    )
    q2: Optional[float] = Field(
        None,
        description="Total return (%) of a fund in the second quarter",
        examples=[-0.03071],
    )
    q3: Optional[float] = Field(
        None,
        description="Total return (%) of a fund in the third quarter",
        examples=[0.10099],
    )
    q4: Optional[float] = Field(
        None,
        description="Total return (%) of a fund in the fourth quarter",
        examples=[-0.00629],
    )


class GetMutualFundsWorld200ResponseMutualFundPerformanceLoadAdjustedReturnInner(
    BaseModel
):
    period: Optional[str] = Field(
        None, description="Period of a load adjusted return", examples=["1_year"]
    )
    return_: Optional[float] = Field(
        None,
        alias="return",
        description="Actual return (%) an investor sees after accounting for fees and sales charges are deducted from a mutual fund's performance",
        examples=[0.06139],
    )


class GetMutualFundsWorld200ResponseMutualFundPerformance(BaseModel):
    trailing_returns: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundPerformanceTrailingReturnsInner]
    ] = Field(None, description="Trailing returns of the fund")
    annual_total_returns: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundPerformanceAnnualTotalReturnsInner]
    ] = Field(None, description="Annual total returns of the fund")
    quarterly_total_returns: Optional[
        List[
            GetMutualFundsWorld200ResponseMutualFundPerformanceQuarterlyTotalReturnsInner
        ]
    ] = Field(None, description="Quarterly total returns of the fund")
    load_adjusted_return: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundPerformanceLoadAdjustedReturnInner]
    ] = Field(None, description="Load adjusted return of the fund")


class GetMutualFundsWorld200ResponseMutualFundRiskVolatilityMeasuresInner(BaseModel):
    period: Optional[str] = Field(
        None, description="Period of a measure", examples=["3_year"]
    )
    alpha: Optional[float] = Field(
        None, description="Alpha score of a fund", examples=[-9.12]
    )
    alpha_category: Optional[float] = Field(
        None, description="Average alpha score of a fund's category", examples=[-0.0939]
    )
    beta: Optional[float] = Field(
        None, description="Beta score of a fund", examples=[1]
    )
    beta_category: Optional[float] = Field(
        None, description="Average beta score of a fund's category", examples=[0.0126]
    )
    mean_annual_return: Optional[float] = Field(
        None, description="Mean annual return of a fund", examples=[0.45]
    )
    mean_annual_return_category: Optional[float] = Field(
        None,
        description="Average mean annual return of a fund's category",
        examples=[0.0117],
    )
    r_squared: Optional[float] = Field(
        None, description="R-squared metric of a fund", examples=[69]
    )
    r_squared_category: Optional[float] = Field(
        None,
        description="Average r-squared metric of a fund's category",
        examples=[0.8309],
    )
    std: Optional[float] = Field(
        None, description="Standard deviation of a fund", examples=[23.15]
    )
    std_category: Optional[float] = Field(
        None,
        description="Average standard deviation of a fund's category",
        examples=[0.2554],
    )
    sharpe_ratio: Optional[float] = Field(
        None, description="Sharpe ratio of a fund", examples=[0.04]
    )
    sharpe_ratio_category: Optional[float] = Field(
        None, description="Average sharpe ratio of a fund's category", examples=[0.005]
    )
    treynor_ratio: Optional[float] = Field(
        None, description="Treynor ratio of a fund", examples=[-1.41]
    )
    treynor_ratio_category: Optional[float] = Field(
        None,
        description="Average treynor ratio of a fund's category",
        examples=[0.0806],
    )


class GetMutualFundsWorld200ResponseMutualFundRiskValuationMetrics(BaseModel):
    price_to_earnings: Optional[float] = Field(
        None, description="Fund price to earnings metric", examples=[0.05695]
    )
    price_to_earnings_category: Optional[float] = Field(
        None,
        description="Average price to earnings metric of funds in the same category",
        examples=[20.63],
    )
    price_to_book: Optional[float] = Field(
        None, description="Fund price to book metric", examples=[0.55626]
    )
    price_to_book_category: Optional[float] = Field(
        None,
        description="Average price to book metric of funds in the same category",
        examples=[2.87],
    )
    price_to_sales: Optional[float] = Field(
        None, description="Fund price to sales metric", examples=[0.97803]
    )
    price_to_sales_category: Optional[float] = Field(
        None,
        description="Average price to sales metric of funds in the same category",
        examples=[1.34],
    )
    price_to_cashflow: Optional[float] = Field(
        None, description="Fund price to cashflow metric", examples=[0.10564]
    )
    price_to_cashflow_category: Optional[float] = Field(
        None,
        description="Average price to cashflow metric of funds in the same category",
        examples=[11.81],
    )
    median_market_capitalization: Optional[int] = Field(
        None, description="Median market capitalization of a fund", examples=[2965]
    )
    median_market_capitalization_category: Optional[int] = Field(
        None,
        description="Median market capitalization of funds in the same category",
        examples=[4925],
    )
    field_3_year_earnings_growth: Optional[float] = Field(
        None,
        alias="3_year_earnings_growth",
        description="Earnings growth over the last three years",
        examples=[16.32],
    )
    field_3_year_earnings_growths_category: Optional[float] = Field(
        None,
        alias="3_year_earnings_growths_category",
        description="Earnings growth over the last three years of funds in the same category",
        examples=[10.55],
    )


class GetMutualFundsWorld200ResponseMutualFundRisk(BaseModel):
    volatility_measures: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundRiskVolatilityMeasuresInner]
    ] = Field(None, description="Volatility statistics of the fund")
    valuation_metrics: Optional[
        GetMutualFundsWorld200ResponseMutualFundRiskValuationMetrics
    ] = None


GetMutualFundsWorld200ResponseMutualFundRatings = ResponseMutualFundWorldRatings


class GetMutualFundsWorld200ResponseMutualFundCompositionMajorMarketSectorsInner(
    BaseModel
):
    sector: Optional[str] = Field(
        None, description="Sector category of a fund exposure", examples=["Industrials"]
    )
    weight: Optional[float] = Field(
        None, description="Weight (%) of a fund exposure in a sector", examples=[0.1742]
    )


class GetMutualFundsWorld200ResponseMutualFundCompositionAssetAllocation(BaseModel):
    cash: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in cash",
        examples=[0.0043],
    )
    stocks: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in stocks",
        examples=[0.9956],
    )
    preferred_stocks: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in preferred stocks",
        examples=[0],
    )
    convertables: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in convertable securities",
        examples=[0],
    )
    bonds: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in bond",
        examples=[0],
    )
    others: Optional[float] = Field(
        None,
        description="Percentage of overall portfolio composition in other forms of holding",
        examples=[0],
    )


class GetMutualFundsWorld200ResponseMutualFundCompositionTopHoldingsInner(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Symbol ticker of a holding instrument", examples=["BBWI"]
    )
    name: Optional[str] = Field(
        None,
        description="Name of a holding instrument",
        examples=["Bath & Body Works Inc"],
    )
    weight: Optional[float] = Field(
        None,
        description="Weight (%) of a holding instrument in overall portfolio composition",
        examples=[0.00624],
    )


class GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownAverageMaturity(
    BaseModel
):
    fund: Optional[Dict[str, Any]] = Field(
        None,
        description="Average maturity of bond holding of a fund",
        examples=["null"],
    )
    category: Optional[float] = Field(
        None,
        description="Average maturity of bond holding of funds in the same category",
        examples=[1.97],
    )


class GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownCreditQualityInner(
    BaseModel
):
    grade: Optional[str] = Field(
        None,
        description="Rating of bond holding of a fund from AAA to below B",
        examples=["U.S. Government"],
    )
    weight: Optional[float] = Field(
        None, description="Weight of bond holding in fund portfolio", examples=[0]
    )


class GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownAverageDuration(
    BaseModel
):
    fund: Optional[Dict[str, Any]] = Field(
        None,
        description="Average duration of bond holding of a fund",
        examples=["null"],
    )
    category: Optional[float] = Field(
        None,
        description="Average duration of bond holding of funds in the same category",
        examples=[1.64],
    )


class GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdown(BaseModel):
    average_maturity: Optional[
        GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownAverageMaturity
    ] = None
    credit_quality: Optional[
        List[
            GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownCreditQualityInner
        ]
    ] = Field(
        None,
        description="Breakdown of the fund’s bond holdings by credit rating and their respective portfolio weights",
    )
    average_duration: Optional[
        GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownAverageDuration
    ] = None


class GetMutualFundsWorld200ResponseMutualFundComposition(BaseModel):
    major_market_sectors: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundCompositionMajorMarketSectorsInner]
    ] = Field(
        None,
        description="Breakdown of the fund’s portfolio by major industry sectors and their respective weights",
    )
    asset_allocation: Optional[
        GetMutualFundsWorld200ResponseMutualFundCompositionAssetAllocation
    ] = None
    top_holdings: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundCompositionTopHoldingsInner]
    ] = Field(
        None,
        description="Top holdings of the fund with their respective weights in the overall portfolio composition",
    )
    bond_breakdown: Optional[
        GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdown
    ] = None


class GetMutualFundsWorld200ResponseMutualFundPurchaseInfoExpenses(BaseModel):
    expense_ratio_gross: Optional[float] = Field(
        None, description="Cost of investing in a mutual fund", examples=[0.0022]
    )
    expense_ratio_net: Optional[float] = Field(
        None,
        description="Percentage of mutual fund assets steered toward a fund's operating expenses and fund management fees",
        examples=[0.001],
    )


class GetMutualFundsWorld200ResponseMutualFundPurchaseInfoMinimums(BaseModel):
    initial_investment: Optional[int] = Field(
        None, description="Investment minimum", examples=[0]
    )
    additional_investment: Optional[int] = Field(
        None, description="Minimum amount of additional investment", examples=[0]
    )
    initial_ira_investment: Optional[Dict[str, Any]] = Field(
        None, description="Investment minimum for IRA", examples=["null"]
    )
    additional_ira_investment: Optional[Dict[str, Any]] = Field(
        None,
        description="Minimum amount of additional investment for IRA",
        examples=["null"],
    )


class GetMutualFundsWorld200ResponseMutualFundPurchaseInfoPricing(BaseModel):
    nav: Optional[float] = Field(
        None,
        description="Net Asset Value: fund value minus liabilities",
        examples=[10.09],
    )
    field_12_month_low: Optional[float] = Field(
        None,
        alias="12_month_low",
        description="Lowest price of the fund over the last year",
        examples=[9.630000114441],
    )
    field_12_month_high: Optional[float] = Field(
        None,
        alias="12_month_high",
        description="Highest price of the fund over the last year",
        examples=[12.10000038147],
    )
    last_month: Optional[float] = Field(
        None,
        description="Fund price at the end of the last month",
        examples=[11.050000190735],
    )


class GetMutualFundsWorld200ResponseMutualFundPurchaseInfo(BaseModel):
    expenses: Optional[GetMutualFundsWorld200ResponseMutualFundPurchaseInfoExpenses] = (
        None
    )
    minimums: Optional[GetMutualFundsWorld200ResponseMutualFundPurchaseInfoMinimums] = (
        None
    )
    pricing: Optional[GetMutualFundsWorld200ResponseMutualFundPurchaseInfoPricing] = (
        None
    )
    brokerages: Optional[List[str]] = Field(
        None,
        description="List of brokerages where mutual fund can be purchased",
        examples=[[]],
    )


class GetMutualFundsWorld200ResponseMutualFundSustainabilityCorporateEsgPillars(
    BaseModel
):
    environmental: Optional[float] = Field(
        None, description="ESG environmental score", examples=[3.73]
    )
    social: Optional[float] = Field(
        None, description="ESG social score", examples=[10.44]
    )
    governance: Optional[float] = Field(
        None, description="ESG governance score", examples=[7.86]
    )


class GetMutualFundsWorld200ResponseMutualFundSustainability(BaseModel):
    score: Optional[int] = Field(
        None,
        description="Sustainability score: asset-weighted average of normalized company-level ESG Scores for the covered holdings in the portfolio from `0` to `100`",
        examples=[22],
    )
    corporate_esg_pillars: Optional[
        GetMutualFundsWorld200ResponseMutualFundSustainabilityCorporateEsgPillars
    ] = None
    sustainable_investment: Optional[bool] = Field(
        None,
        description="Indication that the fund discloses in their prospectus that they employ socially responsible or ESG principles in their investment selection processes",
        examples=[False],
    )
    corporate_aum: Optional[float] = Field(
        None,
        description="Percentage of AUM used to calculate sustainability score",
        examples=[0.99486],
    )


class GetMutualFundsWorld200ResponseMutualFund(BaseModel):
    summary: Optional[GetMutualFundsWorld200ResponseMutualFundSummary] = None
    performance: Optional[GetMutualFundsWorld200ResponseMutualFundPerformance] = None
    risk: Optional[GetMutualFundsWorld200ResponseMutualFundRisk] = None
    ratings: Optional[GetMutualFundsWorld200ResponseMutualFundRatings] = None
    composition: Optional[GetMutualFundsWorld200ResponseMutualFundComposition] = None
    purchase_info: Optional[GetMutualFundsWorld200ResponseMutualFundPurchaseInfo] = None
    sustainability: Optional[GetMutualFundsWorld200ResponseMutualFundSustainability] = (
        None
    )


class GetMutualFundsWorld200Response(BaseModel):
    mutual_fund: Optional[GetMutualFundsWorld200ResponseMutualFund] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetMutualFundsWorldRatings200ResponseMutualFund(BaseModel):
    ratings: Optional[ResponseMutualFundWorldRatings] = None


class GetMutualFundsWorldRatings200Response(BaseModel):
    mutual_fund: Optional[GetMutualFundsWorldRatings200ResponseMutualFund] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetTimeSeriesNatr200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["NATR - Normalized Average True Range"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[14],
    )


class GetTimeSeriesNatr200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesNatr200ResponseMetaIndicator] = None


class GetTimeSeriesNatr200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    natr: Optional[str] = Field(None, description="natr value", examples=["0.09862"])


class GetTimeSeriesNatr200Response(BaseModel):
    meta: Optional[GetTimeSeriesNatr200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesNatr200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesObv200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["OBV - On Balance Volume"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesObv200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesObv200ResponseMetaIndicator] = None


class GetTimeSeriesObv200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    obv: Optional[str] = Field(None, description="obv value", examples=["540374.0"])


class GetTimeSeriesObv200Response(BaseModel):
    meta: Optional[GetTimeSeriesObv200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesObv200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesPercentB200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["PERCENT_B - %B Indicator"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[20],
    )
    sd: Optional[float] = Field(
        None,
        description="The standard deviation applied in the calculation",
        examples=[2],
    )
    ma_type: Optional[str] = Field(
        None, description="The type of moving average used", examples=["SMA"]
    )


class GetTimeSeriesPercentB200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesPercentB200ResponseMetaIndicator] = None


class GetTimeSeriesPercentB200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    percent_b: Optional[str] = Field(
        None, description="Percent_b value", examples=["0.11981"]
    )


class GetTimeSeriesPercentB200Response(BaseModel):
    meta: Optional[GetTimeSeriesPercentB200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesPercentB200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesPivotPointsHL200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["PIVOT_POINTS_HL - Pivot Points (High/Low)"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[10],
    )


class GetTimeSeriesPivotPointsHL200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesPivotPointsHL200ResponseMetaIndicator] = None


class GetTimeSeriesPivotPointsHL200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    pivot_point_h: Optional[int] = Field(
        None, description="`1` if it is a high pivot point, otherwise `0`", examples=[1]
    )
    pivot_point_l: Optional[int] = Field(
        None, description="`1` if it is a low pivot point, otherwise `0`", examples=[0]
    )


class GetTimeSeriesPivotPointsHL200Response(BaseModel):
    meta: Optional[GetTimeSeriesPivotPointsHL200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesPivotPointsHL200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesPlusDI200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["PLUS_DI - Plus Directional Indicator"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesPlusDI200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesPlusDI200ResponseMetaIndicator] = None


class GetTimeSeriesPlusDI200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    plus_di: Optional[str] = Field(
        None, description="plus_di value", examples=["7.69578"]
    )


class GetTimeSeriesPlusDI200Response(BaseModel):
    meta: Optional[GetTimeSeriesPlusDI200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesPlusDI200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesPlusDM200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["PLUS_DM - Plus Directional Movement"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesPlusDM200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesPlusDM200ResponseMetaIndicator] = None


class GetTimeSeriesPlusDM200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    plus_dm: Optional[str] = Field(
        None, description="plus_dm value", examples=["0.159"]
    )


class GetTimeSeriesPlusDM200Response(BaseModel):
    meta: Optional[GetTimeSeriesPlusDM200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesPlusDM200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesPpo200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["PPO - Percentage Price Oscillator"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    fast_period: Optional[int] = Field(
        None, description="The shorter time period for calculation", examples=[12]
    )
    slow_period: Optional[int] = Field(
        None, description="The longer time period for calculation", examples=[26]
    )
    ma_type: Optional[str] = Field(
        None, description="The type of moving average used", examples=["SMA"]
    )


class GetTimeSeriesPpo200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesPpo200ResponseMetaIndicator] = None


class GetTimeSeriesPpo200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ppo: Optional[str] = Field(None, description="PPO value", examples=["-0.2696"])


class GetTimeSeriesPpo200Response(BaseModel):
    meta: Optional[GetTimeSeriesPpo200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesPpo200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetPrice200Response(BaseModel):
    price: Optional[str] = Field(
        None,
        description="Real-time or the latest available price",
        examples=["200.99001"],
    )


GetPriceTarget200ResponseMeta = GetAnalystRatingsLight200ResponseMeta


class GetPriceTarget200ResponsePriceTarget(BaseModel):
    high: Optional[float] = Field(
        None, description="Highest price target given by an analyst", examples=[220]
    )
    median: Optional[float] = Field(
        None, description="Median price target given across analysts", examples=[185]
    )
    low: Optional[float] = Field(
        None, description="Lowest price target given by an analyst", examples=[136]
    )
    average: Optional[float] = Field(
        None,
        description="Average price target given across analysts",
        examples=[184.01],
    )
    current: Optional[float] = Field(
        None, description="Current price from of a security", examples=[169.5672]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency in which the price targets values are quoted",
        examples=["USD"],
    )


class GetPriceTarget200Response(BaseModel):
    meta: Optional[GetPriceTarget200ResponseMeta] = None
    price_target: Optional[GetPriceTarget200ResponsePriceTarget] = None
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetProfile200Response(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker of the company", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    exchange: Optional[str] = Field(
        None,
        description="Exchange name where the company is listed",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market Identifier Code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    sector: Optional[str] = Field(
        None,
        description="Sector at which the company operates",
        examples=["Technology"],
    )
    industry: Optional[str] = Field(
        None,
        description="Industry at which company operates",
        examples=["Consumer Electronics"],
    )
    employees: Optional[int] = Field(
        None, description="Number of employees in the company", examples=[147000]
    )
    website: Optional[str] = Field(
        None, description="Website of the company", examples=["http://www.apple.com"]
    )
    description: Optional[str] = Field(
        None,
        description="Description of the company activities",
        examples=[
            "Apple Inc. designs, manufactures, and markets smartphones, personal computers, tablets, wearables, and..."
        ],
    )
    type: Optional[str] = Field(
        None, description="Issue type of the stock", examples=["Common Stock"]
    )
    CEO: Optional[str] = Field(
        None,
        description="Name of the CEO of the company",
        examples=["Mr. Timothy D. Cook"],
    )
    address: Optional[str] = Field(
        None,
        description="Street address of the company if presented",
        examples=["One Apple Park Way"],
    )
    address2: Optional[str] = Field(
        None,
        description="Secondary address of the company if presented",
        examples=["Cupertino, CA 95014"],
    )
    city: Optional[str] = Field(
        None, description="City of the company if presented", examples=["Cupertino"]
    )
    zip: Optional[str] = Field(
        None, description="ZIP code of the company if presented", examples=["95014"]
    )
    state: Optional[str] = Field(
        None, description="State of the company if presented", examples=["CA"]
    )
    country: Optional[str] = Field(
        None, description="Country of the company if presented", examples=["US"]
    )
    phone: Optional[str] = Field(
        None,
        description="Phone number of the company if presented",
        examples=["408-996-1010"],
    )


class GetQuote200ResponseFiftyTwoWeek(BaseModel):
    low: Optional[str] = Field(
        None, description="52-week low price", examples=["103.10000"]
    )
    high: Optional[str] = Field(
        None, description="52-week high price", examples=["157.25999"]
    )
    low_change: Optional[str] = Field(
        None, description="Current price - 52-week low", examples=["45.75001"]
    )
    high_change: Optional[str] = Field(
        None, description="Current price - 52-week high", examples=["-8.40999"]
    )
    low_change_percent: Optional[str] = Field(
        None, description="Percentage change from 52-week low", examples=["44.37440"]
    )
    high_change_percent: Optional[str] = Field(
        None, description="Percentage change from 52-week high", examples=["-5.34782"]
    )
    range: Optional[str] = Field(
        None,
        description="Range between 52-week low and high",
        examples=["103.099998 - 157.259995"],
    )


class GetQuote200Response(BaseModel):
    symbol: Optional[str] = Field(None, description="Symbol passed", examples=["AAPL"])
    name: Optional[str] = Field(
        None, description="Name of the instrument", examples=["Apple Inc"]
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    currency: Optional[str] = Field(
        None,
        description="Currency in which the equity is denominated",
        examples=["USD"],
    )
    datetime: Optional[str] = Field(
        None,
        description="Datetime in defined timezone referring to when the bar with specified interval was opened",
        examples=["2021-09-16"],
    )
    timestamp: Optional[int] = Field(
        None,
        description="Unix timestamp representing the opening candle of the specified interval",
        examples=[1631772000],
    )
    last_quote_at: Optional[int] = Field(
        None, description="Unix timestamp of last minute candle", examples=[1631772000]
    )
    open: Optional[str] = Field(
        None, description="Price at the opening of current bar", examples=["148.44000"]
    )
    high: Optional[str] = Field(
        None,
        description="Highest price which occurred during the current bar",
        examples=["148.96840"],
    )
    low: Optional[str] = Field(
        None,
        description="Lowest price which occurred during the current bar",
        examples=["147.22099"],
    )
    close: Optional[str] = Field(
        None, description="Close price at the end of the bar", examples=["148.85001"]
    )
    volume: Optional[str] = Field(
        None, description="Trading volume during the bar", examples=["67903927"]
    )
    previous_close: Optional[str] = Field(
        None,
        description="Close price at the end of the previous bar",
        examples=["149.09000"],
    )
    change: Optional[str] = Field(
        None, description="Close - previous_close", examples=["-0.23999"]
    )
    percent_change: Optional[str] = Field(
        None,
        description="(Close - previous_close) / previous_close * 100",
        examples=["-0.16097"],
    )
    average_volume: Optional[str] = Field(
        None,
        description="Average volume of the specified period",
        examples=["83571571"],
    )
    rolling_1day_change: Optional[str] = Field(
        None,
        description="Percent change in price between the current and the backward one, where period is 1 day, available for crypto",
        examples=["123.123"],
    )
    rolling_7day_change: Optional[str] = Field(
        None,
        description="Percent change in price between the current and the backward one, where period is 7 days, available for crypto",
        examples=["123.123"],
    )
    rolling_period_change: Optional[str] = Field(
        None,
        description="Percent change in price between the current and the backward one, where period specified in request param rolling_period, available for crypto",
        examples=["123.123"],
    )
    is_market_open: Optional[bool] = Field(
        None, description="True if market is open; false if closed", examples=[False]
    )
    fifty_two_week: Optional[GetQuote200ResponseFiftyTwoWeek] = None
    extended_change: Optional[str] = Field(
        None,
        description="Diff between the regular close price and the latest extended price",
        examples=["0.09"],
    )
    extended_percent_change: Optional[str] = Field(
        None,
        description="Percent change in price between the regular close price and the latest extended price",
        examples=["0.05"],
    )
    extended_price: Optional[str] = Field(
        None, description="Latest extended price", examples=["125.22"]
    )
    extended_timestamp: Optional[str] = Field(
        None,
        description="Unix timestamp of the last extended price",
        examples=["1649845281"],
    )


GetRecommendations200ResponseMeta = GetAnalystRatingsLight200ResponseMeta


class GetRecommendations200ResponseTrendsCurrentMonth(BaseModel):
    strong_buy: Optional[int] = Field(
        None,
        description="Number of analysts that give a strong buy recommendation",
        examples=[13],
    )
    buy: Optional[int] = Field(
        None,
        description="Number of analysts that give a buy recommendation",
        examples=[20],
    )
    hold: Optional[int] = Field(
        None,
        description="Number of analysts that give a hold recommendation",
        examples=[8],
    )
    sell: Optional[int] = Field(
        None,
        description="Number of analysts that give a sell recommendation",
        examples=[0],
    )
    strong_sell: Optional[int] = Field(
        None,
        description="Number of analysts that give a strong sell recommendation",
        examples=[0],
    )


GetRecommendations200ResponseTrendsPreviousMonth = (
    GetRecommendations200ResponseTrendsCurrentMonth
)


GetRecommendations200ResponseTrends2MonthsAgo = (
    GetRecommendations200ResponseTrendsCurrentMonth
)


GetRecommendations200ResponseTrends3MonthsAgo = (
    GetRecommendations200ResponseTrendsCurrentMonth
)


class GetRecommendations200ResponseTrends(BaseModel):
    current_month: Optional[GetRecommendations200ResponseTrendsCurrentMonth] = None
    previous_month: Optional[GetRecommendations200ResponseTrendsPreviousMonth] = None
    field_2_months_ago: Optional[GetRecommendations200ResponseTrends2MonthsAgo] = Field(
        None, alias="2_months_ago"
    )
    field_3_months_ago: Optional[GetRecommendations200ResponseTrends3MonthsAgo] = Field(
        None, alias="3_months_ago"
    )


class GetRecommendations200Response(BaseModel):
    meta: Optional[GetRecommendations200ResponseMeta] = None
    trends: Optional[GetRecommendations200ResponseTrends] = None
    rating: Optional[float] = Field(
        None,
        description="Rating from 0 to 10 represents overall analysts' recommendation. 0 to 2 - strong sell, 2 to 4 - sell, 4 to 6 - hold, 6 to 8 - buy, 8 to 10 - strong buy.",
        examples=[8.2],
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetRevenueEstimate200ResponseRevenueEstimateInner(BaseModel):
    date: Optional[str] = Field(
        None, description="Date of the estimate", examples=["2022-09-30"]
    )
    period: Optional[str] = Field(
        None,
        description="Period of estimation, can be `current_quarter`, `next_quarter`, `current_year`, or `next_year`",
        examples=["current_quarter"],
    )
    number_of_analysts: Optional[int] = Field(
        None, description="Number of analysts that made the estimation", examples=[24]
    )
    avg_estimate: Optional[float] = Field(
        None, description="Average estimation across analysts", examples=[88631500000]
    )
    low_estimate: Optional[float] = Field(
        None,
        description="Lowest estimation given by an analyst",
        examples=[85144300000],
    )
    high_estimate: Optional[float] = Field(
        None,
        description="Highest estimation given by an analyst",
        examples=[92794900000],
    )
    year_ago_sales: Optional[float] = Field(
        None,
        description="Total revenue received a year ago relative to period",
        examples=[83360000000],
    )
    sales_growth: Optional[float] = Field(
        None,
        description="Estimated sales growth of the period in relation to year-ago sales in prc (%)",
        examples=[0.06],
    )


class GetRevenueEstimate200Response(BaseModel):
    meta: Optional[GetEarningsEstimate200ResponseMeta] = None
    revenue_estimate: Optional[
        List[GetRevenueEstimate200ResponseRevenueEstimateInner]
    ] = Field(None, description="Revenue estimate data")
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetTimeSeriesRoc200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ROC - Rate of change"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="The time period used for calculation", examples=[9]
    )


class GetTimeSeriesRoc200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesRoc200ResponseMetaIndicator] = None


class GetTimeSeriesRoc200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    roc: Optional[str] = Field(None, description="roc value", examples=["-0.56383"])


class GetTimeSeriesRoc200Response(BaseModel):
    meta: Optional[GetTimeSeriesRoc200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesRoc200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesRocp200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ROCP - Rate of change percentage"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesRocp200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesRocp200ResponseMetaIndicator] = None


class GetTimeSeriesRocp200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    rocp: Optional[str] = Field(None, description="ROCP value", examples=["-0.00564"])


class GetTimeSeriesRocp200Response(BaseModel):
    meta: Optional[GetTimeSeriesRocp200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesRocp200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesRocr200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ROCR - Rate of change ratio"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None, description="Number of periods to average over", examples=[9]
    )


class GetTimeSeriesRocr200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesRocr200ResponseMetaIndicator] = None


class GetTimeSeriesRocr200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    rocr: Optional[str] = Field(None, description="ROCR value", examples=["0.99436"])


class GetTimeSeriesRocr200Response(BaseModel):
    meta: Optional[GetTimeSeriesRocr200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesRocr200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesRocr100200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ROCR100 - Rate of change ratio 100 scale"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesRocr100200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesRocr100200ResponseMetaIndicator] = None


class GetTimeSeriesRocr100200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    rocr100: Optional[str] = Field(
        None, description="rocr100 value", examples=["99.43617"]
    )


class GetTimeSeriesRocr100200Response(BaseModel):
    meta: Optional[GetTimeSeriesRocr100200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesRocr100200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesRsi200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["RSI - Relative Strength Index"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[14],
    )


class GetTimeSeriesRsi200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesRsi200ResponseMetaIndicator] = None


class GetTimeSeriesRsi200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    rsi: Optional[str] = Field(None, description="RSI value", examples=["16.57887"])


class GetTimeSeriesRsi200Response(BaseModel):
    meta: Optional[GetTimeSeriesRsi200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesRsi200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesRvol200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["RVOL - Relative Volume Indicator"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[14],
    )


class GetTimeSeriesRvol200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesRvol200ResponseMetaIndicator] = None


class GetTimeSeriesRvol200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    rvol: Optional[str] = Field(None, description="RVOL value", examples=["2.9054"])


class GetTimeSeriesRvol200Response(BaseModel):
    meta: Optional[GetTimeSeriesRvol200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesRvol200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesSar200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["SAR - Parabolic SAR"],
    )
    acceleration: Optional[float] = Field(
        None,
        description="The acceleration factor used in the indicator calculation",
        examples=[0.02],
    )
    maximum: Optional[float] = Field(
        None,
        description="The maximum value considered for the indicator calculation",
        examples=[0.2],
    )


class GetTimeSeriesSar200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesSar200ResponseMetaIndicator] = None


class GetTimeSeriesSar200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    sar: Optional[str] = Field(None, description="SAR value", examples=["201.54365"])


class GetTimeSeriesSar200Response(BaseModel):
    meta: Optional[GetTimeSeriesSar200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesSar200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesSarExt200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["SAREXT - Parabolic SAR Extended"],
    )
    start_value: Optional[float] = Field(
        None,
        description="The initial value for the indicator calculation",
        examples=[0],
    )
    offset_on_reverse: Optional[float] = Field(
        None,
        description="The adjustment applied when the indicator's direction changes",
        examples=[0],
    )
    acceleration_limit_long: Optional[float] = Field(
        None,
        description="The maximum acceleration value for long positions",
        examples=[0.02],
    )
    acceleration_long: Optional[float] = Field(
        None, description="The acceleration value for long positions", examples=[0.02]
    )
    acceleration_max_long: Optional[float] = Field(
        None,
        description="The highest allowed acceleration for long positions",
        examples=[0.2],
    )
    acceleration_limit_short: Optional[float] = Field(
        None,
        description="The maximum acceleration value for short positions",
        examples=[0.02],
    )
    acceleration_short: Optional[float] = Field(
        None, description="The acceleration value for short positions", examples=[0.02]
    )
    acceleration_max_short: Optional[float] = Field(
        None,
        description="The highest allowed acceleration for short positions",
        examples=[0.2],
    )


class GetTimeSeriesSarExt200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesSarExt200ResponseMetaIndicator] = None


class GetTimeSeriesSarExt200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-04-02"],
    )
    sarext: Optional[str] = Field(
        None, description="SAREXT value", examples=["214.059460"]
    )


class GetTimeSeriesSarExt200Response(BaseModel):
    meta: Optional[GetTimeSeriesSarExt200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesSarExt200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesSma200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["SMA - Simple Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesSma200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesSma200ResponseMetaIndicator] = None


class GetTimeSeriesSma200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    sma: Optional[str] = Field(None, description="SMA value", examples=["201.41205"])


class GetTimeSeriesSma200Response(BaseModel):
    meta: Optional[GetTimeSeriesSma200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesSma200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetSplits200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the instrument", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency in which the instrument is denominated",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Timezone of the exchange", examples=["America/New_York"]
    )


class GetSplits200ResponseSplitsInner(BaseModel):
    date: Optional[str] = Field(
        None, description="Stands for the split date", examples=["2020-08-31"]
    )
    description: Optional[str] = Field(
        None, description="Specification of the split event", examples=["4-for-1 split"]
    )
    ratio: Optional[float] = Field(
        None,
        description="The ratio by which the number of a company's outstanding shares of stock are increased following a stock split. For example, a `4-for-1 split` results in four times as many outstanding shares, with each share selling at one forth of its pre-split price",
        examples=[0.25],
    )
    from_factor: Optional[float] = Field(
        None, description="From factor of the split", examples=[4]
    )
    to_factor: Optional[float] = Field(
        None, description="To factor of the split", examples=[1]
    )


class GetSplits200Response(BaseModel):
    meta: Optional[GetSplits200ResponseMeta] = None
    splits: Optional[List[GetSplits200ResponseSplitsInner]] = Field(
        None, description="List of stock splits"
    )


class GetTimeSeriesSqrt200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["SQRT - Square Root"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesSqrt200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesSqrt200ResponseMetaIndicator] = None


class GetTimeSeriesSqrt200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    sqrt: Optional[str] = Field(None, description="SQRT value", examples=["14.17921"])


class GetTimeSeriesSqrt200Response(BaseModel):
    meta: Optional[GetTimeSeriesSqrt200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesSqrt200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetStatistics200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Symbol ticker of instrument", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Name of the company", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None, description="Currency of the instrument", examples=["USD"]
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNAS"],
    )
    exchange_timezone: Optional[str] = Field(
        None, description="Timezone of the exchange", examples=["America/New_York"]
    )


class GetStatistics200ResponseStatisticsValuationsMetrics(BaseModel):
    market_capitalization: Optional[float] = Field(
        None,
        description="Refers to the market value of the company's outstanding shares",
        examples=[2546807865344],
    )
    enterprise_value: Optional[float] = Field(
        None,
        description="Refers to enterprise value (EV) of the company, often used as a more comprehensive alternative to market capitalization",
        examples=[2620597731328],
    )
    trailing_pe: Optional[float] = Field(
        None,
        description="Refers to the trailing price-to-earnings (P/E). It is calculated by taking the current stock price and dividing it by the trailing earnings per share (EPS) for the past 12 months",
        examples=[30.162493],
    )
    forward_pe: Optional[float] = Field(
        None,
        description="Refers to the forward price-to-earnings ratio. It is calculated by dividing the current share price by the estimated future earnings per share",
        examples=[26.982489],
    )
    peg_ratio: Optional[float] = Field(
        None,
        description="The price/earnings to growth (PEG) ratio is a price-to-earnings ratio divided by the growth rate of the earnings",
        examples=[1.4],
    )
    price_to_sales_ttm: Optional[float] = Field(
        None,
        description="The price-to-sales (P/S) ratio is a valuation ratio that compares the market capitalization to its revenues over the last 12 months",
        examples=[7.336227],
    )
    price_to_book_mrq: Optional[float] = Field(
        None,
        description="The price-to-book (P/B) ratio is equal to the current share price divided by the book value of all shares (BVPS) over the last quarter",
        examples=[39.68831],
    )
    enterprise_to_revenue: Optional[float] = Field(
        None,
        description="The enterprise value-to-revenue multiple (EV/R) is a measure that compares enterprise value to revenue",
        examples=[7.549],
    )
    enterprise_to_ebitda: Optional[float] = Field(
        None,
        description="The enterprise value-to-ebitda multiple (EV/EBITDA) is a measure that compares enterprise value to EBITDA",
        examples=[23.623],
    )


class GetStatistics200ResponseStatisticsFinancialsIncomeStatement(BaseModel):
    revenue_ttm: Optional[float] = Field(
        None,
        description="Refers to total revenue over the last 12 months",
        examples=[347155005440],
    )
    revenue_per_share_ttm: Optional[float] = Field(
        None,
        description="Refers to revenue per share over the last 12 months",
        examples=[20.61],
    )
    quarterly_revenue_growth: Optional[float] = Field(
        None,
        description="Refers to quarterly revenue growth year over year",
        examples=[0.364],
    )
    gross_profit_ttm: Optional[float] = Field(
        None,
        description="Refers to gross profit over the last 12 months",
        examples=[104956000000],
    )
    ebitda: Optional[float] = Field(
        None,
        description="Refers to EBITDA (earnings before interest, taxes, depreciation, and amortization) measure; EBITDA is not calculated for banks",
        examples=[110934999040],
    )
    net_income_to_common_ttm: Optional[float] = Field(
        None,
        description="Refers to net income applicable to common shares over the last 12 months",
        examples=[86801997824],
    )
    diluted_eps_ttm: Optional[float] = Field(
        None,
        description="Refers to diluted EPS measure over the last 12 months",
        examples=[5.108],
    )
    quarterly_earnings_growth_yoy: Optional[float] = Field(
        None,
        description="Refers to quarterly earnings growth year over year",
        examples=[0.932],
    )


class GetStatistics200ResponseStatisticsFinancialsBalanceSheet(BaseModel):
    total_cash_mrq: Optional[float] = Field(
        None,
        description="Refers to total cash measure for the most recent quarter",
        examples=[61696000000],
    )
    total_cash_per_share_mrq: Optional[float] = Field(
        None,
        description="Refers to total cash per share measure for the most recent quarter",
        examples=[3.732],
    )
    total_debt_mrq: Optional[float] = Field(
        None,
        description="Refers to total debt measure for the most recent quarter",
        examples=[135491002368],
    )
    total_debt_to_equity_mrq: Optional[float] = Field(
        None,
        description="Refers to total debt to equity measure for the most recent quarter",
        examples=[210.782],
    )
    current_ratio_mrq: Optional[float] = Field(
        None,
        description="Refers to current ratio (total assets / total liabilities) ratio for the most recent quarter",
        examples=[1.062],
    )
    book_value_per_share_mrq: Optional[float] = Field(
        None,
        description="Refers to book value per share (BVPS) ratio for the most recent quarter",
        examples=[3.882],
    )


class GetStatistics200ResponseStatisticsFinancialsCashFlow(BaseModel):
    operating_cash_flow_ttm: Optional[float] = Field(
        None,
        description="Refers to operating cash flow measure over the last 12 months",
        examples=[104414003200],
    )
    levered_free_cash_flow_ttm: Optional[float] = Field(
        None,
        description="Refers to levered free cash flow measure over the last 12 months",
        examples=[80625876992],
    )


class GetStatistics200ResponseStatisticsFinancials(BaseModel):
    fiscal_year_ends: Optional[str] = Field(
        None,
        description="Refers to the completion of the last 12-month accounting period",
        examples=["2020-09-26"],
    )
    most_recent_quarter: Optional[str] = Field(
        None,
        description="The most recent quarter (MRQ) refers to the fiscal quarter that most recently ended",
        examples=["2021-06-26"],
    )
    gross_margin: Optional[float] = Field(
        None,
        description="The portion of a company's revenue left over after direct costs are subtracted",
        examples=[46.57807],
    )
    profit_margin: Optional[float] = Field(
        None,
        description="Refers to gross profit margin. Calculated by dividing net income by sales revenue",
        examples=[0.25004],
    )
    operating_margin: Optional[float] = Field(
        None,
        description="Operating margin is calculated by dividing operating income by net sales",
        examples=[0.28788],
    )
    return_on_assets_ttm: Optional[float] = Field(
        None,
        description="Return on assets (ROA) is calculated by dividing net income by total assets",
        examples=[0.19302],
    )
    return_on_equity_ttm: Optional[float] = Field(
        None,
        description="Return on equity (ROE) is calculated by dividing net income by average shareholders' equity",
        examples=[1.27125],
    )
    income_statement: Optional[
        GetStatistics200ResponseStatisticsFinancialsIncomeStatement
    ] = None
    balance_sheet: Optional[
        GetStatistics200ResponseStatisticsFinancialsBalanceSheet
    ] = None
    cash_flow: Optional[GetStatistics200ResponseStatisticsFinancialsCashFlow] = None


class GetStatistics200ResponseStatisticsStockStatistics(BaseModel):
    shares_outstanding: Optional[float] = Field(
        None,
        description="Refers for the shares outstanding currently held by all its shareholders",
        examples=[16530199552],
    )
    float_shares: Optional[float] = Field(
        None,
        description="Refers to floating stock is the number of public shares a company has available for trading on the open market",
        examples=[16513305231],
    )
    avg_10_volume: Optional[int] = Field(
        None, description="Refers to the average 10 days volume", examples=[72804757]
    )
    avg_90_volume: Optional[int] = Field(
        None, description="Refers to the average 90 days volume", examples=[77013078]
    )
    shares_short: Optional[int] = Field(
        None,
        description="Refers to the number of shares that have been shorted",
        examples=[93105968],
    )
    short_ratio: Optional[float] = Field(
        None, description="Refers to short ratio measure", examples=[1.19]
    )
    short_percent_of_shares_outstanding: Optional[float] = Field(
        None,
        description="Refers to the number of shorted shares divided by the number of shares outstanding",
        examples=[0.0056],
    )
    percent_held_by_insiders: Optional[float] = Field(
        None,
        description="Refers to the percentage of shares held by the company insiders",
        examples=[0.00071000005],
    )
    percent_held_by_institutions: Optional[float] = Field(
        None,
        description="Refers to the percentage of shares held by the institutions",
        examples=[0.58474],
    )


class GetStatistics200ResponseStatisticsStockPriceSummary(BaseModel):
    fifty_two_week_low: Optional[float] = Field(
        None,
        description="Refers to the lowest price at which stock traded during a year",
        examples=[103.1],
    )
    fifty_two_week_high: Optional[float] = Field(
        None,
        description="Refers to the highest price at which stock traded during a year",
        examples=[157.26],
    )
    fifty_two_week_change: Optional[float] = Field(
        None,
        description="Refers to the change between lowest and highest prices during a year",
        examples=[0.375625],
    )
    beta: Optional[float] = Field(
        None,
        description="Refers to beta measure relative to the primary benchmark (index) of the country",
        examples=[1.201965],
    )
    day_50_ma: Optional[float] = Field(
        None,
        description="Refers to the 50-day simple moving average",
        examples=[148.96686],
    )
    day_200_ma: Optional[float] = Field(
        None,
        description="Refers to the 200-day simple moving average",
        examples=[134.42506],
    )


class GetStatistics200ResponseStatisticsDividendsAndSplits(BaseModel):
    forward_annual_dividend_rate: Optional[float] = Field(
        None,
        description="Refers to the forward dividend yield estimation in the currency of instrument",
        examples=[0.88],
    )
    forward_annual_dividend_yield: Optional[float] = Field(
        None,
        description="Refers to the forward dividend yield percentage relative to stock price",
        examples=[0.0057],
    )
    trailing_annual_dividend_rate: Optional[float] = Field(
        None,
        description="Refers to the trailing dividend yield rate in the currency of instrument over the last 12 months",
        examples=[0.835],
    )
    trailing_annual_dividend_yield: Optional[float] = Field(
        None,
        description="Refers to the trailing dividend yield percentage relative to stock price",
        examples=[0.0053832764],
    )
    field_5_year_average_dividend_yield: Optional[float] = Field(
        None,
        alias="5_year_average_dividend_yield",
        description="Refers to the average 5 years dividend yield",
        examples=[1.27],
    )
    payout_ratio: Optional[float] = Field(
        None,
        description="Refers to payout ratio, showing the proportion of earnings a company pays its shareholders in the form of dividends",
        examples=[0.16309999],
    )
    dividend_frequency: Optional[str] = Field(
        None,
        description="Refers to how often a stock or fund pays dividends",
        examples=["Quarterly"],
    )
    dividend_date: Optional[str] = Field(
        None,
        description="Refers to the last dividend payout date",
        examples=["2021-08-12"],
    )
    ex_dividend_date: Optional[str] = Field(
        None,
        description="Refers to the last ex-dividend payout date",
        examples=["2021-08-06"],
    )
    last_split_factor: Optional[str] = Field(
        None,
        description="Specification of the last split event",
        examples=["4-for-1 split"],
    )
    last_split_date: Optional[str] = Field(
        None, description="Refers for the last split date", examples=["2020-08-31"]
    )


class GetStatistics200ResponseStatistics(BaseModel):
    valuations_metrics: Optional[
        GetStatistics200ResponseStatisticsValuationsMetrics
    ] = None
    financials: Optional[GetStatistics200ResponseStatisticsFinancials] = None
    stock_statistics: Optional[GetStatistics200ResponseStatisticsStockStatistics] = None
    stock_price_summary: Optional[
        GetStatistics200ResponseStatisticsStockPriceSummary
    ] = None
    dividends_and_splits: Optional[
        GetStatistics200ResponseStatisticsDividendsAndSplits
    ] = None


class GetStatistics200Response(BaseModel):
    meta: Optional[GetStatistics200ResponseMeta] = None
    statistics: Optional[GetStatistics200ResponseStatistics] = None


class GetTimeSeriesStdDev200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["STDDEV - Standard Deviation"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )
    sd: Optional[float] = Field(
        None,
        description="The standard deviation applied in the calculation",
        examples=[2],
    )


class GetTimeSeriesStdDev200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesStdDev200ResponseMetaIndicator] = None


class GetTimeSeriesStdDev200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    stddev: Optional[str] = Field(
        None, description="Standard Deviation value", examples=["0.86613"]
    )


class GetTimeSeriesStdDev200Response(BaseModel):
    meta: Optional[GetTimeSeriesStdDev200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesStdDev200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesStoch200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["STOCH - Stochastic Oscillator"],
    )
    fast_k_period: Optional[int] = Field(
        None,
        description="The time period for the fast %K line in the Stochastic Oscillator",
        examples=[14],
    )
    slow_k_period: Optional[int] = Field(
        None,
        description="The time period for the slow %K line in the Stochastic Oscillator",
        examples=[1],
    )
    slow_d_period: Optional[int] = Field(
        None,
        description="The time period for the slow %D line in the Stochastic Oscillator",
        examples=[3],
    )
    slow_kma_type: Optional[str] = Field(
        None, description="The type of slow %K Moving Average used", examples=["SMA"]
    )
    slow_dma_type: Optional[str] = Field(
        None,
        description="The type of slow Displaced Moving Average used",
        examples=["SMA"],
    )


class GetTimeSeriesStoch200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesStoch200ResponseMetaIndicator] = None


class GetTimeSeriesStoch200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    slow_k: Optional[str] = Field(
        None, description="slow_k value", examples=["11.35168"]
    )
    slow_d: Optional[str] = Field(None, description="slow_d value", examples=["7.5293"])


class GetTimeSeriesStoch200Response(BaseModel):
    meta: Optional[GetTimeSeriesStoch200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesStoch200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesStochF200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["STOCHF - Stochastic Fast"],
    )
    fast_k_period: Optional[int] = Field(
        None,
        description="The fast_k period used for calculation in the indicator",
        examples=[14],
    )
    fast_d_period: Optional[int] = Field(
        None,
        description="The fast_d period used for calculation in the indicator",
        examples=[3],
    )
    fast_dma_type: Optional[str] = Field(
        None,
        description="The type of fast Displaced Moving Average used",
        examples=["SMA"],
    )


class GetTimeSeriesStochF200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesStochF200ResponseMetaIndicator] = None


class GetTimeSeriesStochF200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    fast_k: Optional[str] = Field(
        None, description="fast_k value", examples=["11.35168"]
    )
    fast_d: Optional[str] = Field(None, description="fast_d value", examples=["7.5293"])


class GetTimeSeriesStochF200Response(BaseModel):
    meta: Optional[GetTimeSeriesStochF200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesStochF200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesStochRsi200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["STOCHRSI - Stochastic RSI"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    rsi_length: Optional[int] = Field(
        None,
        description="Length of period for calculating the RSI component",
        examples=[14],
    )
    stoch_length: Optional[int] = Field(
        None,
        description="Period length for computing the stochastic oscillator of the RSI",
        examples=[14],
    )
    k_period: Optional[int] = Field(
        None, description="Period for smoothing the %K line", examples=[3]
    )
    d_period: Optional[int] = Field(
        None,
        description="Period for smoothing the %D line, which is a moving average of %K",
        examples=[3],
    )


class GetTimeSeriesStochRsi200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesStochRsi200ResponseMetaIndicator] = None


class GetTimeSeriesStochRsi200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    k: Optional[str] = Field(None, description="K value", examples=["100.0"])
    d: Optional[str] = Field(None, description="D value", examples=["33.33333"])


class GetTimeSeriesStochRsi200Response(BaseModel):
    meta: Optional[GetTimeSeriesStochRsi200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesStochRsi200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesSub200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["SUB - Arithmetic Subtraction"],
    )
    series_type_1: Optional[str] = Field(
        None,
        description="First price data type on which technical indicator is calculated",
        examples=["open"],
    )
    series_type_2: Optional[str] = Field(
        None,
        description="Second price data type on which technical indicator is calculated",
        examples=["close"],
    )


class GetTimeSeriesSub200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesSub200ResponseMetaIndicator] = None


class GetTimeSeriesSub200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    sub: Optional[str] = Field(None, description="SUB value", examples=["0.404"])


class GetTimeSeriesSub200Response(BaseModel):
    meta: Optional[GetTimeSeriesSub200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesSub200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesSum200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["SUM - Vector Summation"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesSum200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesSum200ResponseMetaIndicator] = None


class GetTimeSeriesSum200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    sum: Optional[str] = Field(None, description="Sum value", examples=["1812.70842"])


class GetTimeSeriesSum200Response(BaseModel):
    meta: Optional[GetTimeSeriesSum200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesSum200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesSuperTrend200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["SUPERTREND - SuperTrend Indicator"],
    )
    period: Optional[int] = Field(
        None,
        description="The period used for calculation in the indicator",
        examples=[10],
    )
    multiplier: Optional[int] = Field(
        None,
        description="The factor used to adjust the indicator's sensitivity",
        examples=[3],
    )


class GetTimeSeriesSuperTrend200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesSuperTrend200ResponseMetaIndicator] = None


class GetTimeSeriesSuperTrend200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    supertrend: Optional[str] = Field(
        None, description="SuperTrend value", examples=["201.56432"]
    )


class GetTimeSeriesSuperTrend200Response(BaseModel):
    meta: Optional[GetTimeSeriesSuperTrend200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesSuperTrend200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesSuperTrendHeikinAshiCandles200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=[
            "SUPERTREND_HEIKINASHICANDLES - SuperTrendHeikinAshiCandles Indicator"
        ],
    )
    period: Optional[int] = Field(
        None,
        description="The period used for calculation in the indicator",
        examples=[10],
    )
    multiplier: Optional[int] = Field(
        None,
        description="The multiplier used for calculation in the indicator",
        examples=[3],
    )


class GetTimeSeriesSuperTrendHeikinAshiCandles200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[
        GetTimeSeriesSuperTrendHeikinAshiCandles200ResponseMetaIndicator
    ] = None


class GetTimeSeriesSuperTrendHeikinAshiCandles200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    supertrend: Optional[str] = Field(
        None, description="SuperTrend value", examples=["201.66713"]
    )
    heikinhighs: Optional[str] = Field(
        None, description="Heikin-Ashi high values", examples=["201.25599"]
    )
    heikinopens: Optional[str] = Field(
        None, description="Heikin-Ashi open values", examples=["200.9825"]
    )
    heikincloses: Optional[str] = Field(
        None, description="Heikin-Ashi close values", examples=["201.02449"]
    )
    heikinlows: Optional[str] = Field(
        None, description="Heikin-Ashi low values", examples=["200.85199"]
    )


class GetTimeSeriesSuperTrendHeikinAshiCandles200Response(BaseModel):
    meta: Optional[GetTimeSeriesSuperTrendHeikinAshiCandles200ResponseMeta] = None
    values: Optional[
        List[GetTimeSeriesSuperTrendHeikinAshiCandles200ResponseValuesInner]
    ] = Field(None, description="Array of time series data points")
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesT3ma200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["T3MA - Triple Exponential Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )
    v_factor: Optional[float] = Field(
        None,
        description="The factor used to adjust the indicator's volatility",
        examples=[0.7],
    )


class GetTimeSeriesT3ma200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesT3ma200ResponseMetaIndicator] = None


class GetTimeSeriesT3ma200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    t3ma: Optional[str] = Field(None, description="T3MA value", examples=["201.56277"])


class GetTimeSeriesT3ma200Response(BaseModel):
    meta: Optional[GetTimeSeriesT3ma200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesT3ma200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTaxInfo200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested",
        examples=["ALM"],
    )
    name: Optional[str] = Field(
        None, description="The instrument name", examples=["Almirall SA"]
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded",
        examples=["BME"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded",
        examples=["XMAD"],
    )
    country: Optional[str] = Field(
        None, description="The instrument country name", examples=["Spain"]
    )


class GetTaxInfo200ResponseData(BaseModel):
    tax_indicator: Optional[str] = Field(
        None,
        description="The instrument tax indicator, can be `null`, `us_1446f`, `spanish_ftt`, `uk_stamp_duty`, `hk_stamp_duty`, `french_ftt` or `italian_ftt`",
        examples=["spanish_ftt"],
    )


class GetTaxInfo200Response(BaseModel):
    meta: Optional[GetTaxInfo200ResponseMeta] = None
    data: Optional[GetTaxInfo200ResponseData] = None
    status: Optional[str] = Field(
        None,
        description="The status of the request, e.g., `ok`, `error`",
        examples=["ok"],
    )


class GetTechnicalIndicators200ResponseDataValue(BaseModel):
    enable: Optional[bool] = Field(
        None,
        description="If the indicator is tested, approved and is recommended for use returns <code>true</code>, otherwise returns <code>false</code>",
        examples=[True],
    )
    full_name: Optional[str] = Field(
        None,
        description="Full indicator name",
        examples=["Moving Average Convergence Divergence"],
    )
    description: Optional[str] = Field(
        None,
        description="Brief description of the indicator",
        examples=["Moving Average Convergence Divergence(MACD) is ..."],
    )
    type: Optional[str] = Field(
        None,
        description="Group to which indicator belongs to",
        examples=["Momentum Indicators"],
    )
    overlay: Optional[bool] = Field(
        None,
        description="If indicator should be plotted over price bars returns <code>true</code>, otherwise returns <code>false</code>",
        examples=[False],
    )
    output_values: Optional[TechnicalIndicatorsResponseMacdOutputValues] = None
    parameters: Optional[TechnicalIndicatorsResponseMacdParameters] = None
    tinting: Optional[TechnicalIndicatorsResponseMacdTinting] = None


class GetTechnicalIndicators200Response(BaseModel):
    data: Optional[Dict[str, GetTechnicalIndicators200ResponseDataValue]] = Field(
        None, description="Map of technical indicators available at Twelve Data API"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesTema200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["TEMA - Triple Exponential Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesTema200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesTema200ResponseMetaIndicator] = None


class GetTimeSeriesTema200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    tema: Optional[str] = Field(None, description="TEMA value", examples=["200.83136"])


class GetTimeSeriesTema200Response(BaseModel):
    meta: Optional[GetTimeSeriesTema200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesTema200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeries200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )


class GetTimeSeries200Response(BaseModel):
    meta: Optional[GetTimeSeries200ResponseMeta] = None
    values: Optional[List[TimeSeriesItem]] = Field(
        None, description="List of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesCross200Response(BaseModel):
    meta: Optional[CrossMeta] = None
    values: Optional[List[TimeSeriesCrossItem]] = Field(
        None, description="Array of time series data points"
    )


class GetTimeSeriesTRange200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["TRANGE - True Range"],
    )


class GetTimeSeriesTRange200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesTRange200ResponseMetaIndicator] = None


class GetTimeSeriesTRange200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    trange: Optional[str] = Field(None, description="trange value", examples=["0.404"])


class GetTimeSeriesTRange200Response(BaseModel):
    meta: Optional[GetTimeSeriesTRange200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesTRange200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesTrima200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["TRIMA - Triangular Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesTrima200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesTrima200ResponseMetaIndicator] = None


class GetTimeSeriesTrima200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    trima: Optional[str] = Field(
        None, description="TRIMA value", examples=["201.36415"]
    )


class GetTimeSeriesTrima200Response(BaseModel):
    meta: Optional[GetTimeSeriesTrima200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesTrima200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesTsf200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["TSF - Time Series Forecast"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesTsf200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesTsf200ResponseMetaIndicator] = None


class GetTimeSeriesTsf200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    tsf: Optional[str] = Field(None, description="TSF value", examples=["200.63858"])


class GetTimeSeriesTsf200Response(BaseModel):
    meta: Optional[GetTimeSeriesTsf200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesTsf200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesTypPrice200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["TYPPRICE - Typical Price"],
    )


class GetTimeSeriesTypPrice200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesTypPrice200ResponseMetaIndicator] = None


class GetTimeSeriesTypPrice200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    typprice: Optional[str] = Field(
        None, description="typprice value", examples=["201.05266"]
    )


class GetTimeSeriesTypPrice200Response(BaseModel):
    meta: Optional[GetTimeSeriesTypPrice200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesTypPrice200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesUltOsc200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ULTOSC - Ultimate Oscillator"],
    )
    time_period_1: Optional[int] = Field(
        None,
        description="The first time period used for calculation in the indicator",
        examples=[7],
    )
    time_period_2: Optional[int] = Field(
        None,
        description="The second time period used for calculation in the indicator",
        examples=[14],
    )
    time_period_3: Optional[int] = Field(
        None,
        description="The third time period used for calculation in the indicator",
        examples=[28],
    )


class GetTimeSeriesUltOsc200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesUltOsc200ResponseMetaIndicator] = None


class GetTimeSeriesUltOsc200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    ultosc: Optional[str] = Field(
        None, description="Ultimate Oscillator value", examples=["25.17927"]
    )


class GetTimeSeriesUltOsc200Response(BaseModel):
    meta: Optional[GetTimeSeriesUltOsc200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesUltOsc200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesVar200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["VAR - Variance"]
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesVar200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesVar200ResponseMetaIndicator] = None


class GetTimeSeriesVar200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    var: Optional[str] = Field(None, description="VAR value", examples=["0.18755"])


class GetTimeSeriesVar200Response(BaseModel):
    meta: Optional[GetTimeSeriesVar200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesVar200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesVwap200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["VWAP - Volume Weighted Average Price"],
    )
    sd_time_period: Optional[int] = Field(
        None, description="Standard deviation time period"
    )
    sd: Optional[float] = Field(None, description="Standard deviation value")


class GetTimeSeriesVwap200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesVwap200ResponseMetaIndicator] = None


class GetTimeSeriesVwap200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    vwap_lower: Optional[float] = Field(
        None, description="VWAP lower value", examples=[201.05266]
    )
    vwap: Optional[float] = Field(None, description="VWAP value", examples=[201.05266])
    vwap_upper: Optional[float] = Field(
        None, description="VWAP upper value", examples=[201.05266]
    )


class GetTimeSeriesVwap200Response(BaseModel):
    meta: Optional[GetTimeSeriesVwap200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesVwap200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesWclPrice200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["WCLPRICE - Weighted Close Price"],
    )


class GetTimeSeriesWclPrice200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesWclPrice200ResponseMetaIndicator] = None


class GetTimeSeriesWclPrice200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    wclprice: Optional[float] = Field(
        None, description="wclprice value", examples=[201.052]
    )


class GetTimeSeriesWclPrice200Response(BaseModel):
    meta: Optional[GetTimeSeriesWclPrice200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesWclPrice200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesWillR200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["WILLR - Williams %R"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesWillR200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesWillR200ResponseMetaIndicator] = None


class GetTimeSeriesWillR200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    willr: Optional[str] = Field(
        None, description="Williams %R value", examples=["-84.8916"]
    )


class GetTimeSeriesWillR200Response(BaseModel):
    meta: Optional[GetTimeSeriesWillR200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesWillR200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetTimeSeriesWma200ResponseMetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["WMA - Weighted Moving Average"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )
    time_period: Optional[int] = Field(
        None,
        description="The time period used for calculation in the indicator",
        examples=[9],
    )


class GetTimeSeriesWma200ResponseMeta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[GetTimeSeriesWma200ResponseMetaIndicator] = None


class GetTimeSeriesWma200ResponseValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2019-08-09 15:59:00"],
    )
    wma: Optional[str] = Field(None, description="WMA value", examples=["201.20579"])


class GetTimeSeriesWma200Response(BaseModel):
    meta: Optional[GetTimeSeriesWma200ResponseMeta] = None
    values: Optional[List[GetTimeSeriesWma200ResponseValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class AssetsInfoCurrentAssetsReceivables(BaseModel):
    total_receivables: Optional[float] = Field(
        None, description="Total receivables", examples=[60985000000]
    )
    accounts_receivable: Optional[float] = Field(
        None, description="Accounts receivable", examples=[29508000000]
    )
    gross_accounts_receivable: Optional[float] = Field(
        None, description="Gross accounts receivable", examples=[29508000000]
    )
    allowance_for_doubtful_accounts_receivable: Optional[float] = Field(
        None,
        description="Allowance for doubtful accounts receivable",
        examples=[29508000000],
    )
    receivables_adjustments_allowances: Optional[float] = Field(
        None, description="Receivables adjustments allowances", examples=[29508000000]
    )
    other_receivables: Optional[float] = Field(
        None, description="Other receivables", examples=[31477000000]
    )
    due_from_related_parties_current: Optional[float] = Field(
        None, description="Due from related parties current", examples=[31477000000]
    )
    taxes_receivable: Optional[float] = Field(
        None, description="Taxes receivable", examples=[31477000000]
    )
    accrued_interest_receivable: Optional[float] = Field(
        None, description="Accrued interest receivable", examples=[31477000000]
    )
    notes_receivable: Optional[float] = Field(
        None, description="Notes receivable", examples=[31477000000]
    )
    loans_receivable: Optional[float] = Field(
        None, description="Loans receivable", examples=[31477000000]
    )


class AssetsInfoCurrentAssetsInventory(BaseModel):
    total_inventory: Optional[float] = Field(
        None, description="Total inventory", examples=[6331000000]
    )
    inventories_adjustments_allowances: Optional[float] = Field(
        None, description="Inventories adjustments allowances", examples=[6331000000]
    )
    other_inventories: Optional[float] = Field(
        None, description="Other inventories", examples=[6331000000]
    )
    finished_goods: Optional[float] = Field(
        None, description="Finished goods", examples=[6331000000]
    )
    work_in_process: Optional[float] = Field(
        None, description="Work in process", examples=[6331000000]
    )
    raw_materials: Optional[float] = Field(
        None, description="Raw materials", examples=[6331000000]
    )


class AssetsInfoCurrentAssets(BaseModel):
    total_current_assets: Optional[float] = Field(
        None, description="Total current assets", examples=[143566000000]
    )
    cash_cash_equivalents_and_short_term_investments: Optional[float] = Field(
        None,
        description="Cash cash equivalents and short term investments",
        examples=[61555000000],
    )
    cash_and_cash_equivalents: Optional[float] = Field(
        None, description="Cash and cash equivalents", examples=[29965000000]
    )
    cash_equivalents: Optional[float] = Field(
        None, description="Cash equivalents", examples=[1606000000]
    )
    cash_financial: Optional[float] = Field(
        None, description="Cash financial", examples=[28359000000]
    )
    other_short_term_investments: Optional[float] = Field(
        None, description="Other short term investments", examples=[31590000000]
    )
    restricted_cash: Optional[float] = Field(
        None, description="Restricted cash", examples=[31590000000]
    )
    receivables: Optional[AssetsInfoCurrentAssetsReceivables] = None
    inventory: Optional[AssetsInfoCurrentAssetsInventory] = None
    prepaid_assets: Optional[float] = Field(
        None, description="Prepaid assets", examples=[14695000000]
    )
    current_deferred_assets: Optional[float] = Field(
        None, description="Current deferred assets", examples=[14695000000]
    )
    current_deferred_taxes_assets: Optional[float] = Field(
        None, description="Current deferred taxes assets", examples=[14695000000]
    )
    assets_held_for_sale_current: Optional[float] = Field(
        None, description="Assets held for sale current", examples=[14695000000]
    )
    hedging_assets_current: Optional[float] = Field(
        None, description="Hedging assets current", examples=[14695000000]
    )
    other_current_assets: Optional[float] = Field(
        None, description="Other current assets", examples=[14695000000]
    )


class AssetsInfoNonCurrentAssetsGoodwillAndOtherIntangibleAssets(BaseModel):
    goodwill: Optional[float] = Field(
        None, description="Goodwill", examples=[100544000000]
    )
    other_intangible_assets: Optional[float] = Field(
        None, description="Other intangible assets", examples=[100544000000]
    )
    total_goodwill_and_intangible_assets: Optional[float] = Field(
        None,
        description="Total goodwill and intangible assets",
        examples=[100544000000],
    )


class AssetsInfoNonCurrentAssets(BaseModel):
    total_non_current_assets: Optional[float] = Field(
        None, description="Total non current assets", examples=[209017000000]
    )
    financial_assets: Optional[float] = Field(
        None, description="Financial assets", examples=[209017000000]
    )
    investments_and_advances: Optional[float] = Field(
        None, description="Investments and advances", examples=[100544000000]
    )
    other_investments: Optional[float] = Field(
        None, description="Other investments", examples=[100544000000]
    )
    investment_in_financial_assets: Optional[float] = Field(
        None, description="Investment in financial assets", examples=[100544000000]
    )
    held_to_maturity_securities: Optional[float] = Field(
        None, description="Held to maturity securities", examples=[100544000000]
    )
    available_for_sale_securities: Optional[float] = Field(
        None, description="Available for sale securities", examples=[100544000000]
    )
    financial_assets_designated_as_fair_value_through_profit_or_loss_total: Optional[
        float
    ] = Field(
        None,
        description="Financial assets designated as fair value through profit or loss total",
        examples=[100544000000],
    )
    trading_securities: Optional[float] = Field(
        None, description="Trading securities", examples=[100544000000]
    )
    long_term_equity_investment: Optional[float] = Field(
        None, description="Long term equity investment", examples=[100544000000]
    )
    investments_in_joint_ventures_at_cost: Optional[float] = Field(
        None,
        description="Investments in joint ventures at cost",
        examples=[100544000000],
    )
    investments_in_other_ventures_under_equity_method: Optional[float] = Field(
        None,
        description="Investments in other ventures under equity method",
        examples=[100544000000],
    )
    investments_in_associates_at_cost: Optional[float] = Field(
        None, description="Investments in associates at cost", examples=[100544000000]
    )
    investments_in_subsidiaries_at_cost: Optional[float] = Field(
        None, description="Investments in subsidiaries at cost", examples=[100544000000]
    )
    investment_properties: Optional[float] = Field(
        None, description="Investment properties", examples=[100544000000]
    )
    goodwill_and_other_intangible_assets: Optional[
        AssetsInfoNonCurrentAssetsGoodwillAndOtherIntangibleAssets
    ] = None
    net_ppe: Optional[float] = Field(
        None, description="Net ppe", examples=[54376000000]
    )
    gross_ppe: Optional[float] = Field(
        None, description="Gross ppe", examples=[125260000000]
    )
    accumulated_depreciation: Optional[float] = Field(
        None, description="Accumulated depreciation", examples=[-70884000000]
    )
    leases: Optional[float] = Field(None, description="Leases", examples=[12839000000])
    construction_in_progress: Optional[float] = Field(
        None, description="Construction in progress", examples=[12839000000]
    )
    other_properties: Optional[float] = Field(
        None, description="Other properties", examples=[10661000000]
    )
    machinery_furniture_equipment: Optional[float] = Field(
        None, description="Machinery furniture equipment", examples=[78314000000]
    )
    buildings_and_improvements: Optional[float] = Field(
        None, description="Buildings and improvements", examples=[12839000000]
    )
    land_and_improvements: Optional[float] = Field(
        None, description="Land and improvements", examples=[23446000000]
    )
    properties: Optional[float] = Field(None, description="Properties", examples=[0])
    non_current_accounts_receivable: Optional[float] = Field(
        None, description="Non current accounts receivable", examples=[12839000000]
    )
    non_current_note_receivables: Optional[float] = Field(
        None, description="Non current note receivables", examples=[12839000000]
    )
    due_from_related_parties_non_current: Optional[float] = Field(
        None, description="Due from related parties non current", examples=[12839000000]
    )
    non_current_prepaid_assets: Optional[float] = Field(
        None, description="Non current prepaid assets", examples=[12839000000]
    )
    non_current_deferred_assets: Optional[float] = Field(
        None, description="Non current deferred assets", examples=[17852000000]
    )
    non_current_deferred_taxes_assets: Optional[float] = Field(
        None, description="Non current deferred taxes assets", examples=[17852000000]
    )
    defined_pension_benefit: Optional[float] = Field(
        None, description="Defined pension benefit", examples=[12839000000]
    )
    other_non_current_assets: Optional[float] = Field(
        None, description="Other non current assets", examples=[36245000000]
    )


class AssetsInfoLiabilitiesCurrentLiabilitiesPayablesAndAccruedExpenses(BaseModel):
    total_payables_and_accrued_expenses: Optional[float] = Field(
        None, description="Total payables and accrued expenses", examples=[71430000000]
    )
    accounts_payable: Optional[float] = Field(
        None, description="Accounts payable", examples=[62611000000]
    )
    current_accrued_expenses: Optional[float] = Field(
        None, description="Current accrued expenses", examples=[9822000000]
    )
    interest_payable: Optional[float] = Field(
        None, description="Interest payable", examples=[9822000000]
    )
    payables: Optional[float] = Field(
        None, description="Payables", examples=[71430000000]
    )
    other_payable: Optional[float] = Field(
        None, description="Other payable", examples=[9822000000]
    )
    due_to_related_parties_current: Optional[float] = Field(
        None, description="Due to related parties current", examples=[9822000000]
    )
    dividends_payable: Optional[float] = Field(
        None, description="Dividends payable", examples=[9822000000]
    )
    total_tax_payable: Optional[float] = Field(
        None, description="Total tax payable", examples=[8819000000]
    )
    income_tax_payable: Optional[float] = Field(
        None, description="Income tax payable", examples=[8819000000]
    )


class AssetsInfoLiabilitiesCurrentLiabilities(BaseModel):
    total_current_liabilities: Optional[float] = Field(
        None, description="Total current liabilities", examples=[145308000000]
    )
    current_debt_and_capital_lease_obligation: Optional[float] = Field(
        None,
        description="Current debt and capital lease obligation",
        examples=[17382000000],
    )
    current_debt: Optional[float] = Field(
        None, description="Current debt", examples=[15807000000]
    )
    current_capital_lease_obligation: Optional[float] = Field(
        None, description="Current capital lease obligation", examples=[1575000000]
    )
    other_current_borrowings: Optional[float] = Field(
        None, description="Other current borrowings", examples=[9822000000]
    )
    line_of_credit: Optional[float] = Field(
        None, description="Line of credit", examples=[9822000000]
    )
    commercial_paper: Optional[float] = Field(
        None, description="Commercial paper", examples=[5985000000]
    )
    current_notes_payable: Optional[float] = Field(
        None, description="Current notes payable", examples=[9822000000]
    )
    current_provisions: Optional[float] = Field(
        None, description="Current provisions", examples=[9822000000]
    )
    payables_and_accrued_expenses: Optional[
        AssetsInfoLiabilitiesCurrentLiabilitiesPayablesAndAccruedExpenses
    ] = None
    pension_and_other_post_retirement_benefit_plans_current: Optional[float] = Field(
        None,
        description="Pension and other post retirement benefit plans current",
        examples=[8061000000],
    )
    employee_benefits: Optional[float] = Field(
        None, description="Employee benefits", examples=[8061000000]
    )
    current_deferred_liabilities: Optional[float] = Field(
        None, description="Current deferred liabilities", examples=[8061000000]
    )
    current_deferred_revenue: Optional[float] = Field(
        None, description="Current deferred revenue", examples=[8061000000]
    )
    current_deferred_taxes_liabilities: Optional[float] = Field(
        None, description="Current deferred taxes liabilities", examples=[8061000000]
    )
    other_current_liabilities: Optional[float] = Field(
        None, description="Other current liabilities", examples=[48435000000]
    )
    liabilities_held_for_sale_non_current: Optional[float] = Field(
        None,
        description="Liabilities held for sale non current",
        examples=[48435000000],
    )


class AssetsInfoLiabilitiesNonCurrentLiabilitiesLongTermDebtAndCapitalLeaseObligation(
    BaseModel
):
    total_long_term_debt_and_capital_lease_obligation: Optional[float] = Field(
        None,
        description="Total long term debt and capital lease obligation",
        examples=[106548000000],
    )
    long_term_debt: Optional[float] = Field(
        None, description="Long term debt", examples=[95281000000]
    )
    long_term_capital_lease_obligation: Optional[float] = Field(
        None, description="Long term capital lease obligation", examples=[11267000000]
    )


class AssetsInfoLiabilitiesNonCurrentLiabilities(BaseModel):
    total_non_current_liabilities_net_minority_interest: Optional[float] = Field(
        None,
        description="Total non current liabilities net minority interest",
        examples=[145129000000],
    )
    long_term_debt_and_capital_lease_obligation: Optional[
        AssetsInfoLiabilitiesNonCurrentLiabilitiesLongTermDebtAndCapitalLeaseObligation
    ] = None
    long_term_provisions: Optional[float] = Field(
        None, description="Long term provisions", examples=[15457000000]
    )
    non_current_pension_and_other_postretirement_benefit_plans: Optional[float] = Field(
        None,
        description="Non current pension and other postretirement benefit plans",
        examples=[15457000000],
    )
    non_current_accrued_expenses: Optional[float] = Field(
        None, description="Non current accrued expenses", examples=[15457000000]
    )
    due_to_related_parties_non_current: Optional[float] = Field(
        None, description="Due to related parties non current", examples=[15457000000]
    )
    trade_and_other_payables_non_current: Optional[float] = Field(
        None, description="Trade and other payables non current", examples=[15457000000]
    )
    non_current_deferred_liabilities: Optional[float] = Field(
        None, description="Non current deferred liabilities", examples=[15457000000]
    )
    non_current_deferred_revenue: Optional[float] = Field(
        None, description="Non current deferred revenue", examples=[15457000000]
    )
    non_current_deferred_taxes_liabilities: Optional[float] = Field(
        None,
        description="Non current deferred taxes liabilities",
        examples=[15457000000],
    )
    other_non_current_liabilities: Optional[float] = Field(
        None, description="Other non current liabilities", examples=[23124000000]
    )
    preferred_securities_outside_stock_equity: Optional[float] = Field(
        None,
        description="Preferred securities outside stock equity",
        examples=[15457000000],
    )
    derivative_product_liabilities: Optional[float] = Field(
        None, description="Derivative product liabilities", examples=[15457000000]
    )
    capital_lease_obligations: Optional[float] = Field(
        None, description="Capital lease obligations", examples=[12842000000]
    )
    restricted_common_stock: Optional[float] = Field(
        None, description="Restricted common stock", examples=[12842000000]
    )


class CashFlowDataCashFlowFromOperatingActivities(BaseModel):
    net_income_from_continuing_operations: Optional[float] = Field(
        None,
        description="Net income from continuing operations",
        examples=[96995000000],
    )
    operating_cash_flow: Optional[float] = Field(
        None, description="Operating cash flow", examples=[110543000000]
    )
    cash_flow_from_continuing_operating_activities: Optional[float] = Field(
        None,
        description="Cash flow from continuing operating activities",
        examples=[110543000000],
    )
    cash_from_discontinued_operating_activities: Optional[float] = Field(
        None,
        description="Cash from discontinued operating activities",
        examples=[108488000000],
    )
    cash_flow_from_discontinued_operation: Optional[float] = Field(
        None,
        description="Cash flow from discontinued operation",
        examples=[108488000000],
    )
    free_cash_flow: Optional[float] = Field(
        None, description="Free cash flow", examples=[99584000000]
    )
    cash_flows_from_used_in_operating_activities_direct: Optional[float] = Field(
        None,
        description="Cash flows from used in operating activities direct",
        examples=[108488000000],
    )
    taxes_refund_paid: Optional[float] = Field(
        None, description="Taxes refund paid", examples=[108488000000]
    )
    taxes_refund_paid_direct: Optional[float] = Field(
        None, description="Taxes refund paid direct", examples=[108488000000]
    )
    interest_received: Optional[float] = Field(
        None, description="Interest received", examples=[108488000000]
    )
    interest_received_direct: Optional[float] = Field(
        None, description="Interest received direct", examples=[108488000000]
    )
    interest_paid: Optional[float] = Field(
        None, description="Interest paid", examples=[108488000000]
    )
    interest_paid_direct: Optional[float] = Field(
        None, description="Interest paid direct", examples=[108488000000]
    )
    dividend_received: Optional[float] = Field(
        None, description="Dividend received", examples=[108488000000]
    )
    dividend_received_direct: Optional[float] = Field(
        None, description="Dividend received direct", examples=[108488000000]
    )
    dividend_paid: Optional[float] = Field(
        None, description="Dividend paid", examples=[108488000000]
    )
    dividend_paid_direct: Optional[float] = Field(
        None, description="Dividend paid direct", examples=[108488000000]
    )
    change_in_working_capital: Optional[float] = Field(
        None, description="Change in working capital", examples=[-6577000000]
    )
    change_in_other_working_capital: Optional[float] = Field(
        None, description="Change in other working capital", examples=[108488000000]
    )
    change_in_receivables: Optional[float] = Field(
        None, description="Change in receivables", examples=[-417000000]
    )
    changes_in_account_receivables: Optional[float] = Field(
        None, description="Changes in account receivables", examples=[-1688000000]
    )
    change_in_payables_and_accrued_expense: Optional[float] = Field(
        None,
        description="Change in payables and accrued expense",
        examples=[-1889000000],
    )
    change_in_accrued_expense: Optional[float] = Field(
        None, description="Change in accrued expense", examples=[108488000000]
    )
    change_in_payable: Optional[float] = Field(
        None, description="Change in payable", examples=[-1889000000]
    )
    change_in_dividend_payable: Optional[float] = Field(
        None, description="Change in dividend payable", examples=[108488000000]
    )
    change_in_account_payable: Optional[float] = Field(
        None, description="Change in account payable", examples=[-1889000000]
    )
    change_in_tax_payable: Optional[float] = Field(
        None, description="Change in tax payable", examples=[108488000000]
    )
    change_in_income_tax_payable: Optional[float] = Field(
        None, description="Change in income tax payable", examples=[108488000000]
    )
    change_in_interest_payable: Optional[float] = Field(
        None, description="Change in interest payable", examples=[108488000000]
    )
    change_in_other_current_liabilities: Optional[float] = Field(
        None, description="Change in other current liabilities", examples=[3031000000]
    )
    change_in_other_current_assets: Optional[float] = Field(
        None, description="Change in other current assets", examples=[-5684000000]
    )
    change_in_inventory: Optional[float] = Field(
        None, description="Change in inventory", examples=[-1618000000]
    )
    change_in_prepaid_assets: Optional[float] = Field(
        None, description="Change in prepaid assets", examples=[108488000000]
    )
    other_non_cash_items: Optional[float] = Field(
        None, description="Other non cash items", examples=[-2227000000]
    )
    excess_tax_benefit_from_stock_based_compensation: Optional[float] = Field(
        None,
        description="Excess tax benefit from stock based compensation",
        examples=[108488000000],
    )
    stock_based_compensation: Optional[float] = Field(
        None, description="Stock based compensation", examples=[10833000000]
    )
    unrealized_gain_loss_on_investment_securities: Optional[float] = Field(
        None,
        description="Unrealized gain loss on investment securities",
        examples=[108488000000],
    )
    provision_and_write_off_of_assets: Optional[float] = Field(
        None, description="Provision and write off of assets", examples=[108488000000]
    )
    asset_impairment_charge: Optional[float] = Field(
        None, description="Asset impairment charge", examples=[108488000000]
    )
    amortization_of_securities: Optional[float] = Field(
        None, description="Amortization of securities", examples=[108488000000]
    )
    deferred_tax: Optional[float] = Field(
        None, description="Deferred tax", examples=[108488000000]
    )
    deferred_income_tax: Optional[float] = Field(
        None, description="Deferred income tax", examples=[108488000000]
    )
    depreciation_amortization_depletion: Optional[float] = Field(
        None, description="Depreciation amortization depletion", examples=[11519000000]
    )
    depletion: Optional[float] = Field(
        None, description="Depletion", examples=[108488000000]
    )
    depreciation_and_amortization: Optional[float] = Field(
        None, description="Depreciation and amortization", examples=[11519000000]
    )
    amortization_cash_flow: Optional[float] = Field(
        None, description="Amortization cash flow", examples=[108488000000]
    )
    amortization_of_intangibles: Optional[float] = Field(
        None, description="Amortization of intangibles", examples=[108488000000]
    )
    depreciation: Optional[float] = Field(
        None, description="Depreciation", examples=[108488000000]
    )
    operating_gains_losses: Optional[float] = Field(
        None, description="Operating gains losses", examples=[108488000000]
    )
    pension_and_employee_benefit_expense: Optional[float] = Field(
        None,
        description="Pension and employee benefit expense",
        examples=[108488000000],
    )
    earnings_losses_from_equity_investments: Optional[float] = Field(
        None,
        description="Earnings losses from equity investments",
        examples=[108488000000],
    )
    gain_loss_on_investment_securities: Optional[float] = Field(
        None, description="Gain loss on investment securities", examples=[108488000000]
    )
    net_foreign_currency_exchange_gain_loss: Optional[float] = Field(
        None,
        description="Net foreign currency exchange gain loss",
        examples=[108488000000],
    )
    gain_loss_on_sale_of_ppe: Optional[float] = Field(
        None, description="Gain loss on sale of ppe", examples=[108488000000]
    )
    gain_loss_on_sale_of_business: Optional[float] = Field(
        None, description="Gain loss on sale of business", examples=[108488000000]
    )


class CashFlowDataCashFlowFromInvestingActivities(BaseModel):
    investing_cash_flow: Optional[float] = Field(
        None, description="Investing cash flow", examples=[3705000000]
    )
    cash_flow_from_continuing_investing_activities: Optional[float] = Field(
        None,
        description="Cash flow from continuing investing activities",
        examples=[3705000000],
    )
    cash_from_discontinued_investing_activities: Optional[float] = Field(
        None,
        description="Cash from discontinued investing activities",
        examples=[108488000000],
    )
    net_other_investing_changes: Optional[float] = Field(
        None, description="Net other investing changes", examples=[-1337000000]
    )
    interest_received_cfi: Optional[float] = Field(
        None, description="Interest received cfi", examples=[108488000000]
    )
    dividends_received_cfi: Optional[float] = Field(
        None, description="Dividends received cfi", examples=[108488000000]
    )
    net_investment_purchase_and_sale: Optional[float] = Field(
        None, description="Net investment purchase and sale", examples=[16001000000]
    )
    sale_of_investment: Optional[float] = Field(
        None, description="Sale of investment", examples=[45514000000]
    )
    purchase_of_investment: Optional[float] = Field(
        None, description="Purchase of investment", examples=[-29513000000]
    )
    net_investment_properties_purchase_and_sale: Optional[float] = Field(
        None,
        description="Net investment properties purchase and sale",
        examples=[108488000000],
    )
    sale_of_investment_properties: Optional[float] = Field(
        None, description="Sale of investment properties", examples=[108488000000]
    )
    purchase_of_investment_properties: Optional[float] = Field(
        None, description="Purchase of investment properties", examples=[108488000000]
    )
    net_business_purchase_and_sale: Optional[float] = Field(
        None, description="Net business purchase and sale", examples=[108488000000]
    )
    sale_of_business: Optional[float] = Field(
        None, description="Sale of business", examples=[108488000000]
    )
    purchase_of_business: Optional[float] = Field(
        None, description="Purchase of business", examples=[108488000000]
    )
    net_intangibles_purchase_and_sale: Optional[float] = Field(
        None, description="Net intangibles purchase and sale", examples=[108488000000]
    )
    sale_of_intangibles: Optional[float] = Field(
        None, description="Sale of intangibles", examples=[108488000000]
    )
    purchase_of_intangibles: Optional[float] = Field(
        None, description="Purchase of intangibles", examples=[108488000000]
    )
    net_ppe_purchase_and_sale: Optional[float] = Field(
        None, description="Net ppe purchase and sale", examples=[-10959000000]
    )
    sale_of_ppe: Optional[float] = Field(
        None, description="Sale of ppe", examples=[108488000000]
    )
    purchase_of_ppe: Optional[float] = Field(
        None, description="Purchase of ppe", examples=[-10959000000]
    )
    capital_expenditure_reported: Optional[float] = Field(
        None, description="Capital expenditure reported", examples=[108488000000]
    )
    capital_expenditure: Optional[float] = Field(
        None, description="Capital expenditure", examples=[-10959000000]
    )


class CashFlowDataCashFlowFromFinancingActivities(BaseModel):
    financing_cash_flow: Optional[float] = Field(
        None, description="Financing cash flow", examples=[-108488000000]
    )
    cash_flow_from_continuing_financing_activities: Optional[float] = Field(
        None,
        description="Cash flow from continuing financing activities",
        examples=[-108488000000],
    )
    cash_from_discontinued_financing_activities: Optional[float] = Field(
        None,
        description="Cash from discontinued financing activities",
        examples=[108488000000],
    )
    net_other_financing_charges: Optional[float] = Field(
        None, description="Net other financing charges", examples=[-6012000000]
    )
    interest_paid_cff: Optional[float] = Field(
        None, description="Interest paid cff", examples=[108488000000]
    )
    proceeds_from_stock_option_exercised: Optional[float] = Field(
        None,
        description="Proceeds from stock option exercised",
        examples=[108488000000],
    )
    cash_dividends_paid: Optional[float] = Field(
        None, description="Cash dividends paid", examples=[-15025000000]
    )
    preferred_stock_dividend_paid: Optional[float] = Field(
        None, description="Preferred stock dividend paid", examples=[108488000000]
    )
    common_stock_dividend_paid: Optional[float] = Field(
        None, description="Common stock dividend paid", examples=[-15025000000]
    )
    net_preferred_stock_issuance: Optional[float] = Field(
        None, description="Net preferred stock issuance", examples=[108488000000]
    )
    preferred_stock_payments: Optional[float] = Field(
        None, description="Preferred stock payments", examples=[108488000000]
    )
    preferred_stock_issuance: Optional[float] = Field(
        None, description="Preferred stock issuance", examples=[108488000000]
    )
    net_common_stock_issuance: Optional[float] = Field(
        None, description="Net common stock issuance", examples=[-77550000000]
    )
    common_stock_payments: Optional[float] = Field(
        None, description="Common stock payments", examples=[-77550000000]
    )
    common_stock_issuance: Optional[float] = Field(
        None, description="Common stock issuance", examples=[108488000000]
    )
    repurchase_of_capital_stock: Optional[float] = Field(
        None, description="Repurchase of capital stock", examples=[-77550000000]
    )
    net_issuance_payments_of_debt: Optional[float] = Field(
        None, description="Net issuance payments of debt", examples=[-9901000000]
    )
    net_short_term_debt_issuance: Optional[float] = Field(
        None, description="Net short term debt issuance", examples=[-3978000000]
    )
    short_term_debt_payments: Optional[float] = Field(
        None, description="Short term debt payments", examples=[108488000000]
    )
    short_term_debt_issuance: Optional[float] = Field(
        None, description="Short term debt issuance", examples=[108488000000]
    )
    net_long_term_debt_issuance: Optional[float] = Field(
        None, description="Net long term debt issuance", examples=[-5923000000]
    )
    long_term_debt_payments: Optional[float] = Field(
        None, description="Long term debt payments", examples=[-11151000000]
    )
    long_term_debt_issuance: Optional[float] = Field(
        None, description="Long term debt issuance", examples=[5228000000]
    )
    issuance_of_debt: Optional[float] = Field(
        None, description="Issuance of debt", examples=[5228000000]
    )
    repayment_of_debt: Optional[float] = Field(
        None, description="Repayment of debt", examples=[-11151000000]
    )
    issuance_of_capital_stock: Optional[float] = Field(
        None, description="Issuance of capital stock", examples=[108488000000]
    )


class CashFlowDataSupplementalData(BaseModel):
    interest_paid_supplemental_data: Optional[float] = Field(
        None, description="Interest paid supplemental data", examples=[3803000000]
    )
    income_tax_paid_supplemental_data: Optional[float] = Field(
        None, description="Income tax paid supplemental data", examples=[18679000000]
    )


class CashFlowDataForeignAndDomesticSales(BaseModel):
    foreign_sales: Optional[float] = Field(
        None, description="Foreign sales", examples=[108488000000]
    )
    domestic_sales: Optional[float] = Field(
        None, description="Domestic sales", examples=[108488000000]
    )
    adjusted_geography_segment_data: Optional[float] = Field(
        None, description="Adjusted geography segment data", examples=[108488000000]
    )


class CashFlowDataCashPosition(BaseModel):
    beginning_cash_position: Optional[float] = Field(
        None, description="Beginning cash position", examples=[24977000000]
    )
    end_cash_position: Optional[float] = Field(
        None, description="End cash position", examples=[30737000000]
    )
    changes_in_cash: Optional[float] = Field(
        None, description="Changes in cash", examples=[5760000000]
    )
    other_cash_adjustment_outside_change_in_cash: Optional[float] = Field(
        None,
        description="Other cash adjustment outside change in cash",
        examples=[108488000000],
    )
    other_cash_adjustment_inside_change_in_cash: Optional[float] = Field(
        None,
        description="Other cash adjustment inside change in cash",
        examples=[108488000000],
    )
    effect_of_exchange_rate_changes: Optional[float] = Field(
        None, description="Effect of exchange rate changes", examples=[108488000000]
    )


class CashFlowDataDirectMethodCashFlow(BaseModel):
    classes_of_cash_receipts_from_operating_activities: Optional[float] = Field(
        None,
        description="Classes of cash receipts from operating activities",
        examples=[108488000000],
    )
    other_cash_receipts_from_operating_activities: Optional[float] = Field(
        None,
        description="Other cash receipts from operating activities",
        examples=[108488000000],
    )
    receipts_from_government_grants: Optional[float] = Field(
        None, description="Receipts from government grants", examples=[108488000000]
    )
    receipts_from_customers: Optional[float] = Field(
        None, description="Receipts from customers", examples=[108488000000]
    )
    classes_of_cash_payments: Optional[float] = Field(
        None, description="Classes of cash payments", examples=[108488000000]
    )
    other_cash_payments_from_operating_activities: Optional[float] = Field(
        None,
        description="Other cash payments from operating activities",
        examples=[108488000000],
    )
    payments_on_behalf_of_employees: Optional[float] = Field(
        None, description="Payments on behalf of employees", examples=[108488000000]
    )
    payments_to_suppliers_for_goods_and_services: Optional[float] = Field(
        None,
        description="Payments to suppliers for goods and services",
        examples=[108488000000],
    )


class CashFlowStructOperatingActivities(BaseModel):
    net_income: Optional[float] = Field(
        None,
        description="Returns net income (NI). Calculated as sales minus cost of goods sold",
        examples=[34630000000],
    )
    depreciation: Optional[float] = Field(
        None,
        description="Represents depreciation and amortization measure",
        examples=[2697000000],
    )
    deferred_taxes: Optional[float] = Field(
        None,
        description="Stands for taxes that are owed but are not due to be paid until a future date",
        examples=[682000000],
    )
    stock_based_compensation: Optional[float] = Field(
        None,
        description="Refers to share-based compensation as the way of paying employees, executives, and directors of a company with equity in the business",
        examples=[2265000000],
    )
    other_non_cash_items: Optional[float] = Field(
        None, description="Represents other non-cash items", examples=[167000000]
    )
    accounts_receivable: Optional[float] = Field(
        None,
        description="Represents the balance of money due to a firm for goods or services delivered or used but not yet paid for by customers",
        examples=[-13746000000],
    )
    accounts_payable: Optional[float] = Field(
        None,
        description="Refers to an account within the general ledger that represents an obligation to pay off a short-term debt to creditors or suppliers",
        examples=[19813000000],
    )
    other_assets_liabilities: Optional[float] = Field(
        None,
        description="Represents cumulative changes in inventory, other current assets, other current liabilities, and other working capital",
        examples=[458000000],
    )
    operating_cash_flow: Optional[float] = Field(
        None,
        description="Returns operating cash flow (OCF) measure representing a total amount of cash generated by company's normal business operations",
        examples=[46966000000],
    )


class CashFlowStructInvestingActivities(BaseModel):
    capital_expenditures: Optional[float] = Field(
        None,
        description="Capital expenditures (CapEx) are funds used by a company to acquire, upgrade, and maintain physical assets (PPE)",
        examples=[-2803000000],
    )
    net_intangibles: Optional[float] = Field(
        None, description="Represents purchase of a not physical asset", examples=[0]
    )
    net_acquisitions: Optional[float] = Field(
        None,
        description="Refers to net amount of business purchase and sale",
        examples=[0],
    )
    purchase_of_investments: Optional[float] = Field(
        None,
        description="Represents how much money has been used in making investments, including purchases of physical assets, investments in securities",
        examples=[-34913000000],
    )
    sale_of_investments: Optional[float] = Field(
        None,
        description="Represents how much money has been generated from the sale of securities or assets",
        examples=[21984000000],
    )
    other_investing_activity: Optional[float] = Field(
        None, description="Represents other investing activity", examples=[-374000000]
    )
    investing_cash_flow: Optional[float] = Field(
        None,
        description="Returns total amount of cash flow used in investments",
        examples=[-16106000000],
    )


class CashFlowStructFinancingActivities(BaseModel):
    long_term_debt_issuance: Optional[float] = Field(
        None,
        description="Refers to the issuance of any financial obligations that extend beyond a 12 months period",
        examples=[0],
    )
    long_term_debt_payments: Optional[float] = Field(
        None,
        description="Refers to the payments of any financial obligations that extend beyond a 12 months period",
        examples=[0],
    )
    short_term_debt_issuance: Optional[float] = Field(
        None,
        description="Refers to the issuance of any financial obligations that are expected to be paid off within a year",
        examples=[-1000000000],
    )
    common_stock_issuance: Optional[float] = Field(
        None,
        description="Represents a transaction whereby a company issues its own shares to the marketplace",
        examples=[0],
    )
    common_stock_repurchase: Optional[float] = Field(
        None,
        description="Represents a transaction whereby a company buys back its own shares from the marketplace",
        examples=[-20478000000],
    )
    common_dividends: Optional[float] = Field(
        None,
        description="Returns value of payment doled out by a company to its stockholders in the form of periodic distributions of cash",
        examples=[-3732000000],
    )
    other_financing_charges: Optional[float] = Field(
        None, description="Represents other financing charges", examples=[-2949000000]
    )
    financing_cash_flow: Optional[float] = Field(
        None,
        description="Returns cash flow from financing activities (CFF), which shows the net flows of cash that are used to fund the company",
        examples=[-28159000000],
    )


class EquityInfoCapitalStock(BaseModel):
    common_stock: Optional[float] = Field(
        None, description="Common stock", examples=[73812000000]
    )
    preferred_stock: Optional[float] = Field(
        None, description="Preferred stock", examples=[73812000000]
    )
    total_partnership_capital: Optional[float] = Field(
        None, description="Total partnership capital", examples=[73812000000]
    )
    general_partnership_capital: Optional[float] = Field(
        None, description="General partnership capital", examples=[73812000000]
    )
    limited_partnership_capital: Optional[float] = Field(
        None, description="Limited partnership capital", examples=[73812000000]
    )
    capital_stock: Optional[float] = Field(
        None, description="Capital stock", examples=[73812000000]
    )
    other_capital_stock: Optional[float] = Field(
        None, description="Other capital stock", examples=[73812000000]
    )
    additional_paid_in_capital: Optional[float] = Field(
        None, description="Additional paid in capital", examples=[73812000000]
    )
    retained_earnings: Optional[float] = Field(
        None, description="Retained earnings", examples=[-214000000]
    )
    treasury_stock: Optional[float] = Field(
        None, description="Treasury stock", examples=[73812000000]
    )
    treasury_shares_number: Optional[float] = Field(
        None, description="Treasury shares number", examples=[0]
    )
    ordinary_shares_number: Optional[float] = Field(
        None, description="Ordinary shares number", examples=[15550061000]
    )
    preferred_shares_number: Optional[float] = Field(
        None, description="Preferred shares number", examples=[73812000000]
    )
    share_issued: Optional[float] = Field(
        None, description="Share issued", examples=[15550061000]
    )


class EquityInfoEquityAdjustments(BaseModel):
    gains_losses_not_affecting_retained_earnings: Optional[float] = Field(
        None,
        description="Gains losses not affecting retained earnings",
        examples=[-11452000000],
    )
    other_equity_adjustments: Optional[float] = Field(
        None, description="Other equity adjustments", examples=[-11452000000]
    )
    fixed_assets_revaluation_reserve: Optional[float] = Field(
        None, description="Fixed assets revaluation reserve", examples=[11452000000]
    )
    foreign_currency_translation_adjustments: Optional[float] = Field(
        None,
        description="Foreign currency translation adjustments",
        examples=[11452000000],
    )
    minimum_pension_liabilities: Optional[float] = Field(
        None, description="Minimum pension liabilities", examples=[11452000000]
    )
    unrealized_gain_loss: Optional[float] = Field(
        None, description="Unrealized gain loss", examples=[11452000000]
    )


class EtfResponseItemAccess(BaseModel):
    global_: Optional[str] = Field(
        None,
        alias="global",
        description="Level of access to the symbol",
        examples=["Level B"],
    )
    plan: Optional[str] = Field(
        None, description="The plan name for the symbol", examples=["Pro"]
    )


FundResponseItemAccess = BondsResponseItemAccess


class IncomeStatementBlockOperatingExpense(BaseModel):
    research_and_development: Optional[int] = Field(
        None,
        description="Refers to research & development (R&D) expenses",
        examples=[6306000000],
    )
    selling_general_and_administrative: Optional[int] = Field(
        None,
        description="Refers to selling, general and administrative (SG&A) expenses",
        examples=[6449000000],
    )
    other_operating_expenses: Optional[int] = Field(
        None, description="Refers to other operating expenses", examples=[0]
    )


class IncomeStatementBlockNonOperatingInterest(BaseModel):
    income: Optional[int] = Field(
        None,
        description="Refers to non-operating interest income",
        examples=[650000000],
    )
    expense: Optional[int] = Field(
        None,
        description="Refers to non-operating interest expense",
        examples=[694000000],
    )


class IncomeStatementItemRevenue(BaseModel):
    total_revenue: Optional[float] = Field(
        None, description="Total revenue", examples=[383285000000]
    )
    operating_revenue: Optional[float] = Field(
        None, description="Operating revenue", examples=[383285000000]
    )


class IncomeStatementItemGrossProfitCostOfRevenue(BaseModel):
    cost_of_revenue_value: Optional[float] = Field(
        None, description="Cost of revenue value", examples=[214137000000]
    )
    excise_taxes: Optional[float] = Field(
        None, description="Excise taxes", examples=[214137000000]
    )
    reconciled_cost_of_revenue: Optional[float] = Field(
        None, description="Reconciled cost of revenue", examples=[214137000000]
    )


class IncomeStatementItemGrossProfit(BaseModel):
    gross_profit_value: Optional[float] = Field(
        None, description="Gross profit value", examples=[169148000000]
    )
    cost_of_revenue: Optional[IncomeStatementItemGrossProfitCostOfRevenue] = None


class IncomeStatementItemOperatingIncome(BaseModel):
    operating_income_value: Optional[float] = Field(
        None, description="Operating income value", examples=[114301000000]
    )
    total_operating_income_as_reported: Optional[float] = Field(
        None, description="Total operating income as reported", examples=[114301000000]
    )
    operating_expense: Optional[float] = Field(
        None, description="Operating expense", examples=[54847000000]
    )
    other_operating_expenses: Optional[float] = Field(
        None, description="Other operating expenses", examples=[114301000000]
    )
    total_expenses: Optional[float] = Field(
        None, description="Total expenses", examples=[268984000000]
    )


class IncomeStatementItemNetIncome(BaseModel):
    net_income_value: Optional[float] = Field(
        None, description="Net income value", examples=[96995000000]
    )
    net_income_common_stockholders: Optional[float] = Field(
        None, description="Net income common stockholders", examples=[96995000000]
    )
    net_income_including_noncontrolling_interests: Optional[float] = Field(
        None,
        description="Net income including noncontrolling interests",
        examples=[96995000000],
    )
    net_income_from_tax_loss_carryforward: Optional[float] = Field(
        None,
        description="Net income from tax loss carryforward",
        examples=[96995000000],
    )
    net_income_extraordinary: Optional[float] = Field(
        None, description="Net income extraordinary", examples=[96995000000]
    )
    net_income_discontinuous_operations: Optional[float] = Field(
        None, description="Net income discontinuous operations", examples=[96995000000]
    )
    net_income_continuous_operations: Optional[float] = Field(
        None, description="Net income continuous operations", examples=[96995000000]
    )
    net_income_from_continuing_operation_net_minority_interest: Optional[float] = Field(
        None,
        description="Net income from continuing operation net minority interest",
        examples=[96995000000],
    )
    net_income_from_continuing_and_discontinued_operation: Optional[float] = Field(
        None,
        description="Net income from continuing and discontinued operation",
        examples=[96995000000],
    )
    normalized_income: Optional[float] = Field(
        None, description="Normalized income", examples=[96995000000]
    )
    minority_interests: Optional[float] = Field(
        None, description="Minority interests", examples=[96995000000]
    )


class IncomeStatementItemEarningsPerShare(BaseModel):
    diluted_eps: Optional[float] = Field(
        None, description="Diluted EPS", examples=[6.13]
    )
    basic_eps: Optional[float] = Field(None, description="Basic EPS", examples=[6.16])
    continuing_and_discontinued_diluted_eps: Optional[float] = Field(
        None, description="Continuing and discontinued diluted EPS", examples=[6.16]
    )
    continuing_and_discontinued_basic_eps: Optional[float] = Field(
        None, description="Continuing and discontinued basic EPS", examples=[6.16]
    )
    normalized_diluted_eps: Optional[float] = Field(
        None, description="Normalized diluted EPS", examples=[6.16]
    )
    normalized_basic_eps: Optional[float] = Field(
        None, description="Normalized basic EPS", examples=[6.16]
    )
    reported_normalized_diluted_eps: Optional[float] = Field(
        None, description="Reported normalized diluted EPS", examples=[6.16]
    )
    reported_normalized_basic_eps: Optional[float] = Field(
        None, description="Reported normalized basic EPS", examples=[6.16]
    )
    diluted_eps_other_gains_losses: Optional[float] = Field(
        None, description="Diluted EPS other gains losses", examples=[6.16]
    )
    tax_loss_carryforward_diluted_eps: Optional[float] = Field(
        None, description="Tax loss carryforward diluted EPS", examples=[6.16]
    )
    diluted_accounting_change: Optional[float] = Field(
        None, description="Diluted accounting change", examples=[6.16]
    )
    diluted_extraordinary: Optional[float] = Field(
        None, description="Diluted extraordinary", examples=[6.16]
    )
    diluted_discontinuous_operations: Optional[float] = Field(
        None, description="Diluted discontinuous operations", examples=[6.16]
    )
    diluted_continuous_operations: Optional[float] = Field(
        None, description="Diluted continuous operations", examples=[6.16]
    )
    basic_eps_other_gains_losses: Optional[float] = Field(
        None, description="Basic EPS other gains losses", examples=[6.16]
    )
    tax_loss_carryforward_basic_eps: Optional[float] = Field(
        None, description="Tax loss carryforward basic EPS", examples=[6.16]
    )
    basic_accounting_change: Optional[float] = Field(
        None, description="Basic accounting change", examples=[6.16]
    )
    basic_extraordinary: Optional[float] = Field(
        None, description="Basic extraordinary", examples=[6.16]
    )
    basic_discontinuous_operations: Optional[float] = Field(
        None, description="Basic discontinuous operations", examples=[6.16]
    )
    basic_continuous_operations: Optional[float] = Field(
        None, description="Basic continuous operations", examples=[6.16]
    )
    diluted_ni_avail_to_common_stockholders: Optional[float] = Field(
        None,
        description="Diluted NI available to common stockholders",
        examples=[96995000000],
    )
    average_dilution_earnings: Optional[float] = Field(
        None, description="Average dilution earnings", examples=[96995000000]
    )


class IncomeStatementItemExpenses(BaseModel):
    total_expenses: Optional[float] = Field(
        None, description="Total expenses", examples=[268984000000]
    )
    selling_general_and_administration_expense: Optional[float] = Field(
        None,
        description="Selling general and administration expense",
        examples=[24932000000],
    )
    selling_and_marketing_expense: Optional[float] = Field(
        None, description="Selling and marketing expense", examples=[24932000000]
    )
    general_and_administrative_expense: Optional[float] = Field(
        None, description="General and administrative expense", examples=[24932000000]
    )
    other_general_and_administrative_expense: Optional[float] = Field(
        None,
        description="Other general and administrative expense",
        examples=[24932000000],
    )
    depreciation_amortization_depletion_income_statement: Optional[float] = Field(
        None,
        description="Depreciation amortization depletion income statement",
        examples=[29915000000],
    )
    research_and_development_expense: Optional[float] = Field(
        None, description="Research and development expense", examples=[29915000000]
    )
    insurance_and_claims_expense: Optional[float] = Field(
        None, description="Insurance and claims expense", examples=[29915000000]
    )
    rent_and_landing_fees: Optional[float] = Field(
        None, description="Rent and landing fees", examples=[29915000000]
    )
    salaries_and_wages_expense: Optional[float] = Field(
        None, description="Salaries and wages expense", examples=[29915000000]
    )
    rent_expense_supplemental: Optional[float] = Field(
        None, description="Rent expense supplemental", examples=[29915000000]
    )
    provision_for_doubtful_accounts: Optional[float] = Field(
        None, description="Provision for doubtful accounts", examples=[29915000000]
    )


class IncomeStatementItemInterestIncomeAndExpense(BaseModel):
    interest_income: Optional[float] = Field(
        None, description="Interest income", examples=[3750000000]
    )
    interest_expense: Optional[float] = Field(
        None, description="Interest expense", examples=[3933000000]
    )
    net_interest_income: Optional[float] = Field(
        None, description="Net interest income", examples=[-183000000]
    )
    net_non_operating_interest_income_expense: Optional[float] = Field(
        None,
        description="Net non operating interest income expense",
        examples=[-183000000],
    )
    interest_expense_non_operating: Optional[float] = Field(
        None, description="Interest expense non operating", examples=[3933000000]
    )
    interest_income_non_operating: Optional[float] = Field(
        None, description="Interest income non operating", examples=[3750000000]
    )


class IncomeStatementItemOtherIncomeAndExpenses(BaseModel):
    other_income_expense: Optional[float] = Field(
        None, description="Other income expense", examples=[-382000000]
    )
    other_non_operating_income_expenses: Optional[float] = Field(
        None, description="Other non operating income expenses", examples=[-382000000]
    )
    special_income_charges: Optional[float] = Field(
        None, description="Special income charges", examples=[382000000]
    )
    gain_on_sale_of_ppe: Optional[float] = Field(
        None, description="Gain on sale of PPE", examples=[382000000]
    )
    gain_on_sale_of_business: Optional[float] = Field(
        None, description="Gain on sale of business", examples=[382000000]
    )
    gain_on_sale_of_security: Optional[float] = Field(
        None, description="Gain on sale of security", examples=[382000000]
    )
    other_special_charges: Optional[float] = Field(
        None, description="Other special charges", examples=[382000000]
    )
    write_off: Optional[float] = Field(
        None, description="Write off", examples=[382000000]
    )
    impairment_of_capital_assets: Optional[float] = Field(
        None, description="Impairment of capital assets", examples=[382000000]
    )
    restructuring_and_merger_acquisition: Optional[float] = Field(
        None, description="Restructuring and merger acquisition", examples=[382000000]
    )
    securities_amortization: Optional[float] = Field(
        None, description="Securities amortization", examples=[382000000]
    )
    earnings_from_equity_interest: Optional[float] = Field(
        None, description="Earnings from equity interest", examples=[382000000]
    )
    earnings_from_equity_interest_net_of_tax: Optional[float] = Field(
        None,
        description="Earnings from equity interest net of tax",
        examples=[382000000],
    )
    total_other_finance_cost: Optional[float] = Field(
        None, description="Total other finance cost", examples=[382000000]
    )


class IncomeStatementItemTaxes(BaseModel):
    tax_provision: Optional[float] = Field(
        None, description="Tax provision", examples=[16741000000]
    )
    tax_effect_of_unusual_items: Optional[float] = Field(
        None, description="Tax effect of unusual items", examples=[0]
    )
    tax_rate_for_calculations: Optional[float] = Field(
        None, description="Tax rate for calculations", examples=[0.147]
    )
    other_taxes: Optional[float] = Field(None, description="Other taxes", examples=[0])


class IncomeStatementItemDepreciationAndAmortization(BaseModel):
    depreciation_amortization_depletion: Optional[float] = Field(
        None, description="Depreciation amortization depletion", examples=[129188000000]
    )
    amortization_of_intangibles: Optional[float] = Field(
        None, description="Amortization of intangibles", examples=[129188000000]
    )
    depreciation: Optional[float] = Field(
        None, description="Depreciation", examples=[129188000000]
    )
    amortization: Optional[float] = Field(
        None, description="Amortization", examples=[129188000000]
    )
    depletion: Optional[float] = Field(
        None, description="Depletion", examples=[129188000000]
    )
    depreciation_and_amortization_in_income_statement: Optional[float] = Field(
        None,
        description="Depreciation and amortization in income statement",
        examples=[129188000000],
    )


class IncomeStatementItemEbitda(BaseModel):
    ebitda_value: Optional[float] = Field(
        None, description="EBITDA value", examples=[129188000000]
    )
    normalized_ebitda_value: Optional[float] = Field(
        None, description="Normalized EBITDA value", examples=[129188000000]
    )
    ebit_value: Optional[float] = Field(
        None, description="EBIT value", examples=[117669000000]
    )


class IncomeStatementItemDividendsAndShares(BaseModel):
    dividend_per_share: Optional[float] = Field(
        None, description="Dividend per share", examples=[15812547000]
    )
    diluted_average_shares: Optional[float] = Field(
        None, description="Diluted average shares", examples=[15812547000]
    )
    basic_average_shares: Optional[float] = Field(
        None, description="Basic average shares", examples=[15744231000]
    )
    preferred_stock_dividends: Optional[float] = Field(
        None, description="Preferred stock dividends", examples=[15744231000]
    )
    other_under_preferred_stock_dividend: Optional[float] = Field(
        None, description="Other under preferred stock dividend", examples=[15744231000]
    )


class IncomeStatementItemUnusualItems(BaseModel):
    total_unusual_items: Optional[float] = Field(
        None, description="Total unusual items", examples=[11519000000]
    )
    total_unusual_items_excluding_goodwill: Optional[float] = Field(
        None,
        description="Total unusual items excluding goodwill",
        examples=[11519000000],
    )


class IncomeStatementItemDepreciation(BaseModel):
    reconciled_depreciation: Optional[float] = Field(
        None, description="Reconciled depreciation", examples=[11519000000]
    )


class IncomeStatementItemPretaxIncome(BaseModel):
    pretax_income_value: Optional[float] = Field(
        None, description="Pretax income value", examples=[113736000000]
    )


class IncomeStatementItemSpecialIncomeCharges(BaseModel):
    special_income_charges_value: Optional[float] = Field(
        None, description="Special income charges value", examples=[113736000000]
    )


class ResponseMutualFundWorldCompositionBondBreakdown(BaseModel):
    average_maturity: Optional[
        GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownAverageMaturity
    ] = None
    average_duration: Optional[
        GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownAverageDuration
    ] = None
    credit_quality: Optional[
        List[
            GetMutualFundsWorld200ResponseMutualFundCompositionBondBreakdownCreditQualityInner
        ]
    ] = Field(
        None,
        description="Breakdown of the fund’s bond holdings by credit rating and their respective portfolio weights",
    )


class InlineObject(BaseModel):
    data: List[GetAssetsResponseItem] = Field(
        ..., description="List of assets with their details"
    )


class InlineObject1(BaseModel):
    data: Optional[List[Index]] = None


class InlineObject2Expenses(BaseModel):
    expense_ratio_gross: Optional[float] = None
    expense_ratio_net: Optional[float] = None


class InlineObject2Minimums(BaseModel):
    additional_investment: Optional[int] = None
    additional_ira_investment: Optional[Dict[str, Any]] = None
    initial_investment: Optional[int] = None
    initial_ira_investment: Optional[Dict[str, Any]] = None


class InlineObject2Pricing(BaseModel):
    field_12_month_high: Optional[float] = Field(None, alias="12_month_high")
    field_12_month_low: Optional[float] = Field(None, alias="12_month_low")
    last_month: Optional[float] = None
    nav: Optional[float] = None


class InlineObject2(BaseModel):
    brokerages: Optional[List[str]] = None
    expenses: Optional[InlineObject2Expenses] = None
    minimums: Optional[InlineObject2Minimums] = None
    pricing: Optional[InlineObject2Pricing] = None


class InlineObject3(BaseModel):
    performance_rating: Optional[int] = None
    return_rating: Optional[int] = None
    risk_rating: Optional[int] = None


class InlineObject4(BaseModel):
    corporate_aum: Optional[float] = None
    corporate_esg_pillars: Optional[Dict[str, float]] = None
    score: Optional[int] = None
    sustainable_investment: Optional[bool] = None


class InlineObject5(BaseModel):
    calls: Optional[List[OptionSide]] = None
    puts: Optional[List[OptionSide]] = None


class InlineObject6(BaseModel):
    dates: Optional[List[str]] = None


class InlineObject7(BaseModel):
    data: Optional[List[StockExchange]] = None


class InlineObject8MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["ACOS - Arccosine"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["open"],
    )


class InlineObject8Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject8MetaIndicator] = None


class InlineObject8ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-30 02:08:00"],
    )
    acos: Optional[str] = Field(None, description="ACOS value", examples=["12.345"])


class InlineObject8(BaseModel):
    meta: Optional[InlineObject8Meta] = None
    values: Optional[List[InlineObject8ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class InlineObject9MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["ASIN - Arcsine"]
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class InlineObject9Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject9MetaIndicator] = None


class InlineObject9ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-29 16:05:00"],
    )
    asin: Optional[str] = Field(None, description="ASIN value", examples=["12.345"])


class InlineObject9(BaseModel):
    meta: Optional[InlineObject9Meta] = None
    values: Optional[List[InlineObject9ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class InlineObject10MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["ATAN - Arctan"]
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class InlineObject10Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject10MetaIndicator] = None


class InlineObject10ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-29 16:52:00"],
    )
    atan: Optional[str] = Field(None, description="ATAN value", examples=["1.57079"])


class InlineObject10(BaseModel):
    meta: Optional[InlineObject10Meta] = None
    values: Optional[List[InlineObject10ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class InlineObject11MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["COS - Cosine"]
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class InlineObject11Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject11MetaIndicator] = None


class InlineObject11ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-29 16:55:00"],
    )
    cos: Optional[str] = Field(None, description="COS value", examples=["-0.25043722"])


class InlineObject11(BaseModel):
    meta: Optional[InlineObject11Meta] = None
    values: Optional[List[InlineObject11ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class InlineObject12MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["COSH - Hyperbolic Cosine"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class InlineObject12Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject12MetaIndicator] = None


class InlineObject12ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-29 17:01:00"],
    )
    cosh: Optional[str] = Field(None, description="COSH value", examples=["+Inf"])


class InlineObject12(BaseModel):
    meta: Optional[InlineObject12Meta] = None
    values: Optional[List[InlineObject12ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class InlineObject13MetaIndicator(BaseModel):
    ma_type: Optional[str] = None
    max_period: Optional[int] = None
    min_period: Optional[int] = None
    name: Optional[str] = None
    periods: Optional[List[int]] = None
    series_type: Optional[str] = None


class InlineObject13Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject13MetaIndicator] = None


class InlineObject13ValuesInner(BaseModel):
    datetime: Optional[str] = None
    mavp: Optional[str] = None


class InlineObject13(BaseModel):
    meta: Optional[InlineObject13Meta] = None
    values: Optional[List[InlineObject13ValuesInner]] = None


class InlineObject14MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["SIN - Sine"]
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class InlineObject14Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject14MetaIndicator] = None


class InlineObject14ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-29 17:05:00"],
    )
    sin: Optional[str] = Field(None, description="SIN value", examples=["-0.87641625"])


class InlineObject14(BaseModel):
    meta: Optional[InlineObject14Meta] = None
    values: Optional[List[InlineObject14ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class InlineObject15MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["SINH - Hyperbolic Sine"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class InlineObject15Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject15MetaIndicator] = None


class InlineObject15ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-29 17:08:00"],
    )
    sinh: Optional[str] = Field(None, description="SINH value", examples=["+Inf"])


class InlineObject15(BaseModel):
    meta: Optional[InlineObject15Meta] = None
    values: Optional[List[InlineObject15ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class InlineObject16MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of the technical indicator", examples=["TAN - Tangent"]
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class InlineObject16Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject16MetaIndicator] = None


class InlineObject16ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-29 13:12:00"],
    )
    tan: Optional[str] = Field(None, description="TAN value", examples=["-1.29151"])


class InlineObject16(BaseModel):
    meta: Optional[InlineObject16Meta] = None
    values: Optional[List[InlineObject16ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class InlineObject17MetaIndicator(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the technical indicator",
        examples=["TANH - Hyperbolic Tangent"],
    )
    series_type: Optional[str] = Field(
        None,
        description="Price type on which technical indicator is calculated",
        examples=["close"],
    )


class InlineObject17Meta(BaseModel):
    symbol: Optional[str] = Field(
        None,
        description="The ticker symbol of an instrument for which data was requested.",
        examples=["AAPL"],
    )
    interval: Optional[str] = Field(
        None,
        description="The time gap between consecutive data points.",
        examples=["1min"],
    )
    currency: Optional[str] = Field(
        None, description="The currency of a traded instrument.", examples=["USD"]
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="The timezone of the exchange where the instrument is traded.",
        examples=["America/New_York"],
    )
    exchange: Optional[str] = Field(
        None,
        description="The exchange name where the instrument is traded.",
        examples=["NASDAQ"],
    )
    mic_code: Optional[str] = Field(
        None,
        description="The Market Identifier Code (MIC) of the exchange where the instrument is traded.",
        examples=["XNAS"],
    )
    type: Optional[str] = Field(
        None,
        description="The asset class to which the instrument belongs.",
        examples=["Common Stock"],
    )
    indicator: Optional[InlineObject17MetaIndicator] = None


class InlineObject17ValuesInner(BaseModel):
    datetime: Optional[str] = Field(
        None,
        description="Datetime in local market time for equities and in UTC for forex and cryptocurrencies referring to when the bar with specified interval was opened",
        examples=["2025-05-29 13:16:00"],
    )
    tanh: Optional[str] = Field(None, description="TANH value", examples=["1"])


class InlineObject17(BaseModel):
    meta: Optional[InlineObject17Meta] = None
    values: Optional[List[InlineObject17ValuesInner]] = Field(
        None, description="Array of time series data points"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetDividendsCalendar200Response(RootModel[List[DividendsCalendarItem]]):
    root: List[DividendsCalendarItem]


class GetIpoCalendar200Response(
    RootModel[Optional[Dict[str, List[GetIpoCalendar200ResponseValueInner]]]]
):
    root: Optional[Dict[str, List[GetIpoCalendar200ResponseValueInner]]] = None


class GetMarketState200Response(RootModel[List[MarketStateResponseItem]]):
    root: List[MarketStateResponseItem]


class GetSplitsCalendar200Response(RootModel[List[SplitsCalendarResponseItem]]):
    root: List[SplitsCalendarResponseItem]


class BondResponseItem(BaseModel):
    symbol: Optional[str] = Field(None, description="Bond symbol", examples=["US2Y"])
    name: Optional[str] = Field(
        None,
        description="Full name of the bond",
        examples=["US Treasury Yield 2 Years"],
    )
    country: Optional[str] = Field(
        None,
        description="Country where the bond is located",
        examples=["United States"],
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the bond according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where the bond is traded", examples=["NYSE"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNYS"],
    )
    type: Optional[str] = Field(None, description="Type of the bond", examples=["Bond"])
    access: Optional[BondsResponseItemAccess] = None


class CashFlowData(BaseModel):
    fiscal_date: Optional[str] = Field(
        None, description="Fiscal date", examples=["2023-09-30"]
    )
    cash_flow_from_operating_activities: Optional[
        CashFlowDataCashFlowFromOperatingActivities
    ] = None
    cash_flow_from_investing_activities: Optional[
        CashFlowDataCashFlowFromInvestingActivities
    ] = None
    cash_flow_from_financing_activities: Optional[
        CashFlowDataCashFlowFromFinancingActivities
    ] = None
    supplemental_data: Optional[CashFlowDataSupplementalData] = None
    foreign_and_domestic_sales: Optional[CashFlowDataForeignAndDomesticSales] = None
    cash_position: Optional[CashFlowDataCashPosition] = None
    direct_method_cash_flow: Optional[CashFlowDataDirectMethodCashFlow] = None


class CashFlowStruct(BaseModel):
    fiscal_date: Optional[str] = Field(
        None, description="Date of the cash flow release", examples=["2021-12-31"]
    )
    quarter: Optional[str] = Field(
        None,
        description="Fiscal quarter. Visible when `&period=quarterly`",
        examples=["1"],
    )
    year: Optional[int] = Field(None, description="Fiscal year", examples=[2022])
    operating_activities: Optional[CashFlowStructOperatingActivities] = None
    investing_activities: Optional[CashFlowStructInvestingActivities] = None
    financing_activities: Optional[CashFlowStructFinancingActivities] = None
    end_cash_position: Optional[float] = Field(
        None,
        description="Returns the amount of cash a company has when adding the change in cash and beginning cash balance for the current fiscal period",
        examples=[38630000000],
    )
    income_tax_paid: Optional[float] = Field(
        None,
        description="Refers to supplemental data about income tax paid",
        examples=[5235000000],
    )
    interest_paid: Optional[float] = Field(
        None,
        description="Refers to supplemental data about interest paid",
        examples=[531000000],
    )
    free_cash_flow: Optional[float] = Field(
        None,
        description="Represents the cash a company generates after accounting for cash outflows to support operations and maintain its capital assets",
        examples=[49769000000],
    )


class EquityInfo(BaseModel):
    total_equity_gross_minority_interest: Optional[float] = Field(
        None, description="Total equity gross minority interest", examples=[62146000000]
    )
    stockholders_equity: Optional[float] = Field(
        None, description="Stockholders equity", examples=[62146000000]
    )
    common_stock_equity: Optional[float] = Field(
        None, description="Common stock equity", examples=[62146000000]
    )
    preferred_stock_equity: Optional[float] = Field(
        None, description="Preferred stock equity", examples=[62146000000]
    )
    other_equity_interest: Optional[float] = Field(
        None, description="Other equity interest", examples=[62146000000]
    )
    minority_interest: Optional[float] = Field(
        None, description="Minority interest", examples=[62146000000]
    )
    total_capitalization: Optional[float] = Field(
        None, description="Total capitalization", examples=[157427000000]
    )
    net_tangible_assets: Optional[float] = Field(
        None, description="Net tangible assets", examples=[62146000000]
    )
    tangible_book_value: Optional[float] = Field(
        None, description="Tangible book value", examples=[62146000000]
    )
    invested_capital: Optional[float] = Field(
        None, description="Invested capital", examples=[173234000000]
    )
    working_capital: Optional[float] = Field(
        None, description="Working capital", examples=[-1742000000]
    )
    capital_stock: Optional[EquityInfoCapitalStock] = None
    equity_adjustments: Optional[EquityInfoEquityAdjustments] = None
    net_debt: Optional[float] = Field(
        None, description="Net debt", examples=[81123000000]
    )
    total_debt: Optional[float] = Field(
        None, description="Total debt", examples=[123930000000]
    )


class EtfResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Instrument symbol (ticker)", examples=["SPY"]
    )
    name: Optional[str] = Field(
        None, description="Full name of the ETF", examples=["SPDR S&P 500 ETF Trust"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the ETF according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where the ETF is traded", examples=["NYSE"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNYS"],
    )
    country: Optional[str] = Field(
        None, description="Country where the ETF is located", examples=["United States"]
    )
    figi_code: Optional[str] = Field(
        None,
        description="Financial instrument global identifier (FIGI)",
        examples=["BBG000BDTF76"],
    )
    cfi_code: Optional[str] = Field(
        None,
        description="Classification of Financial Instruments (CFI)",
        examples=["CEOJLU"],
    )
    isin: Optional[str] = Field(
        None,
        description="International securities identification number (ISIN)",
        examples=["US78462F1030"],
    )
    cusip: Optional[str] = Field(
        None,
        description="A unique nine-character alphanumeric code used to identify financial securities, ensuring accurate data retrieval for the specified asset",
        examples=["037833100"],
    )
    access: Optional[EtfResponseItemAccess] = None


class ExchangeScheduleResponseItem(BaseModel):
    title: Optional[str] = Field(
        None,
        description="Official name of exchange",
        examples=["NASDAQ/NGS (Global Select Market)"],
    )
    name: Optional[str] = Field(
        None, description="Name of exchange", examples=["NASDAQ"]
    )
    code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNYS"],
    )
    country: Optional[str] = Field(
        None,
        description="Country to which stock exchange belongs to",
        examples=["United States"],
    )
    time_zone: Optional[str] = Field(
        None,
        description="Time zone where exchange is located",
        examples=["America/New_York"],
    )
    sessions: Optional[List[ExchangeScheduleSession]] = Field(
        None, description="Exchange trading hours"
    )


class ExchangesResponseItem(BaseModel):
    title: Optional[str] = Field(
        None, description="Title of exchange", examples=["NASDAQ"]
    )
    name: Optional[str] = Field(
        None, description="Name of exchange", examples=["NASDAQ"]
    )
    code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNGS"],
    )
    country: Optional[str] = Field(
        None,
        description="Country to which stock exchange belongs to",
        examples=["United States"],
    )
    timezone: Optional[str] = Field(
        None,
        description="Time zone where exchange is located",
        examples=["America/New_York"],
    )
    access: Optional[ExchangesResponseItemAccess] = None


class FundResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Instrument symbol (ticker)", examples=["DIVI"]
    )
    name: Optional[str] = Field(
        None,
        description="Full name of the fund",
        examples=["AdvisorShares Athena High Dividend ETF"],
    )
    country: Optional[str] = Field(
        None,
        description="Country where the fund is located",
        examples=["United States"],
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the fund according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where the fund is traded", examples=["NYSE"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["ARCX"],
    )
    type: Optional[str] = Field(None, description="Type of the fund", examples=["ETF"])
    figi_code: Optional[str] = Field(
        None,
        description="Financial instrument global identifier (FIGI)",
        examples=["BBG00161BCW4"],
    )
    cfi_code: Optional[str] = Field(
        None,
        description="Classification of Financial Instruments (CFI)",
        examples=["CECILU"],
    )
    isin: Optional[str] = Field(
        None,
        description="International securities identification number (ISIN)",
        examples=["GB00B65TLW28"],
    )
    cusip: Optional[str] = Field(
        None,
        description="A unique nine-character alphanumeric code used to identify financial securities, ensuring accurate data retrieval for the specified asset",
        examples=["35473P108"],
    )
    access: Optional[FundResponseItemAccess] = None


class IncomeStatementBlock(BaseModel):
    fiscal_date: Optional[str] = Field(
        None,
        description="Date of the income statement release",
        examples=["2021-12-31"],
    )
    quarter: Optional[int] = Field(
        None,
        description="Fiscal quarter. Visible when `&period=quarterly`",
        examples=[1],
    )
    year: Optional[int] = Field(None, description="Fiscal year", examples=[2022])
    sales: Optional[int] = Field(
        None, description="Refers to total reported revenue", examples=[123945000000]
    )
    cost_of_goods: Optional[int] = Field(
        None, description="Refers to cost of revenue", examples=[69702000000]
    )
    gross_profit: Optional[int] = Field(
        None,
        description="Refers to net gross profit: `sales` - `cost_of_goods`",
        examples=[54243000000],
    )
    operating_expense: Optional[IncomeStatementBlockOperatingExpense] = None
    operating_income: Optional[int] = Field(
        None,
        description="Refers to net operating income: `gross_profit` - `research_and_development` - `selling_general_and_administrative`",
        examples=[41488000000],
    )
    non_operating_interest: Optional[IncomeStatementBlockNonOperatingInterest] = None
    other_income_expense: Optional[int] = Field(
        None, description="Refers to other incomes or expenses", examples=[-203000000]
    )
    pretax_income: Optional[int] = Field(
        None,
        description="Refers to earnings before tax: `operating_income` + `net_non_operating_interest` - `other_income_expense`",
        examples=[41241000000],
    )
    income_tax: Optional[int] = Field(
        None, description="Refers to a tax provision", examples=[6611000000]
    )
    net_income: Optional[int] = Field(
        None,
        description="Refers to net income: `pretax_income` - `income_tax`",
        examples=[34630000000],
    )
    eps_basic: Optional[float] = Field(
        None, description="Refers to earnings per share (EPS)", examples=[2.11]
    )
    eps_diluted: Optional[float] = Field(
        None, description="Refers to diluted earnings per share (EPS)", examples=[2.1]
    )
    basic_shares_outstanding: Optional[int] = Field(
        None,
        description="Refers for the shares outstanding held by all its shareholders",
        examples=[16391724000],
    )
    diluted_shares_outstanding: Optional[int] = Field(
        None,
        description="Refers to the total number of shares a company would have if all dilutive securities were exercised and converted into shares",
        examples=[16391724000],
    )
    ebit: Optional[int] = Field(
        None,
        description="Refers to earnings before interest and taxes (EBIT) measure",
        examples=[41488000000],
    )
    ebitda: Optional[int] = Field(
        None,
        description="Refers to EBITDA (earnings before interest, taxes, depreciation, and amortization) measure",
        examples=[44632000000],
    )
    net_income_continuous_operations: Optional[int] = Field(
        None,
        description="Refers to the after-tax earnings that a business has generated from its operational activities",
        examples=[0],
    )
    minority_interests: Optional[int] = Field(
        None,
        description="Refers to amount of minority interests paid out",
        examples=[0],
    )
    preferred_stock_dividends: Optional[int] = Field(
        None,
        description="Refers to dividend that is allocated to and paid on a company's preferred shares",
        examples=[0],
    )


class IncomeStatementItem(BaseModel):
    fiscal_date: Optional[str] = Field(
        None,
        description="Date of the income statement release",
        examples=["2023-09-30"],
    )
    year: Optional[int] = Field(None, description="Fiscal year", examples=[2022])
    revenue: Optional[IncomeStatementItemRevenue] = None
    gross_profit: Optional[IncomeStatementItemGrossProfit] = None
    operating_income: Optional[IncomeStatementItemOperatingIncome] = None
    net_income: Optional[IncomeStatementItemNetIncome] = None
    earnings_per_share: Optional[IncomeStatementItemEarningsPerShare] = None
    expenses: Optional[IncomeStatementItemExpenses] = None
    interest_income_and_expense: Optional[
        IncomeStatementItemInterestIncomeAndExpense
    ] = None
    other_income_and_expenses: Optional[IncomeStatementItemOtherIncomeAndExpenses] = (
        None
    )
    taxes: Optional[IncomeStatementItemTaxes] = None
    depreciation_and_amortization: Optional[
        IncomeStatementItemDepreciationAndAmortization
    ] = None
    ebitda: Optional[IncomeStatementItemEbitda] = None
    dividends_and_shares: Optional[IncomeStatementItemDividendsAndShares] = None
    unusual_items: Optional[IncomeStatementItemUnusualItems] = None
    depreciation: Optional[IncomeStatementItemDepreciation] = None
    pretax_income: Optional[IncomeStatementItemPretaxIncome] = None
    special_income_charges: Optional[IncomeStatementItemSpecialIncomeCharges] = None


class MarketMoversResponseBody(BaseModel):
    values: List[MarketMoversResponseValue] = Field(
        ..., description="Market movers list"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class ResponseMutualFundWorldComposition(BaseModel):
    major_market_sectors: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundCompositionMajorMarketSectorsInner]
    ] = Field(
        None,
        description="Breakdown of the fund’s portfolio by major industry sectors and their respective weights",
    )
    asset_allocation: Optional[
        GetMutualFundsWorld200ResponseMutualFundCompositionAssetAllocation
    ] = None
    top_holdings: Optional[
        List[GetMutualFundsWorld200ResponseMutualFundCompositionTopHoldingsInner]
    ] = Field(
        None,
        description="Top holdings of the fund with their respective weights in the overall portfolio composition",
    )
    bond_breakdown: Optional[ResponseMutualFundWorldCompositionBondBreakdown] = None


ResponseMutualFundWorldPerformance = GetMutualFundsWorld200ResponseMutualFundPerformance


ResponseMutualFundWorldPurchaseInfo = (
    GetMutualFundsWorld200ResponseMutualFundPurchaseInfo
)


ResponseMutualFundWorldRisk = GetMutualFundsWorld200ResponseMutualFundRisk


ResponseMutualFundWorldSummary = GetMutualFundsWorld200ResponseMutualFundSummary


ResponseMutualFundWorldSustainability = (
    GetMutualFundsWorld200ResponseMutualFundSustainability
)


class ResponseSanctionItem(BaseModel):
    source: Optional[str] = Field(
        None, description="The sanction source", examples=["ofac"]
    )
    program: Optional[str] = Field(
        None, description="The sanction program", examples=["RUSSIA-EO14024"]
    )
    notes: Optional[str] = Field(
        None, description="Notes for the sanction", examples=["Block"]
    )
    lists: Optional[List[ResponseSanctionItemList]] = Field(
        None, description="Sanction lists"
    )


class ResponseSanctionedEntitiy(BaseModel):
    symbol: Optional[str] = Field(
        None, description="The instrument symbol ticker", examples=["LOKESHMACH"]
    )
    name: Optional[str] = Field(
        None, description="The instrument name", examples=["Lokesh Machines Ltd."]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market Identifier Code (MIC) under ISO 10383 standard",
        examples=["NSE"],
    )
    country: Optional[str] = Field(None, description="Country name", examples=["India"])
    sanction: Optional[ResponseSanctionItem] = None


class StocksResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Instrument symbol (ticker)", examples=["AAPL"]
    )
    name: Optional[str] = Field(
        None, description="Full name of instrument", examples=["Apple Inc"]
    )
    currency: Optional[str] = Field(
        None,
        description="Currency of the instrument according to the ISO 4217 standard",
        examples=["USD"],
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NASDAQ"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNGS"],
    )
    country: Optional[str] = Field(
        None,
        description="Country where exchange is located",
        examples=["United States"],
    )
    type: Optional[str] = Field(
        None, description="Common issue type", examples=["Common Stock"]
    )
    figi_code: Optional[str] = Field(
        None,
        description="Financial instrument global identifier (FIGI)",
        examples=["BBG000B9Y5X2"],
    )
    cfi_code: Optional[str] = Field(
        None,
        description="Classification of Financial Instruments (CFI)",
        examples=["ESVUFR"],
    )
    isin: Optional[str] = Field(
        None,
        description="International securities identification number (ISIN), available by individual request to support",
        examples=["US0378331005"],
    )
    cusip: Optional[str] = Field(
        None,
        description="A unique nine-character alphanumeric code used to identify financial securities, ensuring accurate data retrieval for the specified asset",
        examples=["037833100"],
    )
    access: Optional[FundResponseItemAccess] = None


class SymbolSearchResponseItem(BaseModel):
    symbol: Optional[str] = Field(
        None, description="Ticker symbol of instrument", examples=["AA"]
    )
    instrument_name: Optional[str] = Field(
        None, description="Name of exchange", examples=["Alcoa Corp"]
    )
    exchange: Optional[str] = Field(
        None, description="Exchange where instrument is traded", examples=["NYSE"]
    )
    mic_code: Optional[str] = Field(
        None,
        description="Market identifier code (MIC) under ISO 10383 standard",
        examples=["XNYS"],
    )
    exchange_timezone: Optional[str] = Field(
        None,
        description="Time zone where exchange is located",
        examples=["America/New_York"],
    )
    instrument_type: Optional[str] = Field(
        None, description="Type of instrument", examples=["Common Stock"]
    )
    country: Optional[str] = Field(
        None,
        description="Country to which stock exchange belongs to",
        examples=["United States"],
    )
    currency: Optional[str] = Field(
        None, description="Currency in which the instrument is traded", examples=["USD"]
    )
    access: Optional[SymbolSearchResponseItemAccess] = None


class GetBonds200ResponseResult(BaseModel):
    count: Optional[int] = Field(
        None, description="Total number of matching instruments", examples=[6]
    )
    list: Optional[List[BondResponseItem]] = None


class GetBonds200Response(BaseModel):
    result: Optional[GetBonds200ResponseResult] = None
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetCashFlow200Response(BaseModel):
    meta: Optional[GetCashFlow200ResponseMeta] = None
    cash_flow: Optional[List[CashFlowStruct]] = Field(
        None, description="Cash flow data"
    )


class GetCashFlowConsolidated200Response(BaseModel):
    cash_flow: Optional[List[CashFlowData]] = Field(None, description="Cash flow data")
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetEtf200Response(BaseModel):
    data: Optional[List[EtfResponseItem]] = Field(None, description="List of ETFs")
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetExchangeSchedule200Response(BaseModel):
    data: Optional[List[ExchangeScheduleResponseItem]] = None


class GetExchanges200Response(BaseModel):
    data: Optional[List[ExchangesResponseItem]] = Field(
        None, description="List of exchanges"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetFunds200ResponseResult(BaseModel):
    count: Optional[int] = Field(
        None, description="Total number of matching instruments", examples=[84799]
    )
    list: Optional[List[FundResponseItem]] = None


class GetFunds200Response(BaseModel):
    result: Optional[GetFunds200ResponseResult] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetIncomeStatement200Response(BaseModel):
    meta: Optional[GetIncomeStatement200ResponseMeta] = None
    income_statement: Optional[List[IncomeStatementBlock]] = Field(
        None, description="Income statement data"
    )


class GetIncomeStatementConsolidated200Response(BaseModel):
    income_statement: Optional[List[IncomeStatementItem]] = Field(
        None, description="Income statement data"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetMutualFundsWorldComposition200ResponseMutualFund(BaseModel):
    composition: Optional[ResponseMutualFundWorldComposition] = None


class GetMutualFundsWorldComposition200Response(BaseModel):
    mutual_fund: Optional[GetMutualFundsWorldComposition200ResponseMutualFund] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetMutualFundsWorldPerformance200ResponseMutualFund(BaseModel):
    performance: Optional[ResponseMutualFundWorldPerformance] = None


class GetMutualFundsWorldPerformance200Response(BaseModel):
    mutual_fund: Optional[GetMutualFundsWorldPerformance200ResponseMutualFund] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetMutualFundsWorldPurchaseInfo200ResponseMutualFund(BaseModel):
    purchase_info: Optional[ResponseMutualFundWorldPurchaseInfo] = None


class GetMutualFundsWorldPurchaseInfo200Response(BaseModel):
    mutual_fund: Optional[GetMutualFundsWorldPurchaseInfo200ResponseMutualFund] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetMutualFundsWorldRisk200ResponseMutualFund(BaseModel):
    risk: Optional[ResponseMutualFundWorldRisk] = None


class GetMutualFundsWorldRisk200Response(BaseModel):
    mutual_fund: Optional[GetMutualFundsWorldRisk200ResponseMutualFund] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetMutualFundsWorldSummary200ResponseMutualFund(BaseModel):
    summary: Optional[ResponseMutualFundWorldSummary] = None


class GetMutualFundsWorldSummary200Response(BaseModel):
    mutual_fund: Optional[GetMutualFundsWorldSummary200ResponseMutualFund] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetMutualFundsWorldSustainability200ResponseMutualFund(BaseModel):
    sustainability: Optional[ResponseMutualFundWorldSustainability] = None


class GetMutualFundsWorldSustainability200Response(BaseModel):
    mutual_fund: Optional[GetMutualFundsWorldSustainability200ResponseMutualFund] = None
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class GetSourceSanctionedEntities200Response(BaseModel):
    sanctions: Optional[List[ResponseSanctionedEntitiy]] = Field(
        None, description="List of sanctioned entities"
    )
    count: Optional[int] = Field(
        None, description="Total number of sanctioned entities", examples=[143]
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetStocks200Response(BaseModel):
    data: Optional[List[StocksResponseItem]] = Field(
        None, description="List of stock instruments"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])


class GetSymbolSearch200Response(BaseModel):
    data: Optional[List[SymbolSearchResponseItem]] = Field(
        None, description="List of symbols matching the search criteria"
    )
    status: Optional[str] = Field(
        None, description="Status of the response", examples=["ok"]
    )


class AssetsInfoLiabilities(BaseModel):
    total_liabilities_net_minority_interest: Optional[float] = Field(
        None,
        description="Total liabilities net minority interest",
        examples=[290437000000],
    )
    current_liabilities: Optional[AssetsInfoLiabilitiesCurrentLiabilities] = None
    non_current_liabilities: Optional[AssetsInfoLiabilitiesNonCurrentLiabilities] = None
    equity: Optional[EquityInfo] = None


class AssetsInfo(BaseModel):
    total_assets: Optional[float] = Field(
        None, description="Total assets", examples=[352583000000]
    )
    current_assets: Optional[AssetsInfoCurrentAssets] = None
    non_current_assets: Optional[AssetsInfoNonCurrentAssets] = None
    liabilities: Optional[AssetsInfoLiabilities] = None


class BalanceSheetConsolidatedItem(BaseModel):
    fiscal_date: Optional[str] = Field(
        None, description="Date of the balance sheet release", examples=["2023-09-30"]
    )
    assets: Optional[AssetsInfo] = None


class GetBalanceSheetConsolidated200Response(BaseModel):
    balance_sheet: Optional[List[BalanceSheetConsolidatedItem]] = Field(
        None, description="Balance sheet data"
    )
    status: Optional[str] = Field(None, description="Response status", examples=["ok"])

# Aliases for response models
GetMarketMovers200Response = MarketMoversResponseBody
GetTimeSeriesPercent_B200Response = GetTimeSeriesPercentB200Response
