# Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our
community a harassment-free experience for everyone, regardless of age, body
size, visible or invisible disability, ethnicity, sex characteristics, gender
identity and expression, level of experience, education, socio-economic status,
nationality, personal appearance, race, religion, or sexual identity
and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming,
diverse, inclusive, and healthy community.

## Our Standards

Examples of behavior that contributes to a positive environment for our
community include:

* Demonstrating empathy and kindness toward other people
* Being respectful of differing opinions, viewpoints, and experiences
* Giving and gracefully accepting constructive feedback
* Accepting responsibility and apologizing to those affected by our mistakes,
  and learning from the experience
* Focusing on what is best not just for us as individuals, but for the
  overall community
* Showing courtesy and respect toward other community members
* Being collaborative and inclusive in discussions and decision-making
* Respecting the academic and professional nature of our work
* Acknowledging the contributions of others appropriately
* Being patient and understanding with newcomers and those learning

Examples of unacceptable behavior include:

* The use of sexualized language or imagery, and sexual attention or
  advances of any kind
* Trolling, insulting or derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or email
  address, without their explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional or academic setting
* Dismissing or belittling others' contributions or expertise
* Making assumptions about others' knowledge or capabilities
* Using aggressive or confrontational language in technical discussions
* Spamming, advertising, or other commercial solicitation without permission

## Enforcement Responsibilities

Community leaders are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

Community leaders have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.

## Scope

This Code of Conduct applies within all community spaces, and also applies when
an individual is officially representing the community in public spaces.
Examples of representing our community include:

* Using an official e-mail address
* Posting via an official social media account
* Acting as an appointed representative at an online or offline event
* Speaking at conferences or meetups on behalf of the project
* Contributing code, documentation, or other project materials
* Participating in project discussions, issue reports, or pull requests

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the community leaders responsible for enforcement at
[INSERT CONTACT METHOD]. All complaints will be reviewed and investigated
promptly and fairly.

All community leaders are obligated to respect the privacy and security of the
reporter of any incident.

## Enforcement Guidelines

Community leaders will follow these Community Impact Guidelines in determining
the consequences for any action they deem in violation of this Code of Conduct:

### 1. Correction

**Community Impact**: Use of inappropriate language or other behavior deemed
unprofessional or unwelcome in the community.

**Consequence**: A private, written warning from community leaders, providing
clarity around the nature of the violation and an explanation of why the
behavior was inappropriate. A public apology may be requested.

### 2. Warning

**Community Impact**: A violation through a single incident or series of
actions.

**Consequence**: A warning with consequences for continued behavior. No
interaction with the people involved, including unsolicited interaction with
those enforcing the Code of Conduct, for a specified period of time. This
includes avoiding interactions in community spaces as well as external channels
like social media. Violating these terms may lead to a temporary or permanent
ban.

### 3. Temporary Ban

**Community Impact**: A serious violation of community standards, including
sustained inappropriate behavior.

**Consequence**: A temporary ban from any sort of interaction or public
communication with the community for a specified period of time. No public or
private interaction with the people involved, including unsolicited interaction
with those enforcing the Code of Conduct, is allowed during this period.
Violating these terms may lead to a permanent ban.

### 4. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation of community
standards, including sustained inappropriate behavior, harassment of an
individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within the
community.

## Reporting Guidelines

If you believe someone is violating the Code of Conduct, we ask that you report
it by emailing [INSERT EMAIL ADDRESS]. All reports will be kept confidential.
In some cases we may determine that a public statement will need to be made. If
that's the case, the identities of all involved parties will remain confidential
unless those individuals have themselves opted to go public.

**When reporting, please include:**

* Your contact information (so we can get in touch with you if we need to
  follow up)
* Names (real, nicknames, or pseudonyms) of any individuals involved
* Description of what happened
* Description of the behavior that violated the Code of Conduct
* When and where the incident occurred
* Any additional context that you believe is relevant
* Whether you believe this incident is ongoing
* Any other information you believe we should have

**What happens after you file a report?**

You will receive an email from the Code of Conduct committee acknowledging
receipt within 24 hours (and we will aim to respond much quicker than that).

The committee will immediately meet to review the incident and determine:

* What happened
* Whether this event constitutes a Code of Conduct violation
* What kind of response is appropriate
* Whether this is an ongoing situation, or if there is a threat to anyone's
  physical safety

If this is determined to be an ongoing incident or a threat to physical safety,
the committee's immediate priority will be to protect everyone involved. This
means we may delay an "official" response until we believe that the situation
has ended and that everyone is physically safe.

Once the committee has a complete account of the events, they will make a
decision as to how to respond. Responses might include:

* Nothing (if we determine no violation occurred)
* A private reprimand from the committee to the individual(s) involved
* A public reprimand
* An imposed vacation (temporary ask to avoid the community and its
  spaces)
* A permanent or temporary ban from some or all community spaces
* A request for a public or private apology

We'll respond within one week to the person who filed the report with either a
resolution or an explanation of why the situation is not yet resolved.

## Appealing

Only permanent resolutions (such as bans) may be appealed. To appeal a decision,
contact the Code of Conduct committee at [INSERT EMAIL ADDRESS] with your
appeal and the committee will review the case.

## Additional Resources

* [Contributing Guidelines](CONTRIBUTING.md)
* [Project Documentation](README.md)
* [Issue Templates](https://github.com/mucsci/scheduler/issues/new/choose)
* [Discussion Guidelines](https://github.com/mucsci/scheduler/discussions)

## Acknowledgment

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org),
version 2.0, available at
https://www.contributor-covenant.org/version/2/0/code_of_conduct.html.

Community Impact Guidelines were inspired by [Mozilla's code of conduct
enforcement ladder](https://github.com/mozilla/diversity).

For answers to common questions about this code of conduct, see the FAQ at
https://www.contributor-covenant.org/faq. Translations are available at
https://www.contributor-covenant.org/translations.

## Updates to This Code of Conduct

This Code of Conduct may be updated from time to time. When updates are made,
they will be announced through:

* A pull request with clear documentation of changes
* An issue announcement with a summary of updates
* A discussion post explaining the rationale for changes
* Email notification to active contributors

All updates will be reviewed by the community and maintainers before being
implemented.

---

## Why This Matters

The Course Constraint Scheduler is an academic project that serves educational
institutions and researchers worldwide. Our community includes:

* **Academic researchers** working on constraint satisfaction and scheduling algorithms
* **University administrators** implementing course scheduling systems
* **Students** learning about optimization and academic planning
* **Open source contributors** from diverse backgrounds and experience levels
* **Industry professionals** applying academic scheduling solutions

By maintaining a respectful and inclusive environment, we ensure that:

* **Innovation thrives** through diverse perspectives and collaborative problem-solving
* **Knowledge is shared** freely and constructively
* **Newcomers feel welcome** and supported in their learning journey
* **Academic integrity** is maintained in all our work
* **Global accessibility** is achieved through inclusive communication

Thank you for helping us create a community that reflects the best of academic
collaboration and open source development.
