"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyGeneratedOutput = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const util_1 = require("projen/lib/util");
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
class SmithyGeneratedOutput extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    synthesize() {
        super.synthesize();
        const { smithyBuildConfigPath, modelPath, outputPath, gradleProjectPath, gradleWrapperPath, } = this.options;
        // Run smithy generation
        util_1.exec(`./gradlew -p ${gradleProjectPath} generate -Pconfig=${smithyBuildConfigPath} -Pdiscover=${modelPath} -Poutput=${outputPath}`, {
            cwd: gradleWrapperPath ??
                path.resolve(__dirname, "..", "..", "..", "..", "scripts", "smithy"),
        });
    }
}
exports.SmithyGeneratedOutput = SmithyGeneratedOutput;
//# sourceMappingURL=data:application/json;base64,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