
###############################################################################
##             This file is generated by hackerforms-protocol.               ##
##        Do not change this file. Any changes will be overwritten.          ##
###############################################################################

import typing
import io
from .page import Page

def execute_js(code: str, **kwargs):
    '''Execute JavaScript on the page
    Args:
        code: The JS code to be executed
    Keyword Arg:
        context (dict): variables to be passed to the JS code
        button_text (string): The text to display on the next step button
    Returns:
      string: Serialized return value of the executed JavaScript
    '''

    button_text = kwargs.get('button_text', 'Next')
    return get_single_value(Page().execute_js(code, **kwargs).run(button_text))

def read_cards(label: str, options: typing.Any, **kwargs):
  '''Read cards from the user

      Positional Args:
        label (str): The text related to this fieldoptions (list): The options to display to the user, eg. [{'title': 'Option 1', 'image': 'https://image_1.png', 'description': 'option 1 description'},{'title': 'Option 2', 'image': 'https://image_2.png', 'description': 'option 2 description'}]
      
      Keyword Args:
        multiple (bool): Whether the user can select multiple options
        button_text (str): The text to display on the button that will submit the value
        initial_value (list): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        searchable (bool): Whether to show a search bar
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            list, any: The options/option selected by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_cards(label, options, **kwargs).run(button_text))

def read_code(label: str, **kwargs):
  '''Read a code snippet from the user with a text highlight

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        language (str): The programming language
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            str: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_code(label, **kwargs).run(button_text))

def read_currency(label: str, **kwargs):
  '''Read a number value from the user with a currency mask

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not, eg. "this field is required"
        placeholder (str): The placeholder text to display to the user
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        min (float): The minimum value allowed, eg. "0"
        max (float): The maximum value allowed, eg. "100"
        step (float): The value to be incremented or decremented while using the input button
        currency (str): The currency to display to the user, eg. "USD", "BRL, "EUR", "GBP" (default is USD)
        
        Returns:
            float: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_currency(label, **kwargs).run(button_text))

def read_date(label: str, **kwargs):
  '''Read a date value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (datetime.date or time.struct_time or str (YYYY-MM-DD)): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            datetime.date: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_date(label, **kwargs).run(button_text))

def read_dropdown(label: str, options: typing.Union[typing.List[str], typing.List[typing.Dict]], **kwargs):
  '''Read a dropdown value from the user

      Positional Args:
        label (str): The label to display to the useroptions (list): The options to display to the user, eg. ['Option 1', 'Option 2'] or [{'label': 'Option 1', 'value': '1'}, {'label': 'Option 2', 'value': '2'}]
      
      Keyword Args:
        multiple (bool): Whether the user can select multiple options
        button_text (str): The text to display on the button that will submit the value
        initial_value: The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            str: The value selected by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_dropdown(label, options, **kwargs).run(button_text))

def read_email(label: str, **kwargs):
  '''Read an email value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            str: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_email(label, **kwargs).run(button_text))

def read_file(label: str, **kwargs):
  '''Read a file value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        multiple (bool): Whether the user will be allowed to upload multiple files
        
        Returns:
            FileResponse: A dict containing the file uploaded by the user ({"file": file, "url": str, "content": bytes})
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_file(label, **kwargs).run(button_text))

def read_html_list(label: str, options: typing.Any, **kwargs):
  '''Read list of html values from the user

      Positional Args:
        label (str): The text related to this fieldoptions (list): The options to display to the user, eg. [{'html': '<div class="container">Info 1A</div>', 'value': 'info1'},{'html': '<div class="container">Info 2B</div>', 'value': 'info2'}]
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (list): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        multiple (bool): Whether the user can select multiple options
        css (str): The css related to the html item in options
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            list, any: The options/option selected by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_html_list(label, options, **kwargs).run(button_text))

def read_image(label: str, **kwargs):
  '''Read a image file value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        multiple (bool): Whether the user will be allowed to upload multiple files
        
        Returns:
            FileResponse: A dict containing the image file uploaded by the user ({"file": file, "url": str, "content": bytes})
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_image(label, **kwargs).run(button_text))

def read_list(item_schema: typing.Any, **kwargs):
  '''Read a list value from the user

      Positional Args:
        item_schema (ListItemSchema): The schema for the items of the list
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        min (float): Min value accepted by the input
        max (float): Max value accepted by the input
        add_button_text (str): Label to be displayed on the add button. The default is "+".
        
        Returns:
            list: The values entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_list(item_schema, **kwargs).run(button_text))

def read_multiple_choice(label: str, options: typing.Union[typing.List[str], typing.List[typing.Dict]], **kwargs):
  '''Read a multiple choice value from the user

      Positional Args:
        label (str): The label to display to the useroptions (list): The options to display to the user, eg. ['Option 1', 'Option 2'] or [{'label': 'Option 1', 'value': '1'}, {'label': 'Option 2', 'value': '2'}]
      
      Keyword Args:
        multiple (bool): Whether the user can select multiple options
        min (number): The minimal amount of options that should be selected
        max (number): The maximum amount of options that should be selected
        button_text (str): The text to display on the button that will submit the value
        initial_value: The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            list or any: The values/value selected by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_multiple_choice(label, options, **kwargs).run(button_text))

def read_nps(label: str, **kwargs):
  '''Gets NPS feedback from user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        min (int): Min value accepted by the input
        max (int): Max value accepted by the input
        min_hint (str): Text to display next to the min value
        max_hint (str): Text to display next to the max value
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            int: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_nps(label, **kwargs).run(button_text))

def read_number(label: str, **kwargs):
  '''Read a number value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        min (float): Min value accepted by the input
        max (float): Max value accepted by the input
        step (float): The value to be incremented or decremented while using the input button
        
        Returns:
            float: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_number(label, **kwargs).run(button_text))

def read_pandas_row_selection(df: typing.Any, **kwargs):
  '''Display a pandas dataframe as a table and allow the user to select rows

      Positional Args:
        df (pandas.DataFrame): The pandas dataframe to be displayed
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        required: Whether the input is required or not
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            list: The list of selected rows
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_pandas_row_selection(df, **kwargs).run(button_text))

def read_password(label: str, **kwargs):
  '''Read a password value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        lowercase_required (bool or str): Whether the input must have at least one lowercase character
        uppercase_required (bool or str): Whether the input must have at least one uppercase character
        special_required (bool or str): Whether the input must have at least one special character
        digit_required (bool or str): Whether the input must have at least one digit
        min_length (int): Minimum length of the password
        max_length (int): Maximum length of the password
        size (int): Size of the password
        pattern (str): A regex pattern for the accepted password
        autocomplete (str): The autocomplete HTML attribute
        
        Returns:
            str: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_password(label, **kwargs).run(button_text))

def read_phone(label: str, **kwargs):
  '''Read a phone number value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            PhoneResponse: A dict containing the value entered by the user ({"raw": str, "masked": str})
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_phone(label, **kwargs).run(button_text))

def read_tag(label: str, **kwargs):
  '''Read a tag value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (list): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            list(str) or list(float): The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_tag(label, **kwargs).run(button_text))

def read(label: str, **kwargs):
  '''Read a text value from the user simple text input

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            str: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read(label, **kwargs).run(button_text))

def read_textarea(label: str, **kwargs):
  '''Read a text value from the user with a text area input

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        placeholder (str): The placeholder text to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            str: The value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_textarea(label, **kwargs).run(button_text))

def read_time(label: str, **kwargs):
  '''Read a time value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        format (str): Whether the input is in the format 24hs or AM/PM. Default is 24hs.
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        
        Returns:
            datetime.time: A datetime.time object representing the value entered by the user
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_time(label, **kwargs).run(button_text))

def read_video(label: str, **kwargs):
  '''Read a video file value from the user

      Positional Args:
        label (str): The label to display to the user
      
      Keyword Args:
        button_text (str): The text to display on the button that will submit the value
        initial_value (str): The initial value to display to the user
        required (bool or str): Whether the input is required or not eg. "this field is required"
        hint (str): A tooltip displayed to the user
        full_width (bool): Whether the input should use full screen width
        multiple (bool): Whether the user will be allowed to upload multiple files
        
        Returns:
            FileResponse: A dict containing the video uploaded by the user ({"file": file, "url": str, "content": bytes})
        '''
  button_text = kwargs.get('button_text', 'Next')
  return get_single_value(Page().read_video(label, **kwargs).run(button_text))

def get_single_value(answer: typing.Dict):
  return list(answer.values())[0]