# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateInstanceTemplateRequest(JDCloudRequest):
    """
    修改一个启动模板的信息，包括名称、描述

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpdateInstanceTemplateRequest, self).__init__(
            '/regions/{regionId}/instanceTemplates/{instanceTemplateId}', 'PATCH', header, version)
        self.parameters = parameters


class UpdateInstanceTemplateParameters(object):

    def __init__(self, regionId, instanceTemplateId, ):
        """
        :param regionId: 地域ID
        :param instanceTemplateId: 启动模板ID
        """

        self.regionId = regionId
        self.instanceTemplateId = instanceTemplateId
        self.description = None
        self.name = None

    def setDescription(self, description):
        """
        :param description: (Optional) 模板描述，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。
        """
        self.description = description

    def setName(self, name):
        """
        :param name: (Optional) 模板名称，<a href="http://docs.jdcloud.com/virtual-machines/api/general_parameters">参考公共参数规范</a>。
        """
        self.name = name

