# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class SqlDataPoint(object):

    def __init__(self, appCode, serviceCode, region, resourceId, metric, time, value, start_time, execution_time, session_id, database, client_net_address, loginname, status, sqlstr, ):
        """
        :param appCode:  目前统一用jcloud
        :param serviceCode:  资源的类型，取值sqlserver
        :param region:  资源所在的地域
        :param resourceId:  资源的uuid
        :param metric:  监控指标名称，长度不超过255字节，只允许英文、数字、下划线_、点.,  [0-9][a-z] [A-Z] [. _ ]， 其它会返回err
        :param time:  毫秒级时间戳，早于当前时间30天的不能写入；建议的上报时间戳：上报时间间隔的整数倍，如上报间隔为5ms，则建议上报的时间戳为 time = current timestamp - (current timestamp % time interval) = 1487647187007 - （1487647187007 % 5） = 1487647187007 -2 = 1487647187005
        :param value:  上报的监控值，即慢sql语句已经执行的时间(单位s)
        :param start_time:  SQL开始执行的时间
        :param execution_time:  SQL已执行时间(单位s)
        :param session_id:  会话ID
        :param database:  数据库库名
        :param client_net_address:  客户端IP地址
        :param loginname:  用户名
        :param status:  SQL会话请求状态
        :param sqlstr:  SQL详细文本
        """

        self.appCode = appCode
        self.serviceCode = serviceCode
        self.region = region
        self.resourceId = resourceId
        self.metric = metric
        self.time = time
        self.value = value
        self.start_time = start_time
        self.execution_time = execution_time
        self.session_id = session_id
        self.database = database
        self.client_net_address = client_net_address
        self.loginname = loginname
        self.status = status
        self.sqlstr = sqlstr
