# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class ShardingDBInstanceSpec(object):

    def __init__(self, mongosNodeType, shardNodeType, shardNodeStorageGB, shardNodeNumber, mongosAzId, shardAzId, vpcId, subnetId, instanceName=None, engine=None, engineVersion=None, mongosNodeNumber=None, configserverNodeType=None, multiAZ=None, password=None, originDBInstanceId=None, restoreTime=None, instanceStorageType=None, storageEncrypted=None, serviceId=None):
        """
        :param instanceName: (Optional) 实例名称，名称只支持中文、数字、大小写字母及英文下划线“_”及中划线“-”，2-32个字符。
        :param engine: (Optional) 数据库类型，默认为MongoDB。
        :param engineVersion: (Optional) 数据库版本，支持：3.4, 3.6；默认为3.6。
        :param mongosNodeType:  mongos节点规格代码，必填。
        :param mongosNodeNumber: (Optional) mongos节点数量，支持2-32个，必填。
        :param configserverNodeType: (Optional) configserve节点规格代码，默认为mongo.m1.small。
        :param shardNodeType:  shard节点规格代码，必填。
        :param shardNodeStorageGB:  shard节点存储空间，单位GB，取值10-1000,10的倍数，必填。
        :param shardNodeNumber:  mongos节点数量，支持2-32个，必填。
        :param multiAZ: (Optional) 是否选择多可用区部署，默认为否。
        :param mongosAzId:  必填。单可用区部署，填写1个可用区；多可用区部署，依次填写每个mongos所在可用区，数量与mognos节点数量一致。
        :param shardAzId:  必填。单可用区部署，填写1个可用区；多可用区部署，需填写3个可用区，依次为副本集的primary、secondary、hidden所在的可用区，将应用到分片集群的shard节点和configserver节点的全部副本集。
        :param vpcId:  VPCID
        :param subnetId:  子网ID
        :param password: (Optional) 密码，必须包含且只支持字母及数字，不少于8字符不超过16字符。
        :param originDBInstanceId: (Optional) 基于一个实例的备份创建新实例，如填写则restoreTime也需要填写。
        :param restoreTime: (Optional) 用户指定备份保留周期内的任意时间点，如2011-06-11T16:00:00Z。
        :param instanceStorageType: (Optional) 存储类型，支持：LOCAL_SSD -本地盘SSD、EBS_SSD -云盘；默认值为：LOCAL_SSD。
        :param storageEncrypted: (Optional) 实例数据加密(存储类型为云硬盘才支持数据加密). false：不加密; true：加密. 缺省为false.
        :param serviceId: (Optional) 跨域服务ID，用于跨地域按时间点创建实例
        """

        self.instanceName = instanceName
        self.engine = engine
        self.engineVersion = engineVersion
        self.mongosNodeType = mongosNodeType
        self.mongosNodeNumber = mongosNodeNumber
        self.configserverNodeType = configserverNodeType
        self.shardNodeType = shardNodeType
        self.shardNodeStorageGB = shardNodeStorageGB
        self.shardNodeNumber = shardNodeNumber
        self.multiAZ = multiAZ
        self.mongosAzId = mongosAzId
        self.shardAzId = shardAzId
        self.vpcId = vpcId
        self.subnetId = subnetId
        self.password = password
        self.originDBInstanceId = originDBInstanceId
        self.restoreTime = restoreTime
        self.instanceStorageType = instanceStorageType
        self.storageEncrypted = storageEncrypted
        self.serviceId = serviceId
