# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class RedirectActionSpec(object):

    def __init__(self, statusCode, protocol=None, port=None, host=None, path=None, query=None):
        """
        :param protocol: (Optional) 重定向后协议，取值为Http、Https。不设置，表示重定向不修改请求协议，与客户端请求协议一致
        :param port: (Optional) 重定向后端口，取值范围为1-65535。不设置，表示重定向不修改请求端口，与客户端请求端口一致
        :param host: (Optional) 重定向后域名。不设置，表示重定向不修改请求域名，与客户端请求域名一致。支持输入IPv4地址和域名。域名输入限制为：仅支持输入大小写字母、数字、英文中划线“-”和点“.”，最少包括一个点"."，不能以点"."和中划线"-"开头或结尾，中划线"-"前后不能为点"."，不区分大小写，且不能超过110字符
        :param path: (Optional) 重定向后URL路径。不设置，表示重定向不修改请求URL路径，与客户端请求URL路径一致。必须以/开头，仅支持输入大小写字母、数字和特殊字符：$-_.+!'()%:@&=/，区分大小写，且不能超过128字符
        :param query: (Optional) 重定向后查询参数，不需手动输入?，系统默认添加，不超过128字符，不设置，表示重定向不修改查询参数，与客户端请求查询参数一致。
        :param statusCode:  取值为http_301、http_302。301表示永久性转移，302表示暂时性转移
        """

        self.protocol = protocol
        self.port = port
        self.host = host
        self.path = path
        self.query = query
        self.statusCode = statusCode
