# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateListenerRequest(JDCloudRequest):
    """
    创建一个监听器
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateListenerRequest, self).__init__(
            '/regions/{regionId}/listeners/', 'POST', header, version)
        self.parameters = parameters


class CreateListenerParameters(object):

    def __init__(self, regionId, listenerName, protocol, port, backendId, loadBalancerId, ):
        """
        :param regionId: Region ID
        :param listenerName: Listener的名字,只允许输入中文、数字、大小写字母、英文下划线“_”及中划线“-”，不允许为空且不超过32字符
        :param protocol: 监听协议, 取值为Tcp, Tls, Http, Https <br>【alb】支持Http, Https，Tcp和Tls <br>【nlb】支持Tcp  <br>【dnlb】支持Tcp
        :param port: 监听端口，取值范围为[1, 65535]
        :param backendId: 默认的后端服务Id
        :param loadBalancerId: Listener所属loadBalancer的Id
        """

        self.regionId = regionId
        self.listenerName = listenerName
        self.protocol = protocol
        self.port = port
        self.backendId = backendId
        self.loadBalancerId = loadBalancerId
        self.urlMapId = None
        self.action = None
        self.certificateSpecs = None
        self.connectionIdleTimeSeconds = None
        self.description = None

    def setUrlMapId(self, urlMapId):
        """
        :param urlMapId: (Optional) 【alb Https和Http协议】转发规则组Id
        """
        self.urlMapId = urlMapId

    def setAction(self, action):
        """
        :param action: (Optional) 默认后端服务的转发策略,取值为Forward或Redirect, 现只支持Forward, 默认为Forward
        """
        self.action = action

    def setCertificateSpecs(self, certificateSpecs):
        """
        :param certificateSpecs: (Optional) 【alb Https和Tls协议】Listener绑定的默认证书，只支持一个证书
        """
        self.certificateSpecs = certificateSpecs

    def setConnectionIdleTimeSeconds(self, connectionIdleTimeSeconds):
        """
        :param connectionIdleTimeSeconds: (Optional) 【alb、nlb】空闲连接超时时间, 范围为[1,86400]。 <br>（Tcp和Tls协议）默认为：1800s <br>（Http和Https协议）默认为：60s <br>【dnlb】不支持
        """
        self.connectionIdleTimeSeconds = connectionIdleTimeSeconds

    def setDescription(self, description):
        """
        :param description: (Optional) 描述,允许输入UTF-8编码下的全部字符，不超过256字符
        """
        self.description = description

