#!/usr/bin/env python

from setuptools import setup

setup(
    name='PynPoint',
    version='0.5.2',
    description='Pipeline for processing and analysis of high-contrast imaging data',
    long_description=open('README.rst').read(),
    author='Tomas Stolker, Markus Bonse, Sascha Quanz, and Adam Amara',
    author_email='tomas.stolker@phys.ethz.ch',
    url='http://pynpoint.ethz.ch',
    packages=['PynPoint',
              'PynPoint.Core',
              'PynPoint.IOmodules',
              'PynPoint.ProcessingModules',
              'PynPoint.Util'],
    package_dir={'PynPoint': 'PynPoint'},
    include_package_data=True,
    install_requires=['configparser',
                      'h5py==2.6.0',
                      'numpy',
                      'numba==0.37.0',
                      'scipy',
                      'astropy<3.0.0',
                      'photutils',
                      'scikit-image',
                      'scikit-learn',
                      'opencv-python',
                      'statsmodels==0.8.0',
                      'PyWavelets',
                      'matplotlib',
                      'emcee',
                      'ephem'],
    license='GPLv3',
    zip_safe=False,
    keywords='PynPoint',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Science/Research',
        'Topic :: Scientific/Engineering :: Astronomy',
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Natural Language :: English',
        'Programming Language :: Python :: 2.7',
    ],
    tests_require=['pytest'],
)
