# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Share']


class Share(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 share_network_id: Optional[pulumi.Input[str]] = None,
                 share_proto: Optional[pulumi.Input[str]] = None,
                 share_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[float]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to configure a share.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network1", admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet1",
            cidr="192.168.199.0/24",
            ip_version=4,
            network_id=network1.id)
        sharenetwork1 = openstack.sharedfilesystem.ShareNetwork("sharenetwork1",
            description="test share network with security services",
            neutron_net_id=network1.id,
            neutron_subnet_id=subnet1.id)
        share1 = openstack.sharedfilesystem.Share("share1",
            description="test share description",
            share_network_id=sharenetwork1.id,
            share_proto="NFS",
            size=1)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The share availability zone. Changing this creates a
               new share.
        :param pulumi.Input[str] description: The human-readable description for the share.
               Changing this updates the description of the existing share.
        :param pulumi.Input[bool] is_public: The level of visibility for the share. Set to true to make
               share public. Set to false to make it private. Default value is false. Changing this
               updates the existing share.
        :param pulumi.Input[Mapping[str, Any]] metadata: One or more metadata key and value pairs as a dictionary of
               strings.
        :param pulumi.Input[str] name: The name of the share. Changing this updates the name
               of the existing share.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Shared File System client.
               A Shared File System client is needed to create a share. Changing this
               creates a new share.
        :param pulumi.Input[str] share_network_id: The UUID of a share network where the share server exists
               or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
               the share_network_id value from the snapshot is used. Changing this creates a new share.
        :param pulumi.Input[str] share_proto: The share protocol - can either be NFS, CIFS,
               CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        :param pulumi.Input[str] share_type: The share type name. If you omit this parameter, the default
               share type is used.
        :param pulumi.Input[float] size: The share size, in GBs. The requested share size cannot be greater
               than the allowed GB quota. Changing this resizes the existing share.
        :param pulumi.Input[str] snapshot_id: The UUID of the share's base snapshot. Changing this creates
               a new share.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['availability_zone'] = availability_zone
            __props__['description'] = description
            __props__['is_public'] = is_public
            __props__['metadata'] = metadata
            __props__['name'] = name
            __props__['region'] = region
            __props__['share_network_id'] = share_network_id
            if share_proto is None:
                raise TypeError("Missing required property 'share_proto'")
            __props__['share_proto'] = share_proto
            __props__['share_type'] = share_type
            if size is None:
                raise TypeError("Missing required property 'size'")
            __props__['size'] = size
            __props__['snapshot_id'] = snapshot_id
            __props__['all_metadata'] = None
            __props__['export_locations'] = None
            __props__['has_replicas'] = None
            __props__['host'] = None
            __props__['project_id'] = None
            __props__['replication_type'] = None
            __props__['share_server_id'] = None
        super(Share, __self__).__init__(
            'openstack:sharedfilesystem/share:Share',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            export_locations: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['ShareExportLocationArgs']]]]] = None,
            has_replicas: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            is_public: Optional[pulumi.Input[bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            replication_type: Optional[pulumi.Input[str]] = None,
            share_network_id: Optional[pulumi.Input[str]] = None,
            share_proto: Optional[pulumi.Input[str]] = None,
            share_server_id: Optional[pulumi.Input[str]] = None,
            share_type: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[float]] = None,
            snapshot_id: Optional[pulumi.Input[str]] = None) -> 'Share':
        """
        Get an existing Share resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] all_metadata: The map of metadata, assigned on the share, which has been
               explicitly and implicitly added.
        :param pulumi.Input[str] availability_zone: The share availability zone. Changing this creates a
               new share.
        :param pulumi.Input[str] description: The human-readable description for the share.
               Changing this updates the description of the existing share.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['ShareExportLocationArgs']]]] export_locations: A list of export locations. For example, when a share server
               has more than one network interface, it can have multiple export locations.
        :param pulumi.Input[bool] has_replicas: Indicates whether a share has replicas or not.
        :param pulumi.Input[str] host: The share host name.
        :param pulumi.Input[bool] is_public: The level of visibility for the share. Set to true to make
               share public. Set to false to make it private. Default value is false. Changing this
               updates the existing share.
        :param pulumi.Input[Mapping[str, Any]] metadata: One or more metadata key and value pairs as a dictionary of
               strings.
        :param pulumi.Input[str] name: The name of the share. Changing this updates the name
               of the existing share.
        :param pulumi.Input[str] project_id: The owner of the Share.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Shared File System client.
               A Shared File System client is needed to create a share. Changing this
               creates a new share.
        :param pulumi.Input[str] replication_type: The share replication type.
        :param pulumi.Input[str] share_network_id: The UUID of a share network where the share server exists
               or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
               the share_network_id value from the snapshot is used. Changing this creates a new share.
        :param pulumi.Input[str] share_proto: The share protocol - can either be NFS, CIFS,
               CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        :param pulumi.Input[str] share_server_id: The UUID of the share server.
        :param pulumi.Input[str] share_type: The share type name. If you omit this parameter, the default
               share type is used.
        :param pulumi.Input[float] size: The share size, in GBs. The requested share size cannot be greater
               than the allowed GB quota. Changing this resizes the existing share.
        :param pulumi.Input[str] snapshot_id: The UUID of the share's base snapshot. Changing this creates
               a new share.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["all_metadata"] = all_metadata
        __props__["availability_zone"] = availability_zone
        __props__["description"] = description
        __props__["export_locations"] = export_locations
        __props__["has_replicas"] = has_replicas
        __props__["host"] = host
        __props__["is_public"] = is_public
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["project_id"] = project_id
        __props__["region"] = region
        __props__["replication_type"] = replication_type
        __props__["share_network_id"] = share_network_id
        __props__["share_proto"] = share_proto
        __props__["share_server_id"] = share_server_id
        __props__["share_type"] = share_type
        __props__["size"] = size
        __props__["snapshot_id"] = snapshot_id
        return Share(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The map of metadata, assigned on the share, which has been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_metadata")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The share availability zone. Changing this creates a
        new share.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The human-readable description for the share.
        Changing this updates the description of the existing share.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="exportLocations")
    def export_locations(self) -> pulumi.Output[List['outputs.ShareExportLocation']]:
        """
        A list of export locations. For example, when a share server
        has more than one network interface, it can have multiple export locations.
        """
        return pulumi.get(self, "export_locations")

    @property
    @pulumi.getter(name="hasReplicas")
    def has_replicas(self) -> pulumi.Output[bool]:
        """
        Indicates whether a share has replicas or not.
        """
        return pulumi.get(self, "has_replicas")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        The share host name.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[Optional[bool]]:
        """
        The level of visibility for the share. Set to true to make
        share public. Set to false to make it private. Default value is false. Changing this
        updates the existing share.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        One or more metadata key and value pairs as a dictionary of
        strings.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the share. Changing this updates the name
        of the existing share.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The owner of the Share.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Shared File System client.
        A Shared File System client is needed to create a share. Changing this
        creates a new share.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> pulumi.Output[str]:
        """
        The share replication type.
        """
        return pulumi.get(self, "replication_type")

    @property
    @pulumi.getter(name="shareNetworkId")
    def share_network_id(self) -> pulumi.Output[str]:
        """
        The UUID of a share network where the share server exists
        or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
        the share_network_id value from the snapshot is used. Changing this creates a new share.
        """
        return pulumi.get(self, "share_network_id")

    @property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> pulumi.Output[str]:
        """
        The share protocol - can either be NFS, CIFS,
        CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        """
        return pulumi.get(self, "share_proto")

    @property
    @pulumi.getter(name="shareServerId")
    def share_server_id(self) -> pulumi.Output[str]:
        """
        The UUID of the share server.
        """
        return pulumi.get(self, "share_server_id")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Output[str]:
        """
        The share type name. If you omit this parameter, the default
        share type is used.
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[float]:
        """
        The share size, in GBs. The requested share size cannot be greater
        than the allowed GB quota. Changing this resizes the existing share.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[str]]:
        """
        The UUID of the share's base snapshot. Changing this creates
        a new share.
        """
        return pulumi.get(self, "snapshot_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

