# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Container']


class Container(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_read: Optional[pulumi.Input[str]] = None,
                 container_sync_key: Optional[pulumi.Input[str]] = None,
                 container_sync_to: Optional[pulumi.Input[str]] = None,
                 container_write: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 versioning: Optional[pulumi.Input[pulumi.InputType['ContainerVersioningArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V1 container resource within OpenStack.

        ## Example Usage
        ### Basic Container

        ```python
        import pulumi
        import pulumi_openstack as openstack

        container1 = openstack.objectstorage.Container("container1",
            content_type="application/json",
            metadata={
                "test": "true",
            },
            region="RegionOne",
            versioning=openstack.objectstorage.ContainerVersioningArgs(
                location="tf-test-container-versions",
                type="versions",
            ))
        ```
        ### Global Read Access

        ```python
        import pulumi
        import pulumi_openstack as openstack

        container1 = openstack.objectstorage.Container("container1",
            container_read=".r:*",
            region="RegionOne")
        ```
        ### Global Read and List Access

        ```python
        import pulumi
        import pulumi_openstack as openstack

        container1 = openstack.objectstorage.Container("container1",
            container_read=".r:*,.rlistings",
            region="RegionOne")
        ```
        ### Write-Only Access for a User

        ```python
        import pulumi
        import pulumi_openstack as openstack

        current = openstack.identity.get_auth_scope(name="current")
        container1 = openstack.objectstorage.Container("container1",
            container_read=f".r:-{var['username']}",
            container_write=f"{current.project_id}:{var['username']}",
            region="RegionOne")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container_read: Sets an access control list (ACL) that grants
               read access. This header can contain a comma-delimited list of users that
               can read the container (allows the GET method for all objects in the
               container). Changing this updates the access control list read access.
        :param pulumi.Input[str] container_sync_key: The secret key for container synchronization.
               Changing this updates container synchronization.
        :param pulumi.Input[str] container_sync_to: The destination for container synchronization.
               Changing this updates container synchronization.
        :param pulumi.Input[str] container_write: Sets an ACL that grants write access.
               Changing this updates the access control list write access.
        :param pulumi.Input[str] content_type: The MIME type for the container. Changing this
               updates the MIME type.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the container so that the container can be destroyed without error. These objects are not recoverable.
        :param pulumi.Input[Mapping[str, Any]] metadata: Custom key/value pairs to associate with the container.
               Changing this updates the existing container metadata.
        :param pulumi.Input[str] name: A unique name for the container. Changing this creates a
               new container.
        :param pulumi.Input[str] region: The region in which to create the container. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new container.
        :param pulumi.Input[pulumi.InputType['ContainerVersioningArgs']] versioning: Enable object versioning. The structure is described below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['container_read'] = container_read
            __props__['container_sync_key'] = container_sync_key
            __props__['container_sync_to'] = container_sync_to
            __props__['container_write'] = container_write
            __props__['content_type'] = content_type
            __props__['force_destroy'] = force_destroy
            __props__['metadata'] = metadata
            __props__['name'] = name
            __props__['region'] = region
            __props__['versioning'] = versioning
        super(Container, __self__).__init__(
            'openstack:objectstorage/container:Container',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_read: Optional[pulumi.Input[str]] = None,
            container_sync_key: Optional[pulumi.Input[str]] = None,
            container_sync_to: Optional[pulumi.Input[str]] = None,
            container_write: Optional[pulumi.Input[str]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            versioning: Optional[pulumi.Input[pulumi.InputType['ContainerVersioningArgs']]] = None) -> 'Container':
        """
        Get an existing Container resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container_read: Sets an access control list (ACL) that grants
               read access. This header can contain a comma-delimited list of users that
               can read the container (allows the GET method for all objects in the
               container). Changing this updates the access control list read access.
        :param pulumi.Input[str] container_sync_key: The secret key for container synchronization.
               Changing this updates container synchronization.
        :param pulumi.Input[str] container_sync_to: The destination for container synchronization.
               Changing this updates container synchronization.
        :param pulumi.Input[str] container_write: Sets an ACL that grants write access.
               Changing this updates the access control list write access.
        :param pulumi.Input[str] content_type: The MIME type for the container. Changing this
               updates the MIME type.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the container so that the container can be destroyed without error. These objects are not recoverable.
        :param pulumi.Input[Mapping[str, Any]] metadata: Custom key/value pairs to associate with the container.
               Changing this updates the existing container metadata.
        :param pulumi.Input[str] name: A unique name for the container. Changing this creates a
               new container.
        :param pulumi.Input[str] region: The region in which to create the container. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new container.
        :param pulumi.Input[pulumi.InputType['ContainerVersioningArgs']] versioning: Enable object versioning. The structure is described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["container_read"] = container_read
        __props__["container_sync_key"] = container_sync_key
        __props__["container_sync_to"] = container_sync_to
        __props__["container_write"] = container_write
        __props__["content_type"] = content_type
        __props__["force_destroy"] = force_destroy
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["region"] = region
        __props__["versioning"] = versioning
        return Container(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="containerRead")
    def container_read(self) -> pulumi.Output[Optional[str]]:
        """
        Sets an access control list (ACL) that grants
        read access. This header can contain a comma-delimited list of users that
        can read the container (allows the GET method for all objects in the
        container). Changing this updates the access control list read access.
        """
        return pulumi.get(self, "container_read")

    @property
    @pulumi.getter(name="containerSyncKey")
    def container_sync_key(self) -> pulumi.Output[Optional[str]]:
        """
        The secret key for container synchronization.
        Changing this updates container synchronization.
        """
        return pulumi.get(self, "container_sync_key")

    @property
    @pulumi.getter(name="containerSyncTo")
    def container_sync_to(self) -> pulumi.Output[Optional[str]]:
        """
        The destination for container synchronization.
        Changing this updates container synchronization.
        """
        return pulumi.get(self, "container_sync_to")

    @property
    @pulumi.getter(name="containerWrite")
    def container_write(self) -> pulumi.Output[Optional[str]]:
        """
        Sets an ACL that grants write access.
        Changing this updates the access control list write access.
        """
        return pulumi.get(self, "container_write")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[Optional[str]]:
        """
        The MIME type for the container. Changing this
        updates the MIME type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean that indicates all objects should be deleted from the container so that the container can be destroyed without error. These objects are not recoverable.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Custom key/value pairs to associate with the container.
        Changing this updates the existing container metadata.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the container. Changing this creates a
        new container.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the container. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new container.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def versioning(self) -> pulumi.Output[Optional['outputs.ContainerVersioning']]:
        """
        Enable object versioning. The structure is described below.
        """
        return pulumi.get(self, "versioning")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

