# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Members']


class Members(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 members: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MembersMemberArgs']]]]] = None,
                 pool_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 members resource within OpenStack (batch members update).

        > **Note:** This resource works only within Octavia API. For
        legacy Neutron LBaaS v2 extension please use
        loadbalancer.Member resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        members1 = openstack.loadbalancer.Members("members1",
            members=[
                openstack.loadbalancer.MembersMemberArgs(
                    address="192.168.199.23",
                    protocol_port=8080,
                ),
                openstack.loadbalancer.MembersMemberArgs(
                    address="192.168.199.24",
                    protocol_port=8080,
                ),
            ],
            pool_id="935685fb-a896-40f9-9ff4-ae531a3a00fe")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MembersMemberArgs']]]] members: A set of dictionaries containing member parameters. The
               structure is described below.
        :param pulumi.Input[str] pool_id: The id of the pool that members will be assigned to.
               Changing this creates a new members resource.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create pool members. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               members resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['members'] = members
            if pool_id is None:
                raise TypeError("Missing required property 'pool_id'")
            __props__['pool_id'] = pool_id
            __props__['region'] = region
        super(Members, __self__).__init__(
            'openstack:loadbalancer/members:Members',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            members: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['MembersMemberArgs']]]]] = None,
            pool_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Members':
        """
        Get an existing Members resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['MembersMemberArgs']]]] members: A set of dictionaries containing member parameters. The
               structure is described below.
        :param pulumi.Input[str] pool_id: The id of the pool that members will be assigned to.
               Changing this creates a new members resource.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create pool members. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               members resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["members"] = members
        __props__["pool_id"] = pool_id
        __props__["region"] = region
        return Members(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Optional[List['outputs.MembersMember']]]:
        """
        A set of dictionaries containing member parameters. The
        structure is described below.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[str]:
        """
        The id of the pool that members will be assigned to.
        Changing this creates a new members resource.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create pool members. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        members resource.
        """
        return pulumi.get(self, "region")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

