"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
test('construct an AWS::Serverless::Application', () => {
    const stack = new cdk.Stack();
    new lib_1.CfnApplication(stack, 'App', {
        location: {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:077246666028:applications/aws-serverless-twitter-event-source',
            semanticVersion: '2.0.0',
        },
        parameters: {
            SearchText: '#serverless -filter:nativeretweets',
            TweetProcessorFunctionName: 'test',
        },
    });
    expect(stack).toMatchTemplate({
        Transform: 'AWS::Serverless-2016-10-31',
        Resources: {
            App: {
                Type: 'AWS::Serverless::Application',
                Properties: {
                    Location: {
                        ApplicationId: 'arn:aws:serverlessrepo:us-east-1:077246666028:applications/aws-serverless-twitter-event-source',
                        SemanticVersion: '2.0.0',
                    },
                    Parameters: {
                        SearchText: '#serverless -filter:nativeretweets',
                        TweetProcessorFunctionName: 'test',
                    },
                },
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2FtLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzYW0udGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGdDQUE4QjtBQUM5QixxQ0FBcUM7QUFDckMsZ0NBQXdDO0FBRXhDLElBQUksQ0FBQywyQ0FBMkMsRUFBRSxHQUFHLEVBQUU7SUFDckQsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7SUFFOUIsSUFBSSxvQkFBYyxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUU7UUFDL0IsUUFBUSxFQUFFO1lBQ1IsYUFBYSxFQUFFLGdHQUFnRztZQUMvRyxlQUFlLEVBQUUsT0FBTztTQUN6QjtRQUNELFVBQVUsRUFBRTtZQUNWLFVBQVUsRUFBRSxvQ0FBb0M7WUFDaEQsMEJBQTBCLEVBQUUsTUFBTTtTQUNuQztLQUNGLENBQUMsQ0FBQztJQUVILE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxlQUFlLENBQUM7UUFDNUIsU0FBUyxFQUFFLDRCQUE0QjtRQUN2QyxTQUFTLEVBQUU7WUFDVCxHQUFHLEVBQUU7Z0JBQ0gsSUFBSSxFQUFFLDhCQUE4QjtnQkFDcEMsVUFBVSxFQUFFO29CQUNWLFFBQVEsRUFBRTt3QkFDUixhQUFhLEVBQUUsZ0dBQWdHO3dCQUMvRyxlQUFlLEVBQUUsT0FBTztxQkFDekI7b0JBQ0QsVUFBVSxFQUFFO3dCQUNWLFVBQVUsRUFBRSxvQ0FBb0M7d0JBQ2hELDBCQUEwQixFQUFFLE1BQU07cUJBQ25DO2lCQUNGO2FBQ0Y7U0FDRjtLQUNGLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICdAYXdzLWNkay9hc3NlcnQvamVzdCc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDZm5BcHBsaWNhdGlvbiB9IGZyb20gJy4uL2xpYic7XG5cbnRlc3QoJ2NvbnN0cnVjdCBhbiBBV1M6OlNlcnZlcmxlc3M6OkFwcGxpY2F0aW9uJywgKCkgPT4ge1xuICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICBuZXcgQ2ZuQXBwbGljYXRpb24oc3RhY2ssICdBcHAnLCB7XG4gICAgbG9jYXRpb246IHtcbiAgICAgIGFwcGxpY2F0aW9uSWQ6ICdhcm46YXdzOnNlcnZlcmxlc3NyZXBvOnVzLWVhc3QtMTowNzcyNDY2NjYwMjg6YXBwbGljYXRpb25zL2F3cy1zZXJ2ZXJsZXNzLXR3aXR0ZXItZXZlbnQtc291cmNlJyxcbiAgICAgIHNlbWFudGljVmVyc2lvbjogJzIuMC4wJyxcbiAgICB9LFxuICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgIFNlYXJjaFRleHQ6ICcjc2VydmVybGVzcyAtZmlsdGVyOm5hdGl2ZXJldHdlZXRzJyxcbiAgICAgIFR3ZWV0UHJvY2Vzc29yRnVuY3Rpb25OYW1lOiAndGVzdCcsXG4gICAgfSxcbiAgfSk7XG5cbiAgZXhwZWN0KHN0YWNrKS50b01hdGNoVGVtcGxhdGUoe1xuICAgIFRyYW5zZm9ybTogJ0FXUzo6U2VydmVybGVzcy0yMDE2LTEwLTMxJyxcbiAgICBSZXNvdXJjZXM6IHtcbiAgICAgIEFwcDoge1xuICAgICAgICBUeXBlOiAnQVdTOjpTZXJ2ZXJsZXNzOjpBcHBsaWNhdGlvbicsXG4gICAgICAgIFByb3BlcnRpZXM6IHtcbiAgICAgICAgICBMb2NhdGlvbjoge1xuICAgICAgICAgICAgQXBwbGljYXRpb25JZDogJ2Fybjphd3M6c2VydmVybGVzc3JlcG86dXMtZWFzdC0xOjA3NzI0NjY2NjAyODphcHBsaWNhdGlvbnMvYXdzLXNlcnZlcmxlc3MtdHdpdHRlci1ldmVudC1zb3VyY2UnLFxuICAgICAgICAgICAgU2VtYW50aWNWZXJzaW9uOiAnMi4wLjAnLFxuICAgICAgICAgIH0sXG4gICAgICAgICAgUGFyYW1ldGVyczoge1xuICAgICAgICAgICAgU2VhcmNoVGV4dDogJyNzZXJ2ZXJsZXNzIC1maWx0ZXI6bmF0aXZlcmV0d2VldHMnLFxuICAgICAgICAgICAgVHdlZXRQcm9jZXNzb3JGdW5jdGlvbk5hbWU6ICd0ZXN0JyxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICB9KTtcbn0pO1xuIl19