# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WebFeedResponseObjectResourceAttributes(BaseModel):
    """
    WebFeedResponseObjectResourceAttributes
    """ # noqa: E501
    name: StrictStr = Field(description="The name of this web feed")
    url: StrictStr = Field(description="The URL of the web feed")
    request_method: StrictStr = Field(description="The HTTP method for requesting the web feed")
    content_type: StrictStr = Field(description="The content-type of the web feed")
    created: datetime = Field(description="Date and time when the web feed was created, in ISO 8601 format (YYYY-MM-DDTHH:MM:SS.mmmmmm)")
    updated: datetime = Field(description="Date and time when the web feed was updated, in ISO 8601 format (YYYY-MM-DDTHH:MM:SS.mmmmmm)")
    status: Optional[StrictStr] = Field(default=None, description="The cache status of this web feed if it exists")
    __properties: ClassVar[List[str]] = ["name", "url", "request_method", "content_type", "created", "updated", "status"]

    @field_validator('request_method')
    def request_method_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['get', 'post']):
            raise ValueError("must be one of enum values ('get', 'post')")
        return value

    @field_validator('content_type')
    def content_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['json', 'xml']):
            raise ValueError("must be one of enum values ('json', 'xml')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['critical_nightly_refresh_timeout', 'disabled', 'ok', 'warning_nightly_refresh_timeout', 'warning_periodic_refresh_timeout']):
            raise ValueError("must be one of enum values ('critical_nightly_refresh_timeout', 'disabled', 'ok', 'warning_nightly_refresh_timeout', 'warning_periodic_refresh_timeout')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebFeedResponseObjectResourceAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebFeedResponseObjectResourceAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "url": obj.get("url"),
            "request_method": obj.get("request_method"),
            "content_type": obj.get("content_type"),
            "created": obj.get("created"),
            "updated": obj.get("updated"),
            "status": obj.get("status")
        })
        return _obj


