# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.email_channel import EmailChannel
from openapi_client.models.push_channel import PushChannel
from openapi_client.models.sms_channel import SMSChannel
from typing import Optional, Set
from typing_extensions import Self

class Subscriptions(BaseModel):
    """
    Subscriptions
    """ # noqa: E501
    email: Optional[EmailChannel] = None
    sms: Optional[SMSChannel] = None
    mobile_push: Optional[PushChannel] = None
    __properties: ClassVar[List[str]] = ["email", "sms", "mobile_push"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Subscriptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of email
        if self.email:
            _dict['email'] = self.email.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sms
        if self.sms:
            _dict['sms'] = self.sms.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mobile_push
        if self.mobile_push:
            _dict['mobile_push'] = self.mobile_push.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Subscriptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email": EmailChannel.from_dict(obj["email"]) if obj.get("email") is not None else None,
            "sms": SMSChannel.from_dict(obj["sms"]) if obj.get("sms") is not None else None,
            "mobile_push": PushChannel.from_dict(obj["mobile_push"]) if obj.get("mobile_push") is not None else None
        })
        return _obj


