# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.subscription_create_job_create_query_resource_object_attributes_profiles import SubscriptionCreateJobCreateQueryResourceObjectAttributesProfiles
from typing import Optional, Set
from typing_extensions import Self

class SubscriptionCreateJobCreateQueryResourceObjectAttributes(BaseModel):
    """
    SubscriptionCreateJobCreateQueryResourceObjectAttributes
    """ # noqa: E501
    custom_source: Optional[StrictStr] = Field(default=None, description="A custom method detail or source to store on the consent records.")
    profiles: SubscriptionCreateJobCreateQueryResourceObjectAttributesProfiles
    historical_import: Optional[StrictBool] = Field(default=False, description="Whether this subscription is part of a historical import. If true, the consented_at field must be provided for each profile.")
    __properties: ClassVar[List[str]] = ["custom_source", "profiles", "historical_import"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubscriptionCreateJobCreateQueryResourceObjectAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of profiles
        if self.profiles:
            _dict['profiles'] = self.profiles.to_dict()
        # set to None if custom_source (nullable) is None
        # and model_fields_set contains the field
        if self.custom_source is None and "custom_source" in self.model_fields_set:
            _dict['custom_source'] = None

        # set to None if historical_import (nullable) is None
        # and model_fields_set contains the field
        if self.historical_import is None and "historical_import" in self.model_fields_set:
            _dict['historical_import'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubscriptionCreateJobCreateQueryResourceObjectAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "custom_source": obj.get("custom_source"),
            "profiles": SubscriptionCreateJobCreateQueryResourceObjectAttributesProfiles.from_dict(obj["profiles"]) if obj.get("profiles") is not None else None,
            "historical_import": obj.get("historical_import") if obj.get("historical_import") is not None else False
        })
        return _obj


