# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.device_metadata import DeviceMetadata
from typing import Optional, Set
from typing_extensions import Self

class PushTokenResponseObjectResourceAttributes(BaseModel):
    """
    PushTokenResponseObjectResourceAttributes
    """ # noqa: E501
    created: datetime = Field(description="The time at which the token was created")
    token: StrictStr = Field(description="The push token")
    enablement_status: StrictStr = Field(description="The enablement status of the push token")
    platform: StrictStr = Field(description="The platform of the push token('ios', 'android')")
    vendor: StrictStr = Field(description="The vendor of the push token('APNs', 'FCM')")
    background: StrictStr = Field(description="The background state of the push token")
    recorded_date: StrictStr = Field(description="The date the push token was recorded")
    metadata: Optional[DeviceMetadata] = None
    __properties: ClassVar[List[str]] = ["created", "token", "enablement_status", "platform", "vendor", "background", "recorded_date", "metadata"]

    @field_validator('enablement_status')
    def enablement_status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['AUTHORIZED', 'DENIED', 'NOT_DETERMINED', 'PROVISIONAL', 'UNAUTHORIZED']):
            raise ValueError("must be one of enum values ('AUTHORIZED', 'DENIED', 'NOT_DETERMINED', 'PROVISIONAL', 'UNAUTHORIZED')")
        return value

    @field_validator('platform')
    def platform_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['android', 'ios']):
            raise ValueError("must be one of enum values ('android', 'ios')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PushTokenResponseObjectResourceAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PushTokenResponseObjectResourceAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created": obj.get("created"),
            "token": obj.get("token"),
            "enablement_status": obj.get("enablement_status"),
            "platform": obj.get("platform"),
            "vendor": obj.get("vendor"),
            "background": obj.get("background"),
            "recorded_date": obj.get("recorded_date"),
            "metadata": DeviceMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None
        })
        return _obj


