# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.get_profile_import_job_response_collection_compound_document_data_inner_all_of_relationships_lists import GetProfileImportJobResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsLists
from openapi_client.models.post_profile_import_job_response_data_relationships_import_errors import PostProfileImportJobResponseDataRelationshipsImportErrors
from openapi_client.models.post_profile_import_job_response_data_relationships_profiles import PostProfileImportJobResponseDataRelationshipsProfiles
from typing import Optional, Set
from typing_extensions import Self

class PostProfileImportJobResponseDataRelationships(BaseModel):
    """
    PostProfileImportJobResponseDataRelationships
    """ # noqa: E501
    lists: Optional[GetProfileImportJobResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsLists] = None
    profiles: Optional[PostProfileImportJobResponseDataRelationshipsProfiles] = None
    import_errors: Optional[PostProfileImportJobResponseDataRelationshipsImportErrors] = Field(default=None, alias="import-errors")
    __properties: ClassVar[List[str]] = ["lists", "profiles", "import-errors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostProfileImportJobResponseDataRelationships from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of lists
        if self.lists:
            _dict['lists'] = self.lists.to_dict()
        # override the default output from pydantic by calling `to_dict()` of profiles
        if self.profiles:
            _dict['profiles'] = self.profiles.to_dict()
        # override the default output from pydantic by calling `to_dict()` of import_errors
        if self.import_errors:
            _dict['import-errors'] = self.import_errors.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostProfileImportJobResponseDataRelationships from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "lists": GetProfileImportJobResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsLists.from_dict(obj["lists"]) if obj.get("lists") is not None else None,
            "profiles": PostProfileImportJobResponseDataRelationshipsProfiles.from_dict(obj["profiles"]) if obj.get("profiles") is not None else None,
            "import-errors": PostProfileImportJobResponseDataRelationshipsImportErrors.from_dict(obj["import-errors"]) if obj.get("import-errors") is not None else None
        })
        return _obj


