# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.get_list_list_response_collection_compound_document_data_inner_all_of_relationships_tags import GetListListResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsTags
from openapi_client.models.get_metric_response_collection_compound_document_data_inner_all_of_relationships_flow_triggers import GetMetricResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsFlowTriggers
from openapi_client.models.post_list_create_response_data_relationships_profiles import PostListCreateResponseDataRelationshipsProfiles
from typing import Optional, Set
from typing_extensions import Self

class PostListCreateResponseDataRelationships(BaseModel):
    """
    PostListCreateResponseDataRelationships
    """ # noqa: E501
    profiles: Optional[PostListCreateResponseDataRelationshipsProfiles] = None
    tags: Optional[GetListListResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsTags] = None
    flow_triggers: Optional[GetMetricResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsFlowTriggers] = Field(default=None, alias="flow-triggers")
    __properties: ClassVar[List[str]] = ["profiles", "tags", "flow-triggers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostListCreateResponseDataRelationships from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of profiles
        if self.profiles:
            _dict['profiles'] = self.profiles.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tags
        if self.tags:
            _dict['tags'] = self.tags.to_dict()
        # override the default output from pydantic by calling `to_dict()` of flow_triggers
        if self.flow_triggers:
            _dict['flow-triggers'] = self.flow_triggers.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostListCreateResponseDataRelationships from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "profiles": PostListCreateResponseDataRelationshipsProfiles.from_dict(obj["profiles"]) if obj.get("profiles") is not None else None,
            "tags": GetListListResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsTags.from_dict(obj["tags"]) if obj.get("tags") is not None else None,
            "flow-triggers": GetMetricResponseCollectionCompoundDocumentDataInnerAllOfRelationshipsFlowTriggers.from_dict(obj["flow-triggers"]) if obj.get("flow-triggers") is not None else None
        })
        return _obj


