# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.form_version_ab_test import FormVersionABTest
from typing import Optional, Set
from typing_extensions import Self

class FormVersionResponseObjectResourceAttributes(BaseModel):
    """
    FormVersionResponseObjectResourceAttributes
    """ # noqa: E501
    form_type: StrictStr = Field(description="The type of form.")
    ab_test: Optional[FormVersionABTest] = None
    status: StrictStr = Field(description="Status of the form version. \"live\" means it's live on site.")
    created_at: datetime = Field(description="ISO8601 timestamp when the form version was created.")
    updated_at: datetime = Field(description="ISO8601 timestamp when the form version was last updated.")
    __properties: ClassVar[List[str]] = ["form_type", "ab_test", "status", "created_at", "updated_at"]

    @field_validator('form_type')
    def form_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['banner', 'embed', 'flyout', 'full_page', 'popup']):
            raise ValueError("must be one of enum values ('banner', 'embed', 'flyout', 'full_page', 'popup')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['draft', 'live']):
            raise ValueError("must be one of enum values ('draft', 'live')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FormVersionResponseObjectResourceAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ab_test
        if self.ab_test:
            _dict['ab_test'] = self.ab_test.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FormVersionResponseObjectResourceAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "form_type": obj.get("form_type"),
            "ab_test": FormVersionABTest.from_dict(obj["ab_test"]) if obj.get("ab_test") is not None else None,
            "status": obj.get("status"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


