# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FlowV2ResponseObjectResourceAttributes(BaseModel):
    """
    FlowV2ResponseObjectResourceAttributes
    """ # noqa: E501
    name: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    archived: Optional[StrictBool] = None
    created: Optional[datetime] = None
    updated: Optional[datetime] = None
    trigger_type: Optional[StrictStr] = Field(default=None, description="Corresponds to the object which triggered the flow.")
    __properties: ClassVar[List[str]] = ["name", "status", "archived", "created", "updated", "trigger_type"]

    @field_validator('trigger_type')
    def trigger_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Added to List', 'Date Based', 'Low Inventory', 'Metric', 'Price Drop', 'Unconfigured']):
            raise ValueError("must be one of enum values ('Added to List', 'Date Based', 'Low Inventory', 'Metric', 'Price Drop', 'Unconfigured')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FlowV2ResponseObjectResourceAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if archived (nullable) is None
        # and model_fields_set contains the field
        if self.archived is None and "archived" in self.model_fields_set:
            _dict['archived'] = None

        # set to None if created (nullable) is None
        # and model_fields_set contains the field
        if self.created is None and "created" in self.model_fields_set:
            _dict['created'] = None

        # set to None if updated (nullable) is None
        # and model_fields_set contains the field
        if self.updated is None and "updated" in self.model_fields_set:
            _dict['updated'] = None

        # set to None if trigger_type (nullable) is None
        # and model_fields_set contains the field
        if self.trigger_type is None and "trigger_type" in self.model_fields_set:
            _dict['trigger_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FlowV2ResponseObjectResourceAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "status": obj.get("status"),
            "archived": obj.get("archived"),
            "created": obj.get("created"),
            "updated": obj.get("updated"),
            "trigger_type": obj.get("trigger_type")
        })
        return _obj


