# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.flow_definition_profile_filter import FlowDefinitionProfileFilter
from typing import Optional, Set
from typing_extensions import Self

class FlowDefinition(BaseModel):
    """
    FlowDefinition
    """ # noqa: E501
    triggers: List[Dict[str, Any]] = Field(description="Corresponds to the object which triggers the flow. Only one trigger is supported.")
    profile_filter: Optional[FlowDefinitionProfileFilter] = None
    actions: List[Dict[str, Any]] = Field(description="A list of actions that make up the flow. Actions are linked to each other by their ids.")
    entry_action_id: Optional[StrictStr] = Field(description="The ID of the action that is the entry point of the flow.")
    __properties: ClassVar[List[str]] = ["triggers", "profile_filter", "actions", "entry_action_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FlowDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of profile_filter
        if self.profile_filter:
            _dict['profile_filter'] = self.profile_filter.to_dict()
        # set to None if profile_filter (nullable) is None
        # and model_fields_set contains the field
        if self.profile_filter is None and "profile_filter" in self.model_fields_set:
            _dict['profile_filter'] = None

        # set to None if entry_action_id (nullable) is None
        # and model_fields_set contains the field
        if self.entry_action_id is None and "entry_action_id" in self.model_fields_set:
            _dict['entry_action_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FlowDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "triggers": obj.get("triggers"),
            "profile_filter": FlowDefinitionProfileFilter.from_dict(obj["profile_filter"]) if obj.get("profile_filter") is not None else None,
            "actions": obj.get("actions"),
            "entry_action_id": obj.get("entry_action_id")
        })
        return _obj


